/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLBuilderFactory;
import net.n3.nanoxml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessPanelWorker
implements Runnable {
    private static final String SPEC_RESOURCE_NAME = "ProcessPanel.Spec.xml";
    private VariableSubstitutor vs;
    protected AbstractUIProcessHandler handler;
    private ArrayList<ProcessingJob> jobs = new ArrayList();
    private boolean result = true;
    private static PrintWriter logfile = null;
    private String logfiledir = null;
    protected AutomatedInstallData idata;

    public ProcessPanelWorker(AutomatedInstallData automatedInstallData, AbstractUIProcessHandler abstractUIProcessHandler) throws IOException {
        this.handler = abstractUIProcessHandler;
        this.idata = automatedInstallData;
        this.vs = new VariableSubstitutor(automatedInstallData.getVariables());
    }

    private boolean readSpec() throws IOException {
        XMLElement xMLElement;
        InputStream inputStream;
        try {
            inputStream = ResourceManager.getInstance().getInputStream(SPEC_RESOURCE_NAME);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        StdXMLParser stdXMLParser = new StdXMLParser();
        stdXMLParser.setBuilder(XMLBuilderFactory.createXMLBuilder());
        stdXMLParser.setValidator(new NonValidator());
        try {
            stdXMLParser.setReader(new StdXMLReader(inputStream));
            xMLElement = (XMLElement)stdXMLParser.parse();
        }
        catch (Exception exception) {
            System.err.println("Error parsing XML specification for processing.");
            System.err.println(exception.toString());
            return false;
        }
        if (!xMLElement.hasChildren()) {
            return false;
        }
        XMLElement xMLElement2 = xMLElement.getFirstChildNamed("logfiledir");
        if (xMLElement2 != null) {
            this.logfiledir = xMLElement2.getContent();
        }
        for (XMLElement xMLElement3 : xMLElement.getChildrenNamed("job")) {
            Object object2;
            ArrayList<String> arrayList;
            String string;
            List<OsConstraint> list;
            Serializable serializable;
            String string2;
            String string3 = xMLElement3.hasAttribute("condition") ? xMLElement3.getAttribute("condition") : (string2 = xMLElement3.hasAttribute("conditionid") ? xMLElement3.getAttribute("conditionid") : null);
            if (string2 != null && string2.length() > 0) {
                Debug.trace("Condition for job.");
                serializable = RulesEngine.getCondition(string2);
                if (serializable != null && !((Condition)serializable).isTrue()) {
                    Debug.trace("condition is not fulfilled.");
                    continue;
                }
            }
            Debug.trace("Condition is fulfilled or not existent.");
            serializable = xMLElement3.getChildrenNamed("executeForPack");
            if (!this.jobRequiredFor((Vector<XMLElement>)serializable) || !OsConstraint.oneMatchesCurrentSystem(list = OsConstraint.getOsList(xMLElement3))) continue;
            ArrayList<Processable> arrayList2 = new ArrayList<Processable>();
            String string4 = xMLElement3.getAttribute("name", "");
            for (XMLElement xMLElement4 : xMLElement3.getChildrenNamed("executefile")) {
                string = xMLElement4.getAttribute("name");
                if (string == null || string.length() == 0) {
                    System.err.println("missing \"name\" attribute for <executefile>");
                    return false;
                }
                arrayList = new ArrayList<String>();
                for (XMLElement xMLElement5 : xMLElement4.getChildrenNamed("arg")) {
                    object2 = xMLElement5.getContent();
                    arrayList.add((String)object2);
                }
                Iterator<XMLElement> iterator = new ArrayList();
                for (Object object2 : xMLElement4.getChildrenNamed("env")) {
                    String string5 = ((XMLElement)object2).getContent();
                    iterator.add((XMLElement)((Object)string5));
                }
                arrayList2.add(new ExecutableFile(string, (List<String>)arrayList, (List<String>)((Object)iterator)));
            }
            for (XMLElement xMLElement4 : xMLElement3.getChildrenNamed("executeclass")) {
                string = xMLElement4.getAttribute("name");
                if (string == null || string.length() == 0) {
                    System.err.println("missing \"name\" attribute for <executeclass>");
                    return false;
                }
                arrayList = new ArrayList();
                for (XMLElement xMLElement6 : xMLElement4.getChildrenNamed("arg")) {
                    object2 = xMLElement6.getContent();
                    arrayList.add((String)object2);
                }
                arrayList2.add(new ExecutableClass(string, arrayList));
            }
            this.jobs.add(new ProcessingJob(string4, arrayList2));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        try {
            if (!this.readSpec()) {
                System.err.println("Error parsing XML specification for processing.");
                return;
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            return;
        }
        if (this.logfiledir != null) {
            void var2_6;
            this.logfiledir = IoHelper.translatePath(this.logfiledir, new VariableSubstitutor(this.idata.getVariables()));
            String object = this.idata.getVariable("APP_VER");
            if (object != null) {
                String string = "V" + object;
            } else {
                String string = "undef";
            }
            String string = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            string = var2_6.replace(' ', '_') + "_" + string;
            try {
                File file = File.createTempFile("Install_" + string + "_", ".log", new File(this.logfiledir));
                logfile = new PrintWriter(new FileOutputStream(file), true);
            }
            catch (IOException iOException) {
                Debug.error(iOException);
            }
        }
        this.handler.startProcessing(this.jobs.size());
        for (ProcessingJob processingJob : this.jobs) {
            this.handler.startProcess(processingJob.name);
            this.result = processingJob.run(this.handler, this.vs);
            this.handler.finishProcess();
            if (this.result) continue;
            break;
        }
        this.handler.finishProcessing();
        if (logfile != null) {
            logfile.close();
        }
    }

    public void startThread() {
        Thread thread = new Thread((Runnable)this, "processing thread");
        thread.start();
    }

    public boolean getResult() {
        return this.result;
    }

    private boolean jobRequiredFor(Vector<XMLElement> vector) {
        if (vector.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.selectedPacks.size(); ++i) {
            String string = ((Pack)this.idata.selectedPacks.get((int)i)).name;
            for (int j = 0; j < vector.size(); ++j) {
                String string2 = vector.elementAt(j).getAttribute("name", "");
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecutableClass
    implements Processable {
        private final String myClassName;
        private final List<String> myArguments;
        protected AbstractUIProcessHandler myHandler;

        public ExecutableClass(String string, List<String> list) {
            this.myClassName = string;
            this.myArguments = list;
        }

        @Override
        public boolean run(AbstractUIProcessHandler abstractUIProcessHandler, VariableSubstitutor variableSubstitutor) {
            boolean bl = false;
            this.myHandler = abstractUIProcessHandler;
            String[] stringArray = new String[this.myArguments.size()];
            int n = 0;
            for (String object : this.myArguments) {
                stringArray[n++] = variableSubstitutor.substitute(object, "plain");
            }
            try {
                ClassLoader classLoader = this.getClass().getClassLoader();
                Class<?> clazz = classLoader.loadClass(this.myClassName);
                Object obj = clazz.newInstance();
                Method method = clazz.getMethod("run", AbstractUIProcessHandler.class, String[].class);
                method.invoke(obj, this.myHandler, stringArray);
                bl = true;
            }
            catch (SecurityException securityException) {
                this.myHandler.emitError("Post Processing Error", "Security exception thrown when processing class: " + this.myClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.myHandler.emitError("Post Processing Error", "Cannot find processing class: " + this.myClassName);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.myHandler.emitError("Post Processing Error", "Processing class does not have 'run' method: " + this.myClassName);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.myHandler.emitError("Post Processing Error", "Error accessing processing class: " + this.myClassName);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.myHandler.emitError("Post Processing Error", "Invocation Problem calling : " + this.myClassName + ", " + invocationTargetException.getCause().getMessage());
            }
            catch (Exception exception) {
                this.myHandler.emitError("Post Processing Error", "Exception when running processing class: " + this.myClassName + ", " + exception.getMessage());
            }
            catch (Error error) {
                this.myHandler.emitError("Post Processing Error", "Error when running processing class: " + this.myClassName + ", " + error.getMessage());
            }
            catch (Throwable throwable) {
                this.myHandler.emitError("Post Processing Error", "Error when running processing class: " + this.myClassName + ", " + throwable.getMessage());
            }
            return bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecutableFile
    implements Processable {
        private String filename;
        private List<String> arguments;
        private List<String> envvariables;
        protected AbstractUIProcessHandler handler;

        public ExecutableFile(String string, List<String> list, List<String> list2) {
            this.filename = string;
            this.arguments = list;
            this.envvariables = list2;
        }

        @Override
        public boolean run(AbstractUIProcessHandler abstractUIProcessHandler, VariableSubstitutor variableSubstitutor) {
            Object object;
            this.handler = abstractUIProcessHandler;
            ArrayList<String> arrayList = new ArrayList<String>(this.arguments.size() + 1);
            arrayList.add(variableSubstitutor.substitute(this.filename, "plain"));
            for (String object22 : this.arguments) {
                arrayList.add(variableSubstitutor.substitute(object22, "plain"));
            }
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            Map<String, String> map = processBuilder.environment();
            for (String string : this.envvariables) {
                object = variableSubstitutor.substitute(string, "plain");
                int n = ((String)object).indexOf("=");
                if (n <= 0) continue;
                map.put(((String)object).substring(0, n), ((String)object).substring(n + 1));
            }
            try {
                Process iOException = processBuilder.start();
                OutputMonitor outputMonitor = new OutputMonitor(this.handler, iOException.getInputStream(), false);
                object = new OutputMonitor(this.handler, iOException.getErrorStream(), true);
                Thread thread = new Thread(outputMonitor);
                Thread thread2 = new Thread((Runnable)object);
                thread.setDaemon(true);
                thread2.setDaemon(true);
                thread.start();
                thread2.start();
                try {
                    int n = iOException.waitFor();
                    this.stopMonitor(outputMonitor, thread);
                    this.stopMonitor((OutputMonitor)object, thread2);
                    if (n != 0 && this.handler.askQuestion("Process execution failed", "Continue anyway?", 37, 47) == 49) {
                        return false;
                    }
                }
                catch (InterruptedException interruptedException) {
                    iOException.destroy();
                    this.handler.emitError("process interrupted", interruptedException.toString());
                    return false;
                }
            }
            catch (IOException iOException) {
                this.handler.emitError("I/O error", iOException.toString());
                return false;
            }
            return true;
        }

        private void stopMonitor(OutputMonitor outputMonitor, Thread thread) {
            outputMonitor.doStop();
            long l = 500L;
            try {
                thread.join(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!thread.isAlive()) {
                return;
            }
            thread.interrupt();
            long l2 = 500L;
            try {
                thread.join(l2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public static class OutputMonitor
        implements Runnable {
            private boolean stderr = false;
            private AbstractUIProcessHandler handler;
            private BufferedReader reader;
            private Boolean stop = false;

            public OutputMonitor(AbstractUIProcessHandler abstractUIProcessHandler, InputStream inputStream, boolean bl) {
                this.stderr = bl;
                this.reader = new BufferedReader(new InputStreamReader(inputStream));
                this.handler = abstractUIProcessHandler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    String string;
                    while ((string = this.reader.readLine()) != null) {
                        this.handler.logOutput(string, this.stderr);
                        if (logfile != null) {
                            logfile.println(string);
                        }
                        Boolean bl = this.stop;
                        synchronized (bl) {
                            if (this.stop.booleanValue()) {
                                return;
                            }
                        }
                    }
                    return;
                }
                catch (IOException iOException) {
                    this.handler.logOutput(iOException.toString(), true);
                    if (logfile == null) return;
                    logfile.println(iOException.toString());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doStop() {
                Boolean bl = this.stop;
                synchronized (bl) {
                    this.stop = true;
                }
            }
        }
    }

    static interface Processable {
        public boolean run(AbstractUIProcessHandler var1, VariableSubstitutor var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProcessingJob
    implements Processable {
        public String name;
        private List<Processable> processables;

        public ProcessingJob(String string, List<Processable> list) {
            this.name = string;
            this.processables = list;
        }

        @Override
        public boolean run(AbstractUIProcessHandler abstractUIProcessHandler, VariableSubstitutor variableSubstitutor) {
            for (Processable processable : this.processables) {
                if (processable.run(abstractUIProcessHandler, variableSubstitutor)) continue;
                return false;
            }
            return true;
        }
    }
}

