/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.Debugger;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.panels.ImgPacksPanelAutomationHelper;
import com.izforge.izpack.panels.PacksModel;
import com.izforge.izpack.panels.PacksPanelInterface;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import net.n3.nanoxml.XMLElement;

public abstract class PacksPanelBase
extends IzPanel
implements PacksPanelInterface,
ListSelectionListener {
    protected JLabel freeSpaceLabel;
    protected JLabel spaceLabel;
    protected JTextArea descriptionArea;
    protected JTextArea dependencyArea;
    protected JTable packsTable;
    protected PacksModel packsModel;
    protected JScrollPane tableScroller;
    private Map<String, Pack> names;
    protected long bytes = 0L;
    protected long freeBytes = 0L;
    protected boolean dependenciesExist = false;
    private LocaleDatabase langpack = null;
    private static final String LANG_FILE_NAME = "packsLang.xml";
    private Debugger debugger;

    public PacksPanelBase(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData);
        try {
            this.langpack = installerFrame.langpack;
            InputStream inputStream = ResourceManager.getInstance().getInputStream(LANG_FILE_NAME);
            this.langpack.add(inputStream);
            this.debugger = installerFrame.getDebugger();
        }
        catch (Throwable throwable) {
            Debug.trace(throwable);
        }
        this.computePacks(installData.availablePacks);
        this.createNormalLayout();
    }

    protected abstract void createNormalLayout();

    public LocaleDatabase getLangpack() {
        return this.langpack;
    }

    public long getBytes() {
        return this.bytes;
    }

    public void setBytes(long l) {
        this.bytes = l;
    }

    public void showSpaceRequired() {
        if (this.spaceLabel != null) {
            this.spaceLabel.setText(Pack.toByteUnitsString(this.bytes));
        }
    }

    public void showFreeSpace() {
        if (IoHelper.supported("getFreeSpace") && this.freeSpaceLabel != null) {
            this.freeBytes = IoHelper.getFreeSpace(IoHelper.existingParent(new File(this.idata.getInstallPath())).getAbsolutePath());
            String string = this.freeBytes < 0L ? this.parent.langpack.getString("PacksPanel.notAscertainable") : Pack.toByteUnitsString(this.freeBytes);
            this.freeSpaceLabel.setText(string);
        }
    }

    public boolean isValidated() {
        if (IoHelper.supported("getFreeSpace") && this.freeBytes >= 0L && this.freeBytes <= this.bytes) {
            JOptionPane.showMessageDialog(this, this.parent.langpack.getString("PacksPanel.notEnoughSpace"), this.parent.langpack.getString("installer.error"), 0);
            return false;
        }
        return true;
    }

    public void makeXMLData(XMLElement xMLElement) {
        new ImgPacksPanelAutomationHelper().makeXMLData(this.idata, xMLElement);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        String string;
        Object object;
        Pack pack;
        int n = this.packsTable.getSelectedRow();
        if (this.descriptionArea != null && n != -1) {
            pack = (Pack)this.idata.availablePacks.get(n);
            object = "";
            string = pack.id + ".description";
            if (this.langpack != null && pack.id != null && !"".equals(pack.id)) {
                object = this.langpack.getString(string);
            }
            if ("".equals(object) || string.equals(object)) {
                object = pack.description;
            }
            VariableSubstitutor variableSubstitutor = new VariableSubstitutor(this.idata.getVariables());
            object = variableSubstitutor.substitute((String)object, null);
            this.descriptionArea.setText((String)object);
        }
        if (this.dependencyArea != null && n != -1) {
            pack = (Pack)this.idata.availablePacks.get(n);
            object = pack.dependencies;
            string = "";
            if (object != null) {
                string = string + (this.langpack == null ? "Dependencies: " : this.langpack.getString("PacksPanel.dependencies"));
            }
            for (int i = 0; object != null && i < object.size(); ++i) {
                String string2 = (String)object.get(i);
                string = string + this.getI18NPackName(this.names.get(string2));
                if (i == object.size() - 1) continue;
                string = string + ", ";
            }
            String string3 = this.langpack == null ? "Excludes: " : this.langpack.getString("PacksPanel.excludes");
            int n2 = 0;
            if (pack.excludeGroup != null) {
                for (int i = 0; i < this.idata.availablePacks.size(); ++i) {
                    Pack pack2 = (Pack)this.idata.availablePacks.get(i);
                    String string4 = pack2.excludeGroup;
                    if (string4 == null || i == n || !pack.excludeGroup.equals(string4)) continue;
                    string3 = string3 + this.getI18NPackName(pack2) + ", ";
                    ++n2;
                }
            }
            if (object != null) {
                string3 = "    " + string3;
            }
            if (n2 > 0) {
                string = string + string3;
            }
            if (string.endsWith(", ")) {
                string = string.substring(0, string.length() - 2);
            }
            this.dependencyArea.setText(string);
        }
    }

    private String getI18NPackName(Pack pack) {
        String string = pack.name;
        String string2 = pack.id;
        if (this.langpack != null && pack.id != null && !"".equals(pack.id)) {
            string = this.langpack.getString(string2);
        }
        if ("".equals(string) || string2 == null || string2.equals(string)) {
            string = pack.name;
        }
        return string;
    }

    protected JLabel createLabel(String string, String string2, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        JLabel jLabel = LabelFactory.create(this.parent.langpack.getString(string), this.parent.icons.getImageIcon(string2), 11);
        if (gridBagLayout != null && gridBagConstraints != null) {
            gridBagLayout.addLayoutComponent(jLabel, gridBagConstraints);
        }
        this.add(jLabel);
        return jLabel;
    }

    protected JLabel createPanelWithLabel(String string, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        jPanel.setAlignmentX(0.0f);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(LabelFactory.create(this.parent.langpack.getString(string)));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jLabel);
        if (gridBagLayout != null && gridBagConstraints != null) {
            gridBagLayout.addLayoutComponent(jPanel, gridBagConstraints);
        }
        this.add(jPanel);
        return jLabel;
    }

    protected JTextArea createTextArea(String string, JScrollPane jScrollPane, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setAlignmentX(0.0f);
        jTextArea.setCaretPosition(0);
        jTextArea.setEditable(false);
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(BorderFactory.createTitledBorder(this.parent.langpack.getString(string)));
        jTextArea.setFont(this.getControlTextFont());
        if (gridBagLayout != null && gridBagConstraints != null) {
            if (jScrollPane != null) {
                gridBagLayout.addLayoutComponent(jScrollPane, gridBagConstraints);
            } else {
                gridBagLayout.addLayoutComponent(jTextArea, gridBagConstraints);
            }
        }
        if (jScrollPane != null) {
            jScrollPane.setViewportView(jTextArea);
            this.add(jScrollPane);
        } else {
            this.add(jTextArea);
        }
        return jTextArea;
    }

    protected JTable createPacksTable(int n, JScrollPane jScrollPane, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        JTable jTable = new JTable();
        jTable.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        jTable.setIntercellSpacing(new Dimension(0, 0));
        jTable.setBackground(Color.white);
        jTable.setSelectionMode(0);
        jTable.getSelectionModel().addListSelectionListener(this);
        jTable.setShowGrid(false);
        jScrollPane.setViewportView(jTable);
        jScrollPane.setAlignmentX(0.0f);
        jScrollPane.getViewport().setBackground(Color.white);
        jScrollPane.setPreferredSize(new Dimension(n, this.idata.guiPrefs.height / 3 + 30));
        if (gridBagLayout != null && gridBagConstraints != null) {
            gridBagLayout.addLayoutComponent(jScrollPane, gridBagConstraints);
        }
        this.add(jScrollPane);
        return jTable;
    }

    private void computePacks(List list) {
        this.names = new HashMap<String, Pack>();
        this.dependenciesExist = false;
        for (Object e : list) {
            Pack pack = (Pack)e;
            this.names.put(pack.name, pack);
            if (pack.dependencies == null && pack.excludeGroup == null) continue;
            this.dependenciesExist = true;
        }
    }

    public void panelActivate() {
        try {
            this.packsModel = new PacksModel(this, this.idata, this.parent.getRules()){

                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            this.packsTable.setModel(this.packsModel);
            CheckBoxRenderer checkBoxRenderer = new CheckBoxRenderer();
            this.packsTable.getColumnModel().getColumn(0).setCellRenderer(checkBoxRenderer);
            this.packsTable.getColumnModel().getColumn(0).setMaxWidth(40);
            this.packsTable.getColumnModel().getColumn(1).setCellRenderer(new PacksPanelTableCellRenderer());
            PacksPanelTableCellRenderer packsPanelTableCellRenderer = new PacksPanelTableCellRenderer();
            packsPanelTableCellRenderer.setHorizontalAlignment(4);
            this.packsTable.getColumnModel().getColumn(2).setCellRenderer(packsPanelTableCellRenderer);
            this.packsTable.getColumnModel().getColumn(2).setMaxWidth(100);
            this.packsTable.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = PacksPanelBase.this.packsTable.rowAtPoint(mouseEvent.getPoint());
                    int n2 = PacksPanelBase.this.packsTable.columnAtPoint(mouseEvent.getPoint());
                    if (n2 == 0) {
                        Integer n3 = (Integer)PacksPanelBase.this.packsModel.getValueAt(n, 0);
                        n3 = n3 == 0 ? 1 : 0;
                        PacksPanelBase.this.packsModel.setValueAt(n3, n, 0);
                        PacksPanelBase.this.packsTable.repaint();
                    }
                }
            });
            this.tableScroller.remove(this.packsTable.getTableHeader());
            this.tableScroller.setColumnHeaderView(null);
            this.tableScroller.setColumnHeader(null);
            Iterator iterator = this.idata.availablePacks.iterator();
            this.bytes = 0L;
            while (iterator.hasNext()) {
                Pack pack = (Pack)iterator.next();
                if (pack.required) {
                    this.bytes += pack.nbytes;
                    continue;
                }
                if (!this.idata.selectedPacks.contains(pack)) continue;
                this.bytes += pack.nbytes;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.showSpaceRequired();
        this.showFreeSpace();
        this.packsTable.setRowSelectionInterval(0, 0);
    }

    public String getSummaryBody() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(256);
        Iterator<Object> iterator = this.idata.selectedPacks.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append("<br>");
            }
            bl = false;
            object = (Pack)iterator.next();
            if (this.langpack != null && ((Pack)object).id != null && !"".equals(((Pack)object).id)) {
                stringBuffer.append(this.langpack.getString(((Pack)object).id));
                continue;
            }
            stringBuffer.append(((Pack)object).name);
        }
        if (this.packsModel.isModifyinstallation()) {
            object = this.packsModel.getInstalledpacks();
            iterator = object.keySet().iterator();
            stringBuffer.append("<br><b>");
            stringBuffer.append(this.langpack.getString("PacksPanel.installedpacks.summarycaption"));
            stringBuffer.append("</b>");
            stringBuffer.append("<br>");
            while (iterator.hasNext()) {
                Pack pack = (Pack)object.get(iterator.next());
                if (this.langpack != null && pack.id != null && !"".equals(pack.id)) {
                    stringBuffer.append(this.langpack.getString(pack.id));
                } else {
                    stringBuffer.append(pack.name);
                }
                stringBuffer.append("<br>");
            }
        }
        return stringBuffer.toString();
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    static class CheckBoxRenderer
    implements TableCellRenderer {
        JCheckBox checkbox = new JCheckBox();

        CheckBoxRenderer() {
            if (OsVersion.IS_UNIX && !OsVersion.IS_OSX) {
                this.checkbox.setIcon(new LFIndependentIcon());
                this.checkbox.setDisabledIcon(new LFIndependentIcon());
                this.checkbox.setSelectedIcon(new LFIndependentIcon());
                this.checkbox.setDisabledSelectedIcon(new LFIndependentIcon());
            }
            this.checkbox.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.checkbox.setForeground(jTable.getSelectionForeground());
                this.checkbox.setBackground(jTable.getSelectionBackground());
            } else {
                this.checkbox.setForeground(jTable.getForeground());
                this.checkbox.setBackground(jTable.getBackground());
            }
            int n3 = (Integer)object;
            if (n3 == -2) {
                this.checkbox.setForeground(Color.GRAY);
            }
            if (n3 == -3) {
                this.checkbox.setForeground(Color.RED);
                this.checkbox.setSelected(true);
            }
            this.checkbox.setEnabled(n3 >= 0);
            this.checkbox.setSelected(object != null && Math.abs(n3) == 1);
            return this.checkbox;
        }
    }

    public static class LFIndependentIcon
    implements Icon {
        ButtonModel buttonModel = null;

        protected int getControlSize() {
            return 13;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            ButtonModel buttonModel;
            this.buttonModel = buttonModel = ((JCheckBox)component).getModel();
            int n3 = this.getControlSize();
            if (buttonModel.isPressed() && buttonModel.isArmed()) {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                if (buttonModel.isEnabled()) {
                    graphics.setColor(Color.green);
                } else {
                    graphics.setColor(Color.gray);
                }
                graphics.fillRect(n, n2, n3 - 1, n3 - 1);
                this.drawPressedBorder(graphics, n, n2, n3, n3, buttonModel);
            } else {
                this.drawBorder(graphics, n, n2, n3, n3, buttonModel);
            }
            graphics.setColor(Color.green);
            if (buttonModel.isSelected()) {
                this.drawCheck(graphics, n, n2);
            }
        }

        private void drawBorder(Graphics graphics, int n, int n2, int n3, int n4, ButtonModel buttonModel) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            if (!buttonModel.isEnabled()) {
                graphics.setColor(new Color(0.4f, 0.4f, 0.4f));
            }
            graphics.drawRect(0, 0, n3 - 2, n4 - 2);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            if (!buttonModel.isEnabled()) {
                graphics.setColor(new Color(0.6f, 0.6f, 0.6f));
            }
            graphics.drawRect(1, 1, n3 - 2, n4 - 2);
            if (buttonModel.isEnabled()) {
                graphics.setColor(Color.white);
            } else {
                graphics.setColor(new Color(0.8f, 0.8f, 0.8f));
            }
            graphics.fillRect(2, 2, n3 - 3, n4 - 3);
            graphics.setColor(MetalLookAndFeel.getControl());
            graphics.drawLine(0, n4 - 1, 1, n4 - 2);
            graphics.drawLine(n3 - 1, 0, n3 - 2, 1);
            graphics.translate(-n, -n2);
        }

        private void drawPressedBorder(Graphics graphics, int n, int n2, int n3, int n4, ButtonModel buttonModel) {
            graphics.translate(n, n2);
            this.drawBorder(graphics, 0, 0, n3, n4, buttonModel);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawLine(1, 1, 1, n4 - 2);
            graphics.drawLine(1, 1, n3 - 2, 1);
            graphics.drawLine(2, 2, 2, n4 - 3);
            graphics.drawLine(2, 2, n3 - 3, 2);
            graphics.translate(-n, -n2);
        }

        protected void drawCheck(Graphics graphics, int n, int n2) {
            int n3 = this.getControlSize();
            if (this.buttonModel != null) {
                if (this.buttonModel.isEnabled()) {
                    graphics.setColor(new Color(0.0f, 0.6f, 0.0f));
                } else {
                    graphics.setColor(new Color(0.1f, 0.1f, 0.1f));
                }
            }
            graphics.drawLine(n + (n3 - 4), n2 + 2, n + (n3 - 4) - 4, n2 + 2 + 4);
            graphics.drawLine(n + (n3 - 4), n2 + 3, n + (n3 - 4) - 4, n2 + 3 + 4);
            graphics.drawLine(n + (n3 - 4), n2 + 4, n + (n3 - 4) - 4, n2 + 4 + 4);
            graphics.drawLine(n + (n3 - 4) - 4, n2 + 2 + 4, n + (n3 - 4) - 4 - 2, n2 + 2 + 4 - 2);
            graphics.drawLine(n + (n3 - 4) - 4, n2 + 3 + 4, n + (n3 - 4) - 4 - 2, n2 + 3 + 4 - 2);
            graphics.drawLine(n + (n3 - 4) - 4, n2 + 4 + 4, n + (n3 - 4) - 4 - 2, n2 + 4 + 4 - 2);
        }

        public int getIconWidth() {
            return this.getControlSize();
        }

        public int getIconHeight() {
            return this.getControlSize();
        }
    }

    static class PacksPanelTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -9089892183236584242L;

        PacksPanelTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = (Integer)jTable.getModel().getValueAt(n, 0);
            if (n3 == -2) {
                component.setForeground(Color.GRAY);
                if (bl) {
                    component.setBackground(jTable.getSelectionBackground());
                } else {
                    component.setBackground(jTable.getBackground());
                }
            } else if (bl) {
                component.setForeground(jTable.getSelectionForeground());
                component.setBackground(jTable.getSelectionBackground());
            } else {
                component.setForeground(jTable.getForeground());
                component.setBackground(jTable.getBackground());
            }
            return component;
        }
    }
}

