/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm;

import com.sun.jna.Native;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import jtermios.JTermios;
import jtermios.Pollfd;
import jtermios.Termios;
import jtermios.TimeVal;
import purejavacomm.PortInUseException;
import purejavacomm.PureJavaIllegalStateException;
import purejavacomm.SerialPort;
import purejavacomm.SerialPortEvent;
import purejavacomm.SerialPortEventListener;
import purejavacomm.UnsupportedCommOperationException;

public class PureJavaSerialPort
extends SerialPort {
    final boolean USE_POLL;
    final boolean RAW_READ_MODE;
    private Thread m_Thread;
    private volatile SerialPortEventListener m_EventListener;
    private volatile OutputStream m_OutputStream;
    private volatile InputStream m_InputStream;
    private volatile int m_FD = -1;
    private volatile boolean m_HaveNudgePipe = false;
    private volatile int m_PipeWrFD = 0;
    private volatile int m_PipeRdFD = 0;
    private byte[] m_NudgeData = new byte[1];
    private volatile int m_BaudRate;
    private volatile int m_DataBits;
    private volatile int m_FlowControlMode;
    private volatile int m_Parity;
    private volatile int m_StopBits;
    private volatile Object m_ThresholdTimeoutLock = new Object();
    private volatile boolean m_TimeoutThresholdChanged = true;
    private volatile boolean m_ReceiveTimeoutEnabled;
    private volatile int m_ReceiveTimeoutValue;
    private volatile int m_ReceiveTimeoutVTIME;
    private volatile boolean m_ReceiveThresholdEnabled;
    private volatile int m_ReceiveThresholdValue;
    private volatile boolean m_PollingReadMode;
    private volatile boolean m_NotifyOnDataAvailable;
    private volatile boolean m_DataAvailableNotified;
    private volatile boolean m_NotifyOnOutputEmpty;
    private volatile boolean m_OutputEmptyNotified;
    private volatile boolean m_NotifyOnRI;
    private volatile boolean m_NotifyOnCTS;
    private volatile boolean m_NotifyOnDSR;
    private volatile boolean m_NotifyOnCD;
    private volatile boolean m_NotifyOnOverrunError;
    private volatile boolean m_NotifyOnParityError;
    private volatile boolean m_NotifyOnFramingError;
    private volatile boolean m_NotifyOnBreakInterrupt;
    private volatile boolean m_ThreadRunning;
    private volatile boolean m_ThreadStarted;
    private int[] m_ioctl = new int[1];
    private int m_ControlLineStates;
    private Termios m_Termios = new Termios();
    private int m_MinVTIME;

    private void sendDataEvents(boolean read, boolean write) {
        if (read && this.m_NotifyOnDataAvailable && !this.m_DataAvailableNotified) {
            this.m_DataAvailableNotified = true;
            this.m_EventListener.serialEvent(new SerialPortEvent(this, 1, false, true));
        }
        if (write && this.m_NotifyOnOutputEmpty && !this.m_OutputEmptyNotified) {
            this.m_OutputEmptyNotified = true;
            this.m_EventListener.serialEvent(new SerialPortEvent(this, 2, false, true));
        }
    }

    private synchronized void sendNonDataEvents() {
        int line;
        if (JTermios.ioctl(this.m_FD, JTermios.TIOCMGET, this.m_ioctl) < 0) {
            return;
        }
        int oldstates = this.m_ControlLineStates;
        this.m_ControlLineStates = this.m_ioctl[0];
        int newstates = this.m_ControlLineStates;
        int changes = oldstates ^ newstates;
        if (changes == 0) {
            return;
        }
        if (this.m_NotifyOnCTS && ((line = JTermios.TIOCM_CTS) & changes) != 0) {
            this.m_EventListener.serialEvent(new SerialPortEvent(this, 3, (oldstates & line) != 0, (newstates & line) != 0));
        }
        if (this.m_NotifyOnDSR && ((line = JTermios.TIOCM_DSR) & changes) != 0) {
            this.m_EventListener.serialEvent(new SerialPortEvent(this, 4, (oldstates & line) != 0, (newstates & line) != 0));
        }
        if (this.m_NotifyOnRI && ((line = JTermios.TIOCM_RI) & changes) != 0) {
            this.m_EventListener.serialEvent(new SerialPortEvent(this, 5, (oldstates & line) != 0, (newstates & line) != 0));
        }
        if (this.m_NotifyOnCD && ((line = JTermios.TIOCM_CD) & changes) != 0) {
            this.m_EventListener.serialEvent(new SerialPortEvent(this, 6, (oldstates & line) != 0, (newstates & line) != 0));
        }
    }

    public synchronized void addEventListener(SerialPortEventListener eventListener) throws TooManyListenersException {
        this.checkState();
        if (eventListener == null) {
            throw new IllegalArgumentException("eventListener cannot be null");
        }
        if (this.m_EventListener != null) {
            throw new TooManyListenersException();
        }
        this.m_EventListener = eventListener;
        if (!this.m_ThreadStarted) {
            this.m_ThreadStarted = true;
            this.m_Thread.start();
        }
    }

    public synchronized int getBaudRate() {
        this.checkState();
        return this.m_BaudRate;
    }

    public synchronized int getDataBits() {
        this.checkState();
        return this.m_DataBits;
    }

    public synchronized int getFlowControlMode() {
        this.checkState();
        return this.m_FlowControlMode;
    }

    public synchronized int getParity() {
        this.checkState();
        return this.m_Parity;
    }

    public synchronized int getStopBits() {
        this.checkState();
        return this.m_StopBits;
    }

    public synchronized boolean isCD() {
        this.checkState();
        return this.getControlLineState(JTermios.TIOCM_CD);
    }

    public synchronized boolean isCTS() {
        this.checkState();
        return this.getControlLineState(JTermios.TIOCM_CTS);
    }

    public synchronized boolean isDSR() {
        this.checkState();
        return this.getControlLineState(JTermios.TIOCM_DSR);
    }

    public synchronized boolean isDTR() {
        this.checkState();
        return this.getControlLineState(JTermios.TIOCM_DTR);
    }

    public synchronized boolean isRI() {
        this.checkState();
        return this.getControlLineState(JTermios.TIOCM_RI);
    }

    public synchronized boolean isRTS() {
        this.checkState();
        return this.getControlLineState(JTermios.TIOCM_RTS);
    }

    public synchronized void notifyOnBreakInterrupt(boolean x) {
        this.checkState();
        this.m_NotifyOnBreakInterrupt = x;
    }

    public synchronized void notifyOnCTS(boolean x) {
        this.checkState();
        if (x) {
            this.updateControlLineState(JTermios.TIOCM_CTS);
        }
        this.m_NotifyOnCTS = x;
        this.nudgePipe();
    }

    public synchronized void notifyOnCarrierDetect(boolean x) {
        this.checkState();
        if (x) {
            this.updateControlLineState(JTermios.TIOCM_CD);
        }
        this.m_NotifyOnCD = x;
        this.nudgePipe();
    }

    public synchronized void notifyOnDSR(boolean x) {
        this.checkState();
        if (x) {
            this.updateControlLineState(JTermios.TIOCM_DSR);
        }
        this.m_NotifyOnDSR = x;
        this.nudgePipe();
    }

    public synchronized void notifyOnDataAvailable(boolean x) {
        this.checkState();
        this.m_NotifyOnDataAvailable = x;
        this.nudgePipe();
    }

    public synchronized void notifyOnFramingError(boolean x) {
        this.checkState();
        this.m_NotifyOnFramingError = x;
    }

    public synchronized void notifyOnOutputEmpty(boolean x) {
        this.checkState();
        this.m_NotifyOnOutputEmpty = x;
        this.nudgePipe();
    }

    public synchronized void notifyOnOverrunError(boolean x) {
        this.checkState();
        this.m_NotifyOnOverrunError = x;
    }

    public synchronized void notifyOnParityError(boolean x) {
        this.checkState();
        this.m_NotifyOnParityError = x;
    }

    public synchronized void notifyOnRingIndicator(boolean x) {
        this.checkState();
        if (x) {
            this.updateControlLineState(JTermios.TIOCM_RI);
        }
        this.m_NotifyOnRI = x;
        this.nudgePipe();
    }

    public synchronized void removeEventListener() {
        this.checkState();
        this.m_EventListener = null;
    }

    public synchronized void sendBreak(int duration) {
        this.checkState();
        JTermios.tcsendbreak(this.m_FD, duration);
    }

    public synchronized void setDTR(boolean x) {
        this.checkState();
        this.setControlLineState(JTermios.TIOCM_DTR, x);
    }

    public synchronized void setRTS(boolean x) {
        this.checkState();
        this.setControlLineState(JTermios.TIOCM_RTS, x);
    }

    public synchronized void disableReceiveFraming() {
        this.checkState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disableReceiveThreshold() {
        this.checkState();
        Object object = this.m_ThresholdTimeoutLock;
        synchronized (object) {
            this.m_ReceiveThresholdEnabled = false;
            this.thresholdOrTimeoutChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disableReceiveTimeout() {
        this.checkState();
        Object object = this.m_ThresholdTimeoutLock;
        synchronized (object) {
            this.m_ReceiveTimeoutEnabled = false;
            this.thresholdOrTimeoutChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void enableReceiveThreshold(int value) throws UnsupportedCommOperationException {
        this.checkState();
        if (value < 0) {
            throw new IllegalArgumentException("threshold" + value + " < 0 ");
        }
        if (this.RAW_READ_MODE && value > 255) {
            throw new IllegalArgumentException("threshold" + value + " > 255 in raw read mode");
        }
        Object object = this.m_ThresholdTimeoutLock;
        synchronized (object) {
            this.m_ReceiveThresholdEnabled = true;
            this.m_ReceiveThresholdValue = value;
            this.thresholdOrTimeoutChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void enableReceiveTimeout(int value) throws UnsupportedCommOperationException {
        if (value < 0) {
            throw new IllegalArgumentException("threshold" + value + " < 0 ");
        }
        if (value > 25500) {
            throw new UnsupportedCommOperationException("threshold" + value + " > 25500 ");
        }
        this.checkState();
        Object object = this.m_ThresholdTimeoutLock;
        synchronized (object) {
            this.m_ReceiveTimeoutEnabled = true;
            this.m_ReceiveTimeoutValue = value;
            this.thresholdOrTimeoutChanged();
        }
    }

    public synchronized void enableReceiveFraming(int arg0) throws UnsupportedCommOperationException {
        this.checkState();
        throw new UnsupportedCommOperationException("receive framing not supported/implemented");
    }

    private void thresholdOrTimeoutChanged() {
        this.m_PollingReadMode = this.m_ReceiveTimeoutEnabled && this.m_ReceiveTimeoutValue == 0 || this.m_ReceiveThresholdEnabled && this.m_ReceiveThresholdValue == 0;
        this.m_ReceiveTimeoutVTIME = (this.m_ReceiveTimeoutValue + 99) / 100;
        this.m_TimeoutThresholdChanged = true;
    }

    public synchronized int getInputBufferSize() {
        this.checkState();
        return 0;
    }

    public synchronized int getOutputBufferSize() {
        this.checkState();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFlowControlMode(int mode) throws UnsupportedCommOperationException {
        this.checkState();
        Termios termios2 = this.m_Termios;
        synchronized (termios2) {
            this.m_Termios.c_iflag &= ~JTermios.IXANY;
            this.m_Termios.c_cflag = (mode & 3) != 0 ? (this.m_Termios.c_cflag |= JTermios.CRTSCTS) : (this.m_Termios.c_cflag &= ~JTermios.CRTSCTS);
            this.m_Termios.c_iflag = (mode & 4) != 0 ? (this.m_Termios.c_iflag |= JTermios.IXOFF) : (this.m_Termios.c_iflag &= ~JTermios.IXOFF);
            this.m_Termios.c_iflag = (mode & 8) != 0 ? (this.m_Termios.c_iflag |= JTermios.IXON) : (this.m_Termios.c_iflag &= ~JTermios.IXON);
            this.checkReturnCode(JTermios.tcsetattr(this.m_FD, JTermios.TCSANOW, this.m_Termios));
            this.m_FlowControlMode = mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSerialPortParams(int baudRate, int dataBits, int stopBits, int parity) throws UnsupportedCommOperationException {
        this.checkState();
        Termios termios2 = this.m_Termios;
        synchronized (termios2) {
            Termios prev = new Termios();
            prev.set(this.m_Termios);
            try {
                int sb;
                int db;
                this.checkReturnCode(JTermios.setspeed(this.m_FD, this.m_Termios, baudRate));
                switch (dataBits) {
                    case 5: {
                        db = JTermios.CS5;
                        break;
                    }
                    case 6: {
                        db = JTermios.CS6;
                        break;
                    }
                    case 7: {
                        db = JTermios.CS7;
                        break;
                    }
                    case 8: {
                        db = JTermios.CS8;
                        break;
                    }
                    default: {
                        throw new UnsupportedCommOperationException("dataBits = " + dataBits);
                    }
                }
                switch (stopBits) {
                    case 1: {
                        sb = 1;
                        break;
                    }
                    case 3: {
                        sb = 2;
                        break;
                    }
                    case 2: {
                        sb = 2;
                        break;
                    }
                    default: {
                        throw new UnsupportedCommOperationException("stopBits = " + stopBits);
                    }
                }
                int fi = this.m_Termios.c_iflag & ~(JTermios.INPCK | JTermios.ISTRIP);
                int fc = this.m_Termios.c_cflag & ~(JTermios.PARENB | JTermios.CMSPAR | JTermios.PARODD);
                switch (parity) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        fc |= JTermios.PARENB;
                        break;
                    }
                    case 1: {
                        fc |= JTermios.PARENB;
                        fc |= JTermios.PARODD;
                        break;
                    }
                    case 3: {
                        fc |= JTermios.PARENB;
                        fc |= JTermios.CMSPAR;
                        fc |= JTermios.PARODD;
                        break;
                    }
                    case 4: {
                        fc |= JTermios.PARENB;
                        fc |= JTermios.CMSPAR;
                        break;
                    }
                    default: {
                        throw new UnsupportedCommOperationException("parity = " + parity);
                    }
                }
                fc &= ~JTermios.CSIZE;
                fc |= db;
                fc = sb == 2 ? (fc |= JTermios.CSTOPB) : (fc &= ~JTermios.CSTOPB);
                this.m_Termios.c_cflag = fc;
                this.m_Termios.c_iflag = fi;
                if (JTermios.tcsetattr(this.m_FD, JTermios.TCSANOW, this.m_Termios) != 0) {
                    throw new UnsupportedCommOperationException("tcsetattr failed");
                }
                this.m_BaudRate = baudRate;
                this.m_Parity = parity;
                this.m_DataBits = dataBits;
                this.m_StopBits = stopBits;
            }
            catch (UnsupportedCommOperationException e) {
                this.m_Termios.set(prev);
                this.checkReturnCode(JTermios.tcsetattr(this.m_FD, JTermios.TCSANOW, this.m_Termios));
                throw e;
            }
            catch (IllegalStateException e) {
                this.m_Termios.set(prev);
                this.checkReturnCode(JTermios.tcsetattr(this.m_FD, JTermios.TCSANOW, this.m_Termios));
                if (e instanceof PureJavaIllegalStateException) {
                    throw e;
                }
                throw new PureJavaIllegalStateException(e);
            }
        }
    }

    public int getNativeFileDescriptor() {
        return this.m_FD;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        this.checkState();
        if (this.m_OutputStream == null) {
            this.m_OutputStream = new OutputStream(){
                private byte[] im_Buffer = new byte[2048];

                public final void write(int b) throws IOException {
                    PureJavaSerialPort.this.checkState();
                    byte[] buf = new byte[]{(byte)b};
                    this.write(buf, 0, 1);
                }

                public final void write(byte[] buffer, int offset, int length) throws IOException {
                    if (buffer == null) {
                        throw new IllegalArgumentException();
                    }
                    if (offset < 0 || length < 0 || offset + length > buffer.length) {
                        throw new IndexOutOfBoundsException("buffer.lengt " + buffer.length + " offset " + offset + " length " + length);
                    }
                    PureJavaSerialPort.this.checkState();
                    while (length > 0) {
                        int n = buffer.length - offset;
                        if (n > this.im_Buffer.length) {
                            n = this.im_Buffer.length;
                        }
                        if (n > length) {
                            n = length;
                        }
                        if (offset > 0) {
                            System.arraycopy(buffer, offset, this.im_Buffer, 0, n);
                            n = JTermios.write(PureJavaSerialPort.this.m_FD, this.im_Buffer, n);
                        } else {
                            n = JTermios.write(PureJavaSerialPort.this.m_FD, buffer, n);
                        }
                        if (n < 0) {
                            PureJavaSerialPort.this.close();
                            throw new IOException();
                        }
                        length -= n;
                        offset += n;
                    }
                    PureJavaSerialPort.this.m_OutputEmptyNotified = false;
                }

                public final void write(byte[] b) throws IOException {
                    this.write(b, 0, b.length);
                }

                public void close() throws IOException {
                    super.close();
                }

                public final void flush() throws IOException {
                    PureJavaSerialPort.this.checkState();
                    if (JTermios.tcdrain(PureJavaSerialPort.this.m_FD) < 0) {
                        this.close();
                        throw new IOException();
                    }
                }
            };
        }
        return this.m_OutputStream;
    }

    public synchronized InputStream getInputStream() throws IOException {
        this.checkState();
        if (this.m_InputStream == null) {
            this.m_InputStream = new InputStream(){
                private int[] im_Available = new int[1];
                private byte[] im_Buffer = new byte[2048];
                private int im_VTIME = -1;
                private int im_VMIN = -1;
                private final Pollfd[] im_ReadPollFD = new Pollfd[]{new Pollfd(), new Pollfd()};
                private byte[] im_Nudge;
                private JTermios.FDSet im_ReadFDSet = JTermios.newFDSet();
                private TimeVal im_ReadTimeVal = new TimeVal();
                private int im_PollFDn;
                private boolean im_ReceiveTimeoutEnabled;
                private int im_ReceiveTimeoutValue;
                private boolean im_ReceiveThresholdEnabled;
                private int im_ReceiveThresholdValue;
                private boolean im_PollingReadMode;
                private int im_ReceiveTimeoutVTIME;
                {
                    this.im_ReadPollFD[0].fd = PureJavaSerialPort.this.m_FD;
                    this.im_ReadPollFD[0].events = JTermios.POLLIN;
                    this.im_ReadPollFD[1].fd = PureJavaSerialPort.this.m_PipeRdFD;
                    this.im_ReadPollFD[1].events = JTermios.POLLIN;
                    this.im_PollFDn = PureJavaSerialPort.this.m_HaveNudgePipe ? 2 : 1;
                    this.im_Nudge = new byte[1];
                }

                public final int available() throws IOException {
                    PureJavaSerialPort.this.checkState();
                    if (JTermios.ioctl(PureJavaSerialPort.this.m_FD, JTermios.FIONREAD, this.im_Available) < 0) {
                        PureJavaSerialPort.this.close();
                        System.out.println(Native.getLastError());
                        throw new IOException();
                    }
                    return this.im_Available[0];
                }

                public final int read() throws IOException {
                    PureJavaSerialPort.this.checkState();
                    byte[] buf = new byte[1];
                    int n = this.read(buf, 0, 1);
                    return n > 0 ? buf[0] & 0xFF : -1;
                }

                public void close() throws IOException {
                    super.close();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final int read(byte[] buffer, int offset, int length) throws IOException {
                    if (buffer == null) {
                        throw new IllegalArgumentException("buffer null");
                    }
                    if (length == 0) {
                        return 0;
                    }
                    if (offset < 0 || length < 0 || offset + length > buffer.length) {
                        throw new IndexOutOfBoundsException("buffer.length " + buffer.length + " offset " + offset + " length " + length);
                    }
                    if (PureJavaSerialPort.this.RAW_READ_MODE) {
                        int bytesRead;
                        if (PureJavaSerialPort.this.m_TimeoutThresholdChanged) {
                            Object object = PureJavaSerialPort.this.m_ThresholdTimeoutLock;
                            synchronized (object) {
                                int vtime = PureJavaSerialPort.this.m_ReceiveTimeoutEnabled ? PureJavaSerialPort.this.m_ReceiveTimeoutVTIME : 0;
                                int vmin = PureJavaSerialPort.this.m_ReceiveThresholdEnabled ? PureJavaSerialPort.this.m_ReceiveThresholdValue : 1;
                                Termios termios2 = PureJavaSerialPort.this.m_Termios;
                                synchronized (termios2) {
                                    ((PureJavaSerialPort)PureJavaSerialPort.this).m_Termios.c_cc[JTermios.VTIME] = (byte)vtime;
                                    ((PureJavaSerialPort)PureJavaSerialPort.this).m_Termios.c_cc[JTermios.VMIN] = (byte)vmin;
                                    PureJavaSerialPort.this.checkReturnCode(JTermios.tcsetattr(PureJavaSerialPort.this.m_FD, JTermios.TCSANOW, PureJavaSerialPort.this.m_Termios));
                                }
                                PureJavaSerialPort.this.m_TimeoutThresholdChanged = false;
                            }
                        }
                        if (offset > 0) {
                            bytesRead = length < this.im_Buffer.length ? JTermios.read(PureJavaSerialPort.this.m_FD, this.im_Buffer, length) : JTermios.read(PureJavaSerialPort.this.m_FD, this.im_Buffer, this.im_Buffer.length);
                            if (bytesRead > 0) {
                                System.arraycopy(this.im_Buffer, 0, buffer, offset, bytesRead);
                            }
                        } else {
                            bytesRead = JTermios.read(PureJavaSerialPort.this.m_FD, buffer, length);
                        }
                        PureJavaSerialPort.this.m_DataAvailableNotified = false;
                        return bytesRead;
                    }
                    if (PureJavaSerialPort.this.m_FD < 0) {
                        PureJavaSerialPort.this.failWithIllegalStateException();
                    }
                    if (PureJavaSerialPort.this.m_TimeoutThresholdChanged) {
                        Object bytesRead = PureJavaSerialPort.this.m_ThresholdTimeoutLock;
                        synchronized (bytesRead) {
                            this.im_ReceiveTimeoutEnabled = PureJavaSerialPort.this.m_ReceiveTimeoutEnabled;
                            this.im_ReceiveTimeoutValue = PureJavaSerialPort.this.m_ReceiveTimeoutValue;
                            this.im_ReceiveThresholdEnabled = PureJavaSerialPort.this.m_ReceiveThresholdEnabled;
                            this.im_ReceiveThresholdValue = PureJavaSerialPort.this.m_ReceiveThresholdValue;
                            this.im_PollingReadMode = PureJavaSerialPort.this.m_PollingReadMode;
                            this.im_ReceiveTimeoutVTIME = PureJavaSerialPort.this.m_ReceiveTimeoutVTIME;
                            PureJavaSerialPort.this.m_TimeoutThresholdChanged = false;
                        }
                    }
                    int bytesLeft = length;
                    int bytesReceived = 0;
                    while (true) {
                        int vtime;
                        int vmin;
                        int minBytesRequired;
                        if (this.im_PollingReadMode) {
                            minBytesRequired = 0;
                            vmin = 0;
                            vtime = 0;
                        } else {
                            minBytesRequired = this.im_ReceiveThresholdEnabled ? this.im_ReceiveThresholdValue : 1;
                            if (minBytesRequired > bytesLeft) {
                                minBytesRequired = bytesLeft;
                            }
                            vmin = minBytesRequired <= 255 ? minBytesRequired : 255;
                            vtime = this.im_ReceiveTimeoutEnabled ? this.im_ReceiveTimeoutVTIME : 0;
                        }
                        if (vmin != this.im_VMIN || vtime != this.im_VTIME) {
                            this.im_VMIN = vmin;
                            this.im_VTIME = vtime;
                            Termios termios3 = PureJavaSerialPort.this.m_Termios;
                            synchronized (termios3) {
                                ((PureJavaSerialPort)PureJavaSerialPort.this).m_Termios.c_cc[JTermios.VTIME] = (byte)this.im_VTIME;
                                ((PureJavaSerialPort)PureJavaSerialPort.this).m_Termios.c_cc[JTermios.VMIN] = (byte)this.im_VMIN;
                                PureJavaSerialPort.this.checkReturnCode(JTermios.tcsetattr(PureJavaSerialPort.this.m_FD, JTermios.TCSANOW, PureJavaSerialPort.this.m_Termios));
                            }
                        }
                        boolean dataAvailable = false;
                        boolean timedout = false;
                        if (!this.im_PollingReadMode) {
                            int n;
                            int timeoutValue;
                            int n2 = timeoutValue = this.im_ReceiveTimeoutEnabled ? this.im_ReceiveTimeoutValue : Integer.MAX_VALUE;
                            if (PureJavaSerialPort.this.USE_POLL) {
                                short re;
                                n = JTermios.poll(this.im_ReadPollFD, this.im_PollFDn, timeoutValue);
                                if (n < 0 || PureJavaSerialPort.this.m_FD < 0) {
                                    throw new IOException();
                                }
                                if ((this.im_ReadPollFD[1].revents & JTermios.POLLIN) != 0) {
                                    JTermios.read(PureJavaSerialPort.this.m_PipeRdFD, this.im_Nudge, 1);
                                }
                                if (((re = this.im_ReadPollFD[0].revents) & JTermios.POLLNVAL_OUT) != 0) {
                                    throw new IOException();
                                }
                                dataAvailable = (re & JTermios.POLLIN) != 0;
                            } else {
                                JTermios.FD_ZERO(this.im_ReadFDSet);
                                JTermios.FD_SET(PureJavaSerialPort.this.m_FD, this.im_ReadFDSet);
                                int maxFD = PureJavaSerialPort.this.m_FD;
                                if (PureJavaSerialPort.this.m_HaveNudgePipe) {
                                    JTermios.FD_SET(PureJavaSerialPort.this.m_PipeRdFD, this.im_ReadFDSet);
                                    if (PureJavaSerialPort.this.m_PipeRdFD > maxFD) {
                                        maxFD = PureJavaSerialPort.this.m_PipeRdFD;
                                    }
                                }
                                if (timeoutValue >= 1000) {
                                    int t = timeoutValue / 1000;
                                    this.im_ReadTimeVal.tv_sec = t;
                                    this.im_ReadTimeVal.tv_usec = (timeoutValue - t * 1000) * 1000;
                                } else {
                                    this.im_ReadTimeVal.tv_sec = 0L;
                                    this.im_ReadTimeVal.tv_usec = timeoutValue * 1000;
                                }
                                n = JTermios.select(maxFD + 1, this.im_ReadFDSet, null, null, this.im_ReadTimeVal);
                                if (n < 0) {
                                    throw new IOException();
                                }
                                if (PureJavaSerialPort.this.m_FD < 0) {
                                    throw new IOException();
                                }
                                dataAvailable = JTermios.FD_ISSET(PureJavaSerialPort.this.m_FD, this.im_ReadFDSet);
                            }
                            if (n == 0 && PureJavaSerialPort.this.m_ReceiveTimeoutEnabled) {
                                timedout = true;
                            }
                        }
                        if (timedout) break;
                        int bytesRead = 0;
                        if (dataAvailable || this.im_PollingReadMode) {
                            if (offset > 0) {
                                bytesRead = bytesLeft < this.im_Buffer.length ? JTermios.read(PureJavaSerialPort.this.m_FD, this.im_Buffer, bytesLeft) : JTermios.read(PureJavaSerialPort.this.m_FD, this.im_Buffer, this.im_Buffer.length);
                                if (bytesRead > 0) {
                                    System.arraycopy(this.im_Buffer, 0, buffer, offset, bytesRead);
                                }
                            } else {
                                bytesRead = JTermios.read(PureJavaSerialPort.this.m_FD, buffer, bytesLeft);
                            }
                            if (bytesRead == 0) {
                                timedout = true;
                            }
                        }
                        if (bytesRead < 0) {
                            throw new IOException();
                        }
                        if ((bytesReceived += bytesRead) >= minBytesRequired || timedout) break;
                        offset += bytesRead;
                        bytesLeft -= bytesRead;
                    }
                    PureJavaSerialPort.this.m_DataAvailableNotified = false;
                    return bytesReceived;
                }
            };
        }
        return this.m_InputStream;
    }

    public synchronized int getReceiveFramingByte() {
        this.checkState();
        return 0;
    }

    public synchronized int getReceiveThreshold() {
        this.checkState();
        return this.m_ReceiveThresholdValue;
    }

    public synchronized int getReceiveTimeout() {
        this.checkState();
        return this.m_ReceiveTimeoutValue;
    }

    public synchronized boolean isReceiveFramingEnabled() {
        this.checkState();
        return false;
    }

    public synchronized boolean isReceiveThresholdEnabled() {
        this.checkState();
        return this.m_ReceiveThresholdEnabled;
    }

    public synchronized boolean isReceiveTimeoutEnabled() {
        this.checkState();
        return this.m_ReceiveTimeoutEnabled;
    }

    public synchronized void setInputBufferSize(int arg0) {
        this.checkState();
    }

    public synchronized void setOutputBufferSize(int arg0) {
        this.checkState();
    }

    private void nudgePipe() {
        if (this.m_HaveNudgePipe) {
            JTermios.write(this.m_PipeWrFD, this.m_NudgeData, 1);
        }
    }

    public synchronized void close() {
        int fd = this.m_FD;
        if (fd != -1) {
            int err;
            block23: {
                block21: {
                    this.m_FD = -1;
                    try {
                        try {
                            if (this.m_InputStream != null) {
                                this.m_InputStream.close();
                            }
                        }
                        catch (IOException e) {
                            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "m_InputStream.close threw an IOException %s\n", e.getMessage());
                            this.m_InputStream = null;
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        this.m_InputStream = null;
                        throw throwable;
                    }
                    this.m_InputStream = null;
                }
                try {
                    try {
                        if (this.m_OutputStream != null) {
                            this.m_OutputStream.close();
                        }
                    }
                    catch (IOException e) {
                        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "m_OutputStream.close threw an IOException %s\n", e.getMessage());
                        this.m_OutputStream = null;
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    this.m_OutputStream = null;
                    throw throwable;
                }
                this.m_OutputStream = null;
            }
            this.nudgePipe();
            int flags = JTermios.fcntl(fd, JTermios.F_GETFL, 0);
            int fcres = JTermios.fcntl(fd, JTermios.F_SETFL, flags |= JTermios.O_NONBLOCK);
            if (fcres != 0) {
                boolean bl = JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "fcntl(%d,%d,%d) returned %d\n", fd, JTermios.F_SETFL, flags, fcres);
            }
            if (this.m_Thread != null) {
                this.m_Thread.interrupt();
            }
            if ((err = JTermios.close(fd)) < 0) {
                boolean bl = JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "JTermios.close returned %d, errno %d\n", err, JTermios.errno());
            }
            if (this.m_HaveNudgePipe) {
                err = JTermios.close(this.m_PipeRdFD);
                if (err < 0) {
                    boolean bl = JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "JTermios.close returned %d, errno %d\n", err, JTermios.errno());
                }
                if ((err = JTermios.close(this.m_PipeWrFD)) < 0) {
                    JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "JTermios.close returned %d, errno %d\n", err, JTermios.errno());
                }
            }
            long t0 = System.currentTimeMillis();
            while (this.m_ThreadRunning) {
                try {
                    Thread.sleep(5L);
                    if (System.currentTimeMillis() - t0 <= 2000L) continue;
                }
                catch (InterruptedException e) {}
                break;
            }
            super.close();
        }
    }

    PureJavaSerialPort(String name, int timeout) throws PortInUseException {
        int[] pipes;
        boolean usepoll = false;
        if (JTermios.canPoll()) {
            String key1 = "purejavacomm.use_poll";
            String key2 = "purejavacomm.usepoll";
            if (System.getProperty(key1) != null) {
                usepoll = Boolean.getBoolean(key1);
                JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "use of '%s' is deprecated, use '%s' instead\n", key1, key2);
            } else {
                usepoll = System.getProperty(key2) != null ? Boolean.getBoolean(key2) : true;
            }
        }
        this.USE_POLL = usepoll;
        this.RAW_READ_MODE = Boolean.getBoolean("purejavacomm.rawreadmode");
        this.name = name;
        int tries = (timeout + 5) / 10;
        while ((this.m_FD = JTermios.open(name, JTermios.O_RDWR | JTermios.O_NOCTTY | JTermios.O_NONBLOCK)) < 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
            if (tries-- >= 0) continue;
            throw new PortInUseException("Unknown Application");
        }
        this.m_MinVTIME = Integer.getInteger("purejavacomm.minvtime", 100);
        int flags = JTermios.fcntl(this.m_FD, JTermios.F_GETFL, 0);
        this.checkReturnCode(JTermios.fcntl(this.m_FD, JTermios.F_SETFL, flags &= ~JTermios.O_NONBLOCK));
        this.m_BaudRate = 9600;
        this.m_DataBits = 8;
        this.m_FlowControlMode = 0;
        this.m_Parity = 0;
        this.m_StopBits = 1;
        this.checkReturnCode(JTermios.tcgetattr(this.m_FD, this.m_Termios));
        JTermios.cfmakeraw(this.m_FD, this.m_Termios);
        this.m_Termios.c_cflag |= JTermios.CLOCAL | JTermios.CREAD;
        this.m_Termios.c_lflag &= ~(JTermios.ICANON | JTermios.ECHO | JTermios.ECHOE | JTermios.ISIG);
        this.m_Termios.c_oflag &= ~JTermios.OPOST;
        this.m_Termios.c_cc[JTermios.VSTART] = (byte)JTermios.DC1;
        this.m_Termios.c_cc[JTermios.VSTOP] = (byte)JTermios.DC3;
        this.m_Termios.c_cc[JTermios.VMIN] = 0;
        this.m_Termios.c_cc[JTermios.VTIME] = 0;
        this.checkReturnCode(JTermios.tcsetattr(this.m_FD, JTermios.TCSANOW, this.m_Termios));
        try {
            this.setSerialPortParams(this.m_BaudRate, this.m_DataBits, this.m_StopBits, this.m_Parity);
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
        }
        try {
            this.setFlowControlMode(0);
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
        }
        int res = JTermios.ioctl(this.m_FD, JTermios.TIOCMGET, this.m_ioctl);
        if (res == 0) {
            this.m_ControlLineStates = this.m_ioctl[0];
        } else {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "ioctl(TIOCMGET) returned %d, errno %d\n", res, JTermios.errno());
        }
        String nudgekey = "purejavacomm.usenudgepipe";
        if ((System.getProperty(nudgekey) == null || Boolean.getBoolean(nudgekey)) && JTermios.pipe(pipes = new int[2]) == 0) {
            this.m_HaveNudgePipe = true;
            this.m_PipeRdFD = pipes[0];
            this.m_PipeWrFD = pipes[1];
            this.checkReturnCode(JTermios.fcntl(this.m_PipeRdFD, JTermios.F_SETFL, JTermios.fcntl(this.m_PipeRdFD, JTermios.F_GETFL, 0) | JTermios.O_NONBLOCK));
        }
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    try {
                        PureJavaSerialPort.this.m_ThreadRunning = true;
                        int TIMEOUT = Integer.getInteger("purejavacomm.pollperiod", 10);
                        TimeVal timeout = null;
                        JTermios.FDSet rset = null;
                        JTermios.FDSet wset = null;
                        Pollfd[] pollfd2 = null;
                        byte[] nudge = null;
                        if (PureJavaSerialPort.this.USE_POLL) {
                            pollfd2 = new Pollfd[]{new Pollfd(), new Pollfd()};
                            nudge = new byte[1];
                            pollfd2[0].fd = PureJavaSerialPort.this.m_FD;
                            pollfd2[1].fd = PureJavaSerialPort.this.m_PipeRdFD;
                        } else {
                            rset = JTermios.newFDSet();
                            wset = JTermios.newFDSet();
                            timeout = new TimeVal();
                            int t = TIMEOUT * 1000;
                            timeout.tv_sec = t / 1000000;
                            timeout.tv_usec = (long)t - timeout.tv_sec * 1000000L;
                        }
                        while (PureJavaSerialPort.this.m_FD >= 0) {
                            boolean pollCtrlLines;
                            boolean read = PureJavaSerialPort.this.m_NotifyOnDataAvailable && !PureJavaSerialPort.this.m_DataAvailableNotified;
                            boolean write = PureJavaSerialPort.this.m_NotifyOnOutputEmpty && !PureJavaSerialPort.this.m_OutputEmptyNotified;
                            int n = 0;
                            boolean bl = pollCtrlLines = PureJavaSerialPort.this.m_NotifyOnCTS || PureJavaSerialPort.this.m_NotifyOnDSR || PureJavaSerialPort.this.m_NotifyOnRI || PureJavaSerialPort.this.m_NotifyOnCD;
                            if (read || write || !pollCtrlLines && PureJavaSerialPort.this.m_HaveNudgePipe) {
                                if (PureJavaSerialPort.this.USE_POLL) {
                                    short e = 0;
                                    if (read) {
                                        e = (short)(e | JTermios.POLLIN);
                                    }
                                    if (write) {
                                        e = (short)(e | JTermios.POLLOUT);
                                    }
                                    pollfd2[0].events = e;
                                    pollfd2[1].events = JTermios.POLLIN;
                                    n = PureJavaSerialPort.this.m_HaveNudgePipe ? JTermios.poll(pollfd2, 2, -1) : JTermios.poll(pollfd2, 1, TIMEOUT);
                                    short re = pollfd2[1].revents;
                                    if ((re & JTermios.POLLNVAL) != 0) {
                                        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "poll() returned POLLNVAL, errno %d\n", JTermios.errno());
                                        break;
                                    }
                                    if ((re & JTermios.POLLIN) != 0) {
                                        JTermios.read(PureJavaSerialPort.this.m_PipeRdFD, nudge, 1);
                                    }
                                    if (((re = pollfd2[0].revents) & JTermios.POLLNVAL) != 0) {
                                        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "poll() returned POLLNVAL, errno %d\n", JTermios.errno());
                                        break;
                                    }
                                    read = read && (re & JTermios.POLLIN) != 0;
                                    write = write && (re & JTermios.POLLOUT) != 0;
                                } else {
                                    JTermios.FD_ZERO(rset);
                                    JTermios.FD_ZERO(wset);
                                    if (read) {
                                        JTermios.FD_SET(PureJavaSerialPort.this.m_FD, rset);
                                    }
                                    if (write) {
                                        JTermios.FD_SET(PureJavaSerialPort.this.m_FD, wset);
                                    }
                                    if (PureJavaSerialPort.this.m_HaveNudgePipe) {
                                        JTermios.FD_SET(PureJavaSerialPort.this.m_PipeRdFD, rset);
                                    }
                                    n = JTermios.select(PureJavaSerialPort.this.m_FD + 1, rset, wset, null, PureJavaSerialPort.this.m_HaveNudgePipe ? null : timeout);
                                    read = read && JTermios.FD_ISSET(PureJavaSerialPort.this.m_FD, rset);
                                    boolean bl2 = write = write && JTermios.FD_ISSET(PureJavaSerialPort.this.m_FD, wset);
                                }
                                if (PureJavaSerialPort.this.m_FD < 0) {
                                    break;
                                }
                                if (n < 0) {
                                    JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "select() or poll() returned %d, errno %d\n", n, JTermios.errno());
                                    PureJavaSerialPort.this.close();
                                    break;
                                }
                            } else {
                                Thread.sleep(TIMEOUT);
                            }
                            if (PureJavaSerialPort.this.m_EventListener == null) continue;
                            if (read || write) {
                                PureJavaSerialPort.this.sendDataEvents(read, write);
                            }
                            if (!pollCtrlLines) continue;
                            PureJavaSerialPort.this.sendNonDataEvents();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        PureJavaSerialPort.this.m_ThreadRunning = false;
                    }
                }
                finally {
                    PureJavaSerialPort.this.m_ThreadRunning = false;
                }
            }
        };
        this.m_Thread = new Thread(runnable, this.getName());
        this.m_Thread.setDaemon(true);
    }

    private synchronized void updateControlLineState(int line) {
        this.checkState();
        if (JTermios.ioctl(this.m_FD, JTermios.TIOCMGET, this.m_ioctl) == -1) {
            throw new PureJavaIllegalStateException("ioctl(m_FD, TIOCMGET, m_ioctl) == -1");
        }
        this.m_ControlLineStates = (this.m_ioctl[0] & line) + (this.m_ControlLineStates & ~line);
    }

    private synchronized boolean getControlLineState(int line) {
        this.checkState();
        if (JTermios.ioctl(this.m_FD, JTermios.TIOCMGET, this.m_ioctl) == -1) {
            throw new PureJavaIllegalStateException("ioctl(m_FD, TIOCMGET, m_ioctl) == -1");
        }
        return (this.m_ioctl[0] & line) != 0;
    }

    private synchronized void setControlLineState(int line, boolean state) {
        this.checkState();
        if (JTermios.ioctl(this.m_FD, JTermios.TIOCMGET, this.m_ioctl) == -1) {
            throw new PureJavaIllegalStateException("ioctl(m_FD, TIOCMGET, m_ioctl) == -1");
        }
        this.m_ioctl[0] = state ? this.m_ioctl[0] | line : this.m_ioctl[0] & ~line;
        if (JTermios.ioctl(this.m_FD, JTermios.TIOCMSET, this.m_ioctl) == -1) {
            throw new PureJavaIllegalStateException("ioctl(m_FD, TIOCMSET, m_ioctl) == -1");
        }
    }

    private void failWithIllegalStateException() {
        throw new PureJavaIllegalStateException("File descriptor is " + this.m_FD + " < 0, maybe closed by previous error condition");
    }

    private void checkState() {
        if (this.m_FD < 0) {
            this.failWithIllegalStateException();
        }
    }

    private void checkReturnCode(int code) {
        if (code != 0) {
            String msg = String.format("JTermios call returned %d at %s", code, JTermios.JTermiosLogging.lineno(1));
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "%s\n", msg);
            try {
                this.close();
            }
            catch (Exception e) {
                StackTraceElement st = e.getStackTrace()[0];
                String msg2 = String.format("close threw %s at class %s line% d", e.getClass().getName(), st.getClassName(), st.getLineNumber());
                JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "%s\n", msg2);
            }
            throw new PureJavaIllegalStateException(msg);
        }
    }

    public boolean isInternalThreadRunning() {
        return this.m_ThreadRunning;
    }
}

