/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import purejavacomm.UnsupportedCommOperationException;
import purejavacomm.testsuite.TestBase;

public class Test8
extends TestBase {
    private static final int[] LIMITED_PARITY;
    private static final int[] LIMITED_STOPBITS;
    private static final int[] LIMITED_DATABITS;
    private static final int[] LIMITED_DATAMASK;
    private static final int[] FULL_PARITY;
    private static final int[] FULL_STOPBITS;
    private static final int[] FULL_DATABITS;
    private static final int[] FULL_DATAMASK;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        LIMITED_PARITY = nArray;
        LIMITED_STOPBITS = new int[]{1};
        LIMITED_DATABITS = new int[]{8};
        LIMITED_DATAMASK = new int[]{255};
        int[] nArray2 = new int[5];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        FULL_PARITY = nArray2;
        FULL_STOPBITS = new int[]{1, 3, 2};
        FULL_DATABITS = new int[]{8, 7, 6, 5};
        FULL_DATAMASK = new int[]{255, 127, 63, 31};
    }

    static void run() throws Exception {
        Test8.run(true);
    }

    static void run(boolean allModes) throws Exception {
        try {
            int[] datamask;
            int[] databits;
            int[] stopbits;
            int[] parity;
            Test8.begin("Test8 - parity etc");
            Test8.openPort();
            if (allModes) {
                parity = FULL_PARITY;
                stopbits = FULL_STOPBITS;
                databits = FULL_DATABITS;
                datamask = FULL_DATAMASK;
            } else {
                parity = LIMITED_PARITY;
                stopbits = LIMITED_STOPBITS;
                databits = LIMITED_DATABITS;
                datamask = LIMITED_DATAMASK;
            }
            System.out.println();
            int tn = 0;
            int ppi = 0;
            while (ppi < parity.length) {
                int sbi = 0;
                while (sbi < stopbits.length) {
                    int dbi = 0;
                    while (dbi < databits.length) {
                        m_Port.enableReceiveTimeout(10000);
                        m_Port.enableReceiveThreshold(256);
                        try {
                            String db = "?";
                            switch (databits[dbi]) {
                                case 5: {
                                    db = "5";
                                    break;
                                }
                                case 6: {
                                    db = "6";
                                    break;
                                }
                                case 7: {
                                    db = "7";
                                    break;
                                }
                                case 8: {
                                    db = "8";
                                }
                            }
                            String sb = "?";
                            switch (stopbits[sbi]) {
                                case 1: {
                                    sb = "1";
                                    break;
                                }
                                case 3: {
                                    sb = "1.5";
                                    break;
                                }
                                case 2: {
                                    sb = "2";
                                }
                            }
                            String pb = "?";
                            switch (parity[ppi]) {
                                case 2: {
                                    pb = "E";
                                    break;
                                }
                                case 1: {
                                    pb = "O";
                                    break;
                                }
                                case 3: {
                                    pb = "M";
                                    break;
                                }
                                case 4: {
                                    pb = "S";
                                    break;
                                }
                                case 0: {
                                    pb = "N";
                                }
                            }
                            Test8.begin("Test8." + ++tn + " databits=" + db + " stopbits=" + sb + " parity=" + pb);
                            m_Port.setSerialPortParams(19200, databits[dbi], stopbits[sbi], parity[ppi]);
                            Test8.sleep(100);
                            byte[] sent = new byte[256];
                            byte[] rcvd = new byte[256];
                            int i = 0;
                            while (i < 256) {
                                sent[i] = (byte)i;
                                ++i;
                            }
                            m_Out = m_Port.getOutputStream();
                            m_In = m_Port.getInputStream();
                            long t0 = System.currentTimeMillis();
                            m_Out.write(sent);
                            int n = 0;
                            while ((n += m_In.read(rcvd, n, 256 - n)) < 256) {
                            }
                            if (n != sent.length) {
                                Test8.fail("was expecting %d characters got %d", sent.length, n);
                            }
                            int i2 = 0;
                            while (i2 < 256) {
                                int tx;
                                if (i2 <= datamask[dbi]) {
                                    if (rcvd[i2] != sent[i2]) {
                                        Test8.fail("failed: transmit '0x%02X' != receive'0x%02X'", sent[i2], rcvd[i2]);
                                    }
                                } else if (databits[dbi] >= 7 && rcvd[i2] != (tx = sent[i2] & datamask[dbi])) {
                                    Test8.fail("failed: transmit (excessive) '0x%02X' != receive'0x%02X'%n", tx, rcvd[i2]);
                                }
                                ++i2;
                            }
                            if (n < 256) {
                                Test8.fail("did not receive all 256 chars, got %d", n);
                            }
                            Test8.finishedOK();
                        }
                        catch (UnsupportedCommOperationException e) {
                            Test8.finishedOK(" NOT SUPPORTED " + e.getMessage(), new Object[0]);
                        }
                        ++dbi;
                    }
                    ++sbi;
                }
                ++ppi;
            }
        }
        finally {
            Test8.closePort();
        }
    }
}

