/*
 * Decompiled with CFR 0.152.
 */
package mseries.Calendar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDateSelectorPanel;
import mseries.Calendar.MDateSelectorUI;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.Calendar.MMonthEvent;
import mseries.Calendar.MMonthListener;

public class MDateSelector
implements ActionListener,
MMonthListener {
    protected Color[] background;
    protected Color[] foreground;
    private MDateSelectorUI view;
    private MDateSelectorPanel panel;
    private Date today;
    private Date minDate;
    private Date maxDate;
    private Date returnDate;
    private boolean cancelled;
    private DateFormat ddf;
    private ResourceBundle rb = null;
    private int firstDay = 1;
    private String imageFile;
    private int style = 2;
    MDateSelectorConstraints constraints = new MDefaultPullDownConstraints();

    public MDateSelector(Date min, Date max) {
        this.minDate = min;
        this.maxDate = max;
        this.today = new Date();
        this.background = new Color[7];
        this.foreground = new Color[7];
    }

    public MDateSelectorPanel getDisplay() {
        return this.getDisplay(this.today);
    }

    public void setImageFile(String imageFile) {
        this.imageFile = imageFile;
    }

    public void setForeground(int day, Color color) {
        this.foreground[day - 1] = color;
    }

    public void setBackground(int day, Color color) {
        this.background[day - 1] = color;
    }

    public void setConstraints(MDateSelectorConstraints c) {
        this.constraints = c;
    }

    public MDateSelectorConstraints getConstraints() {
        return this.constraints;
    }

    public MDateSelectorPanel getDisplay(Date date) {
        this.returnDate = date;
        Date inDate = date == null ? this.today : new Date(date.getTime());
        if (this.panel == null) {
            this.panel = new MDateSelectorPanel(true, this.minDate, this.maxDate);
            this.panel.setPullDownConstraints(this.constraints);
            this.panel.setFocusCycleRoot(false);
            this.panel.setDate(inDate);
        }
        return this.panel;
    }

    public void setChangerStyle(int style) {
        this.style = style;
    }

    public int getChangerStyle() {
        return this.style;
    }

    public void show(Component parent, Point pnt, Date date) {
        this.showSelector(parent, pnt, date);
    }

    private void showSelector(Component parent, Point pnt, Date date) {
        int x = 0;
        int y = 0;
        this.returnDate = date;
        Component frame = parent;
        while (!(frame instanceof JFrame)) {
            x += frame.getBounds().x;
            y += frame.getBounds().y;
            frame = frame.getParent();
        }
        JFrame f = (JFrame)frame;
        if (this.panel == null) {
            this.panel = this.getDisplay(date);
            this.panel.addMMonthListener(this);
        }
        if (this.view == null) {
            this.view = new MDateSelectorUI(f, this.panel, this, this.constraints.getResourceBundle(), this.ddf, this.constraints.getImageFile());
            this.view.pack();
        }
        this.view.setTitle(this.constraints.getPopupTitle());
        Rectangle r = this.view.getBounds();
        r.x = pnt.x + f.getBounds().x + x;
        r.y = pnt.y + f.getBounds().y + y;
        Toolkit t = Toolkit.getDefaultToolkit();
        Dimension screen = t.getScreenSize();
        if (r.x + r.width > screen.width) {
            r.x = screen.width - r.width;
        }
        if (r.y + r.height > screen.height) {
            r.y = screen.height - r.height;
        }
        this.view.setBounds(r);
        this.view.show();
    }

    public void setMinimum(Date min) {
        this.minDate = min;
    }

    public void setMaximum(Date max) {
        this.maxDate = max;
    }

    public void setFirstDay(int firstDay) {
        this.firstDay = firstDay;
    }

    public void setTextLocalizer(ResourceBundle rb) {
        this.rb = rb;
    }

    public void setDateFormatter(DateFormat userDf) {
        this.ddf = userDf;
    }

    public void dataChanged(MMonthEvent e) {
        switch (e.getType()) {
            case 4: {
                if (this.view == null) break;
                this.view.setVisible(false);
                break;
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        this.cancelled = false;
        String command = event.getActionCommand();
        if (command.equals("today")) {
            this.panel.setDMY(this.today);
        }
        if (command.equals("ok")) {
            this.view.setVisible(false);
        }
        if (command.equals("cancel")) {
            this.cancelled = true;
            this.view.setVisible(false);
        }
    }

    public Date getValue() {
        if (this.cancelled) {
            return this.returnDate;
        }
        return this.panel.getDate();
    }
}

