/*
 * Decompiled with CFR 0.152.
 */
package mseries.Calendar;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import mseries.Calendar.MDateSelector;
import mseries.Calendar.MDateSelectorPanel;
import mseries.Calendar.MMonthEvent;
import mseries.Calendar.MMonthListener;
import mseries.ui.MImagePanel;

public class MDateSelectorUI
extends JDialog
implements MMonthListener {
    private JTextField date;
    private GridBagConstraints c = new GridBagConstraints();
    private JButton okButton;
    private JButton todayButton;
    private JButton cancelButton;
    private DateFormat df;
    private ResourceBundle rb;
    MImagePanel innerPanel;

    public MDateSelectorUI(JFrame parent, MDateSelectorPanel panel, MDateSelector controller, ResourceBundle rb, DateFormat df, String imageFile) {
        super(parent, "MSeries Date Selector", true);
        this.setResizable(false);
        this.rb = rb;
        this.df = df == null ? new SimpleDateFormat(System.getProperty("MDateFormat", "d MMMMM yyyy")) : df;
        this.innerPanel = new MImagePanel(new GridBagLayout());
        if (imageFile != null) {
            this.innerPanel.setImageFile(imageFile);
        }
        this.innerPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.date = new JTextField("Error"){

            public boolean isFocusable() {
                return false;
            }
        };
        this.date.setEditable(false);
        this.setColours(this.date);
        this.date.setHorizontalAlignment(0);
        this.c.insets = new Insets(0, 0, 4, 0);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.gridy = -1;
        this.innerPanel.add((Component)this.date, this.c);
        this.c.gridheight = 5;
        this.c.gridy = 1;
        this.innerPanel.add((Component)panel, this.c);
        this.c.gridheight = 1;
        this.c.gridwidth = 1;
        this.okButton = new JButton();
        this.okButton.setActionCommand("ok");
        this.todayButton = new JButton();
        this.todayButton.setActionCommand("today");
        this.cancelButton = new JButton();
        this.cancelButton.setActionCommand("cancel");
        this.setLabels();
        this.c.insets = new Insets(0, 4, 4, 0);
        this.c.fill = 2;
        this.c.anchor = 15;
        this.c.weightx = 0.0;
        this.c.gridx = 1;
        this.c.gridy = 1;
        this.innerPanel.add((Component)this.okButton, this.c);
        this.c.anchor = 15;
        this.c.weightx = 0.0;
        this.c.gridx = 1;
        this.c.gridy = 2;
        this.innerPanel.add((Component)this.cancelButton, this.c);
        this.c.anchor = 10;
        this.c.weightx = 0.0;
        this.c.gridx = 1;
        this.c.gridy = 5;
        this.innerPanel.add((Component)this.todayButton, this.c);
        this.okButton.addActionListener(controller);
        this.todayButton.addActionListener(controller);
        this.cancelButton.addActionListener(controller);
        this.innerPanel.registerKeyboardAction(controller, "cancel", KeyStroke.getKeyStroke(27, 0), 2);
        panel.addMMonthListener(this);
        this.updateDate(panel.getDate());
        this.getContentPane().add(this.innerPanel);
        this.date.setOpaque(false);
        this.cancelButton.setOpaque(false);
        this.todayButton.setOpaque(false);
        this.okButton.setOpaque(false);
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        this.setSize(this.getMinimumSize());
    }

    public void setImageFile(String imageFile) {
        this.innerPanel.setImageFile(imageFile);
    }

    private void setLabels() {
        this.okButton.setText(this.getString("OK", "OK"));
        this.cancelButton.setText(this.getString("Cancel", "Cancel"));
        this.todayButton.setText(this.getString("Today", "Today"));
    }

    private String getString(String in, String def) {
        String ret;
        if (this.rb == null) {
            return def;
        }
        try {
            ret = this.rb.getString(in);
        }
        catch (MissingResourceException e) {
            ret = def;
        }
        return ret;
    }

    private void updateDate(Date date) {
        this.date.setText(this.df.format(date));
    }

    public void dataChanged(MMonthEvent e) {
        Calendar date = e.getNewDate();
        switch (e.getType()) {
            case 1: {
                this.updateDate(date.getTime());
                break;
            }
            case 0: {
                this.updateDate(date.getTime());
                break;
            }
            case 6: {
                this.setLabels();
                break;
            }
        }
    }

    protected void setColours(Component c) {
        c.setBackground(UIManager.getColor("control"));
        c.setForeground(UIManager.getColor("Button.foreground"));
    }
}

