/*
 * Decompiled with CFR 0.152.
 */
package mseries.Calendar;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class MDateValueEditor
implements PropertyEditor {
    protected Date value;
    protected DateFormat df;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    public MDateValueEditor() {
        this.df = DateFormat.getDateInstance(1);
    }

    public String getJavaInitializationString() {
        String buff = "new java.util.Date(" + this.value.getTime() + ")";
        return buff;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g, Rectangle r) {
        g.setClip(r);
        g.drawString(this.getAsText(), r.x + 5, r.y + 15);
    }

    public Component getCustomEditor() {
        final TextField t = new TextField(this.getAsText(), 20);
        t.addTextListener(new TextListener(){

            public void textValueChanged(TextEvent e) {
                MDateValueEditor.this.setAsText(t.getText());
            }
        });
        return t;
    }

    public String getAsText() {
        String val = null;
        val = this.df.format(this.value);
        return val;
    }

    public void setAsText(String s) {
        Date old = this.value;
        try {
            this.value = this.df.parse(s);
            this.listeners.firePropertyChange(null, null, null);
        }
        catch (ParseException e) {
            this.value = old;
        }
    }

    public void setValue(Object object) {
        if (object != null) {
            this.value = (Date)object;
        }
    }

    public Object getValue() {
        return this.value;
    }

    public String[] getTags() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }
}

