/*
 * Decompiled with CFR 0.152.
 */
package mseries.plaf.Kunststoff;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.plaf.ColorUIResource;
import mseries.plaf.Metal.MetalArrowButton;

public class KunststoffArrowButton
extends MetalArrowButton {
    public KunststoffArrowButton(int direction) {
        super(direction);
        this.setRequestFocusEnabled(false);
        this.setDirection(direction);
    }

    public void paint(Graphics g) {
        ColorUIResource colorShadow;
        super.paint(g);
        int w = this.getSize().width;
        int h = this.getSize().height;
        Color origColor = g.getColor();
        boolean isEnabled = this.isEnabled();
        ColorUIResource colorReflection = KunststoffLookAndFeel.getComponentGradientColorReflection();
        if (colorReflection != null) {
            Color colorReflectionFaded = KunststoffUtilities.getTranslucentColor((Color)colorReflection, (int)0);
            Rectangle rect = new Rectangle(0, 0, w, h / 2);
            KunststoffUtilities.drawGradient((Graphics)g, (Color)colorReflection, (Color)colorReflectionFaded, (Rectangle)rect, (boolean)true);
        }
        if ((colorShadow = KunststoffLookAndFeel.getComponentGradientColorShadow()) != null) {
            Color colorShadowFaded = KunststoffUtilities.getTranslucentColor((Color)colorShadow, (int)0);
            Rectangle rect = new Rectangle(0, h / 2, w, h / 2);
            KunststoffUtilities.drawGradient((Graphics)g, (Color)colorShadowFaded, (Color)colorShadow, (Rectangle)rect, (boolean)true);
        }
        int size = Math.min((h - 4) / 3, (w - 4) / 3);
        size = Math.max(size, 2) + 2;
        this.paintTriangle(g, (w - size) / 2, (h - size) / 2, size, this.direction, isEnabled);
        g.setColor(origColor);
    }
}

