/*
 * Decompiled with CFR 0.152.
 */
package mseries.plaf.Metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalArrowButton
extends JButton
implements SwingConstants {
    protected int direction;
    protected boolean top;
    protected boolean left;
    protected boolean bottom;
    protected boolean right;

    public MetalArrowButton(int direction) {
        this.setRequestFocusEnabled(false);
        this.setDirection(direction);
        this.setBackground(UIManager.getColor("control"));
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int dir) {
        this.direction = dir;
    }

    public void drawBorder(boolean top, boolean left, boolean bottom, boolean right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public void paint(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        Color origColor = g.getColor();
        boolean isPressed = this.getModel().isPressed();
        boolean isEnabled = this.isEnabled();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, w, h);
        if (this.left) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(0, 0, 0, h);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(1, 0, 1, h);
        }
        if (this.top) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(0, 0, w - 2, 0);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(1, 1, w - 1, 1);
        }
        if (this.bottom) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(1, h - 2, w, h - 2);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(0, h - 1, w, h - 1);
        }
        if (this.right) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(w - 2, 0, w - 2, h - 2);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(w - 1, 1, w - 1, h - 1);
        }
        if (isPressed) {
            g.setColor(UIManager.getColor("controlShadow"));
            g.fillRect(0, 0, w, h);
        }
        if (h < 5 || w < 5) {
            g.setColor(origColor);
            return;
        }
        int size = Math.min((h - 4) / 3, (w - 4) / 3);
        size = Math.max(size, 2) + 2;
        this.paintTriangle(g, (w - size) / 2, (h - size) / 2, size, this.direction, isEnabled);
        g.setColor(origColor);
    }

    public Dimension getPreferredSize() {
        return new Dimension(16, 16);
    }

    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public boolean isFocusable() {
        return false;
    }

    public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
        Color oldColor = g.getColor();
        int j = 0;
        size = Math.max(size, 2);
        int mid = size / 2;
        g.translate(x, y);
        g.setColor(this.isEnabled() ? MetalLookAndFeel.getControlInfo() : MetalLookAndFeel.getControlShadow());
        switch (direction) {
            case 1: {
                int i = 0;
                while (i < size) {
                    g.drawLine(mid - i, i, mid + i, i);
                    ++i;
                }
                if (isEnabled) break;
                g.setColor(UIManager.getColor("controlLtHighlight"));
                g.drawLine(mid - i + 2, i, mid + i, i);
                break;
            }
            case 5: {
                int i;
                if (!isEnabled) {
                    g.translate(1, 1);
                    g.setColor(UIManager.getColor("controlLtHighlight"));
                    i = size - 1;
                    while (i >= 0) {
                        g.drawLine(mid - i, j, mid + i, j);
                        ++j;
                        --i;
                    }
                    g.translate(-1, -1);
                    g.setColor(UIManager.getColor("controlShadow"));
                }
                j = 0;
                i = size - 1;
                while (i >= 0) {
                    g.drawLine(mid - i, j, mid + i, j);
                    ++j;
                    --i;
                }
                break;
            }
            case 7: {
                int i = 0;
                while (i < size) {
                    g.drawLine(i, mid - i, i, mid + i);
                    ++i;
                }
                if (isEnabled) break;
                g.setColor(UIManager.getColor("controlLtHighlight"));
                g.drawLine(i, mid - i + 2, i, mid + i);
                break;
            }
            case 3: {
                int i;
                if (!isEnabled) {
                    g.translate(1, 1);
                    g.setColor(UIManager.getColor("controlLtHighlight"));
                    i = size - 1;
                    while (i >= 0) {
                        g.drawLine(j, mid - i, j, mid + i);
                        ++j;
                        --i;
                    }
                    g.translate(-1, -1);
                    g.setColor(UIManager.getColor("controlShadow"));
                }
                j = 0;
                i = size - 1;
                while (i >= 0) {
                    g.drawLine(j, mid - i, j, mid + i);
                    ++j;
                    --i;
                }
                break;
            }
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }
}

