/*
 * Decompiled with CFR 0.152.
 */
package mseries.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import mseries.Calendar.CalendarPanel;

public class BasicCalendarPanelUI
extends ComponentUI {
    protected Color background = UIManager.getColor("control");
    protected Color foreground = UIManager.getColor("Button.foreground");
    protected Color selectedBackground = UIManager.getColor("controlShadow");
    protected Color selectedForeground = UIManager.getColor("Button.foreground");
    protected CalendarPanel calendarPanel;
    protected KeyListener keyHandler;
    protected MouseListener mouseHandler;
    protected FocusListener focusHandler;
    protected int cellWidth;
    protected int cellHeight;
    protected int DAYS;
    protected int WEEKS;
    protected Font font;
    private Toolkit tk = Toolkit.getDefaultToolkit();

    public static ComponentUI createUI(JComponent x) {
        return new BasicCalendarPanelUI();
    }

    public void installUI(JComponent c) {
        this.calendarPanel = (CalendarPanel)c;
        this.installDefaults();
        this.installListeners();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
    }

    protected void installDefaults() {
        this.DAYS = CalendarPanel.DAYS;
        this.WEEKS = CalendarPanel.WEEKS;
    }

    protected void uninstallDefaults() {
    }

    protected void installListeners() {
        this.keyHandler = this.createKeyHandler();
        if (this.keyHandler != null) {
            this.calendarPanel.addKeyListener(this.keyHandler);
        }
        if ((this.mouseHandler = this.createMouseHandler()) != null) {
            this.calendarPanel.addMouseListener(this.mouseHandler);
        }
        if ((this.focusHandler = this.createFocusHandler()) != null) {
            this.calendarPanel.addFocusListener(this.focusHandler);
        }
        this.installKeyboardActions();
    }

    private void installKeyboardActions() {
        this.calendarPanel.registerKeyboardAction(new ArrowKeyAction(-1, true), KeyStroke.getKeyStroke(37, 0), 0);
        this.calendarPanel.registerKeyboardAction(new ArrowKeyAction(1, true), KeyStroke.getKeyStroke(39, 0), 0);
        this.calendarPanel.registerKeyboardAction(new ArrowKeyAction(-1, false), KeyStroke.getKeyStroke(38, 0), 0);
        this.calendarPanel.registerKeyboardAction(new ArrowKeyAction(1, false), KeyStroke.getKeyStroke(40, 0), 0);
    }

    protected void uninstallListeners() {
        if (this.keyHandler != null) {
            this.calendarPanel.removeKeyListener(this.keyHandler);
        }
        if (this.mouseHandler != null) {
            this.calendarPanel.removeMouseListener(this.mouseHandler);
        }
        if (this.focusHandler != null) {
            this.calendarPanel.removeFocusListener(this.focusHandler);
        }
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    public void paint(Graphics g, JComponent c) {
        this.cellWidth = this.getCellSize().width;
        this.cellHeight = this.getCellSize().height;
        this.doPaint(g, c);
    }

    private void doPaint(Graphics g, JComponent c) {
        Point thisCell = this.calendarPanel.getSelectedCell();
        this.background = c.getBackground();
        this.foreground = c.getForeground();
        this.font = c.getFont();
        int d = 0;
        while (d < this.WEEKS) {
            int w = 0;
            while (w < this.DAYS) {
                String legend;
                boolean selectCell = false;
                if (thisCell.x == w && thisCell.y == d) {
                    selectCell = true;
                }
                if (!this.calendarPanel.isInMonth(d, w)) {
                    legend = null;
                    this.background = this.calendarPanel.getBackground();
                    this.foreground = this.calendarPanel.getForeground();
                } else {
                    int day = this.calendarPanel.getLegendFor(d, w);
                    if (day == 1) {
                        this.calendarPanel.firstCell.x = w;
                    }
                    legend = Integer.toString(day);
                    this.calendarPanel.lastCell.x = w;
                    this.calendarPanel.lastCell.y = d;
                    this.background = this.calendarPanel.getBackground(d, w);
                    this.foreground = this.calendarPanel.getForeground(d, w);
                }
                g.translate(this.cellWidth * w, this.cellHeight * d);
                this.drawSelectedEffect(g, selectCell);
                if (legend != null) {
                    this.drawLegend(g, legend);
                }
                this.drawFocusedEffect(g, this.calendarPanel.hasFocus() && selectCell, selectCell);
                g.translate(-(this.cellWidth * w), -(this.cellHeight * d));
                ++w;
            }
            ++d;
        }
    }

    protected void drawSelectedEffect(Graphics g, boolean selected) {
        int width = this.getCellSize().width;
        int height = this.getCellSize().height;
        if (this.isOpaque()) {
            g.setColor(this.background);
            g.fillRect(0, 0, width, height);
        }
        if (selected) {
            g.setColor(SystemColor.controlDkShadow);
            g.drawRoundRect(0, 0, width - 1, height - 1, 2, 2);
        }
    }

    public void drawLegend(Graphics g, String legend) {
        int strWidth = 0;
        int strHeight = 0;
        int width = this.getCellSize().width;
        int height = this.getCellSize().height;
        g.setFont(this.calendarPanel.getFont());
        FontMetrics fm = g.getFontMetrics();
        strWidth = fm.stringWidth(legend);
        strHeight = fm.getHeight();
        int x = width - strWidth - 4;
        int y = (height - strHeight) / 2 + strHeight - 4;
        g.setColor(this.foreground);
        g.drawString(legend, x, y);
    }

    protected void drawFocusedEffect(Graphics g, boolean focused, boolean selected) {
    }

    protected MouseListener createMouseHandler() {
        return new MouseAdapter(){
            int x;
            int y;

            public void mousePressed(MouseEvent e) {
                this.x = e.getX() / BasicCalendarPanelUI.this.cellWidth;
                this.y = e.getY() / BasicCalendarPanelUI.this.cellHeight;
                if (BasicCalendarPanelUI.this.calendarPanel.isInMonth(this.y, this.x) && BasicCalendarPanelUI.this.calendarPanel.isInRange(this.y, this.x)) {
                    BasicCalendarPanelUI.this.calendarPanel.setSelectedCell(this.x, this.y);
                    if (BasicCalendarPanelUI.this.calendarPanel.hasFocus()) {
                        BasicCalendarPanelUI.this.calendarPanel.repaint();
                    } else {
                        BasicCalendarPanelUI.this.calendarPanel.requestFocus();
                    }
                    BasicCalendarPanelUI.this.calendarPanel.notifyListeners();
                }
            }
        };
    }

    protected KeyListener createKeyHandler() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                int modifiers = e.getModifiers();
                if (key == 9) {
                    int inc = modifiers == 1 ? -1 : 1;
                    BasicCalendarPanelUI.this.moveToNextCell(inc, true);
                    BasicCalendarPanelUI.this.calendarPanel.notifyListeners();
                    e.consume();
                }
                BasicCalendarPanelUI.this.calendarPanel.repaint();
            }
        };
    }

    protected FocusListener createFocusHandler() {
        return new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                this.doFocus();
            }

            public void focusLost(FocusEvent e) {
                this.doFocus();
            }

            private void doFocus() {
                BasicCalendarPanelUI.this.calendarPanel.repaint();
            }
        };
    }

    protected Dimension getCellSize() {
        return this.calendarPanel.getCellSize();
    }

    protected void moveToNextCell(int inc, boolean roll) {
        this.move(inc, roll);
    }

    private void move(int inc, boolean roll) {
        Point firstCell = this.calendarPanel.firstCell;
        Point lastCell = this.calendarPanel.lastCell;
        Point selectedCell = (Point)this.calendarPanel.getSelectedCell().clone();
        if (inc > 0 && selectedCell.equals(lastCell)) {
            this.calendarPanel.setSelectedCell(firstCell);
            return;
        }
        if (inc < 0 && selectedCell.equals(firstCell)) {
            this.calendarPanel.setSelectedCell(lastCell);
            return;
        }
        selectedCell.x += inc;
        if (selectedCell.x == this.DAYS) {
            selectedCell.x = 0;
            ++selectedCell.y;
        } else if (selectedCell.x < 0) {
            selectedCell.x = this.DAYS - 1;
            --selectedCell.y;
        }
        if (selectedCell.y == this.WEEKS) {
            selectedCell.y = 0;
        } else if (selectedCell.y < 0) {
            selectedCell.y = this.WEEKS - 1;
        }
        if (this.calendarPanel.isInRange(selectedCell.y, selectedCell.x)) {
            this.calendarPanel.setSelectedCell(selectedCell);
        } else {
            this.tk.beep();
        }
    }

    public boolean isOpaque() {
        return !this.calendarPanel.hasImage();
    }

    protected class ArrowKeyAction
    implements ActionListener {
        private boolean horizontal;
        private int inc;
        private Point selected;
        private Point first;
        private Point last;

        public ArrowKeyAction(int inc, boolean horizontal) {
            this.inc = inc;
            this.horizontal = horizontal;
        }

        public void actionPerformed(ActionEvent e) {
            this.doAction(e);
        }

        private void doAction(ActionEvent e) {
            this.selected = BasicCalendarPanelUI.this.calendarPanel.getSelectedCell();
            int x = this.selected.x;
            int y = this.selected.y;
            this.first = BasicCalendarPanelUI.this.calendarPanel.firstCell;
            this.last = BasicCalendarPanelUI.this.calendarPanel.lastCell;
            if (this.horizontal) {
                int left = this.selected.y == this.first.y ? this.first.x : 0;
                int right = this.selected.y == this.last.y ? this.last.x : BasicCalendarPanelUI.this.DAYS - 1;
                this.selected.x += this.inc;
                this.selected.x = Math.min(Math.max(this.selected.x, left), right);
            } else {
                int top = this.selected.x < this.first.x ? this.first.y + 1 : 0;
                int bottom = this.selected.x > this.last.x ? this.last.y - 1 : this.last.y;
                this.selected.y += this.inc;
                this.selected.y = Math.min(Math.max(this.selected.y, top), bottom);
            }
            if (BasicCalendarPanelUI.this.calendarPanel.isInRange(this.selected.y, this.selected.x)) {
                BasicCalendarPanelUI.this.calendarPanel.setSelectedCell(this.selected);
                BasicCalendarPanelUI.this.calendarPanel.notifyListeners();
            } else {
                this.selected.x = x;
                this.selected.y = y;
                BasicCalendarPanelUI.this.tk.beep();
            }
        }
    }
}

