/*
 * Decompiled with CFR 0.152.
 */
package mseries.ui;

import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TextUI;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.Calendar.MFieldListener;
import mseries.ui.MChangeEvent;
import mseries.ui.MChangeListener;
import mseries.ui.MDateField;
import mseries.ui.MDateFormat;
import mseries.utils.SafeCalendarUtils;

public class MDateEntryField
extends JComponent
implements FocusListener {
    private static final String uiClassID = "DateEntryUI";
    protected MDateField display;
    private boolean todayButton = false;
    private boolean hasBorder = true;
    private boolean nullOnEmpty = false;
    private Logger logger = Logger.getLogger("mseries");
    protected EventListenerList listenerList = new EventListenerList();
    MDateSelectorConstraints panelConstraints = new MDefaultPullDownConstraints();
    private int last = 1005;
    private boolean closeOnToday = true;
    static /* synthetic */ Class class$mseries$Calendar$MFieldListener;
    static /* synthetic */ Class class$mseries$ui$MChangeListener;

    public MDateEntryField() {
        this(DateFormat.getDateInstance(3));
    }

    public MDateEntryField(DateFormat df) {
        this.display = new MDateField(df){

            public void setUI(TextUI ui) {
                super.setUI(ui);
                this.setBorder(null);
            }
        };
        this.setValue(new Date());
        this.display.addFocusListener(this);
        this.updateUI();
    }

    public MDateEntryField(int size) {
        this();
    }

    public MDateField getDisplay() {
        return this.display;
    }

    public void updateUI() {
        this.setUI(this.registerUIDelegate());
    }

    public int getFocusLostBehavior() {
        return this.display.getFocusLostBehavior();
    }

    public void setFocusLostBehavior(int b) {
        this.display.setFocusLostBehavior(b);
    }

    protected ComponentUI registerUIDelegate() {
        ComponentUI compUI;
        block4: {
            compUI = (ComponentUI)UIManager.get(uiClassID);
            if (compUI != null) break block4;
            String uiDelegateClassName = "mseries.plaf.basic.BasicDateEntryUI";
            String lafName = UIManager.getLookAndFeel().getID();
            lafName = SafeCalendarUtils.squeeze(lafName);
            uiDelegateClassName = "mseries.plaf." + lafName + "." + lafName + uiClassID;
            try {
                compUI = (ComponentUI)Class.forName(uiDelegateClassName).newInstance();
            }
            catch (Exception e) {
                this.logger.info("Class " + uiDelegateClassName + " not found, using default");
                uiDelegateClassName = "mseries.plaf.basic.BasicDateEntryUI";
                try {
                    compUI = (ComponentUI)Class.forName(uiDelegateClassName).newInstance();
                }
                catch (Exception e1) {
                    System.out.println(e1);
                }
            }
        }
        return compUI;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public boolean getNullOnEmpty() {
        return this.nullOnEmpty;
    }

    public void setNullOnEmpty(boolean nullOnEmpty) {
        this.nullOnEmpty = nullOnEmpty;
    }

    public String getText() {
        return this.display.getText();
    }

    public void setText(String text) {
    }

    public String getName() {
        return this.display.getName();
    }

    public void setName(String name) {
        this.display.setName(name);
    }

    public Date getValue() throws ParseException {
        Date ret = null;
        if (this.nullOnEmpty && this.display.getText().equals("")) {
            ret = null;
        } else {
            this.display.commitEdit();
            ret = (Date)this.display.getValue();
        }
        return ret;
    }

    public void setValue(Date newValue) {
        this.display.setValue(newValue);
    }

    public void setDateFormatter(MDateFormat df) {
        this.display.setDateFormatter(df);
    }

    public MDateFormat getDateFormatter() {
        return this.display.getDateFormatter();
    }

    public JFormattedTextField.AbstractFormatter getDateFormatter(Object x) {
        return this.display.getDateFormatter(x);
    }

    public void setMinimum(Date date) {
        this.display.setMinimum(date);
    }

    public void setMaximum(Date date) {
        this.display.setMaximum(date);
    }

    public Date getMinimum() {
        return this.display.getMinimum();
    }

    public Date getMaximum() {
        return this.display.getMaximum();
    }

    public boolean hasBorder() {
        return this.hasBorder;
    }

    public void drawBorder(boolean border) {
        this.hasBorder = border;
    }

    public Font getFont() {
        return this.display.getFont();
    }

    public void setFont(Font font) {
        this.display.setFont(font);
    }

    public boolean isEnabled() {
        return this.display.isEnabled();
    }

    public void setEditable(boolean editable) {
        this.display.setEditable(editable);
    }

    public boolean isEditable() {
        return this.display.isEditable();
    }

    public void setInputVerifier(InputVerifier inputVerifier) {
        this.display.setInputVerifier(inputVerifier);
    }

    public InputVerifier getInputVerifier() {
        return this.display.getInputVerifier();
    }

    public void setConstraints(MDateSelectorConstraints c) {
        this.panelConstraints = c;
    }

    public MDateSelectorConstraints getConstraints() {
        return this.panelConstraints;
    }

    public void setToolTipText(String text) {
        this.display.setToolTipText(text);
    }

    public String getToolTipText() {
        return this.display.getToolTipText();
    }

    public void opened() {
        this.display.removeFocusListener(this);
    }

    public void closed() {
        this.display.addFocusListener(this);
    }

    public void focusLost(FocusEvent e) {
        this.notifyListeners(e);
    }

    public void requestFocus() {
        this.display.requestFocus();
    }

    public void focusGained(FocusEvent e) {
        this.notifyListeners(e);
    }

    public void addMFieldListener(MFieldListener listener) {
        this.listenerList.add(class$mseries$Calendar$MFieldListener == null ? (class$mseries$Calendar$MFieldListener = MDateEntryField.class$("mseries.Calendar.MFieldListener")) : class$mseries$Calendar$MFieldListener, listener);
    }

    public void removeMFieldListener(MFieldListener listener) {
        this.listenerList.remove(class$mseries$Calendar$MFieldListener == null ? (class$mseries$Calendar$MFieldListener = MDateEntryField.class$("mseries.Calendar.MFieldListener")) : class$mseries$Calendar$MFieldListener, listener);
    }

    public void notifyListeners(FocusEvent e) {
        int type = e.getID();
        if (this.last != type) {
            Object[] listeners = this.listenerList.getListenerList();
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == (class$mseries$Calendar$MFieldListener == null ? MDateEntryField.class$("mseries.Calendar.MFieldListener") : class$mseries$Calendar$MFieldListener)) {
                    MFieldListener l = (MFieldListener)listeners[i + 1];
                    if (type == 1004) {
                        l.fieldEntered(new FocusEvent(this, type));
                    } else {
                        l.fieldExited(new FocusEvent(this, type));
                    }
                }
                i -= 2;
            }
            this.last = type;
        }
    }

    public void addMChangeListener(MChangeListener listener) {
        this.listenerList.add(class$mseries$ui$MChangeListener == null ? (class$mseries$ui$MChangeListener = MDateEntryField.class$("mseries.ui.MChangeListener")) : class$mseries$ui$MChangeListener, listener);
    }

    public void removeMChangeListener(MChangeListener listener) {
        this.listenerList.remove(class$mseries$ui$MChangeListener == null ? (class$mseries$ui$MChangeListener = MDateEntryField.class$("mseries.ui.MChangeListener")) : class$mseries$ui$MChangeListener, listener);
    }

    public void notifyListeners(int type) {
        Date date;
        try {
            date = this.getValue();
        }
        catch (ParseException e) {
            date = null;
        }
        MChangeEvent event = new MChangeEvent(this, date, type);
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$mseries$ui$MChangeListener == null ? MDateEntryField.class$("mseries.ui.MChangeListener") : class$mseries$ui$MChangeListener)) {
                ((MChangeListener)listeners[i + 1]).valueChanged(event);
            }
            i -= 2;
        }
    }

    public void setShowTodayButton(boolean show) {
        this.setShowTodayButton(show, true);
    }

    public boolean getShowTodayButton() {
        return this.todayButton;
    }

    public void setShowTodayButton(boolean show, boolean close) {
        this.todayButton = show;
        this.closeOnToday = close;
    }

    public boolean getCloseOnToday() {
        return this.closeOnToday;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

