/*
 * Decompiled with CFR 0.152.
 */
package mseries.ui;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.Calendar.MFieldListener;
import mseries.ui.MChangeEvent;
import mseries.ui.MChangeListener;
import mseries.ui.MDateEntryField;
import mseries.ui.MDateField;

public class MDateEntryFieldDemo
implements Runnable {
    JFrame frame;
    private ButtonGroup lafMenuGroup = new ButtonGroup();

    public static void main(String[] argv) {
        MDateEntryFieldDemo demo = new MDateEntryFieldDemo();
        demo.run();
    }

    public void run() {
        String build = "";
        String date = "";
        try {
            ResourceBundle rb = ResourceBundle.getBundle("build");
            build = rb.getString("build.number");
            date = rb.getString("build.date");
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.frame = new JFrame("Test Window " + build + " " + date);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        this.frame.setJMenuBar(this.createMenus());
        Calendar cx = Calendar.getInstance();
        cx.set(2001, 5, 12);
        DateFormat d = DateFormat.getDateInstance(3);
        d.setLenient(false);
        final MDateEntryField entryField = new MDateEntryField(d);
        entryField.setNullOnEmpty(true);
        entryField.setFocusLostBehavior(3);
        entryField.setValue(cx.getTime());
        MDefaultPullDownConstraints c = new MDefaultPullDownConstraints();
        c.firstDay = 2;
        c.changerStyle = 3;
        c.hasShadow = true;
        c.selectionEventsEnabled = true;
        entryField.setConstraints(c);
        entryField.addMFieldListener(new MFieldListener(){

            public void fieldEntered(FocusEvent e) {
                System.out.println("MDateEntryField:Entered");
            }

            public void fieldExited(FocusEvent e) {
                System.out.println("MDateEntryField:Exited");
                try {
                    System.out.println("EE " + entryField.getValue());
                }
                catch (Exception ee) {
                    System.out.println(ee);
                }
            }
        });
        entryField.addMChangeListener(new MChangeListener(){

            public void valueChanged(MChangeEvent e) {
                System.out.println(e.getValue());
            }
        });
        entryField.setToolTipText("Click the button");
        DateFormat d2 = DateFormat.getDateInstance(3);
        d.setLenient(true);
        MDateField endDate = new MDateField(d2);
        MDefaultPullDownConstraints c2 = new MDefaultPullDownConstraints();
        c2.firstDay = 1;
        endDate.setConstraints(c2);
        endDate.setPopup(true);
        endDate.setToolTipText("Right click me");
        String[] items = new String[]{"England", "Scotland", "N. Ireland", "Wales"};
        JComboBox<String> c1 = new JComboBox<String>(items);
        GridLayout l = new GridLayout(3, 0, 7, 7);
        JPanel displayPanel = new JPanel(l);
        displayPanel.add(new JLabel("MDateEntryField"));
        displayPanel.add(entryField);
        displayPanel.add(new JLabel("MDateSelector (Right Click)"));
        displayPanel.add(endDate);
        displayPanel.add(new JLabel("Test Combo"));
        displayPanel.add(c1);
        this.frame.getContentPane().setLayout(new FlowLayout());
        this.frame.getContentPane().add(displayPanel);
        this.frame.pack();
        this.frame.show();
    }

    public JMenuBar createMenus() {
        JMenuBar menuBar = new JMenuBar();
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        if (lafs.length <= 0) {
            return menuBar;
        }
        JMenu lafMenu = menuBar.add(new JMenu("Look & Feel"));
        lafMenu.setMnemonic('L');
        int i = 0;
        while (i < lafs.length) {
            UIManager.LookAndFeelInfo laf = lafs[i];
            String lafName = laf.getName();
            String lafClassName = laf.getClassName();
            this.createLafMenuItem(lafMenu, lafName, "", lafClassName);
            ++i;
        }
        this.createLafMenuItem(lafMenu, "Kunststoff", "", "com.incors.plaf.kunststoff.KunststoffLookAndFeel");
        this.createLafMenuItem(lafMenu, "JGoodies PlasticXP", "", "com.jgoodies.plaf.plastic.PlasticXPLookAndFeel");
        return menuBar;
    }

    public JMenuItem createLafMenuItem(JMenu menu, String label, String mnemonic, String laf) {
        JMenuItem mi = menu.add(new JRadioButtonMenuItem(label));
        this.lafMenuGroup.add(mi);
        mi.addActionListener(new ChangeLookAndFeelAction(this, laf));
        return mi;
    }

    public void setLookAndFeel(String laf) {
        try {
            UIManager.setLookAndFeel(laf);
            SwingUtilities.updateComponentTreeUI(this.frame);
            this.frame.pack();
        }
        catch (Exception ex) {
            System.out.println("Failed loading L&F: " + laf);
            JOptionPane.showMessageDialog(null, laf + " is not on the classpath", "Un-supported Look & Feel", 0);
        }
    }

    class ChangeLookAndFeelAction
    implements ActionListener {
        MDateEntryFieldDemo m;
        String laf;

        public ChangeLookAndFeelAction(MDateEntryFieldDemo d, String laf) {
            this.m = d;
            this.laf = laf;
        }

        public void actionPerformed(ActionEvent e) {
            this.m.setLookAndFeel(this.laf);
        }
    }

    public class MSeriesTestInputVerifier
    extends InputVerifier {
        public boolean verify(JComponent input) {
            boolean retval = false;
            System.out.println("input.getClass() = " + input.getClass());
            System.out.println("input.getName() = " + input.getName());
            System.out.println("input.getClientProperty(MNEMONIC) = " + input.getClientProperty("MNEMONIC"));
            if (input instanceof MDateEntryField) {
                System.out.println("MDateEntryField");
                retval = true;
            } else if (input instanceof JTextField) {
                System.out.println("JTextField");
                retval = true;
            }
            return retval;
        }
    }
}

