/*
 * Decompiled with CFR 0.152.
 */
package mseries.ui;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import mseries.ui.BumpBuffer;

public class ShadowImage
implements Icon {
    protected BumpBuffer buffer;
    int width;
    int height;
    int orientation;

    public ShadowImage(int orientation) {
        this.orientation = orientation;
        if (this.buffer == null) {
            this.createBuffer();
        }
    }

    protected void createBuffer() {
        this.buffer = new BumpBuffer();
    }

    public void setArea(int w, int h) {
        this.width = this.width;
        this.height = this.height;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        int bufferWidth = this.buffer.getImageSize().width;
        int bufferHeight = this.buffer.getImageSize().height;
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        if (this.orientation == 1) {
            int i = this.height;
            while (i > bufferWidth) {
                g.drawImage(this.buffer.getImage(), x, i, w, h, null);
                i -= bufferWidth;
            }
        } else {
            int i = this.width;
            while (i > bufferWidth) {
                g.drawImage(this.buffer.getImage(), i, y, i + w, y + h, null);
                i -= bufferWidth;
            }
        }
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }
}

