/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.util.LinkedHashMap;
import java.util.Map;
import jdk.nashorn.internal.runtime.options.Options;

public final class Timing {
    private static final boolean ENABLED = Options.getBooleanProperty("nashorn.time");
    private static final Map<String, Long> TIMINGS;
    private static final long START_TIME;

    public static boolean isEnabled() {
        return ENABLED;
    }

    public static void accumulateTime(String module, long duration) {
        if (Timing.isEnabled()) {
            Long accumulatedTime = TIMINGS.get(module);
            if (accumulatedTime == null) {
                accumulatedTime = 0L;
            }
            TIMINGS.put(module, accumulatedTime + duration);
        }
    }

    static {
        if (ENABLED) {
            TIMINGS = new LinkedHashMap<String, Long>();
            START_TIME = System.currentTimeMillis();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    long t = System.currentTimeMillis();
                    long knownTime = 0L;
                    int maxLength = 0;
                    for (Map.Entry entry : TIMINGS.entrySet()) {
                        maxLength = Math.max(maxLength, ((String)entry.getKey()).length());
                    }
                    ++maxLength;
                    for (Map.Entry entry : TIMINGS.entrySet()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append((String)entry.getKey());
                        while (sb.length() < maxLength) {
                            sb.append(' ');
                        }
                        long duration = (Long)entry.getValue();
                        sb.append(duration);
                        sb.append(' ');
                        sb.append(" ms");
                        knownTime += duration;
                        System.err.println(sb.toString());
                    }
                    long total = t - START_TIME;
                    System.err.println("Total runtime: " + total + " ms (Non-runtime: " + knownTime + " ms [" + (int)((double)knownTime * 100.0 / (double)total) + "%])");
                }
            });
        } else {
            TIMINGS = null;
            START_TIME = 0L;
        }
    }
}

