/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.tree.ClassNode;
import jdk.internal.org.objectweb.asm.util.CheckClassAdapter;
import oracle.jrockit.jfr.JIInliner;
import oracle.jrockit.jfr.JIInstrumentationMethod;
import oracle.jrockit.jfr.JIMethodMergeAdapter;
import oracle.jrockit.jfr.JITracer;
import oracle.jrockit.jfr.JITypeMapping;
import oracle.jrockit.jfr.Logger;

final class JIClassInstrumentation {
    private final Class<?> instrumentor;
    private final Logger logger;
    private final String targetName;
    private final String instrumentorName;
    private byte[] newBytes;
    private final ClassReader targetClassReader;
    private final ClassReader instrClassReader;

    public JIClassInstrumentation(Class<?> clazz, Class<?> clazz2, byte[] byArray, Logger logger) throws ClassNotFoundException, IOException {
        this.instrumentorName = clazz.getName();
        this.targetName = clazz2.getName();
        this.instrumentor = clazz;
        this.logger = logger;
        InputStream inputStream = JITracer.class.getResourceAsStream("/" + this.instrumentorName.replace(".", "/") + ".class");
        this.targetClassReader = new ClassReader(byArray);
        this.instrClassReader = new ClassReader(inputStream);
        this.instrument();
        if (Boolean.getBoolean("jfr.savegenerated")) {
            try (Closeable closeable = new FileOutputStream(this.targetName + ".class");){
                ((FileOutputStream)closeable).write(this.newBytes);
            }
            closeable = new FileWriter(this.targetName + ".asm");
            var7_7 = null;
            try (PrintWriter printWriter = new PrintWriter((Writer)closeable);){
                ClassReader classReader = new ClassReader(this.getNewBytes());
                CheckClassAdapter.verify(classReader, true, printWriter);
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
            finally {
                if (closeable != null) {
                    if (var7_7 != null) {
                        try {
                            ((OutputStreamWriter)closeable).close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        ((OutputStreamWriter)closeable).close();
                    }
                }
            }
            logger.info("Instrumented code saved to " + this.targetName + ".class and .asm");
        }
    }

    private void instrument() throws IOException, ClassNotFoundException {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : this.instrumentor.getDeclaredMethods()) {
            JIInstrumentationMethod jIInstrumentationMethod = method.getAnnotation(JIInstrumentationMethod.class);
            if (jIInstrumentationMethod == null) continue;
            arrayList.add(method);
        }
        ClassNode classNode = new ClassNode();
        JIInliner jIInliner = new JIInliner(327680, classNode, this.targetName, this.instrumentorName, this.targetClassReader, arrayList, this.logger);
        this.instrClassReader.accept(jIInliner, 8);
        ClassWriter classWriter = new ClassWriter(2);
        JIMethodMergeAdapter jIMethodMergeAdapter = new JIMethodMergeAdapter(classWriter, classNode, arrayList, (JITypeMapping[])this.instrumentor.getAnnotationsByType(JITypeMapping.class), this.logger);
        this.targetClassReader.accept(jIMethodMergeAdapter, 8);
        this.newBytes = classWriter.toByteArray();
    }

    public byte[] getNewBytes() {
        return this.newBytes;
    }
}

