/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.lang.reflect.Method;
import java.util.List;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassVisitor;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;
import jdk.internal.org.objectweb.asm.tree.ClassNode;
import jdk.internal.org.objectweb.asm.tree.MethodNode;
import oracle.jrockit.jfr.JIMethodCallInliner;
import oracle.jrockit.jfr.Logger;

final class JIInliner
extends ClassVisitor {
    private final String targetClassName;
    private final String instrumentationClassName;
    private final Logger logger;
    private final ClassNode targetClassNode;
    private final List<Method> instrumentationMethods;

    JIInliner(int n, ClassVisitor classVisitor, String string, String string2, ClassReader classReader, List<Method> list, Logger logger) {
        super(n, classVisitor);
        this.targetClassName = string;
        this.instrumentationClassName = string2;
        this.instrumentationMethods = list;
        this.logger = logger;
        ClassNode classNode = new ClassNode(327680);
        classReader.accept(classNode, 8);
        this.targetClassNode = classNode;
    }

    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        MethodVisitor methodVisitor = super.visitMethod(n, string, string2, string3, stringArray);
        if (this.isInstrumentationMethod(string, string2)) {
            MethodNode methodNode = this.findTargetMethodNode(string, string2);
            if (methodNode == null) {
                throw new IllegalArgumentException("Could not find the method to instrument in the target class");
            }
            if ((methodNode.access & 0x100) == 1) {
                throw new IllegalArgumentException("Cannot instrument native methods: " + this.targetClassNode.name + "." + methodNode.name + methodNode.desc);
            }
            this.logger.trace("Inliner processing method " + string + string2);
            JIMethodCallInliner jIMethodCallInliner = new JIMethodCallInliner(n, string2, methodVisitor, methodNode, this.targetClassName, this.instrumentationClassName, this.logger);
            return jIMethodCallInliner;
        }
        return methodVisitor;
    }

    private boolean isInstrumentationMethod(String string, String string2) {
        for (Method method : this.instrumentationMethods) {
            if (!method.getName().equals(string) || !Type.getMethodDescriptor(method).equals(string2)) continue;
            return true;
        }
        return false;
    }

    private MethodNode findTargetMethodNode(String string, String string2) {
        for (MethodNode methodNode : this.targetClassNode.methods) {
            if (!methodNode.desc.equals(string2) || !methodNode.name.equals(string)) continue;
            return methodNode;
        }
        throw new IllegalArgumentException("could not find MethodNode for " + string + string2);
    }
}

