/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import com.oracle.jrockit.jfr.EventToken;
import com.oracle.jrockit.jfr.InvalidEventDefinitionException;
import com.oracle.jrockit.jfr.InvalidValueException;
import com.oracle.jrockit.jfr.Producer;
import java.io.IOException;
import jdk.jfr.events.FileReadEvent;
import jdk.jfr.events.FileWriteEvent;
import jdk.jfr.events.SocketReadEvent;
import jdk.jfr.events.SocketWriteEvent;
import oracle.jrockit.jfr.FileChannelImplInstrumentor;
import oracle.jrockit.jfr.FileInputStreamInstrumentor;
import oracle.jrockit.jfr.FileOutputStreamInstrumentor;
import oracle.jrockit.jfr.JIClassInstrumentation;
import oracle.jrockit.jfr.JIInstrumentationTarget;
import oracle.jrockit.jfr.Logger;
import oracle.jrockit.jfr.RandomAccessFileInstrumentor;
import oracle.jrockit.jfr.SocketChannelImplInstrumentor;
import oracle.jrockit.jfr.SocketInputStreamInstrumentor;
import oracle.jrockit.jfr.SocketOutputStreamInstrumentor;

public final class JITracer {
    public static EventToken socketReadToken;
    public static EventToken socketWriteToken;
    public static EventToken fileReadToken;
    public static EventToken fileWriteToken;
    private final Class<?>[] instrumentationClasses = new Class[]{FileInputStreamInstrumentor.class, FileOutputStreamInstrumentor.class, RandomAccessFileInstrumentor.class, FileChannelImplInstrumentor.class, SocketInputStreamInstrumentor.class, SocketOutputStreamInstrumentor.class, SocketChannelImplInstrumentor.class};
    private final Class<?>[] targetClasses = new Class[this.instrumentationClasses.length];
    private final Logger logger;

    JITracer(Producer producer, Logger logger) throws InvalidEventDefinitionException, InvalidValueException, ClassNotFoundException {
        this.logger = logger;
        socketReadToken = producer.addEvent(SocketReadEvent.class);
        socketWriteToken = producer.addEvent(SocketWriteEvent.class);
        fileReadToken = producer.addEvent(FileReadEvent.class);
        fileWriteToken = producer.addEvent(FileWriteEvent.class);
        for (int i = 0; i < this.instrumentationClasses.length; ++i) {
            JIInstrumentationTarget jIInstrumentationTarget = this.instrumentationClasses[i].getAnnotation(JIInstrumentationTarget.class);
            this.targetClasses[i] = Class.forName(jIInstrumentationTarget.value());
        }
    }

    byte[] transform(Class<?> clazz, byte[] byArray) throws ClassNotFoundException, IOException {
        for (int i = 0; i < this.targetClasses.length; ++i) {
            if (!this.targetClasses[i].equals(clazz)) continue;
            this.logger.trace("Processing instrumentation class: " + this.instrumentationClasses[i]);
            return new JIClassInstrumentation(this.instrumentationClasses[i], clazz, byArray, this.logger).getNewBytes();
        }
        return null;
    }

    Class<?>[] getTargetClasses() throws ClassNotFoundException {
        return this.targetClasses;
    }
}

