/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.util.PerfLogger;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.security.auth.x500.X500Principal;

final class LazyRootStore {
    private CertStore browserRootStore = null;
    private CertStore jreRootStore = null;
    private boolean isBrowserRootStoreLoaded = false;
    private boolean isJRERootStoreLoaded = false;
    private X509Certificate ocspCertCA = null;
    private LinkedHashSet allRootCerts = new LinkedHashSet();
    private LinkedHashSet jreRootCerts = new LinkedHashSet();
    private HashMap allTrustedSubjects = new HashMap();

    LazyRootStore(CertStore certStore, CertStore certStore2) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.browserRootStore = certStore;
        this.jreRootStore = certStore2;
    }

    private void loadBrowserStore() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (this.browserRootStore != null && !this.isBrowserRootStoreLoaded) {
            PerfLogger.setTime("Security: Start loading browser Root certStore");
            this.browserRootStore.load();
            this.isBrowserRootStoreLoaded = true;
            PerfLogger.setTime("Security: End loading browser Root certStore");
            this.allRootCerts.addAll(this.browserRootStore.getCertificates());
        }
        this.createAllTrustedSubject(this.allRootCerts);
    }

    private void loadJREStore() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (this.isJRERootStoreLoaded) {
            return;
        }
        PerfLogger.setTime("Security: Start loading JRE root cert store");
        this.jreRootStore.load();
        this.jreRootCerts.addAll(this.jreRootStore.getCertificates());
        this.allRootCerts.addAll(this.jreRootStore.getCertificates());
        this.createAllTrustedSubject(this.jreRootCerts);
        this.isJRERootStoreLoaded = true;
        PerfLogger.setTime("Security: End loading JRE root cert store");
    }

    List getTrustAnchors(X509Certificate x509Certificate) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (!this.isBrowserRootStoreLoaded) {
            this.loadBrowserStore();
        }
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        if (this.allRootCerts.contains(x509Certificate)) {
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            arrayList.add(x509Certificate);
            return arrayList;
        }
        if (this.allTrustedSubjects.containsKey(x500Principal)) {
            List list = (List)this.allTrustedSubjects.get(x500Principal);
            return list;
        }
        if (!this.isJRERootStoreLoaded) {
            this.loadJREStore();
            if (this.allRootCerts.contains(x509Certificate)) {
                ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
                arrayList.add(x509Certificate);
                return arrayList;
            }
            if (this.allTrustedSubjects.containsKey(x500Principal)) {
                List list = (List)this.allTrustedSubjects.get(x500Principal);
                return list;
            }
        }
        return null;
    }

    private void createAllTrustedSubject(LinkedHashSet linkedHashSet) {
        for (X509Certificate x509Certificate : linkedHashSet) {
            List<X509Certificate> list;
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            if (this.allTrustedSubjects.containsKey(x500Principal)) {
                list = (List)this.allTrustedSubjects.get(x500Principal);
            } else {
                list = new ArrayList();
                this.allTrustedSubjects.put(x500Principal, list);
            }
            list.add(x509Certificate);
        }
    }

    boolean containSubject(String string) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        X509Certificate x509Certificate2 = null;
        String string2 = null;
        if (!this.isBrowserRootStoreLoaded) {
            this.loadBrowserStore();
        }
        for (X509Certificate x509Certificate2 : this.allRootCerts) {
            string2 = CertUtils.extractSubjectAliasName(x509Certificate2);
            if (!string.equals(string2)) continue;
            this.ocspCertCA = x509Certificate2;
            return true;
        }
        if (!this.isJRERootStoreLoaded) {
            this.loadJREStore();
            for (X509Certificate x509Certificate2 : this.jreRootCerts) {
                string2 = CertUtils.extractSubjectAliasName(x509Certificate2);
                if (!string.equals(string2)) continue;
                this.ocspCertCA = x509Certificate2;
                return true;
            }
        }
        this.ocspCertCA = null;
        return false;
    }

    X509Certificate getOCSPCert() {
        return this.ocspCertCA;
    }
}

