/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.SocketOptions;
import java.net.StandardSocketOptions;

public abstract class DatagramSocketImpl
implements SocketOptions {
    protected int localPort;
    protected FileDescriptor fd;
    DatagramSocket socket;

    void setDatagramSocket(DatagramSocket datagramSocket) {
        this.socket = datagramSocket;
    }

    DatagramSocket getDatagramSocket() {
        return this.socket;
    }

    protected abstract void create() throws SocketException;

    protected abstract void bind(int var1, InetAddress var2) throws SocketException;

    protected abstract void send(DatagramPacket var1) throws IOException;

    protected void connect(InetAddress inetAddress, int n) throws SocketException {
    }

    protected void disconnect() {
    }

    protected abstract int peek(InetAddress var1) throws IOException;

    protected abstract int peekData(DatagramPacket var1) throws IOException;

    protected abstract void receive(DatagramPacket var1) throws IOException;

    @Deprecated
    protected abstract void setTTL(byte var1) throws IOException;

    @Deprecated
    protected abstract byte getTTL() throws IOException;

    protected abstract void setTimeToLive(int var1) throws IOException;

    protected abstract int getTimeToLive() throws IOException;

    protected abstract void join(InetAddress var1) throws IOException;

    protected abstract void leave(InetAddress var1) throws IOException;

    protected abstract void joinGroup(SocketAddress var1, NetworkInterface var2) throws IOException;

    protected abstract void leaveGroup(SocketAddress var1, NetworkInterface var2) throws IOException;

    protected abstract void close();

    protected int getLocalPort() {
        return this.localPort;
    }

    <T> void setOption(SocketOption<T> socketOption, T t) throws IOException {
        if (socketOption == StandardSocketOptions.SO_SNDBUF) {
            this.setOption(4097, t);
        } else if (socketOption == StandardSocketOptions.SO_RCVBUF) {
            this.setOption(4098, t);
        } else if (socketOption == StandardSocketOptions.SO_REUSEADDR) {
            this.setOption(4, t);
        } else if (socketOption == StandardSocketOptions.IP_TOS) {
            this.setOption(3, t);
        } else if (socketOption == StandardSocketOptions.IP_MULTICAST_IF && this.getDatagramSocket() instanceof MulticastSocket) {
            this.setOption(31, t);
        } else if (socketOption == StandardSocketOptions.IP_MULTICAST_TTL && this.getDatagramSocket() instanceof MulticastSocket) {
            if (!(t instanceof Integer)) {
                throw new IllegalArgumentException("not an integer");
            }
            this.setTimeToLive((Integer)t);
        } else if (socketOption == StandardSocketOptions.IP_MULTICAST_LOOP && this.getDatagramSocket() instanceof MulticastSocket) {
            this.setOption(18, t);
        } else {
            throw new UnsupportedOperationException("unsupported option");
        }
    }

    <T> T getOption(SocketOption<T> socketOption) throws IOException {
        if (socketOption == StandardSocketOptions.SO_SNDBUF) {
            return (T)this.getOption(4097);
        }
        if (socketOption == StandardSocketOptions.SO_RCVBUF) {
            return (T)this.getOption(4098);
        }
        if (socketOption == StandardSocketOptions.SO_REUSEADDR) {
            return (T)this.getOption(4);
        }
        if (socketOption == StandardSocketOptions.IP_TOS) {
            return (T)this.getOption(3);
        }
        if (socketOption == StandardSocketOptions.IP_MULTICAST_IF && this.getDatagramSocket() instanceof MulticastSocket) {
            return (T)this.getOption(31);
        }
        if (socketOption == StandardSocketOptions.IP_MULTICAST_TTL && this.getDatagramSocket() instanceof MulticastSocket) {
            Integer n = this.getTimeToLive();
            return (T)n;
        }
        if (socketOption == StandardSocketOptions.IP_MULTICAST_LOOP && this.getDatagramSocket() instanceof MulticastSocket) {
            return (T)this.getOption(18);
        }
        throw new UnsupportedOperationException("unsupported option");
    }

    protected FileDescriptor getFileDescriptor() {
        return this.fd;
    }
}

