/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IntSummaryStatistics;
import java.util.Iterator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;

public final class Collectors {
    static final Set<Collector.Characteristics> CH_CONCURRENT_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH));
    static final Set<Collector.Characteristics> CH_CONCURRENT_NOID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED));
    static final Set<Collector.Characteristics> CH_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
    static final Set<Collector.Characteristics> CH_UNORDERED_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH));
    static final Set<Collector.Characteristics> CH_NOID = Collections.emptySet();

    private Collectors() {
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (object, object2) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", object));
        };
    }

    private static <I, R> Function<I, R> castingIdentity() {
        return object -> object;
    }

    public static <T, C extends Collection<T>> Collector<T, ?, C> toCollection(Supplier<C> supplier) {
        return new CollectorImpl(supplier, Collection::add, (collection, collection2) -> {
            collection.addAll(collection2);
            return collection;
        }, CH_ID);
    }

    public static <T> Collector<T, ?, List<T>> toList() {
        return new CollectorImpl(ArrayList::new, List::add, (list, list2) -> {
            list.addAll(list2);
            return list;
        }, CH_ID);
    }

    public static <T> Collector<T, ?, Set<T>> toSet() {
        return new CollectorImpl(HashSet::new, Set::add, (set, set2) -> {
            set.addAll(set2);
            return set;
        }, CH_UNORDERED_ID);
    }

    public static Collector<CharSequence, ?, String> joining() {
        return new CollectorImpl<CharSequence, StringBuilder, String>(StringBuilder::new, StringBuilder::append, (stringBuilder, stringBuilder2) -> {
            stringBuilder.append((CharSequence)stringBuilder2);
            return stringBuilder;
        }, StringBuilder::toString, CH_NOID);
    }

    public static Collector<CharSequence, ?, String> joining(CharSequence charSequence) {
        return Collectors.joining(charSequence, "", "");
    }

    public static Collector<CharSequence, ?, String> joining(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        return new CollectorImpl<CharSequence, StringJoiner, String>(() -> new StringJoiner(charSequence, charSequence2, charSequence3), StringJoiner::add, StringJoiner::merge, StringJoiner::toString, CH_NOID);
    }

    private static <K, V, M extends Map<K, V>> BinaryOperator<M> mapMerger(BinaryOperator<V> binaryOperator) {
        return (map, map2) -> {
            for (Map.Entry entry : map2.entrySet()) {
                map.merge(entry.getKey(), entry.getValue(), binaryOperator);
            }
            return map;
        };
    }

    public static <T, U, A, R> Collector<T, ?, R> mapping(Function<? super T, ? extends U> function, Collector<? super U, A, R> collector) {
        BiConsumer biConsumer = collector.accumulator();
        return new CollectorImpl<Object, Object, R>(collector.supplier(), (object, object2) -> biConsumer.accept((Object)object, (Object)function.apply(object2)), collector.combiner(), collector.finisher(), collector.characteristics());
    }

    public static <T, A, R, RR> Collector<T, A, RR> collectingAndThen(Collector<T, A, R> collector, Function<R, RR> function) {
        Set<Collector.Characteristics> set = collector.characteristics();
        if (set.contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            if (set.size() == 1) {
                set = CH_NOID;
            } else {
                set = EnumSet.copyOf(set);
                set.remove((Object)Collector.Characteristics.IDENTITY_FINISH);
                set = Collections.unmodifiableSet(set);
            }
        }
        return new CollectorImpl<T, A, RR>(collector.supplier(), collector.accumulator(), collector.combiner(), collector.finisher().andThen(function), set);
    }

    public static <T> Collector<T, ?, Long> counting() {
        return Collectors.reducing(0L, object -> 1L, Long::sum);
    }

    public static <T> Collector<T, ?, Optional<T>> minBy(Comparator<? super T> comparator) {
        return Collectors.reducing(BinaryOperator.minBy(comparator));
    }

    public static <T> Collector<T, ?, Optional<T>> maxBy(Comparator<? super T> comparator) {
        return Collectors.reducing(BinaryOperator.maxBy(comparator));
    }

    public static <T> Collector<T, ?, Integer> summingInt(ToIntFunction<? super T> toIntFunction) {
        return new CollectorImpl<Object, int[], Integer>(() -> new int[1], (nArray, object) -> {
            nArray[0] = nArray[0] + toIntFunction.applyAsInt(object);
        }, (nArray, nArray2) -> {
            nArray[0] = nArray[0] + nArray2[0];
            return nArray;
        }, nArray -> nArray[0], CH_NOID);
    }

    public static <T> Collector<T, ?, Long> summingLong(ToLongFunction<? super T> toLongFunction) {
        return new CollectorImpl<Object, long[], Long>(() -> new long[1], (lArray, object) -> {
            lArray[0] = lArray[0] + toLongFunction.applyAsLong(object);
        }, (lArray, lArray2) -> {
            lArray[0] = lArray[0] + lArray2[0];
            return lArray;
        }, lArray -> lArray[0], CH_NOID);
    }

    public static <T> Collector<T, ?, Double> summingDouble(ToDoubleFunction<? super T> toDoubleFunction) {
        return new CollectorImpl<Object, double[], Double>(() -> new double[3], (dArray, object) -> {
            Collectors.sumWithCompensation(dArray, toDoubleFunction.applyAsDouble(object));
            dArray[2] = dArray[2] + toDoubleFunction.applyAsDouble(object);
        }, (dArray, dArray2) -> {
            Collectors.sumWithCompensation(dArray, dArray2[0]);
            dArray[2] = dArray[2] + dArray2[2];
            return Collectors.sumWithCompensation(dArray, dArray2[1]);
        }, dArray -> Collectors.computeFinalSum(dArray), CH_NOID);
    }

    static double[] sumWithCompensation(double[] dArray, double d) {
        double d2 = d - dArray[1];
        double d3 = dArray[0];
        double d4 = d3 + d2;
        dArray[1] = d4 - d3 - d2;
        dArray[0] = d4;
        return dArray;
    }

    static double computeFinalSum(double[] dArray) {
        double d = dArray[0] + dArray[1];
        double d2 = dArray[dArray.length - 1];
        if (Double.isNaN(d) && Double.isInfinite(d2)) {
            return d2;
        }
        return d;
    }

    public static <T> Collector<T, ?, Double> averagingInt(ToIntFunction<? super T> toIntFunction) {
        return new CollectorImpl<Object, long[], Double>(() -> new long[2], (lArray, object) -> {
            lArray[0] = lArray[0] + (long)toIntFunction.applyAsInt(object);
            lArray[1] = lArray[1] + 1L;
        }, (lArray, lArray2) -> {
            lArray[0] = lArray[0] + lArray2[0];
            lArray[1] = lArray[1] + lArray2[1];
            return lArray;
        }, lArray -> lArray[1] == 0L ? 0.0 : (double)lArray[0] / (double)lArray[1], CH_NOID);
    }

    public static <T> Collector<T, ?, Double> averagingLong(ToLongFunction<? super T> toLongFunction) {
        return new CollectorImpl<Object, long[], Double>(() -> new long[2], (lArray, object) -> {
            lArray[0] = lArray[0] + toLongFunction.applyAsLong(object);
            lArray[1] = lArray[1] + 1L;
        }, (lArray, lArray2) -> {
            lArray[0] = lArray[0] + lArray2[0];
            lArray[1] = lArray[1] + lArray2[1];
            return lArray;
        }, lArray -> lArray[1] == 0L ? 0.0 : (double)lArray[0] / (double)lArray[1], CH_NOID);
    }

    public static <T> Collector<T, ?, Double> averagingDouble(ToDoubleFunction<? super T> toDoubleFunction) {
        return new CollectorImpl<Object, double[], Double>(() -> new double[4], (dArray, object) -> {
            Collectors.sumWithCompensation(dArray, toDoubleFunction.applyAsDouble(object));
            dArray[2] = dArray[2] + 1.0;
            dArray[3] = dArray[3] + toDoubleFunction.applyAsDouble(object);
        }, (dArray, dArray2) -> {
            Collectors.sumWithCompensation(dArray, dArray2[0]);
            Collectors.sumWithCompensation(dArray, dArray2[1]);
            dArray[2] = dArray[2] + dArray2[2];
            dArray[3] = dArray[3] + dArray2[3];
            return dArray;
        }, dArray -> dArray[2] == 0.0 ? 0.0 : Collectors.computeFinalSum(dArray) / dArray[2], CH_NOID);
    }

    public static <T> Collector<T, ?, T> reducing(T t, BinaryOperator<T> binaryOperator) {
        return new CollectorImpl<Object, Object[], Object>(Collectors.boxSupplier(t), (objectArray, object) -> {
            objectArray[0] = binaryOperator.apply(objectArray[0], object);
        }, (objectArray, objectArray2) -> {
            objectArray[0] = binaryOperator.apply(objectArray[0], objectArray2[0]);
            return objectArray;
        }, objectArray -> objectArray[0], CH_NOID);
    }

    private static <T> Supplier<T[]> boxSupplier(T t) {
        return () -> new Object[]{t};
    }

    public static <T> Collector<T, ?, Optional<T>> reducing(BinaryOperator<T> binaryOperator) {
        class OptionalBox
        implements Consumer<T> {
            T value = null;
            boolean present = false;
            final /* synthetic */ BinaryOperator val$op;

            OptionalBox(BinaryOperator binaryOperator) {
                this.val$op = binaryOperator;
            }

            @Override
            public void accept(T t) {
                if (this.present) {
                    this.value = this.val$op.apply(this.value, t);
                } else {
                    this.value = t;
                    this.present = true;
                }
            }
        }
        return new CollectorImpl<Object, OptionalBox, Optional>(() -> new OptionalBox(binaryOperator), OptionalBox::accept, (optionalBox, optionalBox2) -> {
            if (optionalBox2.present) {
                optionalBox.accept(optionalBox2.value);
            }
            return optionalBox;
        }, optionalBox -> Optional.ofNullable(optionalBox.value), CH_NOID);
    }

    public static <T, U> Collector<T, ?, U> reducing(U u, Function<? super T, ? extends U> function, BinaryOperator<U> binaryOperator) {
        return new CollectorImpl<Object, Object[], Object>(Collectors.boxSupplier(u), (objectArray, object) -> {
            objectArray[0] = binaryOperator.apply(objectArray[0], function.apply(object));
        }, (objectArray, objectArray2) -> {
            objectArray[0] = binaryOperator.apply(objectArray[0], objectArray2[0]);
            return objectArray;
        }, objectArray -> objectArray[0], CH_NOID);
    }

    public static <T, K> Collector<T, ?, Map<K, List<T>>> groupingBy(Function<? super T, ? extends K> function) {
        return Collectors.groupingBy(function, Collectors.toList());
    }

    public static <T, K, A, D> Collector<T, ?, Map<K, D>> groupingBy(Function<? super T, ? extends K> function, Collector<? super T, A, D> collector) {
        return Collectors.groupingBy(function, HashMap::new, collector);
    }

    public static <T, K, D, A, M extends Map<K, D>> Collector<T, ?, M> groupingBy(Function<? super T, ? extends K> function, Supplier<M> supplier, Collector<? super T, A, D> collector) {
        Supplier supplier2 = collector.supplier();
        BiConsumer biConsumer = collector.accumulator();
        BiConsumer<Map, Object> biConsumer2 = (map, object) -> {
            Object r = Objects.requireNonNull(function.apply(object), "element cannot be mapped to a null key");
            Object object2 = map.computeIfAbsent(r, arg_0 -> Collectors.lambda$null$148((Supplier)supplier2, arg_0));
            biConsumer.accept(object2, object);
        };
        BinaryOperator<M> binaryOperator = Collectors.mapMerger(collector.combiner());
        Supplier<M> supplier3 = supplier;
        if (collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return new CollectorImpl(supplier3, biConsumer2, binaryOperator, CH_ID);
        }
        Function function2 = collector.finisher();
        Function<Map, Map> function3 = map -> {
            map.replaceAll((object, object2) -> function2.apply(object2));
            Map map2 = map;
            return map2;
        };
        return new CollectorImpl<Object, Map, Map>(supplier3, biConsumer2, binaryOperator, function3, CH_NOID);
    }

    public static <T, K> Collector<T, ?, ConcurrentMap<K, List<T>>> groupingByConcurrent(Function<? super T, ? extends K> function) {
        return Collectors.groupingByConcurrent(function, ConcurrentHashMap::new, Collectors.toList());
    }

    public static <T, K, A, D> Collector<T, ?, ConcurrentMap<K, D>> groupingByConcurrent(Function<? super T, ? extends K> function, Collector<? super T, A, D> collector) {
        return Collectors.groupingByConcurrent(function, ConcurrentHashMap::new, collector);
    }

    public static <T, K, A, D, M extends ConcurrentMap<K, D>> Collector<T, ?, M> groupingByConcurrent(Function<? super T, ? extends K> function, Supplier<M> supplier, Collector<? super T, A, D> collector) {
        Supplier supplier2 = collector.supplier();
        BiConsumer biConsumer = collector.accumulator();
        BinaryOperator<M> binaryOperator = Collectors.mapMerger(collector.combiner());
        Supplier<M> supplier3 = supplier;
        BiConsumer<ConcurrentMap, Object> biConsumer2 = collector.characteristics().contains((Object)Collector.Characteristics.CONCURRENT) ? (concurrentMap, object) -> {
            Object r = Objects.requireNonNull(function.apply(object), "element cannot be mapped to a null key");
            Object object2 = concurrentMap.computeIfAbsent(r, arg_0 -> Collectors.lambda$null$152((Supplier)supplier2, arg_0));
            biConsumer.accept(object2, object);
        } : (concurrentMap, object) -> {
            Object object2;
            Object r = Objects.requireNonNull(function.apply(object), "element cannot be mapped to a null key");
            Object object3 = object2 = concurrentMap.computeIfAbsent(r, arg_0 -> Collectors.lambda$null$154((Supplier)supplier2, arg_0));
            synchronized (object3) {
                biConsumer.accept(object2, object);
            }
        };
        if (collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return new CollectorImpl(supplier3, biConsumer2, binaryOperator, CH_CONCURRENT_ID);
        }
        Function function2 = collector.finisher();
        Function<ConcurrentMap, ConcurrentMap> function3 = concurrentMap -> {
            concurrentMap.replaceAll((object, object2) -> function2.apply(object2));
            ConcurrentMap concurrentMap2 = concurrentMap;
            return concurrentMap2;
        };
        return new CollectorImpl<Object, ConcurrentMap, ConcurrentMap>(supplier3, biConsumer2, binaryOperator, function3, CH_CONCURRENT_NOID);
    }

    public static <T> Collector<T, ?, Map<Boolean, List<T>>> partitioningBy(Predicate<? super T> predicate) {
        return Collectors.partitioningBy(predicate, Collectors.toList());
    }

    public static <T, D, A> Collector<T, ?, Map<Boolean, D>> partitioningBy(Predicate<? super T> predicate, Collector<? super T, A, D> collector) {
        BiConsumer biConsumer = collector.accumulator();
        BiConsumer<Partition, Object> biConsumer2 = (partition, object) -> biConsumer.accept((Object)(predicate.test(object) ? partition.forTrue : partition.forFalse), (Object)object);
        BinaryOperator binaryOperator = collector.combiner();
        BinaryOperator binaryOperator2 = (partition, partition2) -> new Partition(binaryOperator.apply(partition.forTrue, partition2.forTrue), binaryOperator.apply(partition.forFalse, partition2.forFalse));
        Supplier<Partition> supplier = () -> new Partition(collector.supplier().get(), collector.supplier().get());
        if (collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return new CollectorImpl(supplier, biConsumer2, binaryOperator2, CH_ID);
        }
        Function<Partition, Map> function = partition -> new Partition(collector.finisher().apply(partition.forTrue), collector.finisher().apply(partition.forFalse));
        return new CollectorImpl<Object, Partition, Map>(supplier, biConsumer2, binaryOperator2, function, CH_NOID);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> function, Function<? super T, ? extends U> function2) {
        return Collectors.toMap(function, function2, Collectors.throwingMerger(), HashMap::new);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> function, Function<? super T, ? extends U> function2, BinaryOperator<U> binaryOperator) {
        return Collectors.toMap(function, function2, binaryOperator, HashMap::new);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> function, Function<? super T, ? extends U> function2, BinaryOperator<U> binaryOperator, Supplier<M> supplier) {
        BiConsumer<Map, Object> biConsumer = (map, object) -> map.merge(function.apply(object), function2.apply(object), binaryOperator);
        return new CollectorImpl(supplier, biConsumer, Collectors.mapMerger(binaryOperator), CH_ID);
    }

    public static <T, K, U> Collector<T, ?, ConcurrentMap<K, U>> toConcurrentMap(Function<? super T, ? extends K> function, Function<? super T, ? extends U> function2) {
        return Collectors.toConcurrentMap(function, function2, Collectors.throwingMerger(), ConcurrentHashMap::new);
    }

    public static <T, K, U> Collector<T, ?, ConcurrentMap<K, U>> toConcurrentMap(Function<? super T, ? extends K> function, Function<? super T, ? extends U> function2, BinaryOperator<U> binaryOperator) {
        return Collectors.toConcurrentMap(function, function2, binaryOperator, ConcurrentHashMap::new);
    }

    public static <T, K, U, M extends ConcurrentMap<K, U>> Collector<T, ?, M> toConcurrentMap(Function<? super T, ? extends K> function, Function<? super T, ? extends U> function2, BinaryOperator<U> binaryOperator, Supplier<M> supplier) {
        BiConsumer<ConcurrentMap, Object> biConsumer = (concurrentMap, object) -> concurrentMap.merge(function.apply(object), function2.apply(object), binaryOperator);
        return new CollectorImpl(supplier, biConsumer, Collectors.mapMerger(binaryOperator), CH_CONCURRENT_ID);
    }

    public static <T> Collector<T, ?, IntSummaryStatistics> summarizingInt(ToIntFunction<? super T> toIntFunction) {
        return new CollectorImpl(IntSummaryStatistics::new, (intSummaryStatistics, object) -> intSummaryStatistics.accept(toIntFunction.applyAsInt(object)), (intSummaryStatistics, intSummaryStatistics2) -> {
            intSummaryStatistics.combine((IntSummaryStatistics)intSummaryStatistics2);
            return intSummaryStatistics;
        }, CH_ID);
    }

    public static <T> Collector<T, ?, LongSummaryStatistics> summarizingLong(ToLongFunction<? super T> toLongFunction) {
        return new CollectorImpl(LongSummaryStatistics::new, (longSummaryStatistics, object) -> longSummaryStatistics.accept(toLongFunction.applyAsLong(object)), (longSummaryStatistics, longSummaryStatistics2) -> {
            longSummaryStatistics.combine((LongSummaryStatistics)longSummaryStatistics2);
            return longSummaryStatistics;
        }, CH_ID);
    }

    public static <T> Collector<T, ?, DoubleSummaryStatistics> summarizingDouble(ToDoubleFunction<? super T> toDoubleFunction) {
        return new CollectorImpl(DoubleSummaryStatistics::new, (doubleSummaryStatistics, object) -> doubleSummaryStatistics.accept(toDoubleFunction.applyAsDouble(object)), (doubleSummaryStatistics, doubleSummaryStatistics2) -> {
            doubleSummaryStatistics.combine((DoubleSummaryStatistics)doubleSummaryStatistics2);
            return doubleSummaryStatistics;
        }, CH_ID);
    }

    private static /* synthetic */ Object lambda$null$154(Supplier supplier, Object object) {
        return supplier.get();
    }

    private static /* synthetic */ Object lambda$null$152(Supplier supplier, Object object) {
        return supplier.get();
    }

    private static /* synthetic */ Object lambda$null$148(Supplier supplier, Object object) {
        return supplier.get();
    }

    private static final class Partition<T>
    extends AbstractMap<Boolean, T>
    implements Map<Boolean, T> {
        final T forTrue;
        final T forFalse;

        Partition(T t, T t2) {
            this.forTrue = t;
            this.forFalse = t2;
        }

        @Override
        public Set<Map.Entry<Boolean, T>> entrySet() {
            return new AbstractSet<Map.Entry<Boolean, T>>(){

                @Override
                public Iterator<Map.Entry<Boolean, T>> iterator() {
                    AbstractMap.SimpleImmutableEntry simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry(false, forFalse);
                    AbstractMap.SimpleImmutableEntry simpleImmutableEntry2 = new AbstractMap.SimpleImmutableEntry(true, forTrue);
                    return Arrays.asList(simpleImmutableEntry, simpleImmutableEntry2).iterator();
                }

                @Override
                public int size() {
                    return 2;
                }
            };
        }
    }

    static class CollectorImpl<T, A, R>
    implements Collector<T, A, R> {
        private final Supplier<A> supplier;
        private final BiConsumer<A, T> accumulator;
        private final BinaryOperator<A> combiner;
        private final Function<A, R> finisher;
        private final Set<Collector.Characteristics> characteristics;

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> biConsumer, BinaryOperator<A> binaryOperator, Function<A, R> function, Set<Collector.Characteristics> set) {
            this.supplier = supplier;
            this.accumulator = biConsumer;
            this.combiner = binaryOperator;
            this.finisher = function;
            this.characteristics = set;
        }

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> biConsumer, BinaryOperator<A> binaryOperator, Set<Collector.Characteristics> set) {
            this(supplier, biConsumer, binaryOperator, Collectors.castingIdentity(), set);
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.characteristics;
        }
    }
}

