/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.datatransfer;

import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.ToolkitImage;
import sun.util.logging.PlatformLogger;

public abstract class DataTransferer {
    public static final DataFlavor plainTextStringFlavor;
    public static final DataFlavor javaTextEncodingFlavor;
    private static final Map textMIMESubtypeCharsetSupport;
    private static String defaultEncoding;
    private static final Set textNatives;
    private static final Map nativeCharsets;
    private static final Map nativeEOLNs;
    private static final Map nativeTerminators;
    private static final String DATA_CONVERTER_KEY = "DATA_CONVERTER_KEY";
    private static DataTransferer transferer;
    private static final PlatformLogger dtLog;
    private static final String[] DEPLOYMENT_CACHE_PROPERTIES;
    private static final ArrayList<File> deploymentCacheDirectoryList;

    public static synchronized DataTransferer getInstance() {
        return ((SunToolkit)Toolkit.getDefaultToolkit()).getDataTransferer();
    }

    public static String canonicalName(String string) {
        if (string == null) {
            return null;
        }
        try {
            return Charset.forName(string).name();
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            return string;
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            return string;
        }
    }

    public static String getTextCharset(DataFlavor dataFlavor) {
        if (!DataTransferer.isFlavorCharsetTextType(dataFlavor)) {
            return null;
        }
        String string = dataFlavor.getParameter("charset");
        return string != null ? string : DataTransferer.getDefaultTextCharset();
    }

    public static String getDefaultTextCharset() {
        if (defaultEncoding != null) {
            return defaultEncoding;
        }
        defaultEncoding = Charset.defaultCharset().name();
        return defaultEncoding;
    }

    public static boolean doesSubtypeSupportCharset(DataFlavor dataFlavor) {
        String string;
        if (dtLog.isLoggable(PlatformLogger.Level.FINE) && !"text".equals(dataFlavor.getPrimaryType())) {
            dtLog.fine("Assertion (\"text\".equals(flavor.getPrimaryType())) failed");
        }
        if ((string = dataFlavor.getSubType()) == null) {
            return false;
        }
        Object v = textMIMESubtypeCharsetSupport.get(string);
        if (v != null) {
            return v == Boolean.TRUE;
        }
        boolean bl = dataFlavor.getParameter("charset") != null;
        textMIMESubtypeCharsetSupport.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
        return bl;
    }

    public static boolean doesSubtypeSupportCharset(String string, String string2) {
        Object v = textMIMESubtypeCharsetSupport.get(string);
        if (v != null) {
            return v == Boolean.TRUE;
        }
        boolean bl = string2 != null;
        textMIMESubtypeCharsetSupport.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
        return bl;
    }

    public static boolean isFlavorCharsetTextType(DataFlavor dataFlavor) {
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            return true;
        }
        if (!"text".equals(dataFlavor.getPrimaryType()) || !DataTransferer.doesSubtypeSupportCharset(dataFlavor)) {
            return false;
        }
        Class<?> clazz = dataFlavor.getRepresentationClass();
        if (dataFlavor.isRepresentationClassReader() || String.class.equals(clazz) || dataFlavor.isRepresentationClassCharBuffer() || char[].class.equals(clazz)) {
            return true;
        }
        if (!(dataFlavor.isRepresentationClassInputStream() || dataFlavor.isRepresentationClassByteBuffer() || byte[].class.equals(clazz))) {
            return false;
        }
        String string = dataFlavor.getParameter("charset");
        return string != null ? DataTransferer.isEncodingSupported(string) : true;
    }

    public static boolean isFlavorNoncharsetTextType(DataFlavor dataFlavor) {
        if (!"text".equals(dataFlavor.getPrimaryType()) || DataTransferer.doesSubtypeSupportCharset(dataFlavor)) {
            return false;
        }
        return dataFlavor.isRepresentationClassInputStream() || dataFlavor.isRepresentationClassByteBuffer() || byte[].class.equals(dataFlavor.getRepresentationClass());
    }

    public static boolean isEncodingSupported(String string) {
        if (string == null) {
            return false;
        }
        try {
            return Charset.isSupported(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            return false;
        }
    }

    public static boolean isRemote(Class<?> clazz) {
        return RMI.isRemote(clazz);
    }

    public static Set<String> standardEncodings() {
        return StandardEncodingsHolder.standardEncodings;
    }

    public static FlavorTable adaptFlavorMap(final FlavorMap flavorMap) {
        if (flavorMap instanceof FlavorTable) {
            return (FlavorTable)flavorMap;
        }
        return new FlavorTable(){

            public Map getNativesForFlavors(DataFlavor[] dataFlavorArray) {
                return flavorMap.getNativesForFlavors(dataFlavorArray);
            }

            public Map getFlavorsForNatives(String[] stringArray) {
                return flavorMap.getFlavorsForNatives(stringArray);
            }

            public List getNativesForFlavor(DataFlavor dataFlavor) {
                Map map = this.getNativesForFlavors(new DataFlavor[]{dataFlavor});
                String string = (String)map.get(dataFlavor);
                if (string != null) {
                    ArrayList<String> arrayList = new ArrayList<String>(1);
                    arrayList.add(string);
                    return arrayList;
                }
                return Collections.EMPTY_LIST;
            }

            public List getFlavorsForNative(String string) {
                Map map = this.getFlavorsForNatives(new String[]{string});
                DataFlavor dataFlavor = (DataFlavor)map.get(string);
                if (dataFlavor != null) {
                    ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>(1);
                    arrayList.add(dataFlavor);
                    return arrayList;
                }
                return Collections.EMPTY_LIST;
            }
        };
    }

    public abstract String getDefaultUnicodeEncoding();

    public void registerTextFlavorProperties(String string, String string2, String string3, String string4) {
        Integer n;
        Long l = this.getFormatForNativeAsLong(string);
        textNatives.add(l);
        nativeCharsets.put(l, string2 != null && string2.length() != 0 ? string2 : DataTransferer.getDefaultTextCharset());
        if (string3 != null && string3.length() != 0 && !string3.equals("\n")) {
            nativeEOLNs.put(l, string3);
        }
        if (string4 != null && string4.length() != 0 && (n = Integer.valueOf(string4)) > 0) {
            nativeTerminators.put(l, n);
        }
    }

    protected boolean isTextFormat(long l) {
        return textNatives.contains(l);
    }

    protected String getCharsetForTextFormat(Long l) {
        return (String)nativeCharsets.get(l);
    }

    public abstract boolean isLocaleDependentTextFormat(long var1);

    public abstract boolean isFileFormat(long var1);

    public abstract boolean isImageFormat(long var1);

    protected boolean isURIListFormat(long l) {
        return false;
    }

    public SortedMap<Long, DataFlavor> getFormatsForTransferable(Transferable transferable, FlavorTable flavorTable) {
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        if (dataFlavorArray == null) {
            return new TreeMap<Long, DataFlavor>();
        }
        return this.getFormatsForFlavors(dataFlavorArray, flavorTable);
    }

    public SortedMap getFormatsForFlavor(DataFlavor dataFlavor, FlavorTable flavorTable) {
        return this.getFormatsForFlavors(new DataFlavor[]{dataFlavor}, flavorTable);
    }

    public SortedMap<Long, DataFlavor> getFormatsForFlavors(DataFlavor[] dataFlavorArray, FlavorTable flavorTable) {
        Cloneable cloneable;
        HashMap<Long, Cloneable> hashMap = new HashMap<Long, Cloneable>(dataFlavorArray.length);
        HashMap<Long, Cloneable> hashMap2 = new HashMap<Long, Cloneable>(dataFlavorArray.length);
        HashMap<Long, Integer> hashMap3 = new HashMap<Long, Integer>(dataFlavorArray.length);
        HashMap<Long, Integer> hashMap4 = new HashMap<Long, Integer>(dataFlavorArray.length);
        int n = 0;
        for (int i = dataFlavorArray.length - 1; i >= 0; --i) {
            cloneable = dataFlavorArray[i];
            if (cloneable == null || !((DataFlavor)cloneable).isFlavorTextType() && !((DataFlavor)cloneable).isFlavorJavaFileListType() && !DataFlavor.imageFlavor.equals((DataFlavor)cloneable) && !((DataFlavor)cloneable).isRepresentationClassSerializable() && !((DataFlavor)cloneable).isRepresentationClassInputStream() && !((DataFlavor)cloneable).isRepresentationClassRemote()) continue;
            List<String> list = flavorTable.getNativesForFlavor((DataFlavor)cloneable);
            n += list.size();
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                Long l = this.getFormatForNativeAsLong(iterator.next());
                Integer n2 = n--;
                hashMap.put(l, cloneable);
                hashMap3.put(l, n2);
                if ((!"text".equals(((DataFlavor)cloneable).getPrimaryType()) || !"plain".equals(((DataFlavor)cloneable).getSubType())) && !((DataFlavor)cloneable).equals(DataFlavor.stringFlavor)) continue;
                hashMap2.put(l, cloneable);
                hashMap4.put(l, n2);
            }
            n += list.size();
        }
        hashMap.putAll(hashMap2);
        hashMap3.putAll(hashMap4);
        IndexOrderComparator indexOrderComparator = new IndexOrderComparator(hashMap3, false);
        cloneable = new TreeMap(indexOrderComparator);
        cloneable.putAll(hashMap);
        return cloneable;
    }

    public long[] getFormatsForTransferableAsArray(Transferable transferable, FlavorTable flavorTable) {
        return DataTransferer.keysToLongArray(this.getFormatsForTransferable(transferable, flavorTable));
    }

    public long[] getFormatsForFlavorAsArray(DataFlavor dataFlavor, FlavorTable flavorTable) {
        return DataTransferer.keysToLongArray(this.getFormatsForFlavor(dataFlavor, flavorTable));
    }

    public long[] getFormatsForFlavorsAsArray(DataFlavor[] dataFlavorArray, FlavorTable flavorTable) {
        return DataTransferer.keysToLongArray(this.getFormatsForFlavors(dataFlavorArray, flavorTable));
    }

    public Map getFlavorsForFormat(long l, FlavorTable flavorTable) {
        return this.getFlavorsForFormats(new long[]{l}, flavorTable);
    }

    public Map getFlavorsForFormats(long[] lArray, FlavorTable flavorTable) {
        Object object;
        Object object2;
        Object object3;
        HashMap<DataFlavor, Object> hashMap = new HashMap<DataFlavor, Object>(lArray.length);
        HashSet<Object> hashSet = new HashSet<Object>(lArray.length);
        HashSet<DataFlavor> hashSet2 = new HashSet<DataFlavor>(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            object3 = this.getNativeForFormat(l);
            object2 = flavorTable.getFlavorsForNative((String)object3);
            object = object2.iterator();
            while (object.hasNext()) {
                DataFlavor dataFlavor = object.next();
                if (!dataFlavor.isFlavorTextType() && !dataFlavor.isFlavorJavaFileListType() && !DataFlavor.imageFlavor.equals(dataFlavor) && !dataFlavor.isRepresentationClassSerializable() && !dataFlavor.isRepresentationClassInputStream() && !dataFlavor.isRepresentationClassRemote()) continue;
                Long l2 = l;
                Object object4 = DataTransferer.createMapping(l2, dataFlavor);
                hashMap.put(dataFlavor, l2);
                hashSet.add(object4);
                hashSet2.add(dataFlavor);
            }
        }
        block2: for (DataFlavor dataFlavor : hashSet2) {
            List<String> list = flavorTable.getNativesForFlavor(dataFlavor);
            object3 = list.iterator();
            while (object3.hasNext()) {
                object2 = this.getFormatForNativeAsLong((String)object3.next());
                object = DataTransferer.createMapping(object2, dataFlavor);
                if (!hashSet.contains(object)) continue;
                hashMap.put(dataFlavor, object2);
                continue block2;
            }
        }
        return hashMap;
    }

    public Set getFlavorsForFormatsAsSet(long[] lArray, FlavorTable flavorTable) {
        HashSet<DataFlavor> hashSet = new HashSet<DataFlavor>(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            String string = this.getNativeForFormat(lArray[i]);
            List<DataFlavor> list = flavorTable.getFlavorsForNative(string);
            for (DataFlavor dataFlavor : list) {
                if (!dataFlavor.isFlavorTextType() && !dataFlavor.isFlavorJavaFileListType() && !DataFlavor.imageFlavor.equals(dataFlavor) && !dataFlavor.isRepresentationClassSerializable() && !dataFlavor.isRepresentationClassInputStream() && !dataFlavor.isRepresentationClassRemote()) continue;
                hashSet.add(dataFlavor);
            }
        }
        return hashSet;
    }

    public DataFlavor[] getFlavorsForFormatAsArray(long l, FlavorTable flavorTable) {
        return this.getFlavorsForFormatsAsArray(new long[]{l}, flavorTable);
    }

    public DataFlavor[] getFlavorsForFormatsAsArray(long[] lArray, FlavorTable flavorTable) {
        return DataTransferer.setToSortedDataFlavorArray(this.getFlavorsForFormatsAsSet(lArray, flavorTable));
    }

    private static Object createMapping(Object object, Object object2) {
        return Arrays.asList(object, object2);
    }

    protected abstract Long getFormatForNativeAsLong(String var1);

    protected abstract String getNativeForFormat(long var1);

    private String getBestCharsetForTextFormat(Long l, Transferable transferable) throws IOException {
        String string = null;
        if (transferable != null && this.isLocaleDependentTextFormat(l) && transferable.isDataFlavorSupported(javaTextEncodingFlavor)) {
            try {
                string = new String((byte[])transferable.getTransferData(javaTextEncodingFlavor), "UTF-8");
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {}
        } else {
            string = this.getCharsetForTextFormat(l);
        }
        if (string == null) {
            string = DataTransferer.getDefaultTextCharset();
        }
        return string;
    }

    private byte[] translateTransferableString(String string, long l) throws IOException {
        int n;
        Serializable serializable;
        Long l2 = l;
        String string2 = this.getBestCharsetForTextFormat(l2, null);
        String string3 = (String)nativeEOLNs.get(l2);
        if (string3 != null) {
            int n2 = string.length();
            serializable = new StringBuffer(n2 * 2);
            for (n = 0; n < n2; ++n) {
                if (string.startsWith(string3, n)) {
                    ((StringBuffer)serializable).append(string3);
                    n += string3.length() - 1;
                    continue;
                }
                char c = string.charAt(n);
                if (c == '\n') {
                    ((StringBuffer)serializable).append(string3);
                    continue;
                }
                ((StringBuffer)serializable).append(c);
            }
            string = ((StringBuffer)serializable).toString();
        }
        byte[] byArray = string.getBytes(string2);
        serializable = (Integer)nativeTerminators.get(l2);
        if (serializable != null) {
            n = (Integer)serializable;
            byte[] byArray2 = new byte[byArray.length + n];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            for (int i = byArray.length; i < byArray2.length; ++i) {
                byArray2[i] = 0;
            }
            byArray = byArray2;
        }
        return byArray;
    }

    private String translateBytesToString(byte[] byArray, long l, Transferable transferable) throws IOException {
        int n;
        Long l2 = l;
        String string = this.getBestCharsetForTextFormat(l2, transferable);
        String string2 = (String)nativeEOLNs.get(l2);
        Integer n2 = (Integer)nativeTerminators.get(l2);
        if (n2 != null) {
            int n3 = n2;
            block0: for (n = 0; n < byArray.length - n3 + 1; n += n3) {
                for (int i = n; i < n + n3; ++i) {
                    if (byArray[i] != 0) continue block0;
                }
                break;
            }
        } else {
            n = byArray.length;
        }
        String string3 = new String(byArray, 0, n, string);
        if (string2 != null) {
            char[] cArray = string3.toCharArray();
            char[] cArray2 = string2.toCharArray();
            string3 = null;
            int n4 = 0;
            int n5 = 0;
            while (n5 < cArray.length) {
                if (n5 + cArray2.length > cArray.length) {
                    cArray[n4++] = cArray[n5++];
                    continue;
                }
                boolean bl = true;
                int n6 = 0;
                int n7 = n5;
                while (n6 < cArray2.length) {
                    if (cArray2[n6] != cArray[n7]) {
                        bl = false;
                        break;
                    }
                    ++n6;
                    ++n7;
                }
                if (bl) {
                    cArray[n4++] = 10;
                    n5 += cArray2.length;
                    continue;
                }
                cArray[n4++] = cArray[n5++];
            }
            string3 = new String(cArray, 0, n4);
        }
        return string3;
    }

    public byte[] translateTransferable(Transferable transferable, DataFlavor dataFlavor, long l) throws IOException {
        boolean bl;
        Object object;
        try {
            object = transferable.getTransferData(dataFlavor);
            if (object == null) {
                return null;
            }
            if (dataFlavor.equals(DataFlavor.plainTextFlavor) && !(object instanceof InputStream)) {
                object = transferable.getTransferData(DataFlavor.stringFlavor);
                if (object == null) {
                    return null;
                }
                bl = true;
            } else {
                bl = false;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            throw new IOException(unsupportedFlavorException.getMessage());
        }
        if (bl || String.class.equals(dataFlavor.getRepresentationClass()) && DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l)) {
            String string = this.removeSuspectedData(dataFlavor, transferable, (String)object);
            return this.translateTransferableString(string, l);
        }
        if (dataFlavor.isRepresentationClassReader()) {
            if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l)) {
                throw new IOException("cannot transfer non-text data as Reader");
            }
            StringBuffer stringBuffer = new StringBuffer();
            try (Reader reader = (Reader)object;){
                int n;
                while ((n = reader.read()) != -1) {
                    stringBuffer.append((char)n);
                }
            }
            return this.translateTransferableString(stringBuffer.toString(), l);
        }
        if (dataFlavor.isRepresentationClassCharBuffer()) {
            if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l)) {
                throw new IOException("cannot transfer non-text data as CharBuffer");
            }
            CharBuffer charBuffer = (CharBuffer)object;
            int n = charBuffer.remaining();
            char[] cArray = new char[n];
            charBuffer.get(cArray, 0, n);
            return this.translateTransferableString(new String(cArray), l);
        }
        if (char[].class.equals(dataFlavor.getRepresentationClass())) {
            if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l)) {
                throw new IOException("cannot transfer non-text data as char array");
            }
            return this.translateTransferableString(new String((char[])object), l);
        }
        if (dataFlavor.isRepresentationClassByteBuffer()) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            int n = byteBuffer.remaining();
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray, 0, n);
            if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l)) {
                String string = DataTransferer.getTextCharset(dataFlavor);
                return this.translateTransferableString(new String(byArray, string), l);
            }
            return byArray;
        }
        if (byte[].class.equals(dataFlavor.getRepresentationClass())) {
            byte[] byArray = (byte[])object;
            if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l)) {
                String string = DataTransferer.getTextCharset(dataFlavor);
                return this.translateTransferableString(new String(byArray, string), l);
            }
            return byArray;
        }
        if (DataFlavor.imageFlavor.equals(dataFlavor)) {
            if (!this.isImageFormat(l)) {
                throw new IOException("Data translation failed: not an image format");
            }
            Image image = (Image)object;
            byte[] byArray = this.imageToPlatformBytes(image, l);
            if (byArray == null) {
                throw new IOException("Data translation failed: cannot convert java image to native format");
            }
            return byArray;
        }
        byte[] byArray = null;
        if (this.isFileFormat(l)) {
            if (!DataFlavor.javaFileListFlavor.equals(dataFlavor)) {
                throw new IOException("data translation failed");
            }
            List list = (List)object;
            ProtectionDomain protectionDomain = DataTransferer.getUserProtectionDomain(transferable);
            ArrayList<String> arrayList = this.castToFiles(list, protectionDomain);
            try (ByteArrayOutputStream byteArrayOutputStream = this.convertFileListToBytes(arrayList);){
                byArray = byteArrayOutputStream.toByteArray();
            }
        }
        if (this.isURIListFormat(l)) {
            Serializable serializable;
            if (!DataFlavor.javaFileListFlavor.equals(dataFlavor)) {
                throw new IOException("data translation failed");
            }
            String string = this.getNativeForFormat(l);
            String string2 = null;
            if (string != null) {
                try {
                    string2 = new DataFlavor(string).getParameter("charset");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IOException(classNotFoundException);
                }
            }
            if (string2 == null) {
                string2 = "UTF-8";
            }
            List list = (List)object;
            ProtectionDomain protectionDomain = DataTransferer.getUserProtectionDomain(transferable);
            ArrayList<String> arrayList = this.castToFiles(list, protectionDomain);
            ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size());
            for (String object22 : arrayList) {
                serializable = new File(object22).toURI();
                try {
                    arrayList2.add(new URI(((URI)serializable).getScheme(), "", ((URI)serializable).getPath(), ((URI)serializable).getFragment()).toString());
                }
                catch (URISyntaxException i) {
                    throw new IOException(i);
                }
            }
            Object object3 = "\r\n".getBytes(string2);
            ByteArrayOutputStream n2 = new ByteArrayOutputStream();
            serializable = null;
            try {
                for (int throwable = 0; throwable < arrayList2.size(); ++throwable) {
                    byte[] byArray2 = ((String)arrayList2.get(throwable)).getBytes(string2);
                    n2.write(byArray2, 0, byArray2.length);
                    n2.write((byte[])object3, 0, ((Object)object3).length);
                }
                byArray = n2.toByteArray();
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                if (n2 != null) {
                    if (serializable != null) {
                        try {
                            n2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                    } else {
                        n2.close();
                    }
                }
            }
        }
        if (dataFlavor.isRepresentationClassInputStream()) {
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                Object object4 = (InputStream)object;
                Object object5 = null;
                try {
                    boolean bl2 = false;
                    int n = ((InputStream)object4).available();
                    byte[] byArray3 = new byte[n > 8192 ? n : 8192];
                    do {
                        int n2;
                        if (bl2 = (n2 = ((InputStream)object4).read(byArray3, 0, byArray3.length)) == -1) continue;
                        byteArrayOutputStream.write(byArray3, 0, n2);
                    } while (!bl2);
                }
                catch (Throwable throwable) {
                    object5 = throwable;
                    throw throwable;
                }
                finally {
                    if (object4 != null) {
                        if (object5 != null) {
                            try {
                                ((InputStream)object4).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object5).addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)object4).close();
                        }
                    }
                }
                if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l)) {
                    object4 = byteArrayOutputStream.toByteArray();
                    object5 = DataTransferer.getTextCharset(dataFlavor);
                    byte[] byArray4 = this.translateTransferableString(new String((byte[])object4, (String)object5), l);
                    return byArray4;
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
        }
        if (dataFlavor.isRepresentationClassRemote()) {
            Object object6 = RMI.newMarshalledObject(object);
            byArray = DataTransferer.convertObjectToBytes(object6);
        } else if (dataFlavor.isRepresentationClassSerializable()) {
            byArray = DataTransferer.convertObjectToBytes(object);
        } else {
            throw new IOException("data translation failed");
        }
        return byArray;
    }

    /*
     * Exception decompiling
     */
    private static byte[] convertObjectToBytes(Object var0) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract ByteArrayOutputStream convertFileListToBytes(ArrayList<String> var1) throws IOException;

    private String removeSuspectedData(DataFlavor dataFlavor, Transferable transferable, final String string) throws IOException {
        if (null == System.getSecurityManager() || !dataFlavor.isMimeTypeEqual("text/uri-list")) {
            return string;
        }
        String string2 = "";
        final ProtectionDomain protectionDomain = DataTransferer.getUserProtectionDomain(transferable);
        try {
            string2 = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    String[] stringArray;
                    StringBuffer stringBuffer = new StringBuffer(string.length());
                    for (String string2 : stringArray = string.split("(\\s)+")) {
                        File file = new File(string2);
                        if (!file.exists() || DataTransferer.isFileInWebstartedCache(file) || DataTransferer.this.isForbiddenToRead(file, protectionDomain)) continue;
                        if (0 != stringBuffer.length()) {
                            stringBuffer.append("\\r\\n");
                        }
                        stringBuffer.append(string2);
                    }
                    return stringBuffer.toString();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IOException(privilegedActionException.getMessage(), privilegedActionException);
        }
        return string2;
    }

    private static ProtectionDomain getUserProtectionDomain(Transferable transferable) {
        return transferable.getClass().getProtectionDomain();
    }

    private boolean isForbiddenToRead(File file, ProtectionDomain protectionDomain) {
        if (null == protectionDomain) {
            return false;
        }
        try {
            FilePermission filePermission = new FilePermission(file.getCanonicalPath(), "read, delete");
            if (protectionDomain.implies(filePermission)) {
                return false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private ArrayList<String> castToFiles(final List list, final ProtectionDomain protectionDomain) throws IOException {
        final ArrayList<String> arrayList = new ArrayList<String>();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    for (Object e : list) {
                        File file = DataTransferer.this.castToFile(e);
                        if (file == null || null != System.getSecurityManager() && (DataTransferer.isFileInWebstartedCache(file) || DataTransferer.this.isForbiddenToRead(file, protectionDomain))) continue;
                        arrayList.add(file.getCanonicalPath());
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IOException(privilegedActionException.getMessage());
        }
        return arrayList;
    }

    private File castToFile(Object object) throws IOException {
        String string = null;
        if (object instanceof File) {
            string = ((File)object).getCanonicalPath();
        } else if (object instanceof String) {
            string = (String)object;
        } else {
            return null;
        }
        return new File(string);
    }

    private static boolean isFileInWebstartedCache(File file) {
        if (deploymentCacheDirectoryList.isEmpty()) {
            for (String string : DEPLOYMENT_CACHE_PROPERTIES) {
                String string2 = System.getProperty(string);
                if (string2 == null) continue;
                try {
                    File file2 = new File(string2).getCanonicalFile();
                    if (file2 == null) continue;
                    deploymentCacheDirectoryList.add(file2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        for (File file3 : deploymentCacheDirectoryList) {
            for (File file4 = file; file4 != null; file4 = file4.getParentFile()) {
                if (!file4.equals(file3)) continue;
                return true;
            }
        }
        return false;
    }

    public Object translateBytes(byte[] byArray, DataFlavor dataFlavor, long l, Transferable transferable) throws IOException {
        Object object;
        block108: {
            object = null;
            if (this.isFileFormat(l)) {
                if (!DataFlavor.javaFileListFlavor.equals(dataFlavor)) {
                    throw new IOException("data translation failed");
                }
                String[] stringArray = this.dragQueryFile(byArray);
                if (stringArray == null) {
                    return null;
                }
                File[] fileArray = new File[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    fileArray[i] = new File(stringArray[i]);
                }
                object = Arrays.asList(fileArray);
            } else {
                if (this.isURIListFormat(l) && DataFlavor.javaFileListFlavor.equals(dataFlavor)) {
                    try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
                        URI[] uRIArray = this.dragQueryURIs(byteArrayInputStream, l, transferable);
                        if (uRIArray == null) {
                            Object var10_34 = null;
                            return var10_34;
                        }
                        ArrayList<File> arrayList = new ArrayList<File>();
                        for (URI uRI : uRIArray) {
                            try {
                                arrayList.add(new File(uRI));
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                        object = arrayList;
                    }
                }
                if (String.class.equals(dataFlavor.getRepresentationClass()) && DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l)) {
                    object = this.translateBytesToString(byArray, l, transferable);
                } else {
                    if (dataFlavor.isRepresentationClassReader()) {
                        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
                            object = this.translateStream(byteArrayInputStream, dataFlavor, l, transferable);
                        }
                    }
                    if (dataFlavor.isRepresentationClassCharBuffer()) {
                        if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l)) {
                            throw new IOException("cannot transfer non-text data as CharBuffer");
                        }
                        CharBuffer charBuffer = CharBuffer.wrap(this.translateBytesToString(byArray, l, transferable));
                        object = this.constructFlavoredObject(charBuffer, dataFlavor, CharBuffer.class);
                    } else if (char[].class.equals(dataFlavor.getRepresentationClass())) {
                        if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l)) {
                            throw new IOException("cannot transfer non-text data as char array");
                        }
                        object = this.translateBytesToString(byArray, l, transferable).toCharArray();
                    } else if (dataFlavor.isRepresentationClassByteBuffer()) {
                        if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l)) {
                            byArray = this.translateBytesToString(byArray, l, transferable).getBytes(DataTransferer.getTextCharset(dataFlavor));
                        }
                        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                        object = this.constructFlavoredObject(byteBuffer, dataFlavor, ByteBuffer.class);
                    } else if (byte[].class.equals(dataFlavor.getRepresentationClass())) {
                        object = DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l) ? (Object)this.translateBytesToString(byArray, l, transferable).getBytes(DataTransferer.getTextCharset(dataFlavor)) : (Object)byArray;
                    } else {
                        if (dataFlavor.isRepresentationClassInputStream()) {
                            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
                                object = this.translateStream(byteArrayInputStream, dataFlavor, l, transferable);
                            }
                        }
                        if (dataFlavor.isRepresentationClassRemote()) {
                            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                                 ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);){
                                object = RMI.getMarshalledObject(objectInputStream.readObject());
                                break block108;
                            }
                            catch (Exception exception) {
                                throw new IOException(exception.getMessage());
                            }
                        }
                        if (dataFlavor.isRepresentationClassSerializable()) {
                            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
                                object = this.translateStream(byteArrayInputStream, dataFlavor, l, transferable);
                            }
                        } else if (DataFlavor.imageFlavor.equals(dataFlavor)) {
                            if (!this.isImageFormat(l)) {
                                throw new IOException("data translation failed");
                            }
                            object = this.platformImageBytesToImage(byArray, l);
                        }
                    }
                }
            }
        }
        if (object == null) {
            throw new IOException("data translation failed");
        }
        return object;
    }

    public Object translateStream(InputStream inputStream, DataFlavor dataFlavor, long l, Transferable transferable) throws IOException {
        Object object;
        block49: {
            object = null;
            if (this.isURIListFormat(l) && DataFlavor.javaFileListFlavor.equals(dataFlavor)) {
                URI[] uRIArray = this.dragQueryURIs(inputStream, l, transferable);
                if (uRIArray == null) {
                    return null;
                }
                ArrayList<File> arrayList = new ArrayList<File>();
                for (URI uRI : uRIArray) {
                    try {
                        arrayList.add(new File(uRI));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                object = arrayList;
            } else {
                if (String.class.equals(dataFlavor.getRepresentationClass()) && DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l)) {
                    return this.translateBytesToString(DataTransferer.inputStreamToByteArray(inputStream), l, transferable);
                }
                if (DataFlavor.plainTextFlavor.equals(dataFlavor)) {
                    object = new StringReader(this.translateBytesToString(DataTransferer.inputStreamToByteArray(inputStream), l, transferable));
                } else if (dataFlavor.isRepresentationClassInputStream()) {
                    object = this.translateStreamToInputStream(inputStream, dataFlavor, l, transferable);
                } else if (dataFlavor.isRepresentationClassReader()) {
                    if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l)) {
                        throw new IOException("cannot transfer non-text data as Reader");
                    }
                    InputStream inputStream2 = (InputStream)this.translateStreamToInputStream(inputStream, DataFlavor.plainTextFlavor, l, transferable);
                    String string = DataTransferer.getTextCharset(DataFlavor.plainTextFlavor);
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream2, string);
                    object = this.constructFlavoredObject(inputStreamReader, dataFlavor, Reader.class);
                } else if (byte[].class.equals(dataFlavor.getRepresentationClass())) {
                    object = DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l) ? (Object)this.translateBytesToString(DataTransferer.inputStreamToByteArray(inputStream), l, transferable).getBytes(DataTransferer.getTextCharset(dataFlavor)) : (Object)DataTransferer.inputStreamToByteArray(inputStream);
                } else {
                    if (dataFlavor.isRepresentationClassRemote()) {
                        try (ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);){
                            object = RMI.getMarshalledObject(objectInputStream.readObject());
                            break block49;
                        }
                        catch (Exception exception) {
                            throw new IOException(exception.getMessage());
                        }
                    }
                    if (dataFlavor.isRepresentationClassSerializable()) {
                        try (ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);){
                            object = objectInputStream.readObject();
                            break block49;
                        }
                        catch (Exception exception) {
                            throw new IOException(exception.getMessage());
                        }
                    }
                    if (DataFlavor.imageFlavor.equals(dataFlavor)) {
                        if (!this.isImageFormat(l)) {
                            throw new IOException("data translation failed");
                        }
                        object = this.platformImageBytesToImage(DataTransferer.inputStreamToByteArray(inputStream), l);
                    }
                }
            }
        }
        if (object == null) {
            throw new IOException("data translation failed");
        }
        return object;
    }

    private Object translateStreamToInputStream(InputStream inputStream, DataFlavor dataFlavor, long l, Transferable transferable) throws IOException {
        if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l)) {
            inputStream = new ReencodingInputStream(inputStream, l, DataTransferer.getTextCharset(dataFlavor), transferable);
        }
        return this.constructFlavoredObject(inputStream, dataFlavor, InputStream.class);
    }

    private Object constructFlavoredObject(Object object, DataFlavor dataFlavor, Class clazz) throws IOException {
        final Class<?> clazz2 = dataFlavor.getRepresentationClass();
        if (clazz.equals(clazz2)) {
            return object;
        }
        Constructor[] constructorArray = null;
        try {
            constructorArray = (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return clazz2.getConstructors();
                }
            });
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.getMessage());
        }
        Constructor constructor = null;
        for (int i = 0; i < constructorArray.length; ++i) {
            Class<?>[] classArray;
            if (!Modifier.isPublic(constructorArray[i].getModifiers()) || (classArray = constructorArray[i].getParameterTypes()) == null || classArray.length != 1 || !clazz.equals(classArray[0])) continue;
            constructor = constructorArray[i];
            break;
        }
        if (constructor == null) {
            throw new IOException("can't find <init>(L" + clazz + ";)V for class: " + clazz2.getName());
        }
        try {
            return constructor.newInstance(object);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    protected abstract String[] dragQueryFile(byte[] var1);

    protected URI[] dragQueryURIs(InputStream inputStream, long l, Transferable transferable) throws IOException {
        throw new IOException(new UnsupportedOperationException("not implemented on this platform"));
    }

    protected abstract Image platformImageBytesToImage(byte[] var1, long var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Image standardImageBytesToImage(byte[] byArray, String string) throws IOException {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByMIMEType(string);
        if (!iterator.hasNext()) {
            throw new IOException("No registered service provider can decode  an image from " + string);
        }
        IOException iOException = null;
        while (true) {
            if (!iterator.hasNext()) {
                if (iOException != null) throw iOException;
                iOException = new IOException("Registered service providers failed to decode an image from " + string);
                throw iOException;
            }
            ImageReader imageReader = iterator.next();
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                Throwable throwable = null;
                try {
                    ImageInputStream imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
                    try {
                        ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
                        imageReader.setInput(imageInputStream, true, true);
                        BufferedImage bufferedImage = imageReader.read(imageReader.getMinIndex(), imageReadParam);
                        if (bufferedImage == null) continue;
                        BufferedImage bufferedImage2 = bufferedImage;
                        return bufferedImage2;
                    }
                    finally {
                        imageInputStream.close();
                        imageReader.dispose();
                        continue;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (byteArrayInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            byteArrayInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    byteArrayInputStream.close();
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                continue;
            }
            break;
        }
    }

    protected abstract byte[] imageToPlatformBytes(Image var1, long var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] imageToStandardBytes(Image image, String string) throws IOException {
        Object object;
        IOException iOException = null;
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(string);
        if (!iterator.hasNext()) {
            throw new IOException("No registered service provider can encode  an image to " + string);
        }
        if (image instanceof RenderedImage) {
            try {
                return this.imageToStandardBytesImpl((RenderedImage)((Object)image), string);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        int n = 0;
        int n2 = 0;
        if (image instanceof ToolkitImage) {
            object = ((ToolkitImage)image).getImageRep();
            ((ImageRepresentation)object).reconstruct(32);
            n = ((ImageRepresentation)object).getWidth();
            n2 = ((ImageRepresentation)object).getHeight();
        } else {
            n = image.getWidth(null);
            n2 = image.getHeight(null);
        }
        object = ColorModel.getRGBdefault();
        WritableRaster writableRaster = ((ColorModel)object).createCompatibleWritableRaster(n, n2);
        BufferedImage bufferedImage = new BufferedImage((ColorModel)object, writableRaster, ((ColorModel)object).isAlphaPremultiplied(), null);
        Graphics graphics = bufferedImage.getGraphics();
        try {
            graphics.drawImage(image, 0, 0, n, n2, null);
        }
        finally {
            graphics.dispose();
        }
        try {
            return this.imageToStandardBytesImpl(bufferedImage, string);
        }
        catch (IOException iOException3) {
            if (iOException != null) {
                throw iOException;
            }
            throw iOException3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] imageToStandardBytesImpl(RenderedImage renderedImage, String string) throws IOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(string);
        ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(renderedImage);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOException iOException = null;
        while (iterator.hasNext()) {
            ImageWriter imageWriter = iterator.next();
            ImageWriterSpi imageWriterSpi = imageWriter.getOriginatingProvider();
            if (!imageWriterSpi.canEncodeImage(imageTypeSpecifier)) continue;
            try (ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);){
                imageWriter.setOutput(imageOutputStream);
                imageWriter.write(renderedImage);
                imageOutputStream.flush();
            }
            catch (IOException iOException2) {
                imageWriter.dispose();
                byteArrayOutputStream.reset();
                iOException = iOException2;
                continue;
            }
            imageWriter.dispose();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        byteArrayOutputStream.close();
        if (iOException == null) {
            iOException = new IOException("Registered service providers failed to encode " + renderedImage + " to " + string);
        }
        throw iOException;
    }

    private Object concatData(Object object, Object object2) {
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (object2 instanceof byte[]) {
                byte[] byArray2 = (byte[])object2;
                byte[] byArray3 = new byte[byArray.length + byArray2.length];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
                return byArray3;
            }
            inputStream = new ByteArrayInputStream(byArray);
            inputStream2 = (InputStream)object2;
        } else {
            inputStream = (InputStream)object;
            inputStream2 = object2 instanceof byte[] ? new ByteArrayInputStream((byte[])object2) : (InputStream)object2;
        }
        return new SequenceInputStream(inputStream, inputStream2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] convertData(Object object, final Transferable transferable, final long l, final Map map, boolean bl) throws IOException {
        byte[] byArray = null;
        if (bl) {
            try {
                final Stack stack = new Stack();
                Runnable runnable = new Runnable(){
                    private boolean done = false;

                    @Override
                    public void run() {
                        if (this.done) {
                            return;
                        }
                        byte[] byArray = null;
                        try {
                            DataFlavor dataFlavor = (DataFlavor)map.get(l);
                            if (dataFlavor != null) {
                                byArray = DataTransferer.this.translateTransferable(transferable, dataFlavor, l);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            byArray = null;
                        }
                        try {
                            DataTransferer.this.getToolkitThreadBlockedHandler().lock();
                            stack.push(byArray);
                            DataTransferer.this.getToolkitThreadBlockedHandler().exit();
                        }
                        finally {
                            DataTransferer.this.getToolkitThreadBlockedHandler().unlock();
                            this.done = true;
                        }
                    }
                };
                AppContext appContext = SunToolkit.targetToAppContext(object);
                this.getToolkitThreadBlockedHandler().lock();
                if (appContext != null) {
                    appContext.put(DATA_CONVERTER_KEY, runnable);
                }
                SunToolkit.executeOnEventHandlerThread(object, runnable);
                while (stack.empty()) {
                    this.getToolkitThreadBlockedHandler().enter();
                }
                if (appContext != null) {
                    appContext.remove(DATA_CONVERTER_KEY);
                }
                byArray = (byte[])stack.pop();
            }
            finally {
                this.getToolkitThreadBlockedHandler().unlock();
            }
        } else {
            DataFlavor dataFlavor = (DataFlavor)map.get(l);
            if (dataFlavor != null) {
                byArray = this.translateTransferable(transferable, dataFlavor, l);
            }
        }
        return byArray;
    }

    public void processDataConversionRequests() {
        if (EventQueue.isDispatchThread()) {
            AppContext appContext = AppContext.getAppContext();
            this.getToolkitThreadBlockedHandler().lock();
            try {
                Runnable runnable = (Runnable)appContext.get(DATA_CONVERTER_KEY);
                if (runnable != null) {
                    runnable.run();
                    appContext.remove(DATA_CONVERTER_KEY);
                }
            }
            finally {
                this.getToolkitThreadBlockedHandler().unlock();
            }
        }
    }

    public abstract ToolkitThreadBlockedHandler getToolkitThreadBlockedHandler();

    public static long[] keysToLongArray(SortedMap sortedMap) {
        Set set = sortedMap.keySet();
        long[] lArray = new long[set.size()];
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            lArray[n] = (Long)iterator.next();
            ++n;
        }
        return lArray;
    }

    public static DataFlavor[] setToSortedDataFlavorArray(Set set) {
        DataFlavor[] dataFlavorArray = new DataFlavor[set.size()];
        set.toArray(dataFlavorArray);
        DataFlavorComparator dataFlavorComparator = new DataFlavorComparator(false);
        Arrays.sort(dataFlavorArray, dataFlavorComparator);
        return dataFlavorArray;
    }

    protected static byte[] inputStreamToByteArray(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int n = 0;
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
    }

    public List getPlatformMappingsForNative(String string) {
        return new ArrayList();
    }

    public List getPlatformMappingsForFlavor(DataFlavor dataFlavor) {
        return new ArrayList();
    }

    static {
        textNatives = Collections.synchronizedSet(new HashSet());
        nativeCharsets = Collections.synchronizedMap(new HashMap());
        nativeEOLNs = Collections.synchronizedMap(new HashMap());
        nativeTerminators = Collections.synchronizedMap(new HashMap());
        dtLog = PlatformLogger.getLogger("sun.awt.datatransfer.DataTransfer");
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = new DataFlavor("text/plain;charset=Unicode;class=java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        plainTextStringFlavor = dataFlavor;
        DataFlavor dataFlavor2 = null;
        try {
            dataFlavor2 = new DataFlavor("application/x-java-text-encoding;class=\"[B\"");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        javaTextEncodingFlavor = dataFlavor2;
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(17);
        hashMap.put("sgml", Boolean.TRUE);
        hashMap.put("xml", Boolean.TRUE);
        hashMap.put("html", Boolean.TRUE);
        hashMap.put("enriched", Boolean.TRUE);
        hashMap.put("richtext", Boolean.TRUE);
        hashMap.put("uri-list", Boolean.TRUE);
        hashMap.put("directory", Boolean.TRUE);
        hashMap.put("css", Boolean.TRUE);
        hashMap.put("calendar", Boolean.TRUE);
        hashMap.put("plain", Boolean.TRUE);
        hashMap.put("rtf", Boolean.FALSE);
        hashMap.put("tab-separated-values", Boolean.FALSE);
        hashMap.put("t140", Boolean.FALSE);
        hashMap.put("rfc822-headers", Boolean.FALSE);
        hashMap.put("parityfec", Boolean.FALSE);
        textMIMESubtypeCharsetSupport = Collections.synchronizedMap(hashMap);
        DEPLOYMENT_CACHE_PROPERTIES = new String[]{"deployment.system.cachedir", "deployment.user.cachedir", "deployment.javaws.cachedir", "deployment.javapi.cachedir"};
        deploymentCacheDirectoryList = new ArrayList();
    }

    private static class RMI {
        private static final Class<?> remoteClass = RMI.getClass("java.rmi.Remote");
        private static final Class<?> marshallObjectClass = RMI.getClass("java.rmi.MarshalledObject");
        private static final Constructor<?> marshallCtor = RMI.getConstructor(marshallObjectClass, Object.class);
        private static final Method marshallGet = RMI.getMethod(marshallObjectClass, "get", new Class[0]);

        private RMI() {
        }

        private static Class<?> getClass(String string) {
            try {
                return Class.forName(string, true, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        private static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... classArray) {
            try {
                return clazz == null ? null : clazz.getDeclaredConstructor(classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new AssertionError((Object)noSuchMethodException);
            }
        }

        private static Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) {
            try {
                return clazz == null ? null : clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new AssertionError((Object)noSuchMethodException);
            }
        }

        static boolean isRemote(Class<?> clazz) {
            return remoteClass == null ? null : Boolean.valueOf(remoteClass.isAssignableFrom(clazz));
        }

        static Class<?> remoteClass() {
            return remoteClass;
        }

        static Object newMarshalledObject(Object object) throws IOException {
            try {
                return marshallCtor.newInstance(object);
            }
            catch (InstantiationException instantiationException) {
                throw new AssertionError((Object)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new AssertionError((Object)invocationTargetException);
            }
        }

        static Object getMarshalledObject(Object object) throws IOException, ClassNotFoundException {
            try {
                return marshallGet.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (throwable instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)throwable;
                }
                throw new AssertionError((Object)invocationTargetException);
            }
        }
    }

    public static class IndexOrderComparator
    extends IndexedComparator {
        private final Map indexMap;
        private static final Integer FALLBACK_INDEX = Integer.MIN_VALUE;

        public IndexOrderComparator(Map map) {
            super(true);
            this.indexMap = map;
        }

        public IndexOrderComparator(Map map, boolean bl) {
            super(bl);
            this.indexMap = map;
        }

        public int compare(Object object, Object object2) {
            if (!this.order) {
                return -IndexOrderComparator.compareIndices(this.indexMap, object, object2, FALLBACK_INDEX);
            }
            return IndexOrderComparator.compareIndices(this.indexMap, object, object2, FALLBACK_INDEX);
        }
    }

    public static class DataFlavorComparator
    extends IndexedComparator {
        private final CharsetComparator charsetComparator;
        private static final Map exactTypes;
        private static final Map primaryTypes;
        private static final Map nonTextRepresentations;
        private static final Map textTypes;
        private static final Map decodedTextRepresentations;
        private static final Map encodedTextRepresentations;
        private static final Integer UNKNOWN_OBJECT_LOSES;
        private static final Integer UNKNOWN_OBJECT_WINS;
        private static final Long UNKNOWN_OBJECT_LOSES_L;
        private static final Long UNKNOWN_OBJECT_WINS_L;

        public DataFlavorComparator() {
            this(true);
        }

        public DataFlavorComparator(boolean bl) {
            super(bl);
            this.charsetComparator = new CharsetComparator(bl);
        }

        public int compare(Object object, Object object2) {
            DataFlavor dataFlavor = null;
            DataFlavor dataFlavor2 = null;
            if (this.order) {
                dataFlavor = (DataFlavor)object;
                dataFlavor2 = (DataFlavor)object2;
            } else {
                dataFlavor = (DataFlavor)object2;
                dataFlavor2 = (DataFlavor)object;
            }
            if (dataFlavor.equals(dataFlavor2)) {
                return 0;
            }
            int n = 0;
            String string = dataFlavor.getPrimaryType();
            String string2 = dataFlavor.getSubType();
            String string3 = string + "/" + string2;
            Class<?> clazz = dataFlavor.getRepresentationClass();
            String string4 = dataFlavor2.getPrimaryType();
            String string5 = dataFlavor2.getSubType();
            String string6 = string4 + "/" + string5;
            Class<?> clazz2 = dataFlavor2.getRepresentationClass();
            if (dataFlavor.isFlavorTextType() && dataFlavor2.isFlavorTextType()) {
                n = DataFlavorComparator.compareIndices(textTypes, string3, string6, UNKNOWN_OBJECT_LOSES);
                if (n != 0) {
                    return n;
                }
                if (DataTransferer.doesSubtypeSupportCharset(dataFlavor)) {
                    n = DataFlavorComparator.compareIndices(decodedTextRepresentations, clazz, clazz2, UNKNOWN_OBJECT_LOSES);
                    if (n != 0) {
                        return n;
                    }
                    n = this.charsetComparator.compareCharsets(DataTransferer.getTextCharset(dataFlavor), DataTransferer.getTextCharset(dataFlavor2));
                    if (n != 0) {
                        return n;
                    }
                }
                if ((n = DataFlavorComparator.compareIndices(encodedTextRepresentations, clazz, clazz2, UNKNOWN_OBJECT_LOSES)) != 0) {
                    return n;
                }
            } else {
                n = DataFlavorComparator.compareIndices(primaryTypes, string, string4, UNKNOWN_OBJECT_LOSES);
                if (n != 0) {
                    return n;
                }
                n = DataFlavorComparator.compareIndices(exactTypes, string3, string6, UNKNOWN_OBJECT_WINS);
                if (n != 0) {
                    return n;
                }
                n = DataFlavorComparator.compareIndices(nonTextRepresentations, clazz, clazz2, UNKNOWN_OBJECT_LOSES);
                if (n != 0) {
                    return n;
                }
            }
            return dataFlavor.getMimeType().compareTo(dataFlavor2.getMimeType());
        }

        static {
            UNKNOWN_OBJECT_LOSES = Integer.MIN_VALUE;
            UNKNOWN_OBJECT_WINS = Integer.MAX_VALUE;
            UNKNOWN_OBJECT_LOSES_L = Long.MIN_VALUE;
            UNKNOWN_OBJECT_WINS_L = Long.MAX_VALUE;
            HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>(4, 1.0f);
            hashMap.put("application/x-java-file-list", 0);
            hashMap.put("application/x-java-serialized-object", 1);
            hashMap.put("application/x-java-jvm-local-objectref", 2);
            hashMap.put("application/x-java-remote-object", 3);
            exactTypes = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(1, 1.0f);
            hashMap.put("application", 0);
            primaryTypes = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(3, 1.0f);
            hashMap.put(InputStream.class, 0);
            hashMap.put(Serializable.class, 1);
            Class<?> clazz = RMI.remoteClass();
            if (clazz != null) {
                hashMap.put(clazz, 2);
            }
            nonTextRepresentations = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(16, 1.0f);
            hashMap.put("text/plain", 0);
            hashMap.put("application/x-java-serialized-object", 1);
            hashMap.put("text/calendar", 2);
            hashMap.put("text/css", 3);
            hashMap.put("text/directory", 4);
            hashMap.put("text/parityfec", 5);
            hashMap.put("text/rfc822-headers", 6);
            hashMap.put("text/t140", 7);
            hashMap.put("text/tab-separated-values", 8);
            hashMap.put("text/uri-list", 9);
            hashMap.put("text/richtext", 10);
            hashMap.put("text/enriched", 11);
            hashMap.put("text/rtf", 12);
            hashMap.put("text/html", 13);
            hashMap.put("text/xml", 14);
            hashMap.put("text/sgml", 15);
            textTypes = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(4, 1.0f);
            hashMap.put(char[].class, 0);
            hashMap.put(CharBuffer.class, 1);
            hashMap.put(String.class, 2);
            hashMap.put(Reader.class, 3);
            decodedTextRepresentations = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(3, 1.0f);
            hashMap.put(byte[].class, 0);
            hashMap.put(ByteBuffer.class, 1);
            hashMap.put(InputStream.class, 2);
            encodedTextRepresentations = Collections.unmodifiableMap(hashMap);
        }
    }

    public static class CharsetComparator
    extends IndexedComparator {
        private static final Map charsets;
        private static String defaultEncoding;
        private static final Integer DEFAULT_CHARSET_INDEX;
        private static final Integer OTHER_CHARSET_INDEX;
        private static final Integer WORST_CHARSET_INDEX;
        private static final Integer UNSUPPORTED_CHARSET_INDEX;
        private static final String UNSUPPORTED_CHARSET = "UNSUPPORTED";

        public CharsetComparator() {
            this(true);
        }

        public CharsetComparator(boolean bl) {
            super(bl);
        }

        public int compare(Object object, Object object2) {
            String string = null;
            String string2 = null;
            if (this.order) {
                string = (String)object;
                string2 = (String)object2;
            } else {
                string = (String)object2;
                string2 = (String)object;
            }
            return this.compareCharsets(string, string2);
        }

        protected int compareCharsets(String string, String string2) {
            int n = CharsetComparator.compareIndices(charsets, string = CharsetComparator.getEncoding(string), string2 = CharsetComparator.getEncoding(string2), OTHER_CHARSET_INDEX);
            if (n == 0) {
                return string2.compareTo(string);
            }
            return n;
        }

        protected static String getEncoding(String string) {
            if (string == null) {
                return null;
            }
            if (!DataTransferer.isEncodingSupported(string)) {
                return UNSUPPORTED_CHARSET;
            }
            String string2 = DataTransferer.canonicalName(string);
            return charsets.containsKey(string2) ? string2 : string;
        }

        static {
            DEFAULT_CHARSET_INDEX = 2;
            OTHER_CHARSET_INDEX = 1;
            WORST_CHARSET_INDEX = 0;
            UNSUPPORTED_CHARSET_INDEX = Integer.MIN_VALUE;
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(8, 1.0f);
            hashMap.put(DataTransferer.canonicalName("UTF-16LE"), 4);
            hashMap.put(DataTransferer.canonicalName("UTF-16BE"), 5);
            hashMap.put(DataTransferer.canonicalName("UTF-8"), 6);
            hashMap.put(DataTransferer.canonicalName("UTF-16"), 7);
            hashMap.put(DataTransferer.canonicalName("US-ASCII"), WORST_CHARSET_INDEX);
            String string = DataTransferer.canonicalName(DataTransferer.getDefaultTextCharset());
            if (hashMap.get(defaultEncoding) == null) {
                hashMap.put(defaultEncoding, DEFAULT_CHARSET_INDEX);
            }
            hashMap.put(UNSUPPORTED_CHARSET, UNSUPPORTED_CHARSET_INDEX);
            charsets = Collections.unmodifiableMap(hashMap);
        }
    }

    public static abstract class IndexedComparator
    implements Comparator {
        public static final boolean SELECT_BEST = true;
        public static final boolean SELECT_WORST = false;
        protected final boolean order;

        public IndexedComparator() {
            this(true);
        }

        public IndexedComparator(boolean bl) {
            this.order = bl;
        }

        protected static int compareIndices(Map map, Object object, Object object2, Integer n) {
            Integer n2 = (Integer)map.get(object);
            Integer n3 = (Integer)map.get(object2);
            if (n2 == null) {
                n2 = n;
            }
            if (n3 == null) {
                n3 = n;
            }
            return n2.compareTo(n3);
        }

        protected static int compareLongs(Map map, Object object, Object object2, Long l) {
            Long l2 = (Long)map.get(object);
            Long l3 = (Long)map.get(object2);
            if (l2 == null) {
                l2 = l;
            }
            if (l3 == null) {
                l3 = l;
            }
            return l2.compareTo(l3);
        }
    }

    public class ReencodingInputStream
    extends InputStream {
        protected BufferedReader wrapped;
        protected final char[] in = new char[2];
        protected byte[] out;
        protected CharsetEncoder encoder;
        protected CharBuffer inBuf;
        protected ByteBuffer outBuf;
        protected char[] eoln;
        protected int numTerminators;
        protected boolean eos;
        protected int index;
        protected int limit;

        public ReencodingInputStream(InputStream inputStream, long l, String string, Transferable transferable) throws IOException {
            Integer n;
            Long l2 = l;
            String string2 = null;
            if (DataTransferer.this.isLocaleDependentTextFormat(l) && transferable != null && transferable.isDataFlavorSupported(javaTextEncodingFlavor)) {
                try {
                    string2 = new String((byte[])transferable.getTransferData(javaTextEncodingFlavor), "UTF-8");
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {}
            } else {
                string2 = DataTransferer.this.getCharsetForTextFormat(l2);
            }
            if (string2 == null) {
                string2 = DataTransferer.getDefaultTextCharset();
            }
            this.wrapped = new BufferedReader(new InputStreamReader(inputStream, string2));
            if (string == null) {
                throw new NullPointerException("null target encoding");
            }
            try {
                this.encoder = Charset.forName(string).newEncoder();
                this.out = new byte[(int)((double)(this.encoder.maxBytesPerChar() * 2.0f) + 0.5)];
                this.inBuf = CharBuffer.wrap(this.in);
                this.outBuf = ByteBuffer.wrap(this.out);
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                throw new IOException(illegalCharsetNameException.toString());
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new IOException(unsupportedCharsetException.toString());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                throw new IOException(unsupportedOperationException.toString());
            }
            String string3 = (String)nativeEOLNs.get(l2);
            if (string3 != null) {
                this.eoln = string3.toCharArray();
            }
            if ((n = (Integer)nativeTerminators.get(l2)) != null) {
                this.numTerminators = n;
            }
        }

        private int readChar() throws IOException {
            int n = this.wrapped.read();
            if (n == -1) {
                this.eos = true;
                return -1;
            }
            if (this.numTerminators > 0 && n == 0) {
                this.eos = true;
                return -1;
            }
            if (this.eoln != null && this.matchCharArray(this.eoln, n)) {
                n = 10;
            }
            return n;
        }

        @Override
        public int read() throws IOException {
            if (this.eos) {
                return -1;
            }
            if (this.index >= this.limit) {
                int n = this.readChar();
                if (n == -1) {
                    return -1;
                }
                this.in[0] = (char)n;
                this.in[1] = '\u0000';
                this.inBuf.limit(1);
                if (Character.isHighSurrogate((char)n) && (n = this.readChar()) != -1) {
                    this.in[1] = (char)n;
                    this.inBuf.limit(2);
                }
                this.inBuf.rewind();
                this.outBuf.limit(this.out.length).rewind();
                this.encoder.encode(this.inBuf, this.outBuf, false);
                this.outBuf.flip();
                this.limit = this.outBuf.limit();
                this.index = 0;
                return this.read();
            }
            return this.out[this.index++] & 0xFF;
        }

        @Override
        public int available() throws IOException {
            return this.eos ? 0 : this.limit - this.index;
        }

        @Override
        public void close() throws IOException {
            this.wrapped.close();
        }

        private boolean matchCharArray(char[] cArray, int n) throws IOException {
            this.wrapped.mark(cArray.length);
            int n2 = 0;
            if ((char)n == cArray[0]) {
                for (n2 = 1; n2 < cArray.length && (n = this.wrapped.read()) != -1 && (char)n == cArray[n2]; ++n2) {
                }
            }
            if (n2 == cArray.length) {
                return true;
            }
            this.wrapped.reset();
            return false;
        }
    }

    private static class StandardEncodingsHolder {
        private static final SortedSet<String> standardEncodings = StandardEncodingsHolder.load();

        private StandardEncodingsHolder() {
        }

        private static SortedSet<String> load() {
            CharsetComparator charsetComparator = new CharsetComparator(false);
            TreeSet<String> treeSet = new TreeSet<String>(charsetComparator);
            treeSet.add("US-ASCII");
            treeSet.add("ISO-8859-1");
            treeSet.add("UTF-8");
            treeSet.add("UTF-16BE");
            treeSet.add("UTF-16LE");
            treeSet.add("UTF-16");
            treeSet.add(DataTransferer.getDefaultTextCharset());
            return Collections.unmodifiableSortedSet(treeSet);
        }
    }
}

