/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.View;
import com.sun.javafx.scene.accessibility.Accessible;
import com.sun.javafx.scene.accessibility.Action;
import com.sun.javafx.scene.accessibility.Attribute;
import com.sun.javafx.scene.accessibility.Role;
import javafx.scene.Node;

public abstract class PlatformAccessible {
    private Accessible accessible;
    private View view;

    protected PlatformAccessible(Accessible accessible) {
        this.accessible = accessible;
    }

    public void setView(View view) {
        this.view = view;
    }

    public View getView() {
        return this.view;
    }

    public void dispose() {
        if (this.accessible != null) {
            this.accessible = null;
        }
        this.view = null;
    }

    protected boolean isDisposed() {
        return this.accessible == null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.accessible + ")";
    }

    protected boolean isIgnored() {
        Role role = (Role)((Object)this.getAttribute(Attribute.ROLE, new Object[0]));
        if (role == null) {
            return true;
        }
        return role == Role.NODE || role == Role.PARENT;
    }

    protected long getAccessible(Node node) {
        if (node == null) {
            return 0L;
        }
        Accessible accessible = null;
        if (accessible == null) {
            return 0L;
        }
        PlatformAccessible platformAccessible = accessible.impl_getDelegate();
        return platformAccessible != null ? platformAccessible.getNativeAccessible() : 0L;
    }

    protected Node getContainerNode(Node node, Role role) {
        while (node != null) {
            Accessible accessible = null;
            Role role2 = (Role)((Object)accessible.getAttribute(Attribute.ROLE, new Object[0]));
            if (role2 == role) {
                return node;
            }
            node = (Node)accessible.getAttribute(Attribute.PARENT, new Object[0]);
        }
        return null;
    }

    protected Node getContainerNode(Role role) {
        return this.getContainerNode((Node)this.getAttribute(Attribute.PARENT, new Object[0]), role);
    }

    protected Object getAttribute(Attribute attribute, Object ... objectArray) {
        Class<?> clazz;
        Object object = this.accessible.getAttribute(attribute, objectArray);
        if (object != null && (clazz = attribute.getReturnType()) != null) {
            try {
                clazz.cast(object);
            }
            catch (Exception exception) {
                String string = "The expected return type for the " + (Object)((Object)attribute) + " attribute is " + clazz.getSimpleName() + " but found " + object.getClass().getSimpleName();
                System.err.println(string);
                return null;
            }
        }
        return object;
    }

    protected void executeAction(Action action, Object ... objectArray) {
        this.accessible.executeAction(action, objectArray);
    }

    public abstract void sendNotification(Attribute var1);

    protected abstract long getNativeAccessible();
}

