/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.converters;

import com.sun.javafx.Logging;
import com.sun.javafx.Utils;
import com.sun.javafx.css.StyleConverterImpl;
import com.sun.javafx.css.converters.StringConverter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.scene.text.Font;
import sun.util.logging.PlatformLogger;

public final class URLConverter
extends StyleConverterImpl<ParsedValue[], String> {
    public static StyleConverter<ParsedValue[], String> getInstance() {
        return Holder.INSTANCE;
    }

    private URLConverter() {
    }

    @Override
    public String convert(ParsedValue<ParsedValue[], String> parsedValue, Font font) {
        String string;
        URL uRL;
        String string2;
        String string3 = null;
        ParsedValue[] parsedValueArray = parsedValue.getValue();
        String string4 = string2 = parsedValueArray.length > 0 ? StringConverter.getInstance().convert(parsedValueArray[0], font) : null;
        if (string2 != null && !string2.trim().isEmpty() && (uRL = this.resolve(string = parsedValueArray.length > 1 && parsedValueArray[1] != null ? (String)parsedValueArray[1].getValue() : null, string2 = string2.startsWith("url(") ? Utils.stripQuotes(string2.substring(4, string2.length() - 1)) : Utils.stripQuotes(string2))) != null) {
            string3 = uRL.toExternalForm();
        }
        return string3;
    }

    URL resolve(String string, String string2) {
        if (string2 == null || string2.trim().isEmpty()) {
            return null;
        }
        try {
            URI uRI = new URI(string2.trim());
            if (uRI.isAbsolute()) {
                return uRI.toURL();
            }
            if (string != null && !string.trim().isEmpty()) {
                URI uRI2 = new URI(string.trim());
                if (!uRI2.isOpaque()) {
                    URI uRI3 = uRI2.resolve(uRI);
                    return uRI3.toURL();
                }
                URL uRL = uRI2.toURL();
                String string3 = uRI.getPath();
                return new URL(uRL, uRI.getPath());
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String string4 = uRI.getPath();
            URL uRL = null;
            uRL = string4.startsWith("/") ? classLoader.getResource(string4.substring(1)) : classLoader.getResource(string4);
            return uRL;
        }
        catch (MalformedURLException | URISyntaxException exception) {
            PlatformLogger platformLogger = Logging.getCSSLogger();
            if (platformLogger.isLoggable(PlatformLogger.Level.WARNING)) {
                platformLogger.warning(exception.getLocalizedMessage());
            }
            return null;
        }
    }

    public String toString() {
        return "URLType";
    }

    public static final class SequenceConverter
    extends StyleConverterImpl<ParsedValue<ParsedValue[], String>[], String[]> {
        public static SequenceConverter getInstance() {
            return Holder.SEQUENCE_INSTANCE;
        }

        private SequenceConverter() {
        }

        @Override
        public String[] convert(ParsedValue<ParsedValue<ParsedValue[], String>[], String[]> parsedValue, Font font) {
            ParsedValue<ParsedValue[], String>[] parsedValueArray = parsedValue.getValue();
            String[] stringArray = new String[parsedValueArray.length];
            for (int i = 0; i < parsedValueArray.length; ++i) {
                stringArray[i] = URLConverter.getInstance().convert(parsedValueArray[i], font);
            }
            return stringArray;
        }

        public String toString() {
            return "URLSeqType";
        }
    }

    private static class Holder {
        static final URLConverter INSTANCE = new URLConverter();
        static final SequenceConverter SEQUENCE_INSTANCE = new SequenceConverter();

        private Holder() {
        }
    }
}

