/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.skin.ComboBoxBaseSkin;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.control.Skinnable;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.stage.WindowEvent;

public abstract class ComboBoxPopupControl<T>
extends ComboBoxBaseSkin<T> {
    protected PopupControl popup;
    public static final String COMBO_BOX_STYLE_CLASS = "combo-box-popup";
    private boolean popupNeedsReconfiguring = true;

    public ComboBoxPopupControl(ComboBoxBase<T> comboBoxBase, ComboBoxBaseBehavior<T> comboBoxBaseBehavior) {
        super(comboBoxBase, comboBoxBaseBehavior);
    }

    protected abstract Node getPopupContent();

    protected PopupControl getPopup() {
        if (this.popup == null) {
            this.createPopup();
        }
        return this.popup;
    }

    @Override
    public void show() {
        if (this.getSkinnable() == null) {
            throw new IllegalStateException("ComboBox is null");
        }
        Node node = this.getPopupContent();
        if (node == null) {
            throw new IllegalStateException("Popup node is null");
        }
        if (this.getPopup().isShowing()) {
            return;
        }
        this.positionAndShowPopup();
    }

    @Override
    public void hide() {
        if (this.popup != null && this.popup.isShowing()) {
            this.popup.hide();
        }
    }

    private Point2D getPrefPopupPosition() {
        double d = 0.0;
        return Utils.pointRelativeTo((Node)((Object)this.getSkinnable()), this.getPopupContent(), HPos.CENTER, VPos.BOTTOM, d += ((ComboBoxBase)this.getSkinnable()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT ? -3.0 : 0.0, 0.0, false);
    }

    private void positionAndShowPopup() {
        PopupControl popupControl = this.getPopup();
        popupControl.getScene().setNodeOrientation(((ComboBoxBase)this.getSkinnable()).getEffectiveNodeOrientation());
        Node node = this.getPopupContent();
        node.applyCss();
        node.autosize();
        Point2D point2D = this.getPrefPopupPosition();
        this.popupNeedsReconfiguring = true;
        this.reconfigurePopup();
        ComboBoxBase comboBoxBase = (ComboBoxBase)this.getSkinnable();
        popupControl.show(comboBoxBase.getScene().getWindow(), point2D.getX(), point2D.getY());
        node.requestFocus();
    }

    private void createPopup() {
        this.popup = new PopupControl(){
            {
                this.setSkin(new Skin<Skinnable>(){

                    @Override
                    public Skinnable getSkinnable() {
                        return ComboBoxPopupControl.this.getSkinnable();
                    }

                    @Override
                    public Node getNode() {
                        return ComboBoxPopupControl.this.getPopupContent();
                    }

                    @Override
                    public void dispose() {
                    }
                });
            }

            @Override
            public Styleable getStyleableParent() {
                return ComboBoxPopupControl.this.getSkinnable();
            }
        };
        this.popup.getStyleClass().add(COMBO_BOX_STYLE_CLASS);
        this.popup.setConsumeAutoHidingEvents(false);
        this.popup.setAutoHide(true);
        this.popup.setAutoFix(true);
        this.popup.setHideOnEscape(true);
        this.popup.setOnAutoHide(event -> ((ComboBoxBaseBehavior)this.getBehavior()).onAutoHide());
        this.popup.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> ((ComboBoxBaseBehavior)this.getBehavior()).onAutoHide());
        this.popup.addEventHandler(WindowEvent.WINDOW_HIDDEN, windowEvent -> {});
        InvalidationListener invalidationListener = observable -> {
            this.popupNeedsReconfiguring = true;
            this.reconfigurePopup();
        };
        ((ComboBoxBase)this.getSkinnable()).layoutXProperty().addListener(invalidationListener);
        ((ComboBoxBase)this.getSkinnable()).layoutYProperty().addListener(invalidationListener);
        ((ComboBoxBase)this.getSkinnable()).widthProperty().addListener(invalidationListener);
        ((ComboBoxBase)this.getSkinnable()).heightProperty().addListener(invalidationListener);
        ((ComboBoxBase)this.getSkinnable()).sceneProperty().addListener(observable -> {
            if (((ObservableValue)observable).getValue() == null) {
                this.hide();
            }
        });
    }

    void reconfigurePopup() {
        double d;
        if (this.popup == null) {
            return;
        }
        boolean bl = this.popup.isShowing();
        if (!bl) {
            return;
        }
        if (!this.popupNeedsReconfiguring) {
            return;
        }
        this.popupNeedsReconfiguring = false;
        Point2D point2D = this.getPrefPopupPosition();
        Node node = this.getPopupContent();
        double d2 = node.prefWidth(1.0);
        double d3 = node.prefHeight(1.0);
        if (point2D.getX() > -1.0) {
            this.popup.setAnchorX(point2D.getX());
        }
        if (point2D.getY() > -1.0) {
            this.popup.setAnchorY(point2D.getY());
        }
        if (d2 > -1.0) {
            this.popup.setMinWidth(d2);
        }
        if (d3 > -1.0) {
            this.popup.setMinHeight(d3);
        }
        Bounds bounds = node.getLayoutBounds();
        double d4 = bounds.getWidth();
        double d5 = bounds.getHeight();
        double d6 = d4 < d2 ? d2 : d4;
        double d7 = d = d5 < d3 ? d3 : d5;
        if (d6 != d4 || d != d5) {
            node.resize(d6, d);
            if (node instanceof Region) {
                ((Region)node).setMinSize(d6, d);
                ((Region)node).setPrefSize(d6, d);
            }
        }
    }
}

