/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.prism.impl.ManagedResource;
import com.sun.prism.impl.ResourcePool;

public abstract class BaseResourcePool<T>
implements ResourcePool<T> {
    long managedSize;
    final long maxSize;
    final ResourcePool sharedParent;
    private final Thread managerThread;

    protected BaseResourcePool() {
        this(null, Long.MAX_VALUE);
    }

    protected BaseResourcePool(long l) {
        this(null, l);
    }

    protected BaseResourcePool(ResourcePool resourcePool) {
        this(resourcePool, resourcePool.max());
    }

    protected BaseResourcePool(ResourcePool resourcePool, long l) {
        this.sharedParent = resourcePool;
        this.maxSize = resourcePool == null ? l : Math.min(resourcePool.max(), l);
        this.managerThread = Thread.currentThread();
    }

    @Override
    public boolean isManagerThread() {
        return Thread.currentThread() == this.managerThread;
    }

    @Override
    public final long managed() {
        return this.managedSize;
    }

    @Override
    public long used() {
        if (this.sharedParent != null) {
            return this.sharedParent.used();
        }
        return this.managedSize;
    }

    @Override
    public final long max() {
        return this.maxSize;
    }

    @Override
    public boolean prepareForAllocation(long l) {
        return ManagedResource.cleanup((ResourcePool)this, l);
    }

    @Override
    public final void recordAllocated(long l) {
        this.managedSize += l;
    }

    @Override
    public final void resourceManaged(T t) {
        this.recordAllocated(this.size(t));
    }

    @Override
    public final void resourceFreed(T t) {
        this.recordFree(this.size(t));
    }

    @Override
    public final void recordFree(long l) {
        this.managedSize -= l;
        if (this.managedSize < 0L) {
            throw new IllegalStateException("Negative resource amount");
        }
    }
}

