/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.TempState;
import com.sun.javafx.Utils;
import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.collections.VetoableListDecorator;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.jmx.MXNodeAlgorithm;
import com.sun.javafx.jmx.MXNodeAlgorithmContext;
import com.sun.javafx.scene.CssFlags;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.LayoutFlags;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.sg.prism.NGGroup;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.PropertyHelper;
import javafx.scene.Scene;
import javafx.scene.SubScene;

public abstract class Parent
extends Node {
    static final int DIRTY_CHILDREN_THRESHOLD = 10;
    private static final boolean warnOnAutoMove = PropertyHelper.getBooleanProperty("javafx.sg.warn");
    private static final int REMOVED_CHILDREN_THRESHOLD = 20;
    private boolean removedChildrenOptimizationDisabled = false;
    private final Set<Node> childSet = new HashSet<Node>();
    private int startIdx = 0;
    private int pgChildrenSize = 0;
    private boolean childrenTriggerPermutation = false;
    private List<Node> removed;
    private boolean geomChanged;
    private boolean childSetModified;
    private final ObservableList<Node> children = new VetoableListDecorator<Node>((ObservableList)new TrackableObservableList<Node>(){

        @Override
        protected void onChanged(ListChangeListener.Change<Node> change) {
            boolean bl;
            block17: {
                Parent.this.unmodifiableManagedChildren = null;
                bl = false;
                if (Parent.this.childSetModified) {
                    Object object;
                    int n;
                    int n2;
                    while (change.next()) {
                        Node node;
                        int n3;
                        n2 = change.getFrom();
                        n = change.getTo();
                        for (int i = n2; i < n; ++i) {
                            Node node2 = (Node)Parent.this.children.get(i);
                            if (node2.getParent() == null || node2.getParent() == Parent.this) continue;
                            if (warnOnAutoMove) {
                                System.err.println("WARNING added to a new parent without first removing it from its current");
                                System.err.println("    parent. It will be automatically removed from its current parent.");
                                System.err.println("    node=" + node2 + " oldparent= " + node2.getParent() + " newparent=" + this);
                            }
                            node2.getParent().children.remove(node2);
                            if (!warnOnAutoMove) continue;
                            Thread.dumpStack();
                        }
                        object = change.getRemoved();
                        int n4 = object.size();
                        for (n3 = 0; n3 < n4; ++n3) {
                            node = object.get(n3);
                            if (!node.isManaged()) continue;
                            bl = true;
                        }
                        for (n3 = n2; n3 < n; ++n3) {
                            node = (Node)Parent.this.children.get(n3);
                            if (node.isManaged()) {
                                bl = true;
                            }
                            node.setParent(Parent.this);
                            node.setScenes(Parent.this.getScene(), Parent.this.getSubScene());
                            if (!node.isVisible()) continue;
                            Parent.this.geomChanged = true;
                            Parent.this.childIncluded(node);
                        }
                    }
                    if (Parent.this.dirtyChildren == null && Parent.this.children.size() > 10) {
                        Parent.this.dirtyChildren = new ArrayList(20);
                        if (Parent.this.dirtyChildrenCount > 0) {
                            n2 = Parent.this.children.size();
                            for (n = 0; n < n2; ++n) {
                                object = (Node)Parent.this.children.get(n);
                                if (!((Node)object).isVisible() || !((Node)object).boundsChanged) continue;
                                Parent.this.dirtyChildren.add(object);
                            }
                        }
                    }
                } else {
                    while (change.next()) {
                        int n;
                        List<Node> list = change.getRemoved();
                        int n5 = list.size();
                        for (n = 0; n < n5; ++n) {
                            if (!list.get(n).isManaged()) continue;
                            bl = true;
                            break block17;
                        }
                        n5 = change.getTo();
                        for (n = change.getFrom(); n < n5; ++n) {
                            if (!((Node)Parent.this.children.get(n)).isManaged()) continue;
                            bl = true;
                            break block17;
                        }
                    }
                }
            }
            if (bl) {
                Parent.this.requestLayout();
            }
            if (Parent.this.geomChanged) {
                Parent.this.impl_geomChanged();
            }
            change.reset();
            change.next();
            if (Parent.this.startIdx > change.getFrom()) {
                Parent.this.startIdx = change.getFrom();
            }
            Parent.this.impl_markDirty(DirtyBits.PARENT_CHILDREN);
        }
    }){

        @Override
        protected void onProposedChange(List<Node> list, int[] nArray) {
            Node node;
            int n;
            if (Parent.this.getScene() != null) {
                Toolkit.getToolkit().checkFxUserThread();
            }
            Parent.this.geomChanged = false;
            long l = Parent.this.children.size() + list.size();
            int n2 = 0;
            for (n = 0; n < nArray.length; n += 2) {
                n2 += nArray[n + 1] - nArray[n];
            }
            l -= (long)n2;
            if (Parent.this.childrenTriggerPermutation) {
                Parent.this.childSetModified = false;
                return;
            }
            Parent.this.childSetModified = true;
            if (l == (long)Parent.this.childSet.size()) {
                Parent.this.childSetModified = false;
                for (n = list.size() - 1; n >= 0; --n) {
                    node = list.get(n);
                    if (Parent.this.childSet.contains(node)) continue;
                    Parent.this.childSetModified = true;
                    break;
                }
            }
            for (n = 0; n < nArray.length; n += 2) {
                for (int i = nArray[n]; i < nArray[n + 1]; ++i) {
                    Parent.this.childSet.remove(Parent.this.children.get(i));
                }
            }
            try {
                if (Parent.this.childSetModified) {
                    for (n = list.size() - 1; n >= 0; --n) {
                        node = list.get(n);
                        if (node == null) {
                            throw new NullPointerException(this.constructExceptionMessage("child node is null", null));
                        }
                        if (node.getClipParent() != null) {
                            throw new IllegalArgumentException(this.constructExceptionMessage("node already used as a clip", node));
                        }
                        if (!Parent.this.wouldCreateCycle(Parent.this, node)) continue;
                        throw new IllegalArgumentException(this.constructExceptionMessage("cycle detected", node));
                    }
                }
                Parent.this.childSet.addAll(list);
                if ((long)Parent.this.childSet.size() != l) {
                    throw new IllegalArgumentException(this.constructExceptionMessage("duplicate children added", null));
                }
            }
            catch (RuntimeException runtimeException) {
                Parent.this.childSet.clear();
                Parent.this.childSet.addAll(Parent.this.children);
                throw runtimeException;
            }
            if (!Parent.this.childSetModified) {
                return;
            }
            if (Parent.this.removed == null) {
                Parent.this.removed = new ArrayList();
            }
            if (Parent.this.removed.size() + n2 > 20 || !Parent.this.impl_isTreeVisible()) {
                Parent.this.removedChildrenOptimizationDisabled = true;
            }
            for (n = 0; n < nArray.length; n += 2) {
                for (int i = nArray[n]; i < nArray[n + 1]; ++i) {
                    Node node2 = (Node)Parent.this.children.get(i);
                    Scene scene = node2.getScene();
                    if (scene != null) {
                        scene.generateMouseExited(node2);
                    }
                    if (Parent.this.dirtyChildren != null) {
                        Parent.this.dirtyChildren.remove(node2);
                    }
                    if (node2.isVisible()) {
                        Parent.this.geomChanged = true;
                        Parent.this.childExcluded(node2);
                    }
                    if (node2.getParent() == Parent.this) {
                        node2.setParent(null);
                        node2.setScenes(null, null);
                    }
                    if (Parent.this.removedChildrenOptimizationDisabled) continue;
                    Parent.this.removed.add(node2);
                }
            }
        }

        private String constructExceptionMessage(String string, Node node) {
            StringBuilder stringBuilder = new StringBuilder("Children: ");
            stringBuilder.append(string);
            stringBuilder.append(": parent = ").append(Parent.this);
            if (node != null) {
                stringBuilder.append(", node = ").append(node);
            }
            return stringBuilder.toString();
        }
    };
    private final ObservableList<Node> unmodifiableChildren = FXCollections.unmodifiableObservableList(this.children);
    private List<Node> unmodifiableManagedChildren = null;
    private ObjectProperty<ParentTraversalEngine> impl_traversalEngine;
    private ReadOnlyBooleanWrapper needsLayout;
    LayoutFlags layoutFlag = LayoutFlags.CLEAN;
    boolean performingLayout = false;
    private boolean sizeCacheClear = true;
    private double prefWidthCache = -1.0;
    private double prefHeightCache = -1.0;
    private double minWidthCache = -1.0;
    private double minHeightCache = -1.0;
    private boolean sceneRoot = false;
    boolean layoutRoot = false;
    private final ObservableList<String> stylesheets = new TrackableObservableList<String>(){

        @Override
        protected void onChanged(ListChangeListener.Change<String> change) {
            Scene scene = Parent.this.getScene();
            if (scene != null) {
                StyleManager.getInstance().stylesheetsChanged(Parent.this, change);
                change.reset();
                while (change.next() && !change.wasRemoved()) {
                }
                Parent.this.impl_reapplyCSS();
            }
        }
    };
    private BaseBounds tmp = new RectBounds();
    private BaseBounds cachedBounds = new RectBounds();
    private boolean cachedBoundsInvalid;
    private int dirtyChildrenCount;
    private ArrayList<Node> dirtyChildren;
    private Node top;
    private Node left;
    private Node bottom;
    private Node right;
    private Node near;
    private Node far;
    private final int LEFT_INVALID = 1;
    private final int TOP_INVALID = 2;
    private final int NEAR_INVALID = 4;
    private final int RIGHT_INVALID = 8;
    private final int BOTTOM_INVALID = 16;
    private final int FAR_INVALID = 32;

    @Override
    @Deprecated
    public void impl_updatePeer() {
        List<NGNode> list;
        super.impl_updatePeer();
        NGGroup nGGroup = (NGGroup)this.impl_getPeer();
        if (Utils.assertionEnabled() && (list = nGGroup.getChildren()).size() != this.pgChildrenSize) {
            System.err.println("*** pgnodes.size() [" + list.size() + "] != pgChildrenSize [" + this.pgChildrenSize + "]");
        }
        if (this.impl_isDirty(DirtyBits.PARENT_CHILDREN)) {
            int n;
            nGGroup.clearFrom(this.startIdx);
            for (n = this.startIdx; n < this.children.size(); ++n) {
                nGGroup.add(n, (NGNode)((Node)this.children.get(n)).impl_getPeer());
            }
            if (this.removedChildrenOptimizationDisabled) {
                nGGroup.markDirty();
                this.removedChildrenOptimizationDisabled = false;
            } else if (this.removed != null && !this.removed.isEmpty()) {
                for (n = 0; n < this.removed.size(); ++n) {
                    nGGroup.addToRemoved((NGNode)this.removed.get(n).impl_getPeer());
                }
            }
            if (this.removed != null) {
                this.removed.clear();
            }
            this.startIdx = this.pgChildrenSize = this.children.size();
        }
        if (Utils.assertionEnabled()) {
            this.validatePG();
        }
    }

    void validatePG() {
        boolean bl = false;
        NGGroup nGGroup = (NGGroup)this.impl_getPeer();
        List<NGNode> list = nGGroup.getChildren();
        if (list.size() != this.children.size()) {
            System.err.println("*** pgnodes.size validatePG() [" + list.size() + "] != children.size() [" + this.children.size() + "]");
            bl = true;
        } else {
            for (int i = 0; i < this.children.size(); ++i) {
                Node node = (Node)this.children.get(i);
                if (node.getParent() != this) {
                    System.err.println("*** this=" + this + " validatePG children[" + i + "].parent= " + node.getParent());
                    bl = true;
                }
                if (node.impl_getPeer() == list.get(i)) continue;
                System.err.println("*** pgnodes[" + i + "] validatePG != children[" + i + "]");
                bl = true;
            }
        }
        if (bl) {
            throw new AssertionError((Object)"validation of PGGroup children failed");
        }
    }

    void printSeq(String string, List<Node> list) {
        String string2 = string;
        for (Node node : list) {
            string2 = string2 + node + " ";
        }
        System.out.println(string2);
    }

    protected ObservableList<Node> getChildren() {
        return this.children;
    }

    public ObservableList<Node> getChildrenUnmodifiable() {
        return this.unmodifiableChildren;
    }

    protected <E extends Node> List<E> getManagedChildren() {
        if (this.unmodifiableManagedChildren == null) {
            this.unmodifiableManagedChildren = new ArrayList<Node>();
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                Node node = (Node)this.children.get(i);
                if (!node.isManaged()) continue;
                this.unmodifiableManagedChildren.add(node);
            }
        }
        return this.unmodifiableManagedChildren;
    }

    final void managedChildChanged() {
        this.requestLayout();
        this.unmodifiableManagedChildren = null;
    }

    final void impl_toFront(Node node) {
        if (Utils.assertionEnabled() && !this.childSet.contains(node)) {
            throw new AssertionError((Object)"specified node is not in the list of children");
        }
        if (this.children.get(this.children.size() - 1) != node) {
            this.childrenTriggerPermutation = true;
            try {
                this.children.remove(node);
                this.children.add(node);
            }
            finally {
                this.childrenTriggerPermutation = false;
            }
        }
    }

    final void impl_toBack(Node node) {
        if (Utils.assertionEnabled() && !this.childSet.contains(node)) {
            throw new AssertionError((Object)"specified node is not in the list of children");
        }
        if (this.children.get(0) != node) {
            this.childrenTriggerPermutation = true;
            try {
                this.children.remove(node);
                this.children.add(0, node);
            }
            finally {
                this.childrenTriggerPermutation = false;
            }
        }
    }

    @Override
    void scenesChanged(Scene scene, SubScene subScene, Scene scene2, SubScene subScene2) {
        int n;
        if (scene2 != null && scene == null) {
            StyleManager.getInstance().forget(this);
        }
        for (n = 0; n < this.children.size(); ++n) {
            ((Node)this.children.get(n)).setScenes(scene, subScene);
        }
        n = this.layoutFlag != LayoutFlags.CLEAN ? 1 : 0;
        this.sceneRoot = subScene != null && subScene.getRoot() == this || scene != null && scene.getRoot() == this;
        boolean bl = this.layoutRoot = !this.isManaged() || this.sceneRoot;
        if (n != 0 && scene != null && this.layoutRoot && subScene != null) {
            subScene.setDirtyLayout(this);
        }
    }

    @Override
    void setDerivedDepthTest(boolean bl) {
        super.setDerivedDepthTest(bl);
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)this.children.get(i);
            node.computeDerivedDepthTest();
        }
    }

    @Override
    @Deprecated
    protected void impl_pickNodeLocal(PickRay pickRay, PickResultChooser pickResultChooser) {
        double d = this.impl_intersectsBounds(pickRay);
        if (!Double.isNaN(d)) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                ((Node)this.children.get(i)).impl_pickNode(pickRay, pickResultChooser);
                if (!pickResultChooser.isClosed()) continue;
                return;
            }
            if (this.isPickOnBounds()) {
                pickResultChooser.offer(this, d, PickResultChooser.computePoint(pickRay, d));
            }
        }
    }

    @Override
    boolean isConnected() {
        return super.isConnected() || this.sceneRoot;
    }

    @Override
    public Node lookup(String string) {
        Node node = super.lookup(string);
        if (node == null) {
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                Node node2 = (Node)this.children.get(i);
                node = node2.lookup(string);
                if (node == null) continue;
                return node;
            }
        }
        return node;
    }

    @Override
    List<Node> lookupAll(Selector selector, List<Node> list) {
        list = super.lookupAll(selector, list);
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)this.children.get(i);
            list = node.lookupAll(selector, list);
        }
        return list;
    }

    @Deprecated
    public final void setImpl_traversalEngine(ParentTraversalEngine parentTraversalEngine) {
        this.impl_traversalEngineProperty().set(parentTraversalEngine);
    }

    @Deprecated
    public final ParentTraversalEngine getImpl_traversalEngine() {
        return this.impl_traversalEngine == null ? null : (ParentTraversalEngine)this.impl_traversalEngine.get();
    }

    @Deprecated
    public final ObjectProperty<ParentTraversalEngine> impl_traversalEngineProperty() {
        if (this.impl_traversalEngine == null) {
            this.impl_traversalEngine = new SimpleObjectProperty<ParentTraversalEngine>(this, "impl_traversalEngine");
        }
        return this.impl_traversalEngine;
    }

    protected final void setNeedsLayout(boolean bl) {
        if (bl) {
            this.markDirtyLayout(true);
        } else if (this.layoutFlag == LayoutFlags.NEEDS_LAYOUT) {
            boolean bl2 = false;
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                Node node = (Node)this.children.get(i);
                if (!(node instanceof Parent) || ((Parent)node).layoutFlag == LayoutFlags.CLEAN) continue;
                bl2 = true;
                break;
            }
            this.setLayoutFlag(bl2 ? LayoutFlags.DIRTY_BRANCH : LayoutFlags.CLEAN);
        }
    }

    public final boolean isNeedsLayout() {
        return this.layoutFlag == LayoutFlags.NEEDS_LAYOUT;
    }

    public final ReadOnlyBooleanProperty needsLayoutProperty() {
        if (this.needsLayout == null) {
            this.needsLayout = new ReadOnlyBooleanWrapper(this, "needsLayout", this.layoutFlag == LayoutFlags.NEEDS_LAYOUT);
        }
        return this.needsLayout;
    }

    void setLayoutFlag(LayoutFlags layoutFlags) {
        if (this.needsLayout != null) {
            this.needsLayout.set(layoutFlags == LayoutFlags.NEEDS_LAYOUT);
        }
        this.layoutFlag = layoutFlags;
    }

    private void markDirtyLayout(boolean bl) {
        this.setLayoutFlag(LayoutFlags.NEEDS_LAYOUT);
        if (bl || this.layoutRoot) {
            if (this.sceneRoot) {
                Toolkit.getToolkit().requestNextPulse();
                if (this.getSubScene() != null) {
                    this.getSubScene().setDirtyLayout(this);
                }
            } else {
                this.markDirtyLayoutBranch();
            }
        } else {
            this.requestParentLayout();
        }
    }

    public void requestLayout() {
        this.clearSizeCache();
        this.markDirtyLayout(false);
    }

    protected final void requestParentLayout() {
        Parent parent;
        if (!this.layoutRoot && (parent = this.getParent()) != null && !parent.performingLayout) {
            parent.requestLayout();
        }
    }

    void clearSizeCache() {
        if (this.sizeCacheClear) {
            return;
        }
        this.sizeCacheClear = true;
        this.prefWidthCache = -1.0;
        this.prefHeightCache = -1.0;
        this.minWidthCache = -1.0;
        this.minHeightCache = -1.0;
    }

    @Override
    public double prefWidth(double d) {
        if (d == -1.0) {
            if (this.prefWidthCache == -1.0) {
                this.prefWidthCache = this.computePrefWidth(-1.0);
                if (Double.isNaN(this.prefWidthCache) || this.prefWidthCache < 0.0) {
                    this.prefWidthCache = 0.0;
                }
                this.sizeCacheClear = false;
            }
            return this.prefWidthCache;
        }
        double d2 = this.computePrefWidth(d);
        return Double.isNaN(d2) || d2 < 0.0 ? 0.0 : d2;
    }

    @Override
    public double prefHeight(double d) {
        if (d == -1.0) {
            if (this.prefHeightCache == -1.0) {
                this.prefHeightCache = this.computePrefHeight(-1.0);
                if (Double.isNaN(this.prefHeightCache) || this.prefHeightCache < 0.0) {
                    this.prefHeightCache = 0.0;
                }
                this.sizeCacheClear = false;
            }
            return this.prefHeightCache;
        }
        double d2 = this.computePrefHeight(d);
        return Double.isNaN(d2) || d2 < 0.0 ? 0.0 : d2;
    }

    @Override
    public double minWidth(double d) {
        if (d == -1.0) {
            if (this.minWidthCache == -1.0) {
                this.minWidthCache = this.computeMinWidth(-1.0);
                if (Double.isNaN(this.minWidthCache) || this.minWidthCache < 0.0) {
                    this.minWidthCache = 0.0;
                }
                this.sizeCacheClear = false;
            }
            return this.minWidthCache;
        }
        double d2 = this.computeMinWidth(d);
        return Double.isNaN(d2) || d2 < 0.0 ? 0.0 : d2;
    }

    @Override
    public double minHeight(double d) {
        if (d == -1.0) {
            if (this.minHeightCache == -1.0) {
                this.minHeightCache = this.computeMinHeight(-1.0);
                if (Double.isNaN(this.minHeightCache) || this.minHeightCache < 0.0) {
                    this.minHeightCache = 0.0;
                }
                this.sizeCacheClear = false;
            }
            return this.minHeightCache;
        }
        double d2 = this.computeMinHeight(d);
        return Double.isNaN(d2) || d2 < 0.0 ? 0.0 : d2;
    }

    protected double computePrefWidth(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)this.children.get(i);
            if (!node.isManaged()) continue;
            double d4 = node.getLayoutBounds().getMinX() + node.getLayoutX();
            d2 = Math.min(d2, d4);
            d3 = Math.max(d3, d4 + this.boundedSize(node.prefWidth(-1.0), node.minWidth(-1.0), node.maxWidth(-1.0)));
        }
        return d3 - d2;
    }

    protected double computePrefHeight(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)this.children.get(i);
            if (!node.isManaged()) continue;
            double d4 = node.getLayoutBounds().getMinY() + node.getLayoutY();
            d2 = Math.min(d2, d4);
            d3 = Math.max(d3, d4 + this.boundedSize(node.prefHeight(-1.0), node.minHeight(-1.0), node.maxHeight(-1.0)));
        }
        return d3 - d2;
    }

    protected double computeMinWidth(double d) {
        return this.prefWidth(d);
    }

    protected double computeMinHeight(double d) {
        return this.prefHeight(d);
    }

    @Override
    public double getBaselineOffset() {
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            double d;
            Node node = (Node)this.children.get(i);
            if (!node.isManaged() || (d = node.getBaselineOffset()) == Double.NEGATIVE_INFINITY) continue;
            return node.getLayoutBounds().getMinY() + node.getLayoutY() + d;
        }
        return super.getBaselineOffset();
    }

    public final void layout() {
        switch (this.layoutFlag) {
            case CLEAN: {
                break;
            }
            case NEEDS_LAYOUT: {
                if (this.performingLayout) break;
                this.performingLayout = true;
                this.layoutChildren();
            }
            case DIRTY_BRANCH: {
                int n = this.children.size();
                for (int i = 0; i < n; ++i) {
                    Node node = (Node)this.children.get(i);
                    if (node instanceof Parent) {
                        ((Parent)node).layout();
                        continue;
                    }
                    if (!(node instanceof SubScene)) continue;
                    ((SubScene)node).layoutPass();
                }
                this.setLayoutFlag(LayoutFlags.CLEAN);
                this.performingLayout = false;
            }
        }
    }

    protected void layoutChildren() {
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)this.children.get(i);
            if (!node.isResizable() || !node.isManaged()) continue;
            node.autosize();
        }
    }

    @Override
    final void notifyManagedChanged() {
        this.layoutRoot = !this.isManaged() || this.sceneRoot;
    }

    final boolean isSceneRoot() {
        return this.sceneRoot;
    }

    public final ObservableList<String> getStylesheets() {
        return this.stylesheets;
    }

    @Deprecated
    public List<String> impl_getAllParentStylesheets() {
        List<String> list = null;
        Parent parent = this.getParent();
        if (parent != null) {
            list = parent.impl_getAllParentStylesheets();
        }
        if (this.stylesheets != null && !this.stylesheets.isEmpty()) {
            if (list == null) {
                list = new ArrayList<String>(this.stylesheets.size());
            }
            int n = this.stylesheets.size();
            for (int i = 0; i < n; ++i) {
                list.add((String)this.stylesheets.get(i));
            }
        }
        return list;
    }

    @Override
    @Deprecated
    protected void impl_processCSS(WritableValue<Boolean> writableValue) {
        if (this.cssFlag == CssFlags.CLEAN) {
            return;
        }
        if (this.cssFlag == CssFlags.DIRTY_BRANCH) {
            super.processCSS();
            return;
        }
        super.impl_processCSS(writableValue);
        if (this.children.isEmpty()) {
            return;
        }
        Node[] nodeArray = this.children.toArray(new Node[this.children.size()]);
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            Parent parent = node.getParent();
            if (parent == null || parent != this) continue;
            if (CssFlags.UPDATE.compareTo(node.cssFlag) > 0) {
                node.cssFlag = CssFlags.UPDATE;
            }
            node.impl_processCSS(writableValue);
        }
    }

    protected Parent() {
        this.layoutFlag = LayoutFlags.NEEDS_LAYOUT;
    }

    @Override
    @Deprecated
    protected NGNode impl_createPeer() {
        return new NGGroup();
    }

    @Override
    void nodeResolvedOrientationChanged() {
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            ((Node)this.children.get(i)).parentResolvedOrientationInvalidated();
        }
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        if (this.children.isEmpty()) {
            return baseBounds.makeEmpty();
        }
        if (baseTransform.isTranslateOrIdentity()) {
            if (this.cachedBoundsInvalid) {
                this.recomputeBounds();
                if (this.dirtyChildren != null) {
                    this.dirtyChildren.clear();
                }
                this.cachedBoundsInvalid = false;
                this.dirtyChildrenCount = 0;
            }
            baseBounds = !baseTransform.isIdentity() ? baseBounds.deriveWithNewBounds((float)((double)this.cachedBounds.getMinX() + baseTransform.getMxt()), (float)((double)this.cachedBounds.getMinY() + baseTransform.getMyt()), (float)((double)this.cachedBounds.getMinZ() + baseTransform.getMzt()), (float)((double)this.cachedBounds.getMaxX() + baseTransform.getMxt()), (float)((double)this.cachedBounds.getMaxY() + baseTransform.getMyt()), (float)((double)this.cachedBounds.getMaxZ() + baseTransform.getMzt())) : baseBounds.deriveWithNewBounds(this.cachedBounds);
            return baseBounds;
        }
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MIN_VALUE;
        double d5 = Double.MIN_VALUE;
        double d6 = Double.MIN_VALUE;
        boolean bl = true;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)this.children.get(i);
            if (!node.isVisible() || (baseBounds = node.getTransformedBounds(baseBounds, baseTransform)).isEmpty()) continue;
            if (bl) {
                d = baseBounds.getMinX();
                d2 = baseBounds.getMinY();
                d3 = baseBounds.getMinZ();
                d4 = baseBounds.getMaxX();
                d5 = baseBounds.getMaxY();
                d6 = baseBounds.getMaxZ();
                bl = false;
                continue;
            }
            d = Math.min((double)baseBounds.getMinX(), d);
            d2 = Math.min((double)baseBounds.getMinY(), d2);
            d3 = Math.min((double)baseBounds.getMinZ(), d3);
            d4 = Math.max((double)baseBounds.getMaxX(), d4);
            d5 = Math.max((double)baseBounds.getMaxY(), d5);
            d6 = Math.max((double)baseBounds.getMaxZ(), d6);
        }
        if (bl) {
            baseBounds.makeEmpty();
        } else {
            baseBounds = baseBounds.deriveWithNewBounds((float)d, (float)d2, (float)d3, (float)d4, (float)d5, (float)d6);
        }
        return baseBounds;
    }

    private void setChildDirty(Node node, boolean bl) {
        if (node.boundsChanged == bl) {
            return;
        }
        node.boundsChanged = bl;
        if (bl) {
            if (this.dirtyChildren != null) {
                this.dirtyChildren.add(node);
            }
            ++this.dirtyChildrenCount;
        } else {
            if (this.dirtyChildren != null) {
                this.dirtyChildren.remove(node);
            }
            --this.dirtyChildrenCount;
        }
    }

    private void childIncluded(Node node) {
        this.cachedBoundsInvalid = true;
        this.setChildDirty(node, true);
    }

    private void childExcluded(Node node) {
        if (node == this.left) {
            this.left = null;
            this.cachedBoundsInvalid = true;
        }
        if (node == this.top) {
            this.top = null;
            this.cachedBoundsInvalid = true;
        }
        if (node == this.near) {
            this.near = null;
            this.cachedBoundsInvalid = true;
        }
        if (node == this.right) {
            this.right = null;
            this.cachedBoundsInvalid = true;
        }
        if (node == this.bottom) {
            this.bottom = null;
            this.cachedBoundsInvalid = true;
        }
        if (node == this.far) {
            this.far = null;
            this.cachedBoundsInvalid = true;
        }
        this.setChildDirty(node, false);
    }

    private void recomputeBounds() {
        if (this.children.isEmpty()) {
            this.cachedBounds.makeEmpty();
            return;
        }
        if (this.children.size() == 1) {
            Node node = (Node)this.children.get(0);
            node.boundsChanged = false;
            if (node.isVisible()) {
                this.cachedBounds = node.getTransformedBounds(this.cachedBounds, BaseTransform.IDENTITY_TRANSFORM);
                this.near = this.far = node;
                this.right = this.far;
                this.bottom = this.far;
                this.left = this.far;
                this.top = this.far;
            } else {
                this.cachedBounds.makeEmpty();
            }
            return;
        }
        if (this.dirtyChildrenCount == 0 || !this.updateCachedBounds(this.dirtyChildren != null ? this.dirtyChildren : this.children, this.dirtyChildrenCount)) {
            this.createCachedBounds(this.children);
        }
    }

    private boolean updateCachedBounds(List<Node> list, int n) {
        if (this.cachedBounds.isEmpty()) {
            this.createCachedBounds(list);
            return true;
        }
        int n2 = 0;
        if (this.left == null || this.left.boundsChanged) {
            n2 |= 1;
        }
        if (this.top == null || this.top.boundsChanged) {
            n2 |= 2;
        }
        if (this.near == null || this.near.boundsChanged) {
            n2 |= 4;
        }
        if (this.right == null || this.right.boundsChanged) {
            n2 |= 8;
        }
        if (this.bottom == null || this.bottom.boundsChanged) {
            n2 |= 0x10;
        }
        if (this.far == null || this.far.boundsChanged) {
            n2 |= 0x20;
        }
        float f = this.cachedBounds.getMinX();
        float f2 = this.cachedBounds.getMinY();
        float f3 = this.cachedBounds.getMinZ();
        float f4 = this.cachedBounds.getMaxX();
        float f5 = this.cachedBounds.getMaxY();
        float f6 = this.cachedBounds.getMaxZ();
        int n3 = list.size() - 1;
        while (n > 0) {
            Node node = list.get(n3);
            if (node.boundsChanged) {
                node.boundsChanged = false;
                --n;
                this.tmp = node.getTransformedBounds(this.tmp, BaseTransform.IDENTITY_TRANSFORM);
                if (!this.tmp.isEmpty()) {
                    float f7 = this.tmp.getMinX();
                    float f8 = this.tmp.getMinY();
                    float f9 = this.tmp.getMinZ();
                    float f10 = this.tmp.getMaxX();
                    float f11 = this.tmp.getMaxY();
                    float f12 = this.tmp.getMaxZ();
                    if (f7 <= f) {
                        f = f7;
                        this.left = node;
                        n2 &= 0xFFFFFFFE;
                    }
                    if (f8 <= f2) {
                        f2 = f8;
                        this.top = node;
                        n2 &= 0xFFFFFFFD;
                    }
                    if (f9 <= f3) {
                        f3 = f9;
                        this.near = node;
                        n2 &= 0xFFFFFFFB;
                    }
                    if (f10 >= f4) {
                        f4 = f10;
                        this.right = node;
                        n2 &= 0xFFFFFFF7;
                    }
                    if (f11 >= f5) {
                        f5 = f11;
                        this.bottom = node;
                        n2 &= 0xFFFFFFEF;
                    }
                    if (f12 >= f6) {
                        f6 = f12;
                        this.far = node;
                        n2 &= 0xFFFFFFDF;
                    }
                }
            }
            --n3;
        }
        if (n2 != 0) {
            return false;
        }
        this.cachedBounds = this.cachedBounds.deriveWithNewBounds(f, f2, f3, f4, f5, f6);
        return true;
    }

    private void createCachedBounds(List<Node> list) {
        Node node;
        int n;
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            node = list.get(n);
            node.boundsChanged = false;
            if (!node.isVisible()) continue;
            this.tmp = node.getTransformedBounds(this.tmp, BaseTransform.IDENTITY_TRANSFORM);
            if (this.tmp.isEmpty()) continue;
            this.bottom = this.far = node;
            this.right = this.far;
            this.near = this.far;
            this.top = this.far;
            this.left = this.far;
            break;
        }
        if (n == n2) {
            this.far = null;
            this.bottom = null;
            this.right = null;
            this.near = null;
            this.top = null;
            this.left = null;
            this.cachedBounds.makeEmpty();
            return;
        }
        float f = this.tmp.getMinX();
        float f2 = this.tmp.getMinY();
        float f3 = this.tmp.getMinZ();
        float f4 = this.tmp.getMaxX();
        float f5 = this.tmp.getMaxY();
        float f6 = this.tmp.getMaxZ();
        ++n;
        while (n < n2) {
            node = list.get(n);
            node.boundsChanged = false;
            if (node.isVisible()) {
                this.tmp = node.getTransformedBounds(this.tmp, BaseTransform.IDENTITY_TRANSFORM);
                if (!this.tmp.isEmpty()) {
                    float f7 = this.tmp.getMinX();
                    float f8 = this.tmp.getMinY();
                    float f9 = this.tmp.getMinZ();
                    float f10 = this.tmp.getMaxX();
                    float f11 = this.tmp.getMaxY();
                    float f12 = this.tmp.getMaxZ();
                    if (f7 < f) {
                        f = f7;
                        this.left = node;
                    }
                    if (f8 < f2) {
                        f2 = f8;
                        this.top = node;
                    }
                    if (f9 < f3) {
                        f3 = f9;
                        this.near = node;
                    }
                    if (f10 > f4) {
                        f4 = f10;
                        this.right = node;
                    }
                    if (f11 > f5) {
                        f5 = f11;
                        this.bottom = node;
                    }
                    if (f12 > f6) {
                        f6 = f12;
                        this.far = node;
                    }
                }
            }
            ++n;
        }
        this.cachedBounds = this.cachedBounds.deriveWithNewBounds(f, f2, f3, f4, f5, f6);
    }

    @Override
    protected void updateBounds() {
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            ((Node)this.children.get(i)).updateBounds();
        }
        super.updateBounds();
    }

    void childBoundsChanged(Node node) {
        this.cachedBoundsInvalid = true;
        this.setChildDirty(node, true);
        this.impl_geomChanged();
    }

    void childVisibilityChanged(Node node) {
        if (node.isVisible()) {
            this.childIncluded(node);
        } else {
            this.childExcluded(node);
        }
        this.impl_geomChanged();
    }

    @Override
    @Deprecated
    protected boolean impl_computeContains(double d, double d2) {
        Point2D point2D = TempState.getInstance().point;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)this.children.get(i);
            point2D.x = (float)d;
            point2D.y = (float)d2;
            try {
                node.parentToLocal(point2D);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                continue;
            }
            if (!node.contains(point2D.x, point2D.y)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public Object impl_processMXNode(MXNodeAlgorithm mXNodeAlgorithm, MXNodeAlgorithmContext mXNodeAlgorithmContext) {
        return mXNodeAlgorithm.processContainerNode(this, mXNodeAlgorithmContext);
    }
}

