/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.DoubleByte;

public class HKSCS {

    public static class Encoder
    extends DoubleByte.Encoder {
        private DoubleByte.Encoder big5Enc;
        private char[][] c2bBmp;
        private char[][] c2bSupp;
        private byte[] repl = this.replacement();
        static char[] C2B_UNMAPPABLE = new char[256];

        protected Encoder(Charset charset, DoubleByte.Encoder encoder, char[][] cArray, char[][] cArray2) {
            super(charset, null, null);
            this.big5Enc = encoder;
            this.c2bBmp = cArray;
            this.c2bSupp = cArray2;
        }

        public int encodeBig5(char c) {
            return this.big5Enc.encodeChar(c);
        }

        @Override
        public int encodeChar(char c) {
            char c2 = this.c2bBmp[c >> 8][c & 0xFF];
            if (c2 == '\ufffd') {
                return this.encodeBig5(c);
            }
            return c2;
        }

        public int encodeSupp(int n) {
            if ((n & 0xF0000) != 131072) {
                return 65533;
            }
            return this.c2bSupp[n >> 8 & 0xFF][n & 0xFF];
        }

        @Override
        public boolean canEncode(char c) {
            return this.encodeChar(c) != 65533;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n;
            char[] cArray = charBuffer.array();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            try {
                int n5;
                for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; n += n5) {
                    char c = cArray[n];
                    n5 = 1;
                    int n6 = this.encodeChar(c);
                    if (n6 == 65533) {
                        if (Character.isSurrogate(c)) {
                            int n7 = this.sgp().parse(c, cArray, n, n2);
                            if (n7 < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            n6 = this.encodeSupp(n7);
                            if (n6 == 65533) {
                                CoderResult coderResult = CoderResult.unmappableForLength(2);
                                return coderResult;
                            }
                            n5 = 2;
                        } else {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (n6 > 255) {
                        if (n4 - n3 < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n3++] = (byte)(n6 >> 8);
                        byArray[n3++] = (byte)n6;
                        continue;
                    }
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byArray[n3++] = (byte)n6;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    int n2 = 1;
                    char c = charBuffer.get();
                    int n3 = this.encodeChar(c);
                    if (n3 == 65533) {
                        if (Character.isSurrogate(c)) {
                            int n4 = this.sgp().parse(c, charBuffer);
                            if (n4 < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            n3 = this.encodeSupp(n4);
                            if (n3 == 65533) {
                                CoderResult coderResult = CoderResult.unmappableForLength(2);
                                return coderResult;
                            }
                            n2 = 2;
                        } else {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (n3 > 255) {
                        if (byteBuffer.remaining() < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)(n3 >> 8));
                        byteBuffer.put((byte)n3);
                    } else {
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)n3);
                    }
                    n += n2;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }

        @Override
        protected void implReplaceWith(byte[] byArray) {
            this.repl = byArray;
        }

        @Override
        public int encode(char[] cArray, int n, int n2, byte[] byArray) {
            int n3 = 0;
            int n4 = n + n2;
            while (n < n4) {
                char c;
                int n5;
                if ((n5 = this.encodeChar(c = cArray[n++])) == 65533) {
                    if (!Character.isHighSurrogate(c) || n == n4 || !Character.isLowSurrogate(cArray[n]) || (n5 = this.encodeSupp(Character.toCodePoint(c, cArray[n++]))) == 65533) {
                        byArray[n3++] = this.repl[0];
                        if (this.repl.length <= 1) continue;
                        byArray[n3++] = this.repl[1];
                        continue;
                    }
                    ++n;
                }
                if (n5 > 255) {
                    byArray[n3++] = (byte)(n5 >> 8);
                    byArray[n3++] = (byte)n5;
                    continue;
                }
                byArray[n3++] = (byte)n5;
            }
            return n3;
        }

        static void initc2b(char[][] cArray, String[] stringArray, String string) {
            int n;
            int n2;
            int n3;
            int n4 = 64;
            Arrays.fill((Object[])cArray, C2B_UNMAPPABLE);
            for (n3 = 0; n3 < 256; ++n3) {
                String string2 = stringArray[n3];
                if (string2 == null) continue;
                for (n2 = 0; n2 < string2.length(); ++n2) {
                    n = string2.charAt(n2);
                    int n5 = n >> 8;
                    if (cArray[n5] == C2B_UNMAPPABLE) {
                        cArray[n5] = new char[256];
                        Arrays.fill(cArray[n5], '\ufffd');
                    }
                    cArray[n5][n & 0xFF] = (char)(n3 << 8 | n2 + n4);
                }
            }
            if (string != null) {
                n3 = 57344;
                for (int i = 0; i < string.length(); ++i) {
                    n2 = string.charAt(i);
                    if (n2 != 65533) {
                        n = n3 >> 8;
                        if (cArray[n] == C2B_UNMAPPABLE) {
                            cArray[n] = new char[256];
                            Arrays.fill(cArray[n], '\ufffd');
                        }
                        cArray[n][n3 & 0xFF] = n2;
                    }
                    n3 = (char)(n3 + 1);
                }
            }
        }

        static {
            Arrays.fill(C2B_UNMAPPABLE, '\ufffd');
        }
    }

    public static class Decoder
    extends DoubleByte.Decoder {
        static int b2Min = 64;
        static int b2Max = 254;
        private char[][] b2cBmp;
        private char[][] b2cSupp;
        private DoubleByte.Decoder big5Dec;

        protected Decoder(Charset charset, DoubleByte.Decoder decoder, char[][] cArray, char[][] cArray2) {
            super(charset, 0.5f, 1.0f, null, null, 0, 0);
            this.big5Dec = decoder;
            this.b2cBmp = cArray;
            this.b2cSupp = cArray2;
        }

        @Override
        public char decodeSingle(int n) {
            return this.big5Dec.decodeSingle(n);
        }

        public char decodeBig5(int n, int n2) {
            return this.big5Dec.decodeDouble(n, n2);
        }

        @Override
        public char decodeDouble(int n, int n2) {
            return this.b2cBmp[n][n2 - b2Min];
        }

        public char decodeDoubleEx(int n, int n2) {
            return this.b2cSupp[n][n2 - b2Min];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n;
            byte[] byArray = byteBuffer.array();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            try {
                int n5;
                for (n = byteBuffer.arrayOffset() + byteBuffer.position(); n < n2; n += n5) {
                    int n6 = byArray[n] & 0xFF;
                    char c = this.decodeSingle(n6);
                    n5 = 1;
                    int n7 = 1;
                    Object var13_14 = null;
                    if (c == '\ufffd') {
                        if (n2 - n < 2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        int n8 = byArray[n + 1] & 0xFF;
                        ++n5;
                        if (n8 < b2Min || n8 > b2Max) {
                            CoderResult coderResult = CoderResult.unmappableForLength(2);
                            return coderResult;
                        }
                        c = this.decodeDouble(n6, n8);
                        if (c == '\ufffd') {
                            c = this.decodeDoubleEx(n6, n8);
                            if (c == '\ufffd') {
                                c = this.decodeBig5(n6, n8);
                                if (c == '\ufffd') {
                                    CoderResult coderResult = CoderResult.unmappableForLength(2);
                                    return coderResult;
                                }
                            } else {
                                n7 = 2;
                            }
                        }
                    }
                    if (n4 - n3 < n7) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    if (n7 == 2) {
                        cArray[n3++] = Surrogate.high(131072 + c);
                        cArray[n3++] = Surrogate.low(131072 + c);
                        continue;
                    }
                    cArray[n3++] = c;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n3 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            try {
                CoderResult coderResult;
                while (byteBuffer.hasRemaining()) {
                    coderResult = null;
                    int n2 = byteBuffer.get() & 0xFF;
                    int n3 = 1;
                    int n4 = 1;
                    char c = this.decodeSingle(n2);
                    if (c == '\ufffd') {
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult2 = CoderResult.UNDERFLOW;
                            return coderResult2;
                        }
                        int n5 = byteBuffer.get() & 0xFF;
                        ++n3;
                        if (n5 < b2Min || n5 > b2Max) {
                            CoderResult coderResult3 = CoderResult.unmappableForLength(2);
                            return coderResult3;
                        }
                        c = this.decodeDouble(n2, n5);
                        if (c == '\ufffd') {
                            c = this.decodeDoubleEx(n2, n5);
                            if (c == '\ufffd') {
                                c = this.decodeBig5(n2, n5);
                                if (c == '\ufffd') {
                                    CoderResult coderResult4 = CoderResult.unmappableForLength(2);
                                    return coderResult4;
                                }
                            } else {
                                n4 = 2;
                            }
                        }
                    }
                    if (charBuffer.remaining() < n4) {
                        CoderResult coderResult5 = CoderResult.OVERFLOW;
                        return coderResult5;
                    }
                    if (n4 == 2) {
                        charBuffer.put(Surrogate.high(131072 + c));
                        charBuffer.put(Surrogate.low(131072 + c));
                    } else {
                        charBuffer.put(c);
                    }
                    n += n3;
                }
                coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        @Override
        public int decode(byte[] byArray, int n, int n2, char[] cArray) {
            int n3 = 0;
            int n4 = n + n2;
            char c = this.replacement().charAt(0);
            while (n < n4) {
                int n5;
                char c2;
                if ((c2 = this.decodeSingle(n5 = byArray[n++] & 0xFF)) == '\ufffd') {
                    int n6;
                    if (n4 == n) {
                        c2 = c;
                    } else if ((n6 = byArray[n++] & 0xFF) < b2Min || n6 > b2Max) {
                        c2 = c;
                    } else {
                        c2 = this.decodeDouble(n5, n6);
                        if (c2 == '\ufffd') {
                            c2 = this.decodeDoubleEx(n5, n6);
                            if (c2 == '\ufffd') {
                                c2 = this.decodeBig5(n5, n6);
                                if (c2 == '\ufffd') {
                                    c2 = c;
                                }
                            } else {
                                cArray[n3++] = Surrogate.high(131072 + c2);
                                cArray[n3++] = Surrogate.low(131072 + c2);
                                continue;
                            }
                        }
                    }
                }
                cArray[n3++] = c2;
            }
            return n3;
        }

        @Override
        public CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        static void initb2c(char[][] cArray, String[] stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                cArray[i] = stringArray[i] == null ? DoubleByte.B2C_UNMAPPABLE : stringArray[i].toCharArray();
            }
        }
    }
}

