/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi;

import com.google.code.gsonrmi.ParamValidationException;
import com.google.code.gsonrmi.Parameter;
import com.google.code.gsonrmi.RpcError;
import com.google.code.gsonrmi.RpcRequest;
import com.google.code.gsonrmi.RpcResponse;
import com.google.code.gsonrmi.annotations.RMI;
import com.google.gson.JsonParseException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class Invoker {
    private final ParamProcessor a;

    public Invoker(ParamProcessor paramProcessor) {
        this.a = paramProcessor;
    }

    public RpcResponse doInvoke(RpcRequest typeArray, Object object, Object object2) {
        RpcResponse rpcResponse = new RpcResponse();
        new RpcResponse().id = typeArray.id;
        try {
            Method method;
            Parameter[] parameterArray;
            Parameter[] parameterArray2 = parameterArray = typeArray.params != null ? typeArray.params : new Parameter[]{};
            if (typeArray.method.equals("ack")) {
                System.out.println();
            }
            if ((method = this.findMethod(object, typeArray.method, parameterArray)) == null) {
                throw new NoSuchMethodException(typeArray.method);
            }
            typeArray = method.getGenericParameterTypes();
            Annotation[][] annotationArray = method.getParameterAnnotations();
            Object[] objectArray = new Object[typeArray.length];
            int n = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.a.isInjectedParam(annotationArray[i]) ? this.a.injectParam(typeArray[i], annotationArray[i], object2) : this.a.processParam(parameterArray[n++], typeArray[i], annotationArray[i], object2);
            }
            Object object3 = method.invoke(object, objectArray);
            rpcResponse.result = object3 != null ? new Parameter(object3) : null;
        }
        catch (JsonParseException jsonParseException) {
            rpcResponse.error = RpcError.PARSER_ERROR;
            jsonParseException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            rpcResponse.error = new RpcError(RpcError.INVOCATION_EXCEPTION, invocationTargetException.getCause());
            invocationTargetException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            rpcResponse.error = RpcError.METHOD_NOT_FOUND;
            illegalAccessException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            rpcResponse.error = RpcError.INVALID_PARAMS;
            illegalArgumentException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            rpcResponse.error = RpcError.METHOD_NOT_FOUND;
            noSuchMethodException.printStackTrace();
        }
        catch (ParamValidationException paramValidationException) {
            rpcResponse.error = new RpcError(RpcError.PARAM_VALIDATION_FAILED, (Object)paramValidationException.getMessage());
            paramValidationException.printStackTrace();
        }
        return rpcResponse;
    }

    public Method findMethod(Object methodArray, String string, Parameter[] parameterArray) {
        for (Method method : methodArray.getClass().getMethods()) {
            Object object = method.getAnnotation(RMI.class);
            if (object == null) continue;
            if (((String)(object = object.value())).isEmpty()) {
                object = method.getName();
            }
            if (!((String)object).equals(string)) continue;
            int n = 0;
            for (Annotation[] annotationArray : method.getParameterAnnotations()) {
                if (!this.a.isInjectedParam(annotationArray)) continue;
                ++n;
            }
            if (parameterArray.length + n != method.getParameterTypes().length) continue;
            return method;
        }
        return null;
    }

    public static interface ParamProcessor {
        public boolean isInjectedParam(Annotation[] var1);

        public Object injectParam(Type var1, Annotation[] var2, Object var3) throws ParamValidationException;

        public Object processParam(Parameter var1, Type var2, Annotation[] var3, Object var4) throws ParamValidationException;
    }
}

