/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi.transport;

import com.google.code.gsonrmi.Parameter;
import com.google.code.gsonrmi.transport.Collections;
import com.google.code.gsonrmi.transport.DeliveryFailure;
import com.google.code.gsonrmi.transport.Message;
import com.google.code.gsonrmi.transport.MessageProcessor;
import com.google.code.gsonrmi.transport.Route;
import com.google.code.gsonrmi.transport.Transport;
import com.google.gson.Gson;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;

public abstract class Proxy
extends MessageProcessor {
    protected final Transport transport;
    protected final Gson gson;
    private final Map<String, Connection> a;
    private final TimerTask b;

    protected Proxy(Transport transport, Gson gson) {
        this(transport, gson, new Options());
    }

    protected Proxy(Transport transport, Gson gson, Options options) {
        this.transport = transport;
        this.transport.register(this.getScheme(), this.mq);
        this.gson = gson;
        this.a = new HashMap<String, Connection>();
        this.b = transport.sendEvery(new Message(null, Arrays.asList(new Route(URI.create(this.getScheme() + ":proxy"))), new CleanUp()), options.cleanupInterval, options.cleanupInterval);
    }

    protected abstract String getScheme();

    protected abstract Connection createConnection(String var1);

    public void addConnection(Connection connection) {
        this.mq.add(new Message(null, null, new AddConnection(connection)));
    }

    @Override
    protected void process(Message object) {
        if (((Message)object).contentOfType(Transport.Shutdown.class)) {
            this.handle(((Message)object).getContentAs(Transport.Shutdown.class, this.gson));
            return;
        }
        if (((Message)object).contentOfType(AddConnection.class)) {
            AddConnection addConnection = ((Message)object).getContentAs(AddConnection.class, this.gson);
            object = this;
            System.out.println("Adding new Connection: " + addConnection.con.getRemoteAuthority());
            ((Proxy)object).a.put(addConnection.con.getRemoteAuthority(), addConnection.con);
            return;
        }
        if (((Message)object).contentOfType(CleanUp.class)) {
            this.handle(((Message)object).getContentAs(CleanUp.class, this.gson));
            return;
        }
        this.handle((Message)object);
    }

    protected void handle(Transport.Shutdown object) {
        for (Connection connection : this.a.values()) {
            connection.shutdown();
        }
        this.b.cancel();
    }

    protected void handle(Message message) {
        LinkedList<Route> linkedList = new LinkedList<Route>();
        for (Map.Entry entry : Collections.group(message.dests, (Object)Route.GroupBy.AUTHORITY).entrySet()) {
            String string = (String)entry.getKey();
            List<Route> object = entry.getValue();
            Connection connection = this.a.get(string);
            if (connection == null || !connection.isAlive()) {
                System.out.println("Removing Connection: " + connection);
                this.a.remove(string);
                connection = this.createConnection(string);
                if (connection != null) {
                    System.out.println("Adding new Connection: " + connection.getRemoteAuthority());
                    this.a.put(string, connection);
                }
            }
            if (connection != null) {
                connection.send(new Message(message.src, object, message.content, message.contentType));
                continue;
            }
            linkedList.addAll(object);
        }
        if (!linkedList.isEmpty() && !message.contentOfType(DeliveryFailure.class)) {
            DeliveryFailure deliveryFailure = new DeliveryFailure(new Message(message.src, linkedList, message.content, message.contentType));
            this.transport.send(new Message(null, Arrays.asList(message.src), deliveryFailure));
        }
    }

    protected void handle(CleanUp cleanUp) {
        int n = this.a.size();
        Iterator<Connection> iterator = this.a.values().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isAlive()) continue;
            iterator.remove();
        }
        if (this.a.size() < n) {
            System.err.println("INFO: " + this.getClass().getSimpleName() + " cleanup connections " + n + " -> " + this.a.size());
        }
    }

    public Map<String, Connection> getCons() {
        return this.a;
    }

    public static class OnConnectionClosed {
        public Parameter data;
    }

    public static class CheckConnection {
        public Parameter data;
    }

    public static interface Connection {
        public String getRemoteAuthority();

        public boolean isAlive();

        public void send(Message var1);

        public void shutdown();
    }

    public static class AddConnection {
        public final Connection con;

        public AddConnection(Connection connection) {
            this.con = connection;
        }
    }

    public static class Options {
        public long cleanupInterval = 60000L;
    }

    public static class CleanUp {
        protected CleanUp() {
        }
    }
}

