/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi.transport.rmi;

import com.google.code.gsonrmi.Parameter;
import com.google.code.gsonrmi.RpcError;
import com.google.code.gsonrmi.RpcRequest;
import com.google.code.gsonrmi.RpcResponse;
import com.google.code.gsonrmi.annotations.RMI;
import com.google.code.gsonrmi.transport.DeliveryFailure;
import com.google.code.gsonrmi.transport.Message;
import com.google.code.gsonrmi.transport.MessageProcessor;
import com.google.code.gsonrmi.transport.Proxy;
import com.google.code.gsonrmi.transport.Route;
import com.google.code.gsonrmi.transport.Transport;
import com.google.code.gsonrmi.transport.rmi.Call;
import com.google.code.gsonrmi.transport.rmi.Callback;
import com.google.code.gsonrmi.transport.rmi.DefaultRpcHandler;
import com.google.code.gsonrmi.transport.rmi.RmiError;
import com.google.code.gsonrmi.transport.rmi.RpcHandler;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;

public class RmiService
extends MessageProcessor {
    public static final String SCHEME = "rmi";
    private final URI a = new URI("rmi", "service", null);
    private final Transport b;
    private final Gson c;
    private final Map<String, RpcHandler> d;
    private final Map<Integer, Call> e;
    private final TimerTask f;
    private int g;

    public RmiService(Transport transport, Gson gson) throws URISyntaxException {
        this(transport, gson, new Options());
    }

    public RmiService(Transport transport, Gson gson, Options options) throws URISyntaxException {
        this.b = transport;
        this.b.register(SCHEME, this.mq);
        this.c = gson;
        this.d = new HashMap<String, RpcHandler>();
        this.d.put(this.a.getSchemeSpecificPart(), new DefaultRpcHandler(this, this.c));
        this.e = new HashMap<Integer, Call>();
        this.f = new Call(new Route(this.a), "periodicCleanup", new Object[0]).sendEvery(this.b, options.cleanupInterval, options.cleanupInterval);
    }

    @RMI
    public URI register(String string, Object object) throws URISyntaxException {
        if (object instanceof RpcHandler) {
            this.d.put(string, (RpcHandler)object);
        } else {
            this.d.put(string, new DefaultRpcHandler(object, this.c));
        }
        return new URI(SCHEME, string, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void process(Message object) {
        if (((Message)object).contentOfType(Call.class)) {
            Call call = ((Message)object).getContentAs(Call.class, this.c);
            object = this;
            call.a = System.currentTimeMillis();
            if ("_onConnectionClosed".equals(call.method)) {
                if (call.params.length != 0) {
                    System.err.println("WARN: _onConnectionClosed accepts no params");
                }
                if (call.callback != null) {
                    Proxy.OnConnectionClosed onConnectionClosed = new Proxy.OnConnectionClosed();
                    Parameter[] parameterArray = Arrays.copyOf(call.callback.params, call.callback.params.length + 1);
                    Parameter[] parameterArray2 = parameterArray;
                    parameterArray[parameterArray2.length - 1] = new Parameter(call.callback.method);
                    onConnectionClosed.data = new Parameter(parameterArray2);
                    ((RmiService)object).b.send(new Message(call.callback.target, call.targets, onConnectionClosed));
                    return;
                }
                System.err.println("_onConnectionClosed requires a callback");
                return;
            }
            Integer n = null;
            if (call.callback != null) {
                n = ++((RmiService)object).g;
                ((RmiService)object).e.put(n, call);
            }
            if ("_checkConnection".equals(call.method)) {
                if (call.callback != null) {
                    Proxy.CheckConnection checkConnection = new Proxy.CheckConnection();
                    new Proxy.CheckConnection().data = new Parameter(n);
                    ((RmiService)object).b.send(new Message(call.callback.target, call.targets, checkConnection));
                    return;
                }
                System.err.println("_checkConnection requires a callback");
                return;
            }
            RpcRequest rpcRequest = new RpcRequest();
            new RpcRequest().method = call.method;
            rpcRequest.params = call.params;
            rpcRequest.id = n != null ? new Parameter(n) : null;
            ((RmiService)object).b.send(new Message(call.callback != null ? call.callback.target : new Route(((RmiService)object).a), call.targets, rpcRequest));
            return;
        }
        if (!((Message)object).contentOfType(RpcRequest.class)) {
            if (((Message)object).contentOfType(RpcResponse.class)) {
                this.a(((Message)object).getContentAs(RpcResponse.class, this.c), ((Message)object).dests.get(0), Arrays.asList(((Message)object).src));
                return;
            }
            if (((Message)object).contentOfType(DeliveryFailure.class)) {
                Route route = ((Message)object).src;
                Route route2 = ((Message)object).dests.get(0);
                DeliveryFailure deliveryFailure = ((Message)object).getContentAs(DeliveryFailure.class, this.c);
                object = this;
                if (deliveryFailure.message.contentOfType(RpcRequest.class)) {
                    RpcRequest rpcRequest = deliveryFailure.message.getContentAs(RpcRequest.class, ((RmiService)object).c);
                    if (rpcRequest.id != null) {
                        RpcResponse rpcResponse = new RpcResponse();
                        new RpcResponse().id = rpcRequest.id;
                        rpcResponse.error = RmiError.UNREACHABLE;
                        super.a(rpcResponse, route2, RmiService.a(deliveryFailure.message.dests, route));
                        return;
                    }
                    System.err.println("Failed to deliver notification(s): " + rpcRequest.method);
                    return;
                }
                if (deliveryFailure.message.contentOfType(RpcResponse.class)) {
                    RpcResponse rpcResponse = deliveryFailure.message.getContentAs(RpcResponse.class, ((RmiService)object).c);
                    Integer n = rpcResponse.id.getValue(Integer.class, ((RmiService)object).c);
                    System.err.println("Failed to deliver response with id " + n);
                    return;
                }
                if (deliveryFailure.message.contentOfType(Proxy.CheckConnection.class)) {
                    Proxy.CheckConnection checkConnection = deliveryFailure.message.getContentAs(Proxy.CheckConnection.class, ((RmiService)object).c);
                    RpcResponse rpcResponse = new RpcResponse();
                    new RpcResponse().id = checkConnection.data;
                    rpcResponse.error = RmiError.UNREACHABLE;
                    super.a(rpcResponse, route2, RmiService.a(deliveryFailure.message.dests, route));
                    return;
                }
                if (deliveryFailure.message.contentOfType(Proxy.OnConnectionClosed.class)) {
                    Proxy.OnConnectionClosed onConnectionClosed = deliveryFailure.message.getContentAs(Proxy.OnConnectionClosed.class, ((RmiService)object).c);
                    Callback callback = new Callback();
                    new Callback().target = route2;
                    Parameter[] parameterArray = onConnectionClosed.data.getValue(Parameter[].class, ((RmiService)object).c);
                    callback.method = parameterArray[parameterArray.length - 1].getValue(String.class, ((RmiService)object).c);
                    callback.params = Arrays.copyOfRange(parameterArray, 0, parameterArray.length - 1);
                    RpcResponse rpcResponse = new RpcResponse();
                    new RpcResponse().error = RmiError.UNREACHABLE;
                    super.a(callback, rpcResponse, route2, RmiService.a(deliveryFailure.message.dests, route));
                    return;
                }
                System.err.println("Unhandled delivery failure of " + deliveryFailure.message.contentType);
                return;
            }
            if (((Message)object).contentOfType(Transport.Shutdown.class)) {
                ((Message)object).getContentAs(Transport.Shutdown.class, this.c);
                this.a();
                return;
            }
            if (((Message)object).contentOfType(Proxy.CheckConnection.class)) return;
            if (((Message)object).contentOfType(Proxy.OnConnectionClosed.class)) return;
            System.err.println("Unhandled message type: " + ((Message)object).contentType);
            return;
        }
        Route route = ((Message)object).src;
        Object object2 = ((Message)object).dests;
        RpcRequest rpcRequest = ((Message)object).getContentAs(RpcRequest.class, this.c);
        object = this;
        Iterator<Route> iterator = object2.iterator();
        while (iterator.hasNext()) {
            Object object3;
            Route route3 = iterator.next();
            URI uRI = route3.hops[0];
            if (rpcRequest.method.equals("registerCapabilities")) {
                for (int i = 0; i < rpcRequest.params.length; ++i) {
                    System.out.println(rpcRequest.params[i]);
                    if (rpcRequest.params[i] != null) continue;
                    object3 = route.hops[0].getAuthority();
                    object3 = new JsonPrimitive((String)object3);
                    rpcRequest.params[i] = new Parameter((JsonElement)object3);
                }
            }
            if ((object2 = ((RmiService)object).d.get(uRI.getSchemeSpecificPart())) != null) {
                object3 = object2.handle(rpcRequest, route3, route);
            } else {
                object3 = new RpcResponse();
                new RpcResponse().id = rpcRequest.id;
                ((RpcResponse)object3).error = new RpcError(RmiError.TARGET_NOT_FOUND, uRI);
            }
            if (object3 == null) continue;
            if (((RpcResponse)object3).id != null) {
                ((RmiService)object).b.send(new Message(route3, Arrays.asList(route), object3));
                continue;
            }
            if (((RpcResponse)object3).error == null) continue;
            System.err.println("Notification failed:  " + uRI + " method " + rpcRequest.method + ", " + ((RpcResponse)object3).error);
            if (!((RpcResponse)object3).error.equals(RpcError.INVOCATION_EXCEPTION)) continue;
            ((RpcResponse)object3).error.data.getValue(Exception.class, ((RmiService)object).c).printStackTrace();
        }
    }

    private void a(RpcResponse rpcResponse, Route route, List<Route> list) {
        Integer n = rpcResponse.id.getValue(Integer.class, this.c);
        Call call = this.e.get(n);
        if (call != null) {
            this.a(call.callback, rpcResponse, route, list);
            return;
        }
        System.err.println("No pending request with id " + n);
    }

    private void a() {
        for (RpcHandler rpcHandler : this.d.values()) {
            rpcHandler.shutdown();
        }
        this.f.cancel();
    }

    @RMI
    public void periodicCleanup() {
        int n = this.e.size();
        Iterator<Object> iterator = this.e.values().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isExpired()) continue;
            iterator.remove();
        }
        if (this.e.size() < n) {
            System.err.println("INFO: cleanup pending calls " + n + " -> " + this.e.size());
        }
        for (RpcHandler rpcHandler : this.d.values()) {
            rpcHandler.periodicCleanup();
        }
    }

    private static List<Route> a(List<Route> object, Route route) {
        LinkedList<Route> linkedList = new LinkedList<Route>();
        object = object.iterator();
        while (object.hasNext()) {
            Route route2 = (Route)object.next();
            linkedList.add(route2.addFirst(route.hops));
        }
        return linkedList;
    }

    private void a(Callback callback, RpcResponse rpcResponse, Route route, List<Route> list) {
        URI uRI = route.hops[0];
        RpcHandler rpcHandler = this.d.get(uRI.getSchemeSpecificPart());
        if (rpcHandler != null) {
            rpcHandler.handle(rpcResponse, route, list, callback);
            return;
        }
        System.err.println("Callback target not found " + uRI);
    }

    public static class Options {
        public long cleanupInterval = 60000L;
    }
}

