/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi.transport.tcp;

import com.google.code.gsonrmi.transport.DeliveryFailure;
import com.google.code.gsonrmi.transport.Message;
import com.google.code.gsonrmi.transport.Proxy;
import com.google.code.gsonrmi.transport.Route;
import com.google.code.gsonrmi.transport.Transport;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TcpAccessProxy
extends Proxy {
    private final b a;
    private final Options b;

    public TcpAccessProxy(List<InetSocketAddress> list, Transport transport, Gson gson) throws IOException {
        this(list, transport, gson, new Options());
    }

    public TcpAccessProxy(List<InetSocketAddress> list, Transport transport, Gson gson, Options options) throws IOException {
        super(transport, gson, options);
        this.a = new b(this, list);
        this.a.start();
        this.b = options;
    }

    @Override
    protected String getScheme() {
        return "tcpa";
    }

    @Override
    protected Proxy.Connection createConnection(String string) {
        return null;
    }

    @Override
    protected void handle(Transport.Shutdown shutdown) {
        super.handle(shutdown);
        this.a.a();
    }

    protected void setSocketOptions(SocketChannel socketChannel) throws IOException {
        socketChannel.socket().setKeepAlive(true);
    }

    public static class Options
    extends Proxy.Options {
        public int readBufferSize = 4096;
        public int writeBufferSize = 4096;
        public boolean keepAlive = true;
    }

    final class a
    implements Proxy.Connection {
        private final SelectionKey a;
        private final URI b;
        private final ByteBuffer c;
        private final ByteBuffer d;
        private final Queue<ByteBuffer> e;
        private final List<Message> f;
        private /* synthetic */ TcpAccessProxy g;

        public a(TcpAccessProxy tcpAccessProxy, SelectionKey selectionKey, URI uRI) {
            this.g = tcpAccessProxy;
            this.a = selectionKey;
            this.b = uRI;
            this.c = ByteBuffer.allocate(((TcpAccessProxy)tcpAccessProxy).b.readBufferSize);
            this.d = ByteBuffer.allocate(((TcpAccessProxy)tcpAccessProxy).b.writeBufferSize);
            this.e = new ConcurrentLinkedQueue<ByteBuffer>();
            this.f = new LinkedList<Message>();
        }

        public final void a() {
            block9: {
                SocketChannel socketChannel = (SocketChannel)this.a.channel();
                try {
                    if (!this.c.hasRemaining()) {
                        throw new IOException("Line too long");
                    }
                    int n = this.c.position();
                    int n2 = socketChannel.read(this.c);
                    if (n2 > 0) {
                        byte[] byArray = this.c.array();
                        this.c.flip();
                        for (int i = n; i < n + n2; ++i) {
                            if (byArray[i] != 10) continue;
                            Object object = new String(byArray, this.c.position(), i - this.c.position());
                            object = this.g.gson.fromJson((String)object, Message.class);
                            if (object != null) {
                                this.g.transport.send(new Message(((Message)object).src.addFirst(this.b), ((Message)object).dests, ((Message)object).content, ((Message)object).contentType));
                            }
                            this.c.position(i + 1);
                        }
                        this.c.compact();
                        break block9;
                    }
                    if (n2 == -1) {
                        socketChannel.close();
                        this.c();
                        break block9;
                    }
                    throw new IOException("Unexpected " + n2 + " bytes read");
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    exception.printStackTrace();
                    try {
                        socketChannel.close();
                        this.c();
                        return;
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        public final void b() {
            Object object;
            SocketChannel socketChannel = (SocketChannel)this.a.channel();
            while (this.d.hasRemaining() && !this.e.isEmpty()) {
                object = this.e.peek();
                if (((Buffer)object).remaining() <= this.d.remaining()) {
                    this.d.put((ByteBuffer)object);
                    this.e.remove();
                    continue;
                }
                ((ByteBuffer)object).limit(((Buffer)object).position() + this.d.remaining());
                this.d.put(((ByteBuffer)object).slice());
                ((ByteBuffer)object).position(((Buffer)object).limit());
                ((ByteBuffer)object).limit(((Buffer)object).capacity());
            }
            try {
                this.d.flip();
                socketChannel.write(this.d);
                this.d.compact();
                if (this.d.position() == 0 && this.e.isEmpty()) {
                    this.a.interestOps(this.a.interestOps() & 0xFFFFFFFB);
                }
                return;
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace();
                try {
                    socketChannel.close();
                    this.c();
                    return;
                }
                catch (IOException iOException2) {
                    return;
                }
            }
        }

        @Override
        public final String getRemoteAuthority() {
            return this.b.getAuthority();
        }

        @Override
        public final boolean isAlive() {
            return ((SocketChannel)this.a.channel()).isConnected();
        }

        @Override
        public final void send(Message message) {
            if (!message.contentOfType(Proxy.CheckConnection.class)) {
                if (message.contentOfType(Proxy.OnConnectionClosed.class)) {
                    this.f.add(message);
                    return;
                }
                try {
                    LinkedList<Route> linkedList = new LinkedList<Route>();
                    for (Route route : message.dests) {
                        linkedList.add(route.removeFirst());
                    }
                    String string = this.g.gson.toJson(new Message(message.src, linkedList, message.content, message.contentType)) + "\n";
                    this.e.add(ByteBuffer.wrap(string.getBytes("utf-8")));
                    this.a.interestOps(this.a.interestOps() | 4);
                    this.a.selector().wakeup();
                    return;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    UnsupportedEncodingException unsupportedEncodingException2 = unsupportedEncodingException;
                    unsupportedEncodingException.printStackTrace();
                    return;
                }
                catch (CancelledKeyException cancelledKeyException) {
                    CancelledKeyException cancelledKeyException2 = cancelledKeyException;
                    cancelledKeyException.printStackTrace();
                }
            }
        }

        @Override
        public final void shutdown() {
            try {
                ((SocketChannel)this.a.channel()).close();
                return;
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                iOException.printStackTrace();
                return;
            }
        }

        private void c() {
            for (Message message : this.f) {
                this.g.transport.send(new Message(null, Arrays.asList(message.src), new DeliveryFailure(message)));
            }
        }
    }

    final class b
    extends Thread {
        private final Selector a = Selector.open();
        private boolean b;
        private /* synthetic */ TcpAccessProxy c;

        public b(TcpAccessProxy object, List<InetSocketAddress> object2) throws IOException {
            this.c = object;
            object = object2.iterator();
            while (object.hasNext()) {
                object2 = (InetSocketAddress)object.next();
                ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
                serverSocketChannel.configureBlocking(false);
                serverSocketChannel.socket().bind((SocketAddress)object2);
                serverSocketChannel.register(this.a, 16);
            }
        }

        public final void a() {
            this.b = true;
            this.a.wakeup();
        }

        @Override
        public final void run() {
            Iterator<SelectionKey> iterator;
            try {
                while (!this.b) {
                    this.a.select();
                    iterator = this.a.selectedKeys();
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        Object object = iterator.next();
                        iterator.remove();
                        if (!((SelectionKey)object).isValid()) continue;
                        if (((SelectionKey)object).isAcceptable()) {
                            object = ((ServerSocketChannel)((SelectionKey)object).channel()).accept();
                            ((AbstractSelectableChannel)object).configureBlocking(false);
                            this.c.setSocketOptions((SocketChannel)object);
                            SelectionKey selectionKey = ((SelectableChannel)object).register(this.a, 1);
                            object = new InetSocketAddress(((SocketChannel)object).socket().getInetAddress(), ((SocketChannel)object).socket().getPort());
                            object = new a(this.c, selectionKey, new URI(this.c.getScheme(), ((InetSocketAddress)object).getHostName() + ":" + ((InetSocketAddress)object).getPort(), null, "a=1", null));
                            this.c.addConnection((Proxy.Connection)object);
                            selectionKey.attach(object);
                            continue;
                        }
                        if (((SelectionKey)object).isReadable()) {
                            ((a)((SelectionKey)object).attachment()).a();
                            continue;
                        }
                        if (!((SelectionKey)object).isWritable()) continue;
                        ((a)((SelectionKey)object).attachment()).b();
                    }
                }
            }
            catch (IOException iOException) {
                iterator = iOException;
                iOException.printStackTrace();
            }
            catch (URISyntaxException uRISyntaxException) {
                iterator = uRISyntaxException;
                uRISyntaxException.printStackTrace();
            }
            try {
                this.a.close();
                return;
            }
            catch (IOException iOException) {
                iterator = iOException;
                iOException.printStackTrace();
                return;
            }
        }
    }
}

