/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.FieldNamingStrategy;
import java.lang.reflect.Field;

public enum FieldNamingPolicy implements FieldNamingStrategy
{
    IDENTITY{

        @Override
        public final String translateName(Field field) {
            return field.getName();
        }
    }
    ,
    UPPER_CAMEL_CASE{

        @Override
        public final String translateName(Field field) {
            return FieldNamingPolicy.upperCaseFirstLetter(field.getName());
        }
    }
    ,
    UPPER_CAMEL_CASE_WITH_SPACES{

        @Override
        public final String translateName(Field field) {
            return FieldNamingPolicy.upperCaseFirstLetter(FieldNamingPolicy.separateCamelCase(field.getName(), " "));
        }
    }
    ,
    LOWER_CASE_WITH_UNDERSCORES{

        @Override
        public final String translateName(Field field) {
            return FieldNamingPolicy.separateCamelCase(field.getName(), "_").toLowerCase();
        }
    }
    ,
    LOWER_CASE_WITH_DASHES{

        @Override
        public final String translateName(Field field) {
            return FieldNamingPolicy.separateCamelCase(field.getName(), "-").toLowerCase();
        }
    };


    private FieldNamingPolicy() {
    }

    private static String separateCamelCase(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (Character.isUpperCase(c2) && stringBuilder.length() != 0) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private static String upperCaseFirstLetter(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        char c2 = string.charAt(0);
        while (n < string.length() - 1 && !Character.isLetter(c2)) {
            stringBuilder.append(c2);
            c2 = string.charAt(++n);
        }
        if (n == string.length()) {
            return stringBuilder.toString();
        }
        if (!Character.isUpperCase(c2)) {
            string = FieldNamingPolicy.modifyString(Character.toUpperCase(c2), string, ++n);
            return stringBuilder.append(string).toString();
        }
        return string;
    }

    private static String modifyString(char c2, String string, int n) {
        if (n < string.length()) {
            return c2 + string.substring(n);
        }
        return String.valueOf(c2);
    }

    /* synthetic */ FieldNamingPolicy(String string, int n, byte by) {
        this();
    }
}

