/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.google.gson.LongSerializationPolicy;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.Primitives;
import com.google.gson.internal.Streams;
import com.google.gson.internal.bind.ArrayTypeAdapter;
import com.google.gson.internal.bind.CollectionTypeAdapterFactory;
import com.google.gson.internal.bind.DateTypeAdapter;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.internal.bind.JsonTreeWriter;
import com.google.gson.internal.bind.MapTypeAdapterFactory;
import com.google.gson.internal.bind.ObjectTypeAdapter;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.internal.bind.SqlDateTypeAdapter;
import com.google.gson.internal.bind.TimeTypeAdapter;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Gson {
    private final ThreadLocal<Map<TypeToken<?>, a<?>>> c = new ThreadLocal<Map<TypeToken<?>, a<?>>>(this){

        @Override
        protected final /* synthetic */ Object initialValue() {
            return new HashMap();
        }
    };
    private final Map<TypeToken<?>, TypeAdapter<?>> d = Collections.synchronizedMap(new HashMap());
    private final List<TypeAdapterFactory> e;
    private final ConstructorConstructor f;
    private final boolean g;
    private final boolean h;
    private final boolean i;
    private final boolean j;
    final JsonDeserializationContext a = new JsonDeserializationContext(this){
        private /* synthetic */ Gson a;
        {
            this.a = gson;
        }

        @Override
        public final <T> T deserialize(JsonElement jsonElement, Type type) throws JsonParseException {
            return this.a.fromJson(jsonElement, type);
        }
    };
    final JsonSerializationContext b = new JsonSerializationContext(this){
        private /* synthetic */ Gson a;
        {
            this.a = gson;
        }

        @Override
        public final JsonElement serialize(Object object) {
            return this.a.toJsonTree(object);
        }

        @Override
        public final JsonElement serialize(Object object, Type type) {
            return this.a.toJsonTree(object, type);
        }
    };

    public Gson() {
        this(Excluder.DEFAULT, FieldNamingPolicy.IDENTITY, Collections.emptyMap(), false, false, false, true, false, false, LongSerializationPolicy.DEFAULT, Collections.emptyList());
    }

    Gson(Excluder excluder, FieldNamingStrategy fieldNamingStrategy, Map<Type, InstanceCreator<?>> object, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, LongSerializationPolicy longSerializationPolicy, List<TypeAdapterFactory> list) {
        this.f = new ConstructorConstructor((Map<Type, InstanceCreator<?>>)object);
        this.g = bl;
        this.i = bl3;
        this.h = bl4;
        this.j = bl5;
        object = new ArrayList<TypeAdapterFactory>();
        object.add(TypeAdapters.JSON_ELEMENT_FACTORY);
        object.add(ObjectTypeAdapter.FACTORY);
        object.addAll(list);
        object.add(TypeAdapters.STRING_FACTORY);
        object.add(TypeAdapters.INTEGER_FACTORY);
        object.add(TypeAdapters.BOOLEAN_FACTORY);
        object.add(TypeAdapters.BYTE_FACTORY);
        object.add(TypeAdapters.SHORT_FACTORY);
        LongSerializationPolicy longSerializationPolicy2 = longSerializationPolicy;
        Gson gson = this;
        object.add(TypeAdapters.newFactory(Long.TYPE, Long.class, longSerializationPolicy2 == LongSerializationPolicy.DEFAULT ? TypeAdapters.LONG : new TypeAdapter<Number>(gson){

            @Override
            public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return jsonReader.nextLong();
            }

            @Override
            public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
                if ((object = (Number)object) == null) {
                    jsonWriter.nullValue();
                    return;
                }
                jsonWriter.value(object.toString());
            }
        }));
        boolean bl7 = bl6;
        gson = this;
        object.add(TypeAdapters.newFactory(Double.TYPE, Double.class, bl7 ? TypeAdapters.DOUBLE : new TypeAdapter<Number>(gson){
            private /* synthetic */ Gson a;
            {
                this.a = gson;
            }

            @Override
            public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return jsonReader.nextDouble();
            }

            @Override
            public final /* synthetic */ void write(JsonWriter object, Object object2) throws IOException {
                Number number = (Number)object2;
                object2 = object;
                object = this;
                if (number == null) {
                    ((JsonWriter)object2).nullValue();
                    return;
                }
                double d2 = number.doubleValue();
                Gson.a(object.a, d2);
                ((JsonWriter)object2).value(number);
            }
        }));
        bl7 = bl6;
        gson = this;
        object.add(TypeAdapters.newFactory(Float.TYPE, Float.class, bl7 ? TypeAdapters.FLOAT : new TypeAdapter<Number>(gson){
            private /* synthetic */ Gson a;
            {
                this.a = gson;
            }

            @Override
            public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return Float.valueOf((float)jsonReader.nextDouble());
            }

            @Override
            public final /* synthetic */ void write(JsonWriter object, Object object2) throws IOException {
                Number number = (Number)object2;
                object2 = object;
                object = this;
                if (number == null) {
                    ((JsonWriter)object2).nullValue();
                    return;
                }
                float f = number.floatValue();
                Gson.a(object.a, f);
                ((JsonWriter)object2).value(number);
            }
        }));
        object.add(TypeAdapters.NUMBER_FACTORY);
        object.add(TypeAdapters.CHARACTER_FACTORY);
        object.add(TypeAdapters.STRING_BUILDER_FACTORY);
        object.add(TypeAdapters.STRING_BUFFER_FACTORY);
        object.add(TypeAdapters.newFactory(BigDecimal.class, TypeAdapters.BIG_DECIMAL));
        object.add(TypeAdapters.newFactory(BigInteger.class, TypeAdapters.BIG_INTEGER));
        object.add(TypeAdapters.URL_FACTORY);
        object.add(TypeAdapters.URI_FACTORY);
        object.add(TypeAdapters.UUID_FACTORY);
        object.add(TypeAdapters.LOCALE_FACTORY);
        object.add(TypeAdapters.INET_ADDRESS_FACTORY);
        object.add(TypeAdapters.BIT_SET_FACTORY);
        object.add(DateTypeAdapter.FACTORY);
        object.add(TypeAdapters.CALENDAR_FACTORY);
        object.add(TimeTypeAdapter.FACTORY);
        object.add(SqlDateTypeAdapter.FACTORY);
        object.add(TypeAdapters.TIMESTAMP_FACTORY);
        object.add(ArrayTypeAdapter.FACTORY);
        object.add(TypeAdapters.ENUM_FACTORY);
        object.add(TypeAdapters.CLASS_FACTORY);
        object.add(excluder);
        object.add(new CollectionTypeAdapterFactory(this.f));
        object.add(new MapTypeAdapterFactory(this.f, bl2));
        object.add(new ReflectiveTypeAdapterFactory(this.f, fieldNamingStrategy, excluder));
        this.e = Collections.unmodifiableList(object);
    }

    public final <T> TypeAdapter<T> getAdapter(TypeToken<T> typeToken) {
        Object object = this.d.get(typeToken);
        if (object != null) {
            return object;
        }
        object = this.c.get();
        TypeAdapter a2 = object.get(typeToken);
        if (a2 != null) {
            return a2;
        }
        a2 = new a();
        object.put(typeToken, a2);
        try {
            for (TypeAdapterFactory typeAdapterFactory : this.e) {
                TypeAdapter<T> object2 = typeAdapterFactory.create(this, typeToken);
                if (object2 == null) continue;
                a2.a(object2);
                this.d.put(typeToken, object2);
                a2 = object2;
                return a2;
            }
            throw new IllegalArgumentException("GSON cannot handle " + typeToken);
        }
        finally {
            object.remove(typeToken);
        }
    }

    public final <T> TypeAdapter<T> getDelegateAdapter(TypeAdapterFactory typeAdapterFactory, TypeToken<T> typeToken) {
        boolean bl = false;
        for (TypeAdapterFactory typeAdapterFactory2 : this.e) {
            if (!bl) {
                if (typeAdapterFactory2 != typeAdapterFactory) continue;
                bl = true;
                continue;
            }
            TypeAdapter<T> typeAdapter = typeAdapterFactory2.create(this, typeToken);
            if (typeAdapter == null) continue;
            return typeAdapter;
        }
        throw new IllegalArgumentException("GSON cannot serialize " + typeToken);
    }

    public final <T> TypeAdapter<T> getAdapter(Class<T> clazz) {
        return this.getAdapter(TypeToken.get(clazz));
    }

    public final JsonElement toJsonTree(Object object) {
        if (object == null) {
            return JsonNull.INSTANCE;
        }
        return this.toJsonTree(object, object.getClass());
    }

    public final JsonElement toJsonTree(Object object, Type type) {
        JsonTreeWriter jsonTreeWriter = new JsonTreeWriter();
        this.toJson(object, type, jsonTreeWriter);
        return jsonTreeWriter.get();
    }

    public final String toJson(Object object) {
        if (object == null) {
            return this.toJson(JsonNull.INSTANCE);
        }
        return this.toJson(object, object.getClass());
    }

    public final String toJson(Object object, Type type) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(object, type, stringWriter);
        return stringWriter.toString();
    }

    public final void toJson(Object object, Appendable appendable) throws JsonIOException {
        if (object != null) {
            this.toJson(object, object.getClass(), appendable);
            return;
        }
        this.toJson((JsonElement)JsonNull.INSTANCE, appendable);
    }

    public final void toJson(Object object, Type type, Appendable object2) throws JsonIOException {
        try {
            object2 = this.a(Streams.writerForAppendable((Appendable)object2));
            this.toJson(object, type, (JsonWriter)object2);
            return;
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public final void toJson(Object object, Type object2, JsonWriter jsonWriter) throws JsonIOException {
        object2 = this.getAdapter(TypeToken.get((Type)object2));
        boolean bl = jsonWriter.isLenient();
        jsonWriter.setLenient(true);
        boolean bl2 = jsonWriter.isHtmlSafe();
        jsonWriter.setHtmlSafe(this.h);
        boolean bl3 = jsonWriter.getSerializeNulls();
        jsonWriter.setSerializeNulls(this.g);
        try {
            ((TypeAdapter)object2).write(jsonWriter, object);
            return;
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        finally {
            jsonWriter.setLenient(bl);
            jsonWriter.setHtmlSafe(bl2);
            jsonWriter.setSerializeNulls(bl3);
        }
    }

    public final String toJson(JsonElement jsonElement) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(jsonElement, (Appendable)stringWriter);
        return stringWriter.toString();
    }

    public final void toJson(JsonElement jsonElement, Appendable object) throws JsonIOException {
        try {
            object = this.a(Streams.writerForAppendable((Appendable)object));
            this.toJson(jsonElement, (JsonWriter)object);
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private JsonWriter a(Writer closeable) throws IOException {
        if (this.i) {
            ((Writer)closeable).write(")]}'\n");
        }
        closeable = new JsonWriter((Writer)closeable);
        if (this.j) {
            ((JsonWriter)closeable).setIndent("  ");
        }
        ((JsonWriter)closeable).setSerializeNulls(this.g);
        return closeable;
    }

    public final void toJson(JsonElement jsonElement, JsonWriter jsonWriter) throws JsonIOException {
        boolean bl = jsonWriter.isLenient();
        jsonWriter.setLenient(true);
        boolean bl2 = jsonWriter.isHtmlSafe();
        jsonWriter.setHtmlSafe(this.h);
        boolean bl3 = jsonWriter.getSerializeNulls();
        jsonWriter.setSerializeNulls(this.g);
        try {
            Streams.write(jsonElement, jsonWriter);
            return;
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        finally {
            jsonWriter.setLenient(bl);
            jsonWriter.setHtmlSafe(bl2);
            jsonWriter.setSerializeNulls(bl3);
        }
    }

    public final <T> T fromJson(String string, Class<T> clazz) throws JsonSyntaxException {
        string = this.fromJson(string, (Type)clazz);
        return Primitives.wrap(clazz).cast(string);
    }

    public final <T> T fromJson(String object, Type type) throws JsonSyntaxException {
        if (object == null) {
            return null;
        }
        object = new StringReader((String)object);
        object = this.fromJson((Reader)object, type);
        return (T)object;
    }

    public final <T> T fromJson(Reader closeable, Class<T> clazz) throws JsonSyntaxException, JsonIOException {
        closeable = new JsonReader((Reader)closeable);
        T t = this.fromJson((JsonReader)closeable, clazz);
        Gson.a(t, (JsonReader)closeable);
        return Primitives.wrap(clazz).cast(t);
    }

    public final <T> T fromJson(Reader closeable, Type type) throws JsonIOException, JsonSyntaxException {
        closeable = new JsonReader((Reader)closeable);
        type = this.fromJson((JsonReader)closeable, type);
        Gson.a(type, (JsonReader)closeable);
        return (T)type;
    }

    private static void a(Object object, JsonReader jsonReader) {
        try {
            if (object != null && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonIOException("JSON document was not fully consumed.");
            }
            return;
        }
        catch (MalformedJsonException malformedJsonException) {
            throw new JsonSyntaxException(malformedJsonException);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public final <T> T fromJson(JsonReader jsonReader, Type object) throws JsonIOException, JsonSyntaxException {
        boolean bl = true;
        boolean bl2 = jsonReader.isLenient();
        jsonReader.setLenient(true);
        try {
            jsonReader.peek();
            bl = false;
            object = this.getAdapter(TypeToken.get((Type)object));
            object = ((TypeAdapter)object).read(jsonReader);
            return (T)object;
        }
        catch (EOFException eOFException) {
            if (bl) {
                return null;
            }
            throw new JsonSyntaxException(eOFException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new JsonSyntaxException(illegalStateException);
        }
        catch (IOException iOException) {
            throw new JsonSyntaxException(iOException);
        }
        finally {
            jsonReader.setLenient(bl2);
        }
    }

    public final <T> T fromJson(JsonElement jsonElement, Class<T> clazz) throws JsonSyntaxException {
        jsonElement = this.fromJson(jsonElement, (Type)clazz);
        return Primitives.wrap(clazz).cast(jsonElement);
    }

    public final <T> T fromJson(JsonElement jsonElement, Type type) throws JsonSyntaxException {
        if (jsonElement == null) {
            return null;
        }
        return this.fromJson(new JsonTreeReader(jsonElement), type);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("{serializeNulls:").append(this.g).append("factories:").append(this.e).append(",instanceCreators:").append(this.f).append("}");
        return stringBuilder.toString();
    }

    static /* synthetic */ void a(Gson gson, double d2) {
        double d3 = d2;
        if (Double.isNaN(d3) || Double.isInfinite(d3)) {
            throw new IllegalArgumentException(d3 + " is not a valid double value as per JSON specification. To override this behavior, use GsonBuilder.serializeSpecialDoubleValues() method.");
        }
    }

    static final class a<T>
    extends TypeAdapter<T> {
        private TypeAdapter<T> a;

        a() {
        }

        public final void a(TypeAdapter<T> typeAdapter) {
            if (this.a != null) {
                throw new AssertionError();
            }
            this.a = typeAdapter;
        }

        @Override
        public final T read(JsonReader jsonReader) throws IOException {
            if (this.a == null) {
                throw new IllegalStateException();
            }
            return this.a.read(jsonReader);
        }

        @Override
        public final void write(JsonWriter jsonWriter, T t) throws IOException {
            if (this.a == null) {
                throw new IllegalStateException();
            }
            this.a.write(jsonWriter, t);
        }
    }
}

