/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.internal.bind.JsonTreeWriter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public abstract class TypeAdapter<T> {
    public abstract void write(JsonWriter var1, T var2) throws IOException;

    public final void toJson(Writer closeable, T t) throws IOException {
        closeable = new JsonWriter((Writer)closeable);
        this.write((JsonWriter)closeable, t);
    }

    public final TypeAdapter<T> nullSafe() {
        return new TypeAdapter<T>(this){
            private /* synthetic */ TypeAdapter a;
            {
                this.a = typeAdapter;
            }

            @Override
            public final void write(JsonWriter jsonWriter, T t) throws IOException {
                if (t == null) {
                    jsonWriter.nullValue();
                    return;
                }
                this.a.write(jsonWriter, t);
            }

            @Override
            public final T read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return this.a.read(jsonReader);
            }
        };
    }

    public final String toJson(T t) throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.toJson(stringWriter, t);
        return stringWriter.toString();
    }

    public final JsonElement toJsonTree(T t) {
        try {
            JsonTreeWriter jsonTreeWriter = new JsonTreeWriter();
            this.write(jsonTreeWriter, t);
            return jsonTreeWriter.get();
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public abstract T read(JsonReader var1) throws IOException;

    public final T fromJson(Reader closeable) throws IOException {
        closeable = new JsonReader((Reader)closeable);
        return this.read((JsonReader)closeable);
    }

    public final T fromJson(String string) throws IOException {
        return this.fromJson(new StringReader(string));
    }

    public final T fromJsonTree(JsonElement object) {
        try {
            object = new JsonTreeReader((JsonElement)object);
            return this.read((JsonReader)object);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }
}

