/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.internal.$Gson$Preconditions;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;

public final class $Gson$Types {
    static final Type[] a = new Type[0];

    private $Gson$Types() {
    }

    public static ParameterizedType newParameterizedTypeWithOwner(Type type, Type type2, Type ... typeArray) {
        return new b(type, type2, typeArray);
    }

    public static GenericArrayType arrayOf(Type type) {
        return new a(type);
    }

    public static WildcardType subtypeOf(Type type) {
        return new c(new Type[]{type}, a);
    }

    public static WildcardType supertypeOf(Type type) {
        return new c(new Type[]{Object.class}, new Type[]{type});
    }

    public static Type canonicalize(Type type) {
        if (type instanceof Class) {
            return ((Class)(type = (Class)type)).isArray() ? new a($Gson$Types.canonicalize(((Class)type).getComponentType())) : type;
        }
        if (type instanceof ParameterizedType) {
            type = (ParameterizedType)type;
            return new b(type.getOwnerType(), type.getRawType(), type.getActualTypeArguments());
        }
        if (type instanceof GenericArrayType) {
            type = (GenericArrayType)type;
            return new a(type.getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            type = (WildcardType)type;
            return new c(type.getUpperBounds(), type.getLowerBounds());
        }
        return type;
    }

    public static Class<?> getRawType(Type type) {
        while (true) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                type = parameterizedType.getRawType();
                $Gson$Preconditions.checkArgument(type instanceof Class);
                return (Class)type;
            }
            if (type instanceof GenericArrayType) {
                Type type2 = ((GenericArrayType)type).getGenericComponentType();
                return Array.newInstance($Gson$Types.getRawType(type2), 0).getClass();
            }
            if (type instanceof TypeVariable) {
                return Object.class;
            }
            if (!(type instanceof WildcardType)) break;
            type = ((WildcardType)type).getUpperBounds()[0];
        }
        String string = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + string);
    }

    public static boolean equals(Type type, Type type2) {
        while (true) {
            if (type == type2) {
                return true;
            }
            if (type instanceof Class) {
                return type.equals(type2);
            }
            if (type instanceof ParameterizedType) {
                if (!(type2 instanceof ParameterizedType)) {
                    return false;
                }
                type = (ParameterizedType)type;
                type2 = (ParameterizedType)type2;
                Type type3 = type2.getOwnerType();
                Type type4 = type.getOwnerType();
                return (type4 == type3 || type4 != null && type4.equals(type3)) && type.getRawType().equals(type2.getRawType()) && Arrays.equals(type.getActualTypeArguments(), type2.getActualTypeArguments());
            }
            if (!(type instanceof GenericArrayType)) break;
            if (!(type2 instanceof GenericArrayType)) {
                return false;
            }
            type = (GenericArrayType)type;
            type2 = (GenericArrayType)type2;
            type2 = type2.getGenericComponentType();
            type = type.getGenericComponentType();
        }
        if (type instanceof WildcardType) {
            if (!(type2 instanceof WildcardType)) {
                return false;
            }
            type = (WildcardType)type;
            type2 = (WildcardType)type2;
            return Arrays.equals(type.getUpperBounds(), type2.getUpperBounds()) && Arrays.equals(type.getLowerBounds(), type2.getLowerBounds());
        }
        if (type instanceof TypeVariable) {
            if (!(type2 instanceof TypeVariable)) {
                return false;
            }
            type = (TypeVariable)type;
            type2 = (TypeVariable)type2;
            return type.getGenericDeclaration() == type2.getGenericDeclaration() && type.getName().equals(type2.getName());
        }
        return false;
    }

    public static String typeToString(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        return type.toString();
    }

    private static Type a(Type object, Class<?> object2, Class<?> clazz) {
        block0: while (true) {
            if (clazz == object2) {
                return object;
            }
            if (clazz.isInterface()) {
                object = ((Class)object2).getInterfaces();
                int n = ((Class<?>[])object).length;
                for (int i = 0; i < n; ++i) {
                    if (object[i] == clazz) {
                        return ((Class)object2).getGenericInterfaces()[i];
                    }
                    if (!clazz.isAssignableFrom(object[i])) continue;
                    Type type = ((Class)object2).getGenericInterfaces()[i];
                    object2 = object[i];
                    object = type;
                    continue block0;
                }
            }
            if (((Class)object2).isInterface()) break;
            while (object2 != Object.class) {
                object = ((Class)object2).getSuperclass();
                if (object == clazz) {
                    return ((Class)object2).getGenericSuperclass();
                }
                if (clazz.isAssignableFrom((Class<?>)object)) {
                    Type type = ((Class)object2).getGenericSuperclass();
                    object2 = object;
                    object = type;
                    continue block0;
                }
                object2 = object;
            }
            break;
        }
        return clazz;
    }

    private static Type b(Type type, Class<?> clazz, Class<?> clazz2) {
        $Gson$Preconditions.checkArgument(clazz2.isAssignableFrom(clazz));
        return $Gson$Types.resolve(type, clazz, $Gson$Types.a(type, clazz, clazz2));
    }

    public static Type getArrayComponentType(Type type) {
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        return ((Class)type).getComponentType();
    }

    public static Type getCollectionElementType(Type type, Class<?> clazz) {
        if ((type = $Gson$Types.b(type, clazz, Collection.class)) instanceof WildcardType) {
            type = ((WildcardType)type).getUpperBounds()[0];
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    public static Type[] getMapKeyAndValueTypes(Type type, Class<?> clazz) {
        if (type == Properties.class) {
            return new Type[]{String.class, String.class};
        }
        if ((type = $Gson$Types.b(type, clazz, Map.class)) instanceof ParameterizedType) {
            type = (ParameterizedType)type;
            return type.getActualTypeArguments();
        }
        return new Type[]{Object.class, Object.class};
    }

    public static Type resolve(Type type, Class<?> clazz, Type typeArray) {
        Type type2;
        Type type3;
        while (typeArray instanceof TypeVariable) {
            Type type4;
            type3 = (TypeVariable)typeArray;
            type2 = type3;
            Class<?> clazz2 = clazz;
            typeArray = type;
            Type type5 = type2;
            Object object = type5.getGenericDeclaration();
            type5 = object instanceof Class ? (Class)object : null;
            if (type5 != null && (typeArray = $Gson$Types.a((Type)typeArray, clazz2, type5)) instanceof ParameterizedType) {
                int n;
                block18: {
                    object = type2;
                    type5 = ((Class)type5).getTypeParameters();
                    for (n = 0; n < ((Type)type5).length; ++n) {
                        if (!object.equals(type5[n])) {
                            continue;
                        }
                        break block18;
                    }
                    throw new NoSuchElementException();
                }
                type4 = ((ParameterizedType)typeArray).getActualTypeArguments()[n];
            } else {
                type4 = typeArray = type2;
            }
            if (type4 != type3) continue;
            return typeArray;
        }
        if (typeArray instanceof Class && ((Class)typeArray).isArray()) {
            Type type6;
            type3 = (Class)typeArray;
            if ((typeArray = ((Class)type3).getComponentType()) == (type6 = $Gson$Types.resolve(type, clazz, typeArray))) {
                return type3;
            }
            return $Gson$Types.arrayOf(type6);
        }
        if (typeArray instanceof GenericArrayType) {
            Type type7;
            type3 = (GenericArrayType)typeArray;
            if ((typeArray = type3.getGenericComponentType()) == (type7 = $Gson$Types.resolve(type, clazz, typeArray))) {
                return type3;
            }
            return $Gson$Types.arrayOf(type7);
        }
        if (typeArray instanceof ParameterizedType) {
            type3 = (ParameterizedType)typeArray;
            Type type8 = $Gson$Types.resolve(type, clazz, typeArray = type3.getOwnerType());
            boolean bl = type8 != typeArray;
            typeArray = type3.getActualTypeArguments();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type9 = $Gson$Types.resolve(type, clazz, typeArray[i]);
                if (type9 == typeArray[i]) continue;
                if (!bl) {
                    typeArray = (Type[])typeArray.clone();
                    bl = true;
                }
                typeArray[i] = type9;
            }
            if (bl) {
                return $Gson$Types.newParameterizedTypeWithOwner(type8, type3.getRawType(), typeArray);
            }
            return type3;
        }
        if (typeArray instanceof WildcardType) {
            type3 = (WildcardType)typeArray;
            typeArray = type3.getLowerBounds();
            Type[] typeArray2 = type3.getUpperBounds();
            if (typeArray.length == 1) {
                type2 = $Gson$Types.resolve(type, clazz, typeArray[0]);
                if (type2 != typeArray[0]) {
                    return $Gson$Types.supertypeOf(type2);
                }
            } else if (typeArray2.length == 1 && (type2 = $Gson$Types.resolve(type, clazz, typeArray2[0])) != typeArray2[0]) {
                return $Gson$Types.subtypeOf(type2);
            }
            return type3;
        }
        return typeArray;
    }

    static /* synthetic */ void a(Type type) {
        $Gson$Preconditions.checkArgument(!(type instanceof Class) || !((Class)type).isPrimitive());
    }

    static /* synthetic */ int a(Object object) {
        if (object != null) {
            return object.hashCode();
        }
        return 0;
    }

    static final class c
    implements Serializable,
    WildcardType {
        private final Type upperBound;
        private final Type lowerBound;
        private static final long serialVersionUID = 0L;

        public c(Type[] typeArray, Type[] typeArray2) {
            $Gson$Preconditions.checkArgument(typeArray2.length <= 1);
            $Gson$Preconditions.checkArgument(typeArray.length == 1);
            if (typeArray2.length == 1) {
                $Gson$Preconditions.checkNotNull(typeArray2[0]);
                $Gson$Types.a(typeArray2[0]);
                $Gson$Preconditions.checkArgument(typeArray[0] == Object.class);
                this.lowerBound = $Gson$Types.canonicalize(typeArray2[0]);
                this.upperBound = Object.class;
                return;
            }
            $Gson$Preconditions.checkNotNull(typeArray[0]);
            $Gson$Types.a(typeArray[0]);
            this.lowerBound = null;
            this.upperBound = $Gson$Types.canonicalize(typeArray[0]);
        }

        @Override
        public final Type[] getUpperBounds() {
            return new Type[]{this.upperBound};
        }

        @Override
        public final Type[] getLowerBounds() {
            if (this.lowerBound != null) {
                return new Type[]{this.lowerBound};
            }
            return a;
        }

        public final boolean equals(Object object) {
            return object instanceof WildcardType && $Gson$Types.equals(this, (WildcardType)object);
        }

        public final int hashCode() {
            return (this.lowerBound != null ? 31 + this.lowerBound.hashCode() : 1) ^ 31 + this.upperBound.hashCode();
        }

        public final String toString() {
            if (this.lowerBound != null) {
                return "? super " + $Gson$Types.typeToString(this.lowerBound);
            }
            if (this.upperBound == Object.class) {
                return "?";
            }
            return "? extends " + $Gson$Types.typeToString(this.upperBound);
        }
    }

    static final class a
    implements Serializable,
    GenericArrayType {
        private final Type componentType;
        private static final long serialVersionUID = 0L;

        public a(Type type) {
            this.componentType = $Gson$Types.canonicalize(type);
        }

        @Override
        public final Type getGenericComponentType() {
            return this.componentType;
        }

        public final boolean equals(Object object) {
            return object instanceof GenericArrayType && $Gson$Types.equals(this, (GenericArrayType)object);
        }

        public final int hashCode() {
            return this.componentType.hashCode();
        }

        public final String toString() {
            return $Gson$Types.typeToString(this.componentType) + "[]";
        }
    }

    static final class b
    implements Serializable,
    ParameterizedType {
        private final Type ownerType;
        private final Type rawType;
        private final Type[] typeArguments;
        private static final long serialVersionUID = 0L;

        public b(Type type, Type type2, Type ... typeArray) {
            if (type2 instanceof Class) {
                Class clazz = (Class)type2;
                $Gson$Preconditions.checkArgument(type != null || clazz.getEnclosingClass() == null);
                $Gson$Preconditions.checkArgument(type == null || clazz.getEnclosingClass() != null);
            }
            this.ownerType = type == null ? null : $Gson$Types.canonicalize(type);
            this.rawType = $Gson$Types.canonicalize(type2);
            this.typeArguments = (Type[])typeArray.clone();
            for (int i = 0; i < this.typeArguments.length; ++i) {
                $Gson$Preconditions.checkNotNull(this.typeArguments[i]);
                $Gson$Types.a(this.typeArguments[i]);
                this.typeArguments[i] = $Gson$Types.canonicalize(this.typeArguments[i]);
            }
        }

        @Override
        public final Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public final Type getRawType() {
            return this.rawType;
        }

        @Override
        public final Type getOwnerType() {
            return this.ownerType;
        }

        public final boolean equals(Object object) {
            return object instanceof ParameterizedType && $Gson$Types.equals(this, (ParameterizedType)object);
        }

        public final int hashCode() {
            return Arrays.hashCode(this.typeArguments) ^ this.rawType.hashCode() ^ $Gson$Types.a((Object)this.ownerType);
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder(30 * (this.typeArguments.length + 1));
            stringBuilder.append($Gson$Types.typeToString(this.rawType));
            if (this.typeArguments.length == 0) {
                return stringBuilder.toString();
            }
            stringBuilder.append("<").append($Gson$Types.typeToString(this.typeArguments[0]));
            for (int i = 1; i < this.typeArguments.length; ++i) {
                stringBuilder.append(", ").append($Gson$Types.typeToString(this.typeArguments[i]));
            }
            return stringBuilder.append(">").toString();
        }
    }
}

