/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import java.math.BigInteger;

public final class LazilyParsedNumber
extends Number {
    private final String value;

    public LazilyParsedNumber(String string) {
        this.value = string;
    }

    @Override
    public final int intValue() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return (int)Long.parseLong(this.value);
            }
            catch (NumberFormatException numberFormatException2) {
                return new BigInteger(this.value).intValue();
            }
        }
    }

    @Override
    public final long longValue() {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            return new BigInteger(this.value).longValue();
        }
    }

    @Override
    public final float floatValue() {
        return Float.parseFloat(this.value);
    }

    @Override
    public final double doubleValue() {
        return Double.parseDouble(this.value);
    }

    public final String toString() {
        return this.value;
    }
}

