/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.bind.a;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class ArrayTypeAdapter<E>
extends TypeAdapter<Object> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> object) {
            if (!((object = ((TypeToken)object).getType()) instanceof GenericArrayType || object instanceof Class && ((Class)object).isArray())) {
                return null;
            }
            object = $Gson$Types.getArrayComponentType((Type)object);
            TypeAdapter<?> typeAdapter = gson.getAdapter(TypeToken.get((Type)object));
            return new ArrayTypeAdapter(gson, typeAdapter, $Gson$Types.getRawType((Type)object));
        }
    };
    private final Class<E> a;
    private final TypeAdapter<E> b;

    public ArrayTypeAdapter(Gson gson, TypeAdapter<E> typeAdapter, Class<E> clazz) {
        this.b = new a<E>(gson, typeAdapter, clazz);
        this.a = clazz;
    }

    @Override
    public final Object read(JsonReader jsonReader) throws IOException {
        Object object;
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        ArrayList<E> arrayList = new ArrayList<E>();
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            object = this.b.read(jsonReader);
            arrayList.add(object);
        }
        jsonReader.endArray();
        object = Array.newInstance(this.a, arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            Array.set(object, i, arrayList.get(i));
        }
        return object;
    }

    @Override
    public final void write(JsonWriter jsonWriter, Object object) throws IOException {
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        jsonWriter.beginArray();
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            this.b.write(jsonWriter, object2);
        }
        jsonWriter.endArray();
    }
}

