/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.StringMap;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class ObjectTypeAdapter
extends TypeAdapter<Object> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (typeToken.getRawType() == Object.class) {
                return new ObjectTypeAdapter(gson, 0);
            }
            return null;
        }
    };
    private final Gson a;

    private ObjectTypeAdapter(Gson gson) {
        this.a = gson;
    }

    @Override
    public final Object read(JsonReader jsonReader) throws IOException {
        Object object = jsonReader.peek();
        switch (2.a[((Enum)object).ordinal()]) {
            case 1: {
                object = new ArrayList();
                jsonReader.beginArray();
                while (jsonReader.hasNext()) {
                    object.add(this.read(jsonReader));
                }
                jsonReader.endArray();
                return object;
            }
            case 2: {
                object = new StringMap();
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    object.put(jsonReader.nextName(), this.read(jsonReader));
                }
                jsonReader.endObject();
                return object;
            }
            case 3: {
                return jsonReader.nextString();
            }
            case 4: {
                return jsonReader.nextDouble();
            }
            case 5: {
                return jsonReader.nextBoolean();
            }
            case 6: {
                jsonReader.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public final void write(JsonWriter jsonWriter, Object object) throws IOException {
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        TypeAdapter<?> typeAdapter = this.a.getAdapter(object.getClass());
        if (typeAdapter instanceof ObjectTypeAdapter) {
            jsonWriter.beginObject();
            jsonWriter.endObject();
            return;
        }
        typeAdapter.write(jsonWriter, object);
    }

    /* synthetic */ ObjectTypeAdapter(Gson gson, byte by) {
        this(gson);
    }

    static final class 2 {
        static final /* synthetic */ int[] a;

        static {
            a = new int[JsonToken.values().length];
            try {
                2.a[JsonToken.BEGIN_ARRAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                2.a[JsonToken.BEGIN_OBJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                2.a[JsonToken.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                2.a[JsonToken.NUMBER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                2.a[JsonToken.BOOLEAN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                2.a[JsonToken.NULL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

