/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;

public final class TypeAdapters {
    public static final TypeAdapter<Class> CLASS = new TypeAdapter<Class>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            throw new UnsupportedOperationException("Attempted to deserialize a java.eu.memshare.lang.Class. Forgot to register a type adapter?");
        }

        @Override
        public final /* synthetic */ void write(JsonWriter object, Object object2) throws IOException {
            object = (Class)object2;
            throw new UnsupportedOperationException("Attempted to serialize java.eu.memshare.lang.Class: " + ((Class)object).getName() + ". Forgot to register a type adapter?");
        }
    };
    public static final TypeAdapterFactory CLASS_FACTORY = TypeAdapters.newFactory(Class.class, CLASS);
    public static final TypeAdapter<BitSet> BIT_SET = new TypeAdapter<BitSet>(){

        private static BitSet a(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            BitSet bitSet = new BitSet();
            jsonReader.beginArray();
            int n = 0;
            JsonToken jsonToken = jsonReader.peek();
            while (jsonToken != JsonToken.END_ARRAY) {
                boolean bl;
                switch (jsonToken) {
                    case NUMBER: {
                        bl = jsonReader.nextInt() != 0;
                        break;
                    }
                    case BOOLEAN: {
                        bl = jsonReader.nextBoolean();
                        break;
                    }
                    case STRING: {
                        String string = jsonReader.nextString();
                        try {
                            bl = Integer.parseInt(string) != 0;
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new JsonSyntaxException("Error: Expecting: bitset number value (1, 0), Found: " + string);
                        }
                    }
                    default: {
                        throw new JsonSyntaxException("Invalid bitset value type: " + (Object)((Object)jsonToken));
                    }
                }
                if (bl) {
                    bitSet.set(n);
                }
                ++n;
                jsonToken = jsonReader.peek();
            }
            jsonReader.endArray();
            return bitSet;
        }

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            return 12.a(jsonReader);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            if ((object = (BitSet)object) == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.beginArray();
            for (int i = 0; i < ((BitSet)object).length(); ++i) {
                int n = ((BitSet)object).get(i) ? 1 : 0;
                jsonWriter.value(n);
            }
            jsonWriter.endArray();
        }
    };
    public static final TypeAdapterFactory BIT_SET_FACTORY = TypeAdapters.newFactory(BitSet.class, BIT_SET);
    public static final TypeAdapter<Boolean> BOOLEAN = new TypeAdapter<Boolean>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            if (jsonReader.peek() == JsonToken.STRING) {
                return Boolean.parseBoolean(jsonReader.nextString());
            }
            return jsonReader.nextBoolean();
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            if ((object = (Boolean)object) == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.value((Boolean)object);
        }
    };
    public static final TypeAdapter<Boolean> BOOLEAN_AS_STRING = new TypeAdapter<Boolean>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return Boolean.valueOf(jsonReader.nextString());
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            jsonWriter.value((object = (Boolean)object) == null ? "null" : ((Boolean)object).toString());
        }
    };
    public static final TypeAdapterFactory BOOLEAN_FACTORY = TypeAdapters.newFactory(Boolean.TYPE, Boolean.class, BOOLEAN);
    public static final TypeAdapter<Number> BYTE = new TypeAdapter<Number>(){

        private static Number a(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                int n = jsonReader.nextInt();
                return (byte)n;
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
        }

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            return 28.a(jsonReader);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            object = (Number)object;
            jsonWriter.value((Number)object);
        }
    };
    public static final TypeAdapterFactory BYTE_FACTORY = TypeAdapters.newFactory(Byte.TYPE, Byte.class, BYTE);
    public static final TypeAdapter<Number> SHORT = new TypeAdapter<Number>(){

        private static Number a(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                return (short)jsonReader.nextInt();
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
        }

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            return 29.a(jsonReader);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            object = (Number)object;
            jsonWriter.value((Number)object);
        }
    };
    public static final TypeAdapterFactory SHORT_FACTORY = TypeAdapters.newFactory(Short.TYPE, Short.class, SHORT);
    public static final TypeAdapter<Number> INTEGER = new TypeAdapter<Number>(){

        private static Number a(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                return jsonReader.nextInt();
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
        }

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            return 30.a(jsonReader);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            object = (Number)object;
            jsonWriter.value((Number)object);
        }
    };
    public static final TypeAdapterFactory INTEGER_FACTORY = TypeAdapters.newFactory(Integer.TYPE, Integer.class, INTEGER);
    public static final TypeAdapter<Number> LONG = new TypeAdapter<Number>(){

        private static Number a(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                return jsonReader.nextLong();
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
        }

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            return 31.a(jsonReader);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            object = (Number)object;
            jsonWriter.value((Number)object);
        }
    };
    public static final TypeAdapter<Number> FLOAT = new TypeAdapter<Number>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return Float.valueOf((float)jsonReader.nextDouble());
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            object = (Number)object;
            jsonWriter.value((Number)object);
        }
    };
    public static final TypeAdapter<Number> DOUBLE = new TypeAdapter<Number>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return jsonReader.nextDouble();
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            object = (Number)object;
            jsonWriter.value((Number)object);
        }
    };
    public static final TypeAdapter<Number> NUMBER = new TypeAdapter<Number>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            JsonToken jsonToken = jsonReader.peek();
            switch (jsonToken) {
                case NULL: {
                    jsonReader.nextNull();
                    return null;
                }
                case NUMBER: {
                    return new LazilyParsedNumber(jsonReader.nextString());
                }
            }
            throw new JsonSyntaxException("Expecting number, got: " + (Object)((Object)jsonToken));
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            object = (Number)object;
            jsonWriter.value((Number)object);
        }
    };
    public static final TypeAdapterFactory NUMBER_FACTORY = TypeAdapters.newFactory(Number.class, NUMBER);
    public static final TypeAdapter<Character> CHARACTER = new TypeAdapter<Character>(){

        @Override
        public final /* synthetic */ Object read(JsonReader object) throws IOException {
            if (((JsonReader)object).peek() == JsonToken.NULL) {
                ((JsonReader)object).nextNull();
                return null;
            }
            if (((String)(object = ((JsonReader)object).nextString())).length() != 1) {
                throw new JsonSyntaxException("Expecting character, got: " + (String)object);
            }
            return Character.valueOf(((String)object).charAt(0));
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            jsonWriter.value((object = (Character)object) == null ? null : String.valueOf(object));
        }
    };
    public static final TypeAdapterFactory CHARACTER_FACTORY = TypeAdapters.newFactory(Character.TYPE, Character.class, CHARACTER);
    public static final TypeAdapter<String> STRING = new TypeAdapter<String>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            JsonToken jsonToken = jsonReader.peek();
            if (jsonToken == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            if (jsonToken == JsonToken.BOOLEAN) {
                return Boolean.toString(jsonReader.nextBoolean());
            }
            return jsonReader.nextString();
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            object = (String)object;
            jsonWriter.value((String)object);
        }
    };
    public static final TypeAdapter<BigDecimal> BIG_DECIMAL = new TypeAdapter<BigDecimal>(){

        private static BigDecimal a(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                return new BigDecimal(jsonReader.nextString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
        }

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            return 6.a(jsonReader);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            object = (BigDecimal)object;
            jsonWriter.value((Number)object);
        }
    };
    public static final TypeAdapter<BigInteger> BIG_INTEGER = new TypeAdapter<BigInteger>(){

        private static BigInteger a(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                return new BigInteger(jsonReader.nextString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
        }

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            return 7.a(jsonReader);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            object = (BigInteger)object;
            jsonWriter.value((Number)object);
        }
    };
    public static final TypeAdapterFactory STRING_FACTORY = TypeAdapters.newFactory(String.class, STRING);
    public static final TypeAdapter<StringBuilder> STRING_BUILDER = new TypeAdapter<StringBuilder>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return new StringBuilder(jsonReader.nextString());
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            jsonWriter.value((object = (StringBuilder)object) == null ? null : ((StringBuilder)object).toString());
        }
    };
    public static final TypeAdapterFactory STRING_BUILDER_FACTORY = TypeAdapters.newFactory(StringBuilder.class, STRING_BUILDER);
    public static final TypeAdapter<StringBuffer> STRING_BUFFER = new TypeAdapter<StringBuffer>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return new StringBuffer(jsonReader.nextString());
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            jsonWriter.value((object = (StringBuffer)object) == null ? null : ((StringBuffer)object).toString());
        }
    };
    public static final TypeAdapterFactory STRING_BUFFER_FACTORY = TypeAdapters.newFactory(StringBuffer.class, STRING_BUFFER);
    public static final TypeAdapter<URL> URL = new TypeAdapter<URL>(){

        @Override
        public final /* synthetic */ Object read(JsonReader object) throws IOException {
            if (((JsonReader)object).peek() == JsonToken.NULL) {
                ((JsonReader)object).nextNull();
                return null;
            }
            if ("null".equals(object = ((JsonReader)object).nextString())) {
                return null;
            }
            return new URL((String)object);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            jsonWriter.value((object = (URL)object) == null ? null : ((URL)object).toExternalForm());
        }
    };
    public static final TypeAdapterFactory URL_FACTORY = TypeAdapters.newFactory(URL.class, URL);
    public static final TypeAdapter<URI> URI = new TypeAdapter<URI>(){

        private static URI a(JsonReader object) throws IOException {
            if (((JsonReader)object).peek() == JsonToken.NULL) {
                ((JsonReader)object).nextNull();
                return null;
            }
            try {
                object = ((JsonReader)object).nextString();
                if ("null".equals(object)) {
                    return null;
                }
                return new URI((String)object);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new JsonIOException(uRISyntaxException);
            }
        }

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            return 11.a(jsonReader);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            jsonWriter.value((object = (URI)object) == null ? null : ((URI)object).toASCIIString());
        }
    };
    public static final TypeAdapterFactory URI_FACTORY = TypeAdapters.newFactory(URI.class, URI);
    public static final TypeAdapter<InetAddress> INET_ADDRESS = new TypeAdapter<InetAddress>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return InetAddress.getByName(jsonReader.nextString());
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            jsonWriter.value((object = (InetAddress)object) == null ? null : ((InetAddress)object).getHostAddress());
        }
    };
    public static final TypeAdapterFactory INET_ADDRESS_FACTORY = TypeAdapters.newTypeHierarchyFactory(InetAddress.class, INET_ADDRESS);
    public static final TypeAdapter<UUID> UUID = new TypeAdapter<UUID>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return java.util.UUID.fromString(jsonReader.nextString());
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            jsonWriter.value((object = (UUID)object) == null ? null : ((UUID)object).toString());
        }
    };
    public static final TypeAdapterFactory UUID_FACTORY = TypeAdapters.newFactory(UUID.class, UUID);
    public static final TypeAdapterFactory TIMESTAMP_FACTORY = new TypeAdapterFactory(){

        @Override
        public final <T> TypeAdapter<T> create(Gson object, TypeToken<T> typeToken) {
            if (typeToken.getRawType() != Timestamp.class) {
                return null;
            }
            object = ((Gson)object).getAdapter(Date.class);
            return new TypeAdapter<Timestamp>(this, (TypeAdapter)object){
                private /* synthetic */ TypeAdapter a;
                {
                    this.a = typeAdapter;
                }

                @Override
                public final /* synthetic */ Object read(JsonReader object) throws IOException {
                    JsonReader jsonReader = object;
                    object = this;
                    object = (Date)object.a.read(jsonReader);
                    if (object != null) {
                        return new Timestamp(((Date)object).getTime());
                    }
                    return null;
                }
            };
        }
    };
    public static final TypeAdapter<Calendar> CALENDAR = new TypeAdapter<Calendar>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            jsonReader.beginObject();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (jsonReader.peek() != JsonToken.END_OBJECT) {
                String string = jsonReader.nextName();
                int n7 = jsonReader.nextInt();
                if ("year".equals(string)) {
                    n = n7;
                    continue;
                }
                if ("month".equals(string)) {
                    n2 = n7;
                    continue;
                }
                if ("dayOfMonth".equals(string)) {
                    n3 = n7;
                    continue;
                }
                if ("hourOfDay".equals(string)) {
                    n4 = n7;
                    continue;
                }
                if ("minute".equals(string)) {
                    n5 = n7;
                    continue;
                }
                if (!"second".equals(string)) continue;
                n6 = n7;
            }
            jsonReader.endObject();
            return new GregorianCalendar(n, n2, n3, n4, n5, n6);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            if ((object = (Calendar)object) == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.beginObject();
            jsonWriter.name("year");
            jsonWriter.value(((Calendar)object).get(1));
            jsonWriter.name("month");
            jsonWriter.value(((Calendar)object).get(2));
            jsonWriter.name("dayOfMonth");
            jsonWriter.value(((Calendar)object).get(5));
            jsonWriter.name("hourOfDay");
            jsonWriter.value(((Calendar)object).get(11));
            jsonWriter.name("minute");
            jsonWriter.value(((Calendar)object).get(12));
            jsonWriter.name("second");
            jsonWriter.value(((Calendar)object).get(13));
            jsonWriter.endObject();
        }
    };
    public static final TypeAdapterFactory CALENDAR_FACTORY = TypeAdapters.newFactoryForMultipleTypes(Calendar.class, GregorianCalendar.class, CALENDAR);
    public static final TypeAdapter<Locale> LOCALE = new TypeAdapter<Locale>(){

        @Override
        public final /* synthetic */ Object read(JsonReader object) throws IOException {
            if (((JsonReader)object).peek() == JsonToken.NULL) {
                ((JsonReader)object).nextNull();
                return null;
            }
            object = ((JsonReader)object).nextString();
            object = new StringTokenizer((String)object, "_");
            String string = null;
            String string2 = null;
            String string3 = null;
            if (((StringTokenizer)object).hasMoreElements()) {
                string = ((StringTokenizer)object).nextToken();
            }
            if (((StringTokenizer)object).hasMoreElements()) {
                string2 = ((StringTokenizer)object).nextToken();
            }
            if (((StringTokenizer)object).hasMoreElements()) {
                string3 = ((StringTokenizer)object).nextToken();
            }
            if (string2 == null && string3 == null) {
                return new Locale(string);
            }
            if (string3 == null) {
                return new Locale(string, string2);
            }
            return new Locale(string, string2, string3);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            jsonWriter.value((object = (Locale)object) == null ? null : ((Locale)object).toString());
        }
    };
    public static final TypeAdapterFactory LOCALE_FACTORY = TypeAdapters.newFactory(Locale.class, LOCALE);
    public static final TypeAdapter<JsonElement> JSON_ELEMENT = new TypeAdapter<JsonElement>(){

        private JsonElement a(JsonReader object) throws IOException {
            switch (((JsonReader)object).peek()) {
                case STRING: {
                    return new JsonPrimitive(((JsonReader)object).nextString());
                }
                case NUMBER: {
                    object = ((JsonReader)object).nextString();
                    return new JsonPrimitive(new LazilyParsedNumber((String)object));
                }
                case BOOLEAN: {
                    return new JsonPrimitive(((JsonReader)object).nextBoolean());
                }
                case NULL: {
                    ((JsonReader)object).nextNull();
                    return JsonNull.INSTANCE;
                }
                case BEGIN_ARRAY: {
                    JsonArray jsonArray = new JsonArray();
                    ((JsonReader)object).beginArray();
                    while (((JsonReader)object).hasNext()) {
                        jsonArray.add(this.a((JsonReader)object));
                    }
                    ((JsonReader)object).endArray();
                    return jsonArray;
                }
                case BEGIN_OBJECT: {
                    JsonObject jsonObject = new JsonObject();
                    ((JsonReader)object).beginObject();
                    while (((JsonReader)object).hasNext()) {
                        jsonObject.add(((JsonReader)object).nextName(), this.a((JsonReader)object));
                    }
                    ((JsonReader)object).endObject();
                    return jsonObject;
                }
            }
            throw new IllegalArgumentException();
        }

        /*
         * Enabled aggressive block sorting
         */
        private void a(JsonWriter jsonWriter, JsonElement iterator) throws IOException {
            if (iterator == null || ((JsonElement)((Object)iterator)).isJsonNull()) {
                jsonWriter.nullValue();
                return;
            }
            if (((JsonElement)((Object)iterator)).isJsonPrimitive()) {
                if (((JsonPrimitive)((Object)(iterator = ((JsonElement)((Object)iterator)).getAsJsonPrimitive()))).isNumber()) {
                    jsonWriter.value(((JsonPrimitive)((Object)iterator)).getAsNumber());
                    return;
                }
                if (((JsonPrimitive)((Object)iterator)).isBoolean()) {
                    jsonWriter.value(((JsonPrimitive)((Object)iterator)).getAsBoolean());
                    return;
                }
                jsonWriter.value(((JsonPrimitive)((Object)iterator)).getAsString());
                return;
            }
            if (((JsonElement)((Object)iterator)).isJsonArray()) {
                jsonWriter.beginArray();
                iterator = ((JsonElement)((Object)iterator)).getAsJsonArray().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        jsonWriter.endArray();
                        return;
                    }
                    JsonElement jsonElement = iterator.next();
                    this.a(jsonWriter, jsonElement);
                }
            }
            if (!((JsonElement)((Object)iterator)).isJsonObject()) throw new IllegalArgumentException("Couldn't write " + iterator.getClass());
            jsonWriter.beginObject();
            iterator = ((JsonElement)((Object)iterator)).getAsJsonObject().entrySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    jsonWriter.endObject();
                    return;
                }
                Map.Entry entry = (Map.Entry)iterator.next();
                jsonWriter.name((String)entry.getKey());
                this.a(jsonWriter, (JsonElement)entry.getValue());
            }
        }

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
            return this.a(jsonReader);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
            this.a(jsonWriter, (JsonElement)object);
        }
    };
    public static final TypeAdapterFactory JSON_ELEMENT_FACTORY = TypeAdapters.newFactory(JsonElement.class, JSON_ELEMENT);
    public static final TypeAdapterFactory ENUM_FACTORY = TypeAdapters.newEnumTypeHierarchyFactory();

    private TypeAdapters() {
    }

    public static TypeAdapterFactory newEnumTypeHierarchyFactory() {
        return new TypeAdapterFactory(){

            @Override
            public final <T> TypeAdapter<T> create(Gson clazz, TypeToken<T> typeToken) {
                clazz = typeToken.getRawType();
                if (!Enum.class.isAssignableFrom(clazz) || clazz == Enum.class) {
                    return null;
                }
                if (!clazz.isEnum()) {
                    clazz = clazz.getSuperclass();
                }
                return new a(clazz);
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(TypeToken<TT> typeToken, TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(typeToken, typeAdapter){
            private /* synthetic */ TypeToken a;
            private /* synthetic */ TypeAdapter b;
            {
                this.a = typeToken;
                this.b = typeAdapter;
            }

            @Override
            public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                if (typeToken.equals(this.a)) {
                    return this.b;
                }
                return null;
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(Class<TT> clazz, TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(clazz, typeAdapter){
            private /* synthetic */ Class a;
            private /* synthetic */ TypeAdapter b;
            {
                this.a = clazz;
                this.b = typeAdapter;
            }

            @Override
            public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                if (typeToken.getRawType() == this.a) {
                    return this.b;
                }
                return null;
            }

            public final String toString() {
                return "Factory[type=" + this.a.getName() + ",adapter=" + this.b + "]";
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(Class<TT> clazz, Class<TT> clazz2, TypeAdapter<? super TT> typeAdapter) {
        return new TypeAdapterFactory(clazz, clazz2, typeAdapter){
            private /* synthetic */ Class a;
            private /* synthetic */ Class b;
            private /* synthetic */ TypeAdapter c;
            {
                this.a = clazz;
                this.b = clazz2;
                this.c = typeAdapter;
            }

            @Override
            public final <T> TypeAdapter<T> create(Gson clazz, TypeToken<T> typeToken) {
                clazz = typeToken.getRawType();
                if (clazz == this.a || clazz == this.b) {
                    return this.c;
                }
                return null;
            }

            public final String toString() {
                return "Factory[type=" + this.b.getName() + "+" + this.a.getName() + ",adapter=" + this.c + "]";
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactoryForMultipleTypes(Class<TT> clazz, Class<? extends TT> clazz2, TypeAdapter<? super TT> typeAdapter) {
        return new TypeAdapterFactory(clazz, clazz2, typeAdapter){
            private /* synthetic */ Class a;
            private /* synthetic */ Class b;
            private /* synthetic */ TypeAdapter c;
            {
                this.a = clazz;
                this.b = clazz2;
                this.c = typeAdapter;
            }

            @Override
            public final <T> TypeAdapter<T> create(Gson clazz, TypeToken<T> typeToken) {
                clazz = typeToken.getRawType();
                if (clazz == this.a || clazz == this.b) {
                    return this.c;
                }
                return null;
            }

            public final String toString() {
                return "Factory[type=" + this.a.getName() + "+" + this.b.getName() + ",adapter=" + this.c + "]";
            }
        };
    }

    public static <TT> TypeAdapterFactory newTypeHierarchyFactory(Class<TT> clazz, TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(clazz, typeAdapter){
            private /* synthetic */ Class a;
            private /* synthetic */ TypeAdapter b;
            {
                this.a = clazz;
                this.b = typeAdapter;
            }

            @Override
            public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                if (this.a.isAssignableFrom(typeToken.getRawType())) {
                    return this.b;
                }
                return null;
            }

            public final String toString() {
                return "Factory[typeHierarchy=" + this.a.getName() + ",adapter=" + this.b + "]";
            }
        };
    }

    static final class a<T extends Enum<T>>
    extends TypeAdapter<T> {
        private final Map<String, T> a = new HashMap<String, T>();
        private final Map<T, String> b = new HashMap<T, String>();

        public a(Class<T> clazz) {
            try {
                for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                    String string = enum_.name();
                    SerializedName serializedName = clazz.getField(string).getAnnotation(SerializedName.class);
                    if (serializedName != null) {
                        string = serializedName.value();
                    }
                    this.a.put(string, enum_);
                    this.b.put(enum_, string);
                }
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new AssertionError();
            }
        }

        @Override
        public final /* synthetic */ Object read(JsonReader object) throws IOException {
            JsonReader jsonReader = object;
            object = this;
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return (Enum)((a)object).a.get(jsonReader.nextString());
        }

        @Override
        public final /* synthetic */ void write(JsonWriter object, Object object2) throws IOException {
            Enum enum_ = (Enum)object2;
            object2 = object;
            object = this;
            ((JsonWriter)object2).value(enum_ == null ? null : ((a)object).b.get(enum_));
        }
    }
}

