/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import com.google.gson.stream.a;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class JsonWriter
implements Closeable,
Flushable {
    private static final String[] a = new String[128];
    private static final String[] b;
    private final Writer c;
    private final List<a> d = new ArrayList<a>();
    private String e;
    private String f;
    private boolean g;
    private boolean h;
    private String i;
    private boolean j;

    public JsonWriter(Writer writer) {
        this.d.add(com.google.gson.stream.a.EMPTY_DOCUMENT);
        this.f = ":";
        this.j = true;
        if (writer == null) {
            throw new NullPointerException("out == null");
        }
        this.c = writer;
    }

    public final void setIndent(String string) {
        if (string.length() == 0) {
            this.e = null;
            this.f = ":";
            return;
        }
        this.e = string;
        this.f = ": ";
    }

    public final void setLenient(boolean bl) {
        this.g = bl;
    }

    public boolean isLenient() {
        return this.g;
    }

    public final void setHtmlSafe(boolean bl) {
        this.h = bl;
    }

    public final boolean isHtmlSafe() {
        return this.h;
    }

    public final void setSerializeNulls(boolean bl) {
        this.j = bl;
    }

    public final boolean getSerializeNulls() {
        return this.j;
    }

    public JsonWriter beginArray() throws IOException {
        this.b();
        return this.a(com.google.gson.stream.a.EMPTY_ARRAY, "[");
    }

    public JsonWriter endArray() throws IOException {
        return this.a(com.google.gson.stream.a.EMPTY_ARRAY, com.google.gson.stream.a.NONEMPTY_ARRAY, "]");
    }

    public JsonWriter beginObject() throws IOException {
        this.b();
        return this.a(com.google.gson.stream.a.EMPTY_OBJECT, "{");
    }

    public JsonWriter endObject() throws IOException {
        return this.a(com.google.gson.stream.a.EMPTY_OBJECT, com.google.gson.stream.a.NONEMPTY_OBJECT, "}");
    }

    private JsonWriter a(a a2, String string) throws IOException {
        this.a(true);
        this.d.add(a2);
        this.c.write(string);
        return this;
    }

    private JsonWriter a(a a2, a a3, String string) throws IOException {
        a a4 = this.a();
        if (a4 != a3 && a4 != a2) {
            throw new IllegalStateException("Nesting problem: " + this.d);
        }
        if (this.i != null) {
            throw new IllegalStateException("Dangling name: " + this.i);
        }
        this.d.remove(this.d.size() - 1);
        if (a4 == a3) {
            this.c();
        }
        this.c.write(string);
        return this;
    }

    private a a() {
        int n = this.d.size();
        if (n == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        return this.d.get(n - 1);
    }

    private void a(a a2) {
        this.d.set(this.d.size() - 1, a2);
    }

    public JsonWriter name(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("name == null");
        }
        if (this.i != null) {
            throw new IllegalStateException();
        }
        if (this.d.isEmpty()) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.i = string;
        return this;
    }

    private void b() throws IOException {
        if (this.i != null) {
            JsonWriter jsonWriter = this;
            a a2 = jsonWriter.a();
            if (a2 == com.google.gson.stream.a.NONEMPTY_OBJECT) {
                jsonWriter.c.write(44);
            } else if (a2 != com.google.gson.stream.a.EMPTY_OBJECT) {
                throw new IllegalStateException("Nesting problem: " + jsonWriter.d);
            }
            jsonWriter.c();
            jsonWriter.a(com.google.gson.stream.a.DANGLING_NAME);
            this.a(this.i);
            this.i = null;
        }
    }

    public JsonWriter value(String string) throws IOException {
        if (string == null) {
            return this.nullValue();
        }
        this.b();
        this.a(false);
        this.a(string);
        return this;
    }

    public JsonWriter nullValue() throws IOException {
        if (this.i != null) {
            if (this.j) {
                this.b();
            } else {
                this.i = null;
                return this;
            }
        }
        this.a(false);
        this.c.write("null");
        return this;
    }

    public JsonWriter value(boolean bl) throws IOException {
        this.b();
        this.a(false);
        this.c.write(bl ? "true" : "false");
        return this;
    }

    public JsonWriter value(double d2) throws IOException {
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + d2);
        }
        this.b();
        this.a(false);
        this.c.append(Double.toString(d2));
        return this;
    }

    public JsonWriter value(long l) throws IOException {
        this.b();
        this.a(false);
        this.c.write(Long.toString(l));
        return this;
    }

    public JsonWriter value(Number number) throws IOException {
        if (number == null) {
            return this.nullValue();
        }
        this.b();
        String string = number.toString();
        if (!this.g && (string.equals("-Infinity") || string.equals("Infinity") || string.equals("NaN"))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + number);
        }
        this.a(false);
        this.c.append(string);
        return this;
    }

    @Override
    public void flush() throws IOException {
        if (this.d.isEmpty()) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.c.flush();
    }

    @Override
    public void close() throws IOException {
        this.c.close();
        int n = this.d.size();
        if (n > 1 || n == 1 && this.d.get(n - 1) != com.google.gson.stream.a.NONEMPTY_DOCUMENT) {
            throw new IOException("Incomplete document");
        }
        this.d.clear();
    }

    private void a(String string) throws IOException {
        String[] stringArray = this.h ? b : a;
        this.c.write("\"");
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            String string2;
            char c2 = string.charAt(i);
            if (c2 < '\u0080') {
                string2 = stringArray[c2];
                if (string2 == null) {
                    continue;
                }
            } else if (c2 == '\u2028') {
                string2 = "\\u2028";
            } else {
                if (c2 != '\u2029') continue;
                string2 = "\\u2029";
            }
            if (n < i) {
                this.c.write(string, n, i - n);
            }
            this.c.write(string2);
            n = i + 1;
        }
        if (n < n2) {
            this.c.write(string, n, n2 - n);
        }
        this.c.write("\"");
    }

    private void c() throws IOException {
        if (this.e == null) {
            return;
        }
        this.c.write("\n");
        for (int i = 1; i < this.d.size(); ++i) {
            this.c.write(this.e);
        }
    }

    private void a(boolean bl) throws IOException {
        switch (this.a()) {
            case NONEMPTY_DOCUMENT: {
                if (!this.g) {
                    throw new IllegalStateException("JSON must have only one top-level value.");
                }
            }
            case EMPTY_DOCUMENT: {
                if (!this.g && !bl) {
                    throw new IllegalStateException("JSON must start with an array or an object.");
                }
                this.a(com.google.gson.stream.a.NONEMPTY_DOCUMENT);
                return;
            }
            case EMPTY_ARRAY: {
                this.a(com.google.gson.stream.a.NONEMPTY_ARRAY);
                this.c();
                return;
            }
            case NONEMPTY_ARRAY: {
                this.c.append(',');
                this.c();
                return;
            }
            case DANGLING_NAME: {
                this.c.append(this.f);
                this.a(com.google.gson.stream.a.NONEMPTY_OBJECT);
                return;
            }
        }
        throw new IllegalStateException("Nesting problem: " + this.d);
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            JsonWriter.a[i] = String.format("\\u%04x", i);
        }
        JsonWriter.a[34] = "\\\"";
        JsonWriter.a[92] = "\\\\";
        JsonWriter.a[9] = "\\t";
        JsonWriter.a[8] = "\\b";
        JsonWriter.a[10] = "\\n";
        JsonWriter.a[13] = "\\r";
        JsonWriter.a[12] = "\\f";
        String[] stringArray = (String[])a.clone();
        b = stringArray;
        stringArray[60] = "\\u003c";
        JsonWriter.b[62] = "\\u003e";
        JsonWriter.b[38] = "\\u0026";
        JsonWriter.b[61] = "\\u003d";
        JsonWriter.b[39] = "\\u0027";
    }
}

