/*
 * Decompiled with CFR 0.152.
 */
package eu.memshare.export.main;

import com.google.code.gsonrmi.RpcError;
import com.google.code.gsonrmi.annotations.RMI;
import com.google.code.gsonrmi.annotations.Session;
import com.google.code.gsonrmi.transport.Route;
import com.google.code.gsonrmi.transport.rmi.Call;
import eu.memshare.export.dao.Login_Token;
import eu.memshare.export.dao.MemshareFile;
import eu.memshare.export.dao.MemshareNode;
import eu.memshare.export.dao.NodeFilter;
import eu.memshare.export.dao.SchemaBean;
import eu.memshare.export.dao.Users;
import eu.memshare.export.main.GSONEntity;
import eu.memshare.export.main.GSONSession;
import eu.memshare.export.main.TcpProxyInterface;
import eu.memshare.export.utils.Enums;
import eu.memshare.export.utils.Utils;
import eu.memshare.filetransfer.FileTransferClient;
import eu.memshare.filetransfer.FileTransferJob;
import eu.memshare.filetransfer.FileTransferStatusListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ExportGsonClient
extends GSONEntity {
    private static ExportGsonClient instance;
    private static Login_Token token;
    private static String schemaLongName;
    private static String schemaIP;
    private static Users user;

    private ExportGsonClient(String string, String string2, String string3, Integer n, TcpProxyInterface tcpProxyInterface) throws InvocationTargetException, URISyntaxException {
        super(string, string2, string3, n, tcpProxyInterface);
    }

    static ExportGsonClient a(String object, String string, String string2, Integer n, TcpProxyInterface tcpProxyInterface) {
        try {
            System.out.println("Starting connection to worker on ip: " + (String)object);
            System.setProperty("javax.net.ssl.keyStore", "mySrvKeystore");
            System.setProperty("javax.net.ssl.keyStorePassword", "123456");
            System.setProperty("javax.net.ssl.trustStore", "mySrvKeystore");
            System.setProperty("javax.net.ssl.trustStorePassword", "123456");
            instance = new ExportGsonClient((String)object, string, string2, null, tcpProxyInterface);
        }
        catch (InvocationTargetException | URISyntaxException exception) {
            object = exception;
            exception.printStackTrace();
        }
        return instance;
    }

    private void connectToWorkerMainPort(SchemaBean schemaBean) throws URISyntaxException {
        schemaLongName = Utils.escapeForSchema(schemaBean.getLongName());
        schemaIP = schemaBean.getIp();
        this.serverName = "rmi:channelManager";
        this.clientName = "rmi:TestClient";
        this.url = "tcp://" + schemaBean.getIp() + ":" + schemaBean.getPort();
        this.rebuildGSON("TestClient");
    }

    private void connectToWorkerUserPort(SchemaBean schemaBean, Integer n) throws URISyntaxException {
        String string = user.getLogin_name();
        this.serverName = "rmi:" + Utils.buildChannelName(string, n, "server_");
        string = Utils.buildChannelName(string, n, "client_");
        this.clientName = "rmi:" + string;
        this.url = "tcp://" + schemaBean.getIp() + ":" + n;
        this.rebuildGSON(string);
    }

    protected static synchronized ExportGsonClient getInstance() {
        return instance;
    }

    protected String getSchemaLongName() {
        return schemaLongName;
    }

    static String a() {
        return schemaIP;
    }

    final List<SchemaBean> a(String string, String string2) {
        token = this.getLoginToken(string, string2);
        if (token == null) {
            System.out.println("LOGIN TOKEN IS NULL");
            return null;
        }
        System.out.println("LOGIN TOKEN OK");
        return ExportGsonClient.getInstance().getSchemaForUser();
    }

    final boolean a(SchemaBean schemaBean) throws URISyntaxException {
        Integer n;
        this.connectToWorkerMainPort(schemaBean);
        user = this.getUserFromWorker();
        if (user != null && (n = this.openChannel(user, schemaLongName)) != null) {
            this.connectToWorkerUserPort(schemaBean, n);
            return true;
        }
        return false;
    }

    final boolean a(File file, Long constable, FileTransferStatusListener fileTransferStatusListener, Boolean bl) throws FileNotFoundException {
        if (file.exists() && file.isFile()) {
            String string = Utils.getSha1Checksum(file);
            Long l = file.length();
            System.out.println("Checksum: " + string);
            constable = this.saveMemshareFile((Long)constable, file.getName(), string, l, Enums.FileUsage.Attach, bl);
            if (((Boolean)constable).booleanValue()) {
                FileTransferClient.getInstance().addJob(new FileTransferJob(FileTransferJob.CommandType.UPLOAD_TO_SERVER, file.getPath(), schemaLongName, fileTransferStatusListener, string));
                return true;
            }
        } else {
            throw new FileNotFoundException();
        }
        return false;
    }

    static void a(MemshareFile object, File file, FileTransferStatusListener fileTransferStatusListener) throws Exception {
        if ((object = ((MemshareFile)object).getChecksum()) != null && !((String)object).equals("")) {
            FileTransferClient.getInstance().addJob(new FileTransferJob(FileTransferJob.CommandType.DOWNLOAD_FROM_SERVER, file.getAbsolutePath(), schemaLongName, fileTransferStatusListener, (String)object));
            return;
        }
        throw new Exception("Invalid checksum for MemshareFile.");
    }

    private Login_Token getLoginToken(String string, String string2) {
        return (Login_Token)this.doServerJob("getLoginByNamePass", "returnLoginToken", string, string2);
    }

    private List<SchemaBean> getSchemaForUser() {
        return (List)this.doServerJob("getAllSchemaForUser", "returnSchemaList", token);
    }

    private Users getUserFromWorker() {
        return (Users)this.doServerJob("getUserByLoginToken", "returnUser", token, schemaLongName);
    }

    private Integer openChannel(Users users, String string) {
        return (Integer)this.doServerJob("openChannel", "returnInteger", users, string);
    }

    final Boolean b() {
        return (Boolean)this.doServerJob("keepAlive", "returnBoolean", this.clientName, user.getId());
    }

    final Long a(Long l, String string, boolean bl) {
        return (Long)this.doServerJob("exportMemshareNode2", "returnLong", l, string, bl, user.getId(), schemaLongName);
    }

    final Boolean b(Long l, String string, boolean bl) {
        return (Boolean)this.doServerJob("exportMemshareDescription2", "returnBoolean", l, string, bl, user.getId(), schemaLongName);
    }

    final Boolean a(Long l, Map<String, List<String>> map, boolean bl, boolean bl2) {
        return (Boolean)this.doServerJob("exportMemshareTags2", "returnBoolean", l, map, bl, bl2, user.getId(), schemaLongName);
    }

    final Boolean b(Long l, Map<String, List<Map<String, String>>> map, boolean bl, boolean bl2) {
        return (Boolean)this.doServerJob("exportMemshareMicrosheets2", "returnBoolean", l, map, bl, bl2, user.getId(), schemaLongName);
    }

    private Boolean saveMemshareFile(Long l, String string, String string2, Long l2, Enums.FileUsage fileUsage, boolean bl) {
        return (Boolean)this.doServerJob("exportMemshareFile2", "returnBoolean", new Object[]{l, string, string2, l2, fileUsage, bl, user.getId(), schemaLongName});
    }

    final List<MemshareNode> a(Long l, NodeFilter nodeFilter) {
        return (List)this.doServerJob("getChildrenNodesAPI", "returnMemshareNodeList", l, nodeFilter, user.getId(), schemaLongName);
    }

    final List<MemshareFile> a(Long l) {
        return (List)this.doServerJob("getMemshareFilesAPI", "returnMemshareFileList", l, user.getId(), schemaLongName);
    }

    @RMI
    public void returnLoginToken(Login_Token login_Token, @Session GSONSession gSONSession, RpcError rpcError) {
        this.processResult(login_Token, gSONSession);
    }

    @RMI
    public void returnSchemaList(List<SchemaBean> list, @Session GSONSession gSONSession, RpcError rpcError) {
        this.processResult(list, gSONSession);
    }

    @RMI
    public void returnMemshareNodeList(List<MemshareNode> list, @Session GSONSession gSONSession, RpcError rpcError) {
        this.processResult(list, gSONSession);
    }

    @RMI
    public void returnMemshareFileList(List<MemshareFile> list, @Session GSONSession gSONSession, RpcError rpcError) {
        this.processResult(list, gSONSession);
    }

    @RMI
    public void returnBoolean(Boolean bl, @Session GSONSession gSONSession, RpcError rpcError) {
        this.processResult(bl, gSONSession);
    }

    @RMI
    public void returnUser(Users users, @Session GSONSession gSONSession, RpcError rpcError) {
        this.processResult(users, gSONSession);
    }

    @RMI
    public void returnInteger(Integer n, @Session GSONSession gSONSession, RpcError rpcError) {
        this.processResult(n, gSONSession);
    }

    @RMI
    public void returnLong(Long l, @Session GSONSession gSONSession, RpcError rpcError) {
        this.processResult(l, gSONSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResult(Object object, GSONSession gSONSession) {
        if (object != null) {
            gSONSession.setResult(object);
        }
        object = gSONSession;
        synchronized (object) {
            gSONSession.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doServerJob(String object, String object2, Object ... objectArray) {
        Object object3 = null;
        try {
            GSONSession gSONSession = new GSONSession();
            Route route = new Route(new URI(this.url), new URI(this.serverName + "#" + UUID.randomUUID()));
            URI uRI = new URI(this.clientName);
            object = new Call(route, (String)object, objectArray);
            object = ((Call)object).callback(uRI, (String)object2, new Object[0]).session(gSONSession);
            object2 = gSONSession;
            synchronized (object2) {
                ((Call)object).send(this.transport);
                gSONSession.wait(120000L);
            }
            object3 = gSONSession.getResult() == null && gSONSession.getRpcError() != null ? null : gSONSession.getResult();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return object3;
    }

    static {
        user = null;
    }
}

