/*
 * Decompiled with CFR 0.152.
 */
package eu.memshare.filetransfer;

import eu.memshare.export.main.MemshareClient;
import eu.memshare.export.utils.Utils;
import eu.memshare.filetransfer.FileTransferJob;
import eu.memshare.filetransfer.FileTransferStatusListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class FileTransferClient
implements Runnable {
    private static FileTransferClient instance = null;
    private String ipServer;
    private int port = 33332;
    private int maxTimeout = 30000;
    private Vector<FileTransferJob> jobs = new Vector();
    private ExecutorService executor = Executors.newCachedThreadPool();

    private FileTransferClient() {
        this.ipServer = MemshareClient.getIpServer();
        Thread thread = new Thread(this);
        thread.setName("FileTransferClient");
        thread.start();
    }

    public static synchronized FileTransferClient getInstance() {
        if (instance == null) {
            instance = new FileTransferClient();
        }
        return instance;
    }

    public synchronized void addJob(FileTransferJob fileTransferJob) {
        this.jobs.add(fileTransferJob);
    }

    @Override
    public void run() {
        while (true) {
            Object object;
            try {
                while (true) {
                    if (this.jobs.size() > 0) {
                        object = this.jobs.remove(0);
                        switch (((FileTransferJob)object).d) {
                            case UPLOAD_TO_SERVER: {
                                this.executor.submit(new Runnable(this, (FileTransferJob)object){
                                    private /* synthetic */ FileTransferJob a;
                                    private /* synthetic */ FileTransferClient b;
                                    {
                                        this.b = fileTransferClient;
                                        this.a = fileTransferJob;
                                    }

                                    @Override
                                    public final void run() {
                                        try {
                                            this.b.uploadFileToServer(this.a);
                                            return;
                                        }
                                        catch (Throwable throwable) {
                                            Throwable throwable2 = throwable;
                                            throwable.printStackTrace();
                                            return;
                                        }
                                    }
                                });
                                break;
                            }
                            case DOWNLOAD_FROM_SERVER: {
                                this.executor.submit(new Runnable(this, (FileTransferJob)object){
                                    private /* synthetic */ FileTransferJob a;
                                    private /* synthetic */ FileTransferClient b;
                                    {
                                        this.b = fileTransferClient;
                                        this.a = fileTransferJob;
                                    }

                                    @Override
                                    public final void run() {
                                        try {
                                            this.b.downloadFromServer(this.a);
                                            return;
                                        }
                                        catch (Throwable throwable) {
                                            Throwable throwable2 = throwable;
                                            throwable.printStackTrace();
                                            return;
                                        }
                                    }
                                });
                            }
                        }
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throwable.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void downloadFromServer(FileTransferJob fileTransferJob) throws IOException, ClassNotFoundException {
        Socket socket = new Socket(this.ipServer, this.port);
        socket.setSoLinger(false, 0);
        socket.setSoTimeout(this.maxTimeout);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
        ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
        objectOutputStream.writeObject((Object)FileTransferJob.CommandType.DOWNLOAD_FROM_SERVER);
        objectOutputStream.writeObject(fileTransferJob.b);
        objectOutputStream.writeObject(fileTransferJob.e);
        objectOutputStream.flush();
        FileOutputStream fileOutputStream = new FileOutputStream(fileTransferJob.a);
        byte[] byArray = new byte[524288];
        long l = 0L;
        FileTransferStatusListener.Messages messages = null;
        long l2 = objectInputStream.readLong();
        if (l2 > 0L) {
            boolean bl = false;
            while (l < l2) {
                try {
                    int n = objectInputStream.read(byArray, 0, 524288);
                    if (n <= 0) break;
                    fileOutputStream.write(byArray, 0, n);
                    fileOutputStream.flush();
                    objectOutputStream.writeObject(l += (long)n);
                    objectOutputStream.flush();
                    fileTransferJob.c.bytesReceived(l, l2);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    messages = FileTransferStatusListener.Messages.Timeout;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                fileTransferJob.c.completed();
            }
        } else {
            fileTransferJob.c.error(FileTransferStatusListener.Messages.FileNotFound.toString());
        }
        if (messages == null) {
            String string = Utils.getSha1Checksum(new File(fileTransferJob.a));
            messages = !string.equals(fileTransferJob.e) ? FileTransferStatusListener.Messages.Checksum_differs : FileTransferStatusListener.Messages.Transfer_completed;
        }
        objectOutputStream.writeObject((Object)messages);
        objectOutputStream.flush();
        fileOutputStream.close();
        objectOutputStream.close();
        objectInputStream.close();
        socket.close();
    }

    private void uploadFileToServer(FileTransferJob fileTransferJob) throws IOException, ClassNotFoundException {
        Object object = new File(fileTransferJob.a);
        Socket socket = new Socket(this.ipServer, this.port);
        socket.setSoLinger(false, 0);
        socket.setSoTimeout(this.maxTimeout);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
        ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
        Object object2 = Utils.getSha1Checksum((File)object);
        objectOutputStream.writeObject((Object)FileTransferJob.CommandType.UPLOAD_TO_SERVER);
        objectOutputStream.writeObject(fileTransferJob.b);
        objectOutputStream.writeObject(object2);
        objectOutputStream.writeLong(((File)object).length());
        objectOutputStream.flush();
        object2 = new BufferedInputStream(new FileInputStream((File)object));
        Object object3 = new byte[0x100000];
        Object object4 = new LinkedList<Object>();
        object3 = new Callable<FileTransferStatusListener.Messages>(this, (BufferedInputStream)object2, object3, objectOutputStream){
            private /* synthetic */ BufferedInputStream a;
            private /* synthetic */ byte[] b;
            private /* synthetic */ ObjectOutputStream c;
            {
                this.a = bufferedInputStream;
                this.b = byArray;
                this.c = objectOutputStream;
            }

            @Override
            public final /* synthetic */ Object call() throws Exception {
                int n;
                3 var1_1 = this;
                while ((n = var1_1.a.read(var1_1.b, 0, var1_1.b.length)) > 0) {
                    var1_1.c.write(var1_1.b, 0, n);
                    var1_1.c.flush();
                }
                return null;
            }
        };
        object4.add(object3);
        object = new Callable<FileTransferStatusListener.Messages>(this, objectInputStream, fileTransferJob, (File)object){
            private /* synthetic */ ObjectInputStream a;
            private /* synthetic */ FileTransferJob b;
            private /* synthetic */ File c;
            private /* synthetic */ FileTransferClient d;
            {
                this.d = fileTransferClient;
                this.a = objectInputStream;
                this.b = fileTransferJob;
                this.c = file;
            }

            @Override
            public final /* synthetic */ Object call() throws Exception {
                4 var1_1 = this;
                FileTransferStatusListener.Messages messages = null;
                while (messages == null) {
                    Object object = var1_1.d.getBytesTransmitted(var1_1.a);
                    if (object != null) {
                        if (object instanceof FileTransferStatusListener.Messages) {
                            messages = (FileTransferStatusListener.Messages)((Object)object);
                        } else {
                            long l = (Long)object;
                            var1_1.b.c.bytesReceived(l, var1_1.c.length());
                        }
                    }
                    if (object != null) continue;
                    messages = FileTransferStatusListener.Messages.Timeout;
                    break;
                }
                return messages;
            }
        };
        object4.add(object);
        try {
            object = this.executor.invokeAll(object4);
            object3 = null;
            object = object.iterator();
            while (object.hasNext()) {
                object4 = (Future)object.next();
                if (object4 == null) continue;
                try {
                    object3 = (FileTransferStatusListener.Messages)((Object)object4.get());
                }
                catch (ExecutionException executionException) {
                    object4 = executionException;
                    executionException.printStackTrace();
                }
            }
            if (object3 != null) {
                switch (5.b[object3.ordinal()]) {
                    case 1: {
                        fileTransferJob.c.completed();
                        break;
                    }
                    default: {
                        fileTransferJob.c.error(object3.toString());
                        break;
                    }
                }
            } else {
                fileTransferJob.c.interrupted();
            }
        }
        catch (InterruptedException interruptedException) {
            fileTransferJob.c.interrupted();
        }
        ((BufferedInputStream)object2).close();
        objectOutputStream.close();
        objectInputStream.close();
        socket.close();
    }

    private Object getBytesTransmitted(ObjectInputStream object) throws IOException, ClassNotFoundException {
        Object object2 = null;
        try {
            object2 = ((ObjectInputStream)object).readObject();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            object = socketTimeoutException;
            socketTimeoutException.printStackTrace();
        }
        return object2;
    }
}

