/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.mortbay.jetty.Server;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.ecr.BonValidatorResponseInterface;
import ro.atreides.ecr.CashRegisterInterface;
import ro.atreides.ecr.EcrFeedbackInterface;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrPrevalidareType;
import ro.atreides.ecr.EcrPrintingThread;
import ro.atreides.ecr.EcrSale;
import ro.atreides.ecr.EcrSerialNumberReadInterface;
import ro.atreides.ecr.EcrType;
import ro.atreides.ecr.ExtraCommandsBean;
import ro.atreides.ecr.GenericXmlHandler;
import ro.atreides.ecr.GenericXmlHandlerInterface;
import ro.atreides.ecr.NonFiscalReceiptPrintingThread;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.tricky.NonPrintedBonInterface;
import ro.atreides.utils.web.WebServerInterface;
import ro.deversoft.ecr.noarch.EcrLicenseVerifier;
import ro.deversoft.utils.noarch.Logger;
import ro.deversoft.utils.noarch.UtilsNoarch;

public abstract class AbstractCashRegister
implements CashRegisterInterface {
    protected Properties conf;
    protected EcrPrintingThread pt;
    public int onlineDecimalPlaces;
    public static int ecrMinGrp;
    public static int ecrMaxGrp;
    public int webServerPort;
    public String ecrExeFile;
    public String onlineItemsFile;
    public String onlineErrFile;
    public String onlineLogFile;
    public String onlineDirectory;
    public String systemPrefix;
    public String expectedReply;
    public String fileNameTemplate;
    public String nonfiscalReceiptLocation;
    public boolean bonNumbering;
    protected boolean licenseRequired;
    protected WebServerInterface webserver;
    protected NonPrintedBonInterface inter;
    protected boolean forceF = false;
    protected boolean multipleTipPlataSupported = true;
    protected Hashtable<String, String> paymentTypes;
    protected boolean overridePaymentCodes;
    protected int priceForcedDigits;
    protected int paymentForcedDigits;
    protected int incarcaForcedDigits;
    protected int nrLogic;
    protected EcrType ecrType = null;

    public boolean isPrevalidareBonuriEnabled() {
        boolean bl = EcrLicenseVerifier.getInstance().isFunctionLicensed(EcrLicenseVerifier.FUNCTION.prevalidareBonEnabled);
        if (!bl) {
            return false;
        }
        Object object = this.conf.getProperty(EcrLogic.ECR_GUI_CONFIGS.PREVALIDARE_TYPE.toString());
        return !Validators.correctString(object) || (object = EcrPrevalidareType.valueOf(object)) == null || object != EcrPrevalidareType.FARA_PREVALIDARE;
    }

    @Override
    public boolean isForceF() {
        return this.forceF;
    }

    @Override
    public void setForceF(boolean bl) {
        this.forceF = bl;
    }

    public void setLicenseRequired(boolean bl) {
        this.licenseRequired = bl;
    }

    @Override
    public void setInter(NonPrintedBonInterface nonPrintedBonInterface) {
        this.inter = nonPrintedBonInterface;
    }

    public void buildConfiguration(Properties properties) throws RuntimeException {
        this.conf = properties;
        this.overridePaymentCodes = Boolean.parseBoolean(properties.getProperty("overridePaymentCodes", "false"));
        this.ecrExeFile = properties.getProperty("ecrExeFile");
        this.onlineItemsFile = properties.getProperty("ecrItemsFile");
        this.onlineErrFile = properties.getProperty("ecrErrFile");
        this.onlineLogFile = properties.getProperty("ecrLogFile");
        this.onlineDirectory = properties.getProperty("ecrDirectory");
        this.systemPrefix = properties.getProperty("ecrSystemPrefix");
        this.onlineDecimalPlaces = Integer.parseInt(properties.getProperty("ecrDecimalPlaces", "2"));
        ecrMinGrp = Integer.parseInt(properties.getProperty("ecrMinGrp", "1"));
        ecrMaxGrp = Integer.parseInt(properties.getProperty("ecrMaxGrp", "1"));
        this.bonNumbering = Boolean.parseBoolean(properties.getProperty("bonNumbering", "false"));
        this.expectedReply = properties.getProperty("expectedReply");
        this.webServerPort = Integer.parseInt(properties.getProperty("webServerPort", "8080"));
        this.fileNameTemplate = properties.getProperty("fileNameTemplate");
        this.nonfiscalReceiptLocation = properties.getProperty("nonfiscalReceiptLocation");
        this.paymentTypes = new Hashtable();
        Object object = properties.getProperty("paymentTypes", "Cash");
        object = UtilsNoarch.splitString((String)object, ',');
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            String string = (String)((Vector)object).elementAt(i);
            String string2 = properties.getProperty("paymentType_" + string, "");
            string = string.toUpperCase();
            this.paymentTypes.put(string, string2);
        }
        this.priceForcedDigits = Integer.parseInt(properties.getProperty("priceForcedDigits", "0"));
        this.paymentForcedDigits = Integer.parseInt(properties.getProperty("paymentForcedDigits", "0"));
        this.incarcaForcedDigits = Integer.parseInt(properties.getProperty("incarcaForcedDigits", "0"));
        this.nrLogic = Integer.parseInt(properties.getProperty("nrLogic", "1"));
        String string = properties.getProperty(EcrLogic.ECR_GUI_CONFIGS.ECR_TYPE.toString());
        if (string != null) {
            try {
                this.ecrType = EcrType.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger.logException(this, (Exception)illegalArgumentException);
            }
        }
        Logger.logInfo(this, "table = " + this.paymentTypes);
    }

    public boolean start() {
        String string = "";
        if (Validators.correctString(this.ecrExeFile)) {
            string = this.systemPrefix + " " + this.ecrExeFile;
        }
        this.pt = new EcrPrintingThread(this.onlineDirectory, string, this.onlineItemsFile, this.onlineLogFile, this.onlineErrFile, this.bonNumbering, this.expectedReply, this.fileNameTemplate);
        this.pt.setName("EcrPrintingThread");
        this.pt.start();
        if (this.nonfiscalReceiptLocation != null) {
            new NonFiscalReceiptPrintingThread(this.nonfiscalReceiptLocation, this);
        }
        return true;
    }

    public void printNonFiscalBon(String string) {
    }

    public static String getDepartament(EcrSale ecrSale) {
        return ecrSale.getDepartament();
    }

    public static String getGrupa(EcrSale ecrSale) {
        return "" + AbstractCashRegister.getRightNumber(ecrSale.getGrupa(), ecrMinGrp, ecrMaxGrp);
    }

    public static int getRightNumber(int n, int n2, int n3) {
        if ((n = n % n3 + 1) < n2) {
            n = n2;
        }
        return n;
    }

    public void finishInitialize() {
    }

    public WebServerInterface getWebserver() {
        return this.webserver;
    }

    public void setWebserver(WebServerInterface webServerInterface) {
        this.webserver = webServerInterface;
        try {
            System.out.println("starting Web server");
            if (webServerInterface != null) {
                webServerInterface = (Server)webServerInterface.prepareWebServer(this.webServerPort);
                webServerInterface.addWebApplication("/ecrPrint", "./webapps/ecrPrint/");
            }
            return;
        }
        catch (Exception exception) {
            Logger.logException(this, exception);
            return;
        }
    }

    @Override
    public void printX() {
    }

    @Override
    public void printZ() {
    }

    @Override
    public void introduNumerar(double d2) {
    }

    @Override
    public boolean numerarInputReady() {
        return false;
    }

    @Override
    public void processBonFiscal(String string, String string2, int n, EcrType ecrType, String string3, BonValidatorResponseInterface bonValidatorResponseInterface, Map<Integer, Integer> map) {
        this.pt.addToQueue(string);
    }

    public void stopECR() {
    }

    public void startECR() {
    }

    public void processXml(String object) {
        block13: {
            try {
                GenericXmlHandler genericXmlHandler = new GenericXmlHandler(this.getXmlHandlerInterface());
                Utils.importXml((DefaultHandler)genericXmlHandler, (String)object);
                object = genericXmlHandler.getExtraCommands();
                if (object != null && ((Vector)object).size() > 0) {
                    object = ((Vector)object).iterator();
                    while (object.hasNext()) {
                        ExtraCommandsBean extraCommandsBean = (ExtraCommandsBean)object.next();
                        switch (extraCommandsBean.getOperation()) {
                            case addCash: {
                                this.introduNumerar(extraCommandsBean.getValue());
                                break;
                            }
                            case removeCash: {
                                this.introduNumerar(-extraCommandsBean.getValue().doubleValue());
                                break;
                            }
                            case xReport: {
                                this.printX();
                                break;
                            }
                            case zReport: {
                                this.printZ();
                            }
                        }
                    }
                    break block13;
                }
                object = genericXmlHandler.getSales();
                Vector<EcrPlata> vector = genericXmlHandler.getPlati();
                Vector<String> vector2 = genericXmlHandler.getComments();
                double d2 = genericXmlHandler.getTotalSales();
                String string = genericXmlHandler.getIdBon();
                int n = genericXmlHandler.getIdOrder();
                Collections.sort(vector, new Comparator<EcrPlata>(this){

                    @Override
                    public final /* synthetic */ int compare(Object object, Object object2) {
                        if (((EcrPlata)(object = (EcrPlata)object)).isDefault()) {
                            return 1;
                        }
                        return -1;
                    }
                });
                this.printBonFiscal((Vector<EcrSale>)object, d2, vector, null, vector2, string, n);
                return;
            }
            catch (IOException iOException) {
                Logger.logException(this, (Exception)iOException);
                return;
            }
            catch (SAXException sAXException) {
                Logger.logException(this, (Exception)sAXException);
                return;
            }
        }
    }

    protected GenericXmlHandlerInterface getXmlHandlerInterface() {
        return new GenericXmlHandlerInterface(this){
            private /* synthetic */ AbstractCashRegister a;
            {
                this.a = abstractCashRegister;
            }

            @Override
            public final String getEcrPaymentCode(String string) {
                return this.a.paymentTypes.get(string);
            }
        };
    }

    @Override
    public int getNoOfBonsToPrint() {
        return 0;
    }

    @Override
    public void deleteNonPrintedBons() {
    }

    public void setMultipleTipPlataSupported(boolean bl) {
        this.multipleTipPlataSupported = bl;
    }

    @Override
    public boolean multiplePaymentTypesSupported() {
        return this.multipleTipPlataSupported;
    }

    @Override
    public void deleteBonByIdentifier(String string) {
    }

    public boolean ecrConnectedAtStartup() {
        return true;
    }

    @Override
    public String getForcedEcrMapping(String string) {
        if (this.overridePaymentCodes) {
            return this.paymentTypes.get(string.toUpperCase());
        }
        return null;
    }

    public void clearFeedbackFile() {
    }

    public String getFeedbackByIdentifier(String string) {
        return "";
    }

    public void addListener(EcrFeedbackInterface ecrFeedbackInterface) {
    }

    public void addLicenseCode(String string) {
    }

    public void setEcrSerialNumberReadInterface(EcrSerialNumberReadInterface ecrSerialNumberReadInterface) {
    }

    public void copieBon() {
    }

    public void useEcrSerialNumberOldSchool() {
    }

    public EcrType getEcrType() {
        return this.ecrType;
    }
}

