/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import org.mortbay.jetty.Server;
import org.mortbay.util.InetAddrPort;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrFeedbackInterface;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.ecr.EcrSale;
import ro.atreides.ecr.ScalaXmlImporter;
import ro.atreides.ecr.datecs.nativeImpl.MP55Impl;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.web.WebServerInterface;
import ro.deversoft.utils.noarch.FileUtils;
import ro.deversoft.utils.noarch.Formatters;
import ro.deversoft.utils.noarch.Logger;
import ro.deversoft.utils.noarch.UtilsNoarch;

public class EcrMain {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(String[] object) {
        Logger.grabOutput = true;
        new File("errors.txt").delete();
        Logger.getInstance(6, "ecr.log");
        Object object2 = Utils.getCmdlineValue("-file", object, "");
        Object object3 = Utils.getCmdlineValue("-nativefile", object, "");
        String string = Utils.getCmdlineValue("-nativedir", object, "");
        String string2 = Utils.getCmdlineValue("-webserverport", object, "");
        String string3 = Utils.getCmdlineValue("-scalaFile", object, "");
        String string4 = Utils.getCmdlineValue("-scalaDir", object, "");
        String string5 = Utils.getCmdlineValue("-licenseCode", object, "");
        String string6 = Utils.getCmdlineValue("-nativeFileCharset", object);
        Object object4 = Utils.getCmdlineValue("-secondsWait", object, "30000");
        int n = -1;
        File file = FileUtils.getCurrentDirAsFile();
        File file2 = null;
        if (Validators.correctInteger((String)object4)) {
            n = Integer.parseInt((String)object4);
        }
        Logger.logDebug("EcrMain", object.toString());
        object = EcrLogic.getInstance(object, true, null);
        object4 = object.getEcr();
        if (Validators.correctString(string5)) {
            ((AbstractCashRegister)object4).addLicenseCode(string5);
        }
        boolean bl = false;
        if (Validators.correctString((String)object2)) {
            Logger.logDebug("EcrMain", "processing standard XML file");
            ((AbstractCashRegister)object4).processXml((String)object2);
        } else if (Validators.correctString((String)object3)) {
            Logger.logDebug("EcrMain", "processing standard native file");
            try {
                object = FileUtils.readFileToString((String)object3);
                ((AbstractCashRegister)object4).processBonFiscal((String)object, "1", -1, null, null, null, null);
            }
            catch (IOException iOException) {
                Logger.logException("EcrMain", (Exception)iOException);
            }
        } else if (Validators.correctString(string)) {
            Logger.logDebug("EcrMain", "processing native dir :" + string + " in DAEMON MODE ");
            file2 = new File(string);
            if (!file2.exists() || file2.isFile()) {
                DialogUtils.errorDialog(null, "Director inexistent : " + string, LangRoAll.nuPotContinua);
                System.exit(1);
            }
            object.startDirDaemon(file2, (AbstractCashRegister)object4, string6, "*.inp,*.bon", file2, 300L);
            bl = true;
        } else if (Validators.correctString(string3)) {
            Logger.logDebug("EcrMain", "processing scala XML file");
            try {
                object = new Properties();
                object.load(new FileInputStream("conf/ecr/scala_ecr.properties"));
                object2 = new File(string3);
                EcrMain.b((Properties)object, (File)object2, (AbstractCashRegister)object4);
            }
            catch (Exception exception) {
                Logger.logException("EcrMain", exception);
                System.exit(1);
            }
        } else if (Validators.correctString(string4)) {
            Logger.logDebug("EcrMain", "processing scala XML dir :" + string4 + " in DAEMON MODE ");
            try {
                object = new Properties();
                object.load(new FileInputStream("conf/ecr/scala_ecr.properties"));
                object2 = new File(string4);
                if (!((File)object2).exists() || ((File)object2).isFile()) {
                    DialogUtils.errorDialog(null, "Director inexistent : " + string4, LangRoAll.nuPotContinua);
                    System.exit(1);
                }
                object3 = new Thread((File)object2, (Properties)object, (AbstractCashRegister)object4){
                    private /* synthetic */ File a;
                    private /* synthetic */ Properties b;
                    private /* synthetic */ AbstractCashRegister c;
                    {
                        this.a = file;
                        this.b = properties;
                        this.c = abstractCashRegister;
                    }

                    @Override
                    public final void run() {
                        while (true) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                            File[] fileArray = this.a.listFiles(new FilenameFilter(this){

                                @Override
                                public final boolean accept(File object, String string) {
                                    object = string.toLowerCase();
                                    return ((String)object).endsWith(".xml");
                                }
                            });
                            if (fileArray != null && fileArray.length > 0) {
                                for (int i = 0; i < fileArray.length; ++i) {
                                    File file = fileArray[i];
                                    try {
                                        EcrMain.b(this.b, file, this.c);
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        Logger.logException(this, exception);
                                        System.exit(1);
                                    }
                                }
                            }
                            UtilsNoarch.systemExit();
                        }
                    }
                };
                ((Thread)object3).setName("Scala reader thread");
                ((Thread)object3).start();
            }
            catch (Exception exception) {
                Logger.logException("EcrMain", exception);
                System.exit(1);
            }
            bl = true;
        } else {
            bl = true;
        }
        if (Validators.correctInteger(string2) && bl) {
            Logger.logDebug("EcrMain", "starting as daemon webserver");
            try {
                int n2 = Integer.parseInt(string2);
                object2 = new Server();
                object2.addListener(new InetAddrPort(n2));
                ((AbstractCashRegister)object4).setWebserver(new WebServerInterface((Server)object2){
                    private /* synthetic */ Server a;
                    {
                        this.a = server;
                    }

                    @Override
                    public final Object prepareWebServer(int n) {
                        return this.a;
                    }
                });
                object2.start();
                return;
            }
            catch (Exception exception) {
                Logger.logException("EcrMain", exception);
                return;
            }
        }
        boolean bl2 = bl;
        object2 = file2 != null ? file2 : file;
        object3 = new Object();
        ((AbstractCashRegister)object4).addListener(new EcrFeedbackInterface((File)object2, bl2, object3){
            private /* synthetic */ File a;
            private /* synthetic */ boolean b;
            private /* synthetic */ Object c;
            {
                this.a = file;
                this.b = bl;
                this.c = object;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void bonFinished(int n, int n2, int n3, int n4, MP55Impl.CASA_EXPLAIN_MESSAGES cASA_EXPLAIN_MESSAGES, String string, boolean bl) {
                Object object = "OK;Z=" + n3 + "|NR=" + n2 + "|UNIQUE_ID=" + string;
                EcrMain.a(this.a, (String)object, string);
                if (bl && !this.b) {
                    object = this.c;
                    synchronized (object) {
                        this.c.notify();
                        return;
                    }
                }
            }
        });
        Object object5 = object3;
        synchronized (object5) {
            try {
                if (n > 0) {
                    object3.wait(n);
                } else {
                    object3.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        UtilsNoarch.systemExit();
    }

    private static synchronized void b(Properties object, File file, AbstractCashRegister abstractCashRegister) throws Exception {
        String string;
        object = new ScalaXmlImporter((Properties)object);
        Utils.importXml((DefaultHandler)object, file.getAbsolutePath());
        Vector<String> vector = new Vector<String>();
        double d2 = 0.0;
        for (EcrSale object22 : ((ScalaXmlImporter)object).getSales()) {
            d2 += object22.getQuantity() * object22.getPpuOriginal();
            string = object22.getProduct() + " CANT: " + object22.getQuantity() + " PRET UNITAR : " + object22.getPpuDupaDiscount();
            vector.add(string);
        }
        String string2 = "Verificati produsele !!";
        string = Utils.getStringForJDialogList("Verificati produsele !!", "", vector);
        DialogUtils.okDialog(null, string, string2);
        if (DialogUtils.confirmDialog(null, LangRoAll.tiparimBonFiscal, LangRoAll.confirmare)) {
            abstractCashRegister.printBonFiscal(((ScalaXmlImporter)object).getSales(), d2, ((ScalaXmlImporter)object).getPlati(), null, ((ScalaXmlImporter)object).getComments(), "", -1);
        } else {
            DialogUtils.errorDialog(null, LangRoAll.operatieEsuata, LangRoAll.nuPotContinua);
        }
        file.renameTo(new File(file.getAbsolutePath() + "_done"));
    }

    static /* synthetic */ void a(File object, String string, String string2) {
        try {
            string2 = "errors_" + string2 + "_" + Formatters.DATE_TIME_SECONDS_MILLIS_FORMAT.format(new Date()) + ".txt";
            object = ((File)object).getAbsolutePath() + File.separator + string2;
            FileUtils.writeTextToFile((String)object, string);
            return;
        }
        catch (IOException iOException) {
            Logger.logException(EcrMain.class.getName(), (Exception)iOException);
            return;
        }
    }
}

