/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import ro.atreides.ecr.EcrPaymentType;
import ro.atreides.ecr.SerialLibraryType;

public enum EcrType {
    Datecs_MP55("datecs.NewMP55", 9, false, false, SerialLibraryType.RxTx_ForceDTR, 9600, EcrPaymentType.MP55_CARD, true, false),
    Datecs_DP50_D("datecs.NewMP55", 4, true, true, SerialLibraryType.PureJava, 9600, EcrPaymentType.MP55B_CARD, true, true),
    Datecs_MP55_L_LD("datecs.NewMP55", 9, true, true, SerialLibraryType.PureJava, 9600, EcrPaymentType.MP55B_CARD, true, true),
    Datecs_MP55_B("datecs.NewMP55", 4, true, true, SerialLibraryType.PureJava, 9600, EcrPaymentType.MP55B_CARD, true, true),
    Datecs_DP25("datecsgen3.Generic", 9, true, true, SerialLibraryType.PureJava, 38400, EcrPaymentType.DP25_CARD_NATIVE, false, true),
    Datecs_DP45("datecsgen3.Generic", 9, true, true, SerialLibraryType.PureJava, 38400, EcrPaymentType.DP25_CARD_NATIVE, false, true),
    Datecs_DP05("datecsgen3.Generic", 9, true, true, SerialLibraryType.PureJava, 38400, EcrPaymentType.DP25_CARD_NATIVE, false, true),
    Datecs_MP55KL("datecsgen3.Generic", 9, true, true, SerialLibraryType.PureJava, 38400, EcrPaymentType.DP25_CARD_NATIVE, false, true);

    private static Map<EcrType, Map<Character, EcrPaymentType>> paymentTypes;
    private String driverClass;
    private int maxDepartments;
    private int preferredSpeed;
    private boolean supportsX;
    private boolean supportsZ;
    private boolean permitTotalIfPaidInFull;
    private boolean allowNegativePrice;
    private SerialLibraryType preferedSerialLibraryTypeWindows;
    private EcrPaymentType tipPlataCardEnum;

    private EcrType(String string2, int n2, boolean bl, boolean bl2, SerialLibraryType serialLibraryType, int n3, EcrPaymentType ecrPaymentType, boolean bl3, boolean bl4) {
        this.driverClass = string2;
        this.maxDepartments = n2;
        this.supportsX = bl;
        this.supportsZ = bl2;
        this.preferedSerialLibraryTypeWindows = serialLibraryType;
        this.preferredSpeed = n3;
        this.tipPlataCardEnum = ecrPaymentType;
        this.permitTotalIfPaidInFull = bl3;
        this.allowNegativePrice = bl4;
    }

    public final String getDriverClass() {
        return this.driverClass;
    }

    public final int getMaxDepartments() {
        return this.maxDepartments;
    }

    public final boolean isSupportsX() {
        return this.supportsX;
    }

    public final boolean isSupportsZ() {
        return this.supportsZ;
    }

    public final SerialLibraryType getPreferedSerialLibraryTypeWindows() {
        return this.preferedSerialLibraryTypeWindows;
    }

    public final int getPreferredSpeed() {
        return this.preferredSpeed;
    }

    public final EcrPaymentType getTipPlataCardEnum() {
        return this.tipPlataCardEnum;
    }

    public final Map<Character, EcrPaymentType> getPayments() {
        return paymentTypes.get((Object)this);
    }

    public final boolean isPermitTotalIfPaidInFull() {
        return this.permitTotalIfPaidInFull;
    }

    public final boolean isAllowNegativePrice() {
        return this.allowNegativePrice;
    }

    static {
        paymentTypes = Collections.synchronizedMap(new LinkedHashMap());
        Hashtable<Character, EcrPaymentType> hashtable = new Hashtable<Character, EcrPaymentType>();
        hashtable.put(Character.valueOf(EcrPaymentType.MP55_CASH.getCode()), EcrPaymentType.MP55_CASH);
        hashtable.put(Character.valueOf(EcrPaymentType.MP55_CARD.getCode()), EcrPaymentType.MP55_CARD);
        hashtable.put(Character.valueOf(EcrPaymentType.MP55_TICKET.getCode()), EcrPaymentType.MP55_TICKET);
        hashtable.put(Character.valueOf(EcrPaymentType.MP55_CEC.getCode()), EcrPaymentType.MP55_CEC);
        paymentTypes.put(Datecs_MP55, hashtable);
        hashtable = new Hashtable<Character, EcrPaymentType>();
        hashtable.put(Character.valueOf(EcrPaymentType.MP55B_CASH.getCode()), EcrPaymentType.MP55B_CASH);
        hashtable.put(Character.valueOf(EcrPaymentType.MP55B_CARD.getCode()), EcrPaymentType.MP55B_CARD);
        hashtable.put(Character.valueOf(EcrPaymentType.MP55B_TICKET.getCode()), EcrPaymentType.MP55B_TICKET);
        hashtable.put(Character.valueOf(EcrPaymentType.MP55_TICKET.getCode()), EcrPaymentType.MP55_TICKET);
        paymentTypes.put(Datecs_DP50_D, hashtable);
        paymentTypes.put(Datecs_MP55_L_LD, hashtable);
        paymentTypes.put(Datecs_MP55_B, hashtable);
        hashtable = new Hashtable<Character, EcrPaymentType>();
        hashtable.put(Character.valueOf(EcrPaymentType.DP25_CASH.getCode()), EcrPaymentType.DP25_CASH);
        hashtable.put(Character.valueOf(EcrPaymentType.DP25_CARD.getCode()), EcrPaymentType.DP25_CARD);
        hashtable.put(Character.valueOf(EcrPaymentType.DP25_CEC.getCode()), EcrPaymentType.DP25_CEC);
        hashtable.put(Character.valueOf(EcrPaymentType.DP25_CREDIT.getCode()), EcrPaymentType.DP25_CREDIT);
        hashtable.put(Character.valueOf(EcrPaymentType.DP25_TICHET.getCode()), EcrPaymentType.DP25_TICHET);
        hashtable.put(Character.valueOf(EcrPaymentType.DP25_CUPON.getCode()), EcrPaymentType.DP25_CUPON);
        paymentTypes.put(Datecs_DP25, hashtable);
        paymentTypes.put(Datecs_DP45, hashtable);
        paymentTypes.put(Datecs_DP05, hashtable);
        paymentTypes.put(Datecs_MP55KL, hashtable);
    }
}

