/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.io.IOException;
import java.util.Vector;
import ro.atreides.ecr.EcrClosedException;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.ecr.SerialDeviceDetector;
import ro.atreides.ecr.SerialDriverInterface;
import ro.atreides.ecr.SerialDriverInterfaceImpl;
import ro.atreides.ecr.SerialIOBuilder;
import ro.atreides.ecr.SerialPortInstance;
import ro.atreides.ecr.SerialReader;
import ro.atreides.ecr.SerialUtils;
import ro.atreides.ecr.SerialWriter;
import ro.deversoft.utils.noarch.Logger;

public abstract class SerialDriver
implements SerialDeviceDetector,
SerialIOBuilder {
    private SerialDriverInterface a;
    private SerialPortInstance b;
    private SerialWriter c;
    private SerialReader d;
    private String e;
    private boolean f = true;
    private boolean g = false;
    protected boolean notifications;
    protected Vector filters = new Vector();

    public SerialDriver(String string) {
        this.e = string == null ? "_last_detected_serial_driver_" : string;
        this.a = new SerialDriverInterfaceImpl();
    }

    public Vector getFilters() {
        return this.filters;
    }

    public void setFilters(Vector vector) {
        this.filters = vector;
    }

    public void setNotifications(boolean bl) {
        this.notifications = bl;
    }

    public final String getLastDetectedFile() {
        return this.e;
    }

    public final void setLastDetectedFile(String string) {
        this.e = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        if (this.g || !this.f) {
            return;
        }
        SerialDriver serialDriver = this;
        synchronized (serialDriver) {
            if (!this.isRunning()) {
                return;
            }
            this.g = true;
            this.f = true;
            Thread thread = new Thread(this){
                private /* synthetic */ SerialDriver a;
                {
                    this.a = serialDriver;
                }

                @Override
                public final void run() {
                    boolean bl = this.a.a(true);
                    EcrLogic.getInstance().ecrConnected(bl);
                    if (bl) {
                        this.a.startDriver();
                    }
                }
            };
            String string = this.getDriverName();
            thread.setName(string == null ? "Serial Driver Thread" : string);
            thread.start();
            return;
        }
    }

    public final synchronized void stop() {
        Logger.logVerbose(this, ">>>>>>>>>>>>>> STOPING ECR <<<<<<<<<<<<");
        this.f = false;
        if (this.b != null) {
            this.b.close();
        }
    }

    public final boolean isRunning() {
        return this.f;
    }

    public final void setDriverInterface(SerialDriverInterface serialDriverInterface) {
        if (serialDriverInterface != null) {
            this.a = serialDriverInterface;
        }
    }

    public final SerialDriverInterface getDriverInterface() {
        return this.a;
    }

    public final boolean detect() {
        boolean bl = this.a(false);
        EcrLogic.getInstance().ecrConnected(bl);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(boolean bl) {
        if (this.b != null) {
            this.b.close();
        }
        if (!bl) {
            Logger.logVerbose(this, "ECR INTERFACE: ecrRemoved()");
            int n = this.a.deviceRemoved(this.notifications);
            if (n != 0) {
                Logger.logVerbose(this, "ECR INTERFACE: user choose IGNORE");
                this.stop();
                return false;
            }
            Logger.logVerbose(this, "ECR INTERFACE: user choose RETRY");
        }
        while (this.isRunning()) {
            SerialPortInstance serialPortInstance;
            SerialDriver serialDriver = this;
            synchronized (serialDriver) {
                if (!this.isRunning()) {
                    return false;
                }
                serialPortInstance = SerialUtils.detect(this.buildSpeeds(), this.getLastDetectedFile(), (SerialIOBuilder)this, this, this.filters);
                if (serialPortInstance != null) {
                    SerialDriver serialDriver2 = this;
                    this.b = serialPortInstance;
                    serialDriver2.c = serialDriver2.b.getWriter();
                    serialDriver2.d = serialDriver2.b.getReader();
                    return true;
                }
            }
            SerialUtils.sleep(500L);
            if (!this.isRunning()) {
                return false;
            }
            if (serialPortInstance != null) continue;
            Logger.logVerbose(this, "ECR INTERFACE: ecrRemoved()");
            int n = bl ? this.a.deviceNotPresent(this.notifications) : this.a.deviceRemoved(this.notifications);
            if (n != 0) {
                Logger.logVerbose(this, "ECR INTERFACE: user choose IGNORE");
                this.stop();
                return false;
            }
            if (n != 0) continue;
            Logger.logVerbose(this, "ECR INTERFACE: user choose RETRY");
        }
        return false;
    }

    protected void write(byte[] byArray) throws EcrClosedException {
        boolean bl;
        if (!this.c.writetoport(byArray) && !(bl = this.detect())) {
            throw new EcrClosedException();
        }
    }

    protected final Object read(int n) throws EcrClosedException {
        Object object;
        block2: {
            object = null;
            try {
                object = this.d.read(n);
            }
            catch (IOException iOException) {
                boolean bl = this.detect();
                n = bl ? 1 : 0;
                if (bl) break block2;
                throw new EcrClosedException();
            }
        }
        return object;
    }

    protected final void clearReader() {
        this.d.clearReader();
    }

    public String getDriverName() {
        return "Serial Driver Thread";
    }

    protected abstract void startDriver();

    protected abstract Integer[] buildSpeeds();
}

