/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import ro.atreides.ecr.EcrClosedException;
import ro.atreides.ecr.EcrLogger;
import ro.atreides.ecr.EcrPersistentList;
import ro.atreides.ecr.EcrReceipt;
import ro.atreides.ecr.SerialDriver;
import ro.atreides.utils.tricky.NonPrintedBonInterface;
import ro.deversoft.utils.noarch.Logger;

public abstract class SerialEcr
extends SerialDriver {
    protected EcrPersistentList productsList;
    protected EcrLogger logger = new EcrLogger();

    public SerialEcr(String string) {
        super(string + "_last_detected_");
        this.productsList = new EcrPersistentList(string + "_persistent_list_");
    }

    @Override
    protected final void startDriver() {
        Logger.logVerbose(this, "ECR: STARTING TO SELL");
        while (this.isRunning()) {
            EcrReceipt ecrReceipt = null;
            try {
                ecrReceipt = this.productsList.next();
                if (!this.isRunning()) break;
                this.newReceipt(ecrReceipt);
                this.productsList.selled(ecrReceipt);
            }
            catch (EcrClosedException ecrClosedException) {
                Logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>>>>> ECR CLOSED <<<<<<<<<<<<<<<<<<<<<<<<<");
                break;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
                this.productsList.selled(ecrReceipt);
            }
        }
        this.stop();
    }

    protected final void updatePersistentList() {
        this.productsList.update();
    }

    public final int getNoOfBonsToPrint() {
        return this.productsList.size();
    }

    public final void addEcrReceipt(EcrReceipt ecrReceipt) {
        this.productsList.addReceipt(ecrReceipt);
    }

    @Override
    public String getDriverName() {
        return "Ecr Printing Thread";
    }

    public void log(String string) {
        if (this.logger != null) {
            this.logger.log((Object)this, string);
        }
    }

    public void log(Exception exception) {
        if (this.logger != null) {
            this.logger.log((Object)this, exception);
        }
    }

    protected final void removeReceipt(EcrReceipt ecrReceipt) {
        this.productsList.selled(ecrReceipt);
    }

    protected abstract void newReceipt(EcrReceipt var1) throws EcrClosedException;

    public void deleteNonPrintedBons(NonPrintedBonInterface nonPrintedBonInterface) {
        this.productsList.deleteNonPrintedBons(nonPrintedBonInterface);
    }
}

