/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.ReentrantLock;
import purejavacomm.SerialPort;
import ro.atreides.ecr.SerialIOBuilder;
import ro.atreides.ecr.SerialReader;
import ro.atreides.ecr.SerialSettings;
import ro.atreides.ecr.SerialUtils;
import ro.atreides.ecr.SerialWriter;

public final class SerialPortInstance {
    private SerialSettings a;
    private InputStream b;
    private OutputStream c;
    private SerialPort d;
    private SerialWriter e;
    private SerialReader f;

    public SerialPortInstance(InputStream inputStream, OutputStream outputStream, SerialPort serialPort, SerialSettings serialSettings, SerialIOBuilder serialIOBuilder) {
        if (inputStream == null || outputStream == null || serialPort == null || serialSettings == null) {
            throw new NullPointerException();
        }
        this.b = inputStream;
        this.c = outputStream;
        this.d = serialPort;
        this.a = serialSettings;
        if (serialIOBuilder != null) {
            this.e = serialIOBuilder.buildWriter(serialPort, outputStream);
            this.f = serialIOBuilder.buildReader(serialPort, inputStream);
        }
    }

    public final SerialWriter getWriter() {
        return this.e;
    }

    public final SerialReader getReader() {
        return this.f;
    }

    public final String getPort() {
        return this.a.getName();
    }

    public final int getSpeed() {
        return this.a.getSpeed();
    }

    public final InputStream getInput() {
        return this.b;
    }

    public final OutputStream getOutput() {
        return this.c;
    }

    public final SerialPort getSerialPort() {
        return this.d;
    }

    public final synchronized void close() {
        ReentrantLock reentrantLock = null;
        if (this.f != null) {
            this.f.close();
            reentrantLock = this.f.getLock();
            this.f = null;
        }
        if (this.e != null) {
            this.e.close();
            this.e = null;
        }
        SerialUtils.closeAll(this.b, this.c, this.d, reentrantLock);
        this.b = null;
        this.c = null;
        this.d = null;
    }
}

