/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.ReentrantLock;
import purejavacomm.SerialPort;
import ro.atreides.ecr.EcrLogger;
import ro.deversoft.utils.noarch.Logger;

public abstract class SerialReader {
    protected InputStream in;
    protected SerialPort serial;
    private boolean a = false;
    private EcrLogger b;
    protected final ReentrantLock ECR_CLOSED_LOCK = new ReentrantLock(true);

    public SerialReader(InputStream inputStream, SerialPort serialPort) {
        if (inputStream == null || serialPort == null) {
            throw new NullPointerException();
        }
        this.in = inputStream;
        this.serial = serialPort;
    }

    public final boolean isReaderClosed() {
        return this.a;
    }

    public final void close() {
        this.a = true;
    }

    public void log(String string) {
        if (this.b == null) {
            Logger.logVerbose(this, string);
            return;
        }
        this.b.log(string);
    }

    public void log(Exception exception) {
        if (this.b == null) {
            Logger.logVerbose(this, "Exception: " + exception.getMessage());
            return;
        }
        this.b.log((Object)this, exception);
    }

    public void setLogger(EcrLogger ecrLogger) {
        this.b = ecrLogger;
    }

    public final ReentrantLock getLock() {
        return this.ECR_CLOSED_LOCK;
    }

    public abstract Object read(int var1) throws IOException;

    public void clearReader() {
        this.ECR_CLOSED_LOCK.lock();
        try {
            int n;
            if (!this.isReaderClosed() && (n = this.in.available()) > 0) {
                this.in.skip(n);
            }
            return;
        }
        catch (IOException iOException) {
            this.log(iOException);
            return;
        }
        finally {
            this.ECR_CLOSED_LOCK.unlock();
        }
    }
}

