/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.SerialPort;
import ro.atreides.ecr.ConfigUtils;
import ro.atreides.ecr.SerialConnectInfo;
import ro.atreides.ecr.SerialDeviceDetector;
import ro.atreides.ecr.SerialIOBuilder;
import ro.atreides.ecr.SerialPortInstance;
import ro.atreides.ecr.SerialSettings;
import ro.deversoft.utils.noarch.Logger;

public class SerialUtils {
    private static final ReentrantLock a = new ReentrantLock(true);

    public static Vector<String> getPorts() {
        TreeSet<String> treeSet = new TreeSet<String>();
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        System.out.println("portList : " + enumeration);
        while (enumeration.hasMoreElements()) {
            CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
            System.out.println("port : name " + commPortIdentifier.getName() + " owner " + commPortIdentifier.getCurrentOwner() + " portType " + commPortIdentifier.getPortType() + " owned " + commPortIdentifier.isCurrentlyOwned());
            if (commPortIdentifier.getPortType() != 1) continue;
            System.out.println("port : name " + commPortIdentifier.getName() + " isSerial !");
            treeSet.add(commPortIdentifier.getName());
        }
        return new Vector<String>(treeSet);
    }

    public static SerialPortInstance initPort(SerialSettings serialSettings) {
        return SerialUtils.initPort(serialSettings, null);
    }

    public static SerialPortInstance initPort(SerialSettings serialSettings, SerialIOBuilder serialIOBuilder) {
        if (serialSettings == null) {
            return null;
        }
        Logger.logVerbose(SerialUtils.class.getName(), ">>>>>>>>>>>>>>>>>>> INITIALIZARE: port=" + serialSettings.getName() + " speed=" + serialSettings.getSpeed() + " <<<<<<<<<<<<<<<<<<");
        InputStream inputStream = null;
        OutputStream outputStream = null;
        SerialPort serialPort = null;
        try {
            String string = serialSettings.getName();
            if (string == null) {
                Logger.logWarning(SerialUtils.class.getName(), ">>>>> nume port = null");
                throw new NullPointerException();
            }
            Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
            while (enumeration.hasMoreElements()) {
                CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
                if (commPortIdentifier.getPortType() != serialSettings.getPortType() || !commPortIdentifier.getName().equals(string)) continue;
                Logger.logInfo(SerialUtils.class.getName(), ">>>>> Opening port: " + string);
                serialPort = (SerialPort)commPortIdentifier.open("CasaDeMarkatReader", 2000);
                serialPort.setRTS(serialSettings.isRTS());
                inputStream = serialPort.getInputStream();
                outputStream = serialPort.getOutputStream();
                serialPort.setSerialPortParams(serialSettings.getSpeed(), serialSettings.getDataBits(), serialSettings.getStopBits(), serialSettings.getPariry());
                Logger.logInfo(SerialUtils.class.getName(), ">>>>> Initializare port corecta");
                return new SerialPortInstance(inputStream, outputStream, serialPort, serialSettings, serialIOBuilder);
            }
            Logger.logWarning(SerialUtils.class.getName(), "port indisponibil");
            throw new NoSuchPortException();
        }
        catch (Exception exception) {
            SerialUtils.closeAll(inputStream, outputStream, serialPort);
            Logger.logWarning(SerialUtils.class.getName(), ">>>>> Eroare de initializare port, portul se va inchide");
            Logger.logWarning(SerialUtils.class.getName(), exception.toString());
            return null;
        }
    }

    public static void closeAll(InputStream inputStream, OutputStream outputStream, SerialPort serialPort, ReentrantLock reentrantLock) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Throwable throwable) {
            Logger.logWarning(SerialUtils.class.getName(), throwable.toString());
        }
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (Throwable throwable) {
            Logger.logWarning(SerialUtils.class.getName(), throwable.toString());
        }
        try {
            if (serialPort != null) {
                if (reentrantLock != null) {
                    reentrantLock.lock();
                    try {
                        serialPort.close();
                    }
                    finally {
                        reentrantLock.unlock();
                    }
                } else {
                    serialPort.close();
                }
            }
            return;
        }
        catch (Throwable throwable) {
            Logger.logWarning(SerialUtils.class.getName(), throwable.toString());
            return;
        }
    }

    public static void closeAll(InputStream inputStream, OutputStream outputStream, SerialPort serialPort) {
        SerialUtils.closeAll(inputStream, outputStream, serialPort, null);
    }

    public static Vector<SerialConnectInfo> getSerialConnectInfos(Integer[] object, String object2, Vector vector) {
        Vector<SerialConnectInfo> vector2 = new Vector<SerialConnectInfo>();
        if ((object2 = SerialUtils.getLastDetected((String)object2)) != null) {
            vector2.add((SerialConnectInfo)object2);
        }
        object = SerialUtils.a(object, vector, (SerialConnectInfo)object2);
        vector2.addAll((Collection<SerialConnectInfo>)object);
        return vector2;
    }

    private static Vector a(Integer[] integerArray, Vector vector, SerialConnectInfo serialConnectInfo) {
        Vector<SerialConnectInfo> vector2 = new Vector<SerialConnectInfo>();
        Vector<String> vector3 = SerialUtils.getPorts();
        for (int i = 0; i < vector3.size(); ++i) {
            int n;
            String string = vector3.get(i);
            boolean bl = false;
            for (n = 0; n < vector.size() && !bl; ++n) {
                String string2 = (String)vector.elementAt(n);
                if (!string.matches(string2)) continue;
                bl = true;
            }
            if (!bl) continue;
            for (n = 0; n < integerArray.length; ++n) {
                int n2 = integerArray[n];
                SerialConnectInfo serialConnectInfo2 = new SerialConnectInfo(string, n2);
                if (serialConnectInfo != null && serialConnectInfo2.equals(serialConnectInfo)) continue;
                vector2.add(serialConnectInfo2);
            }
        }
        return vector2;
    }

    public static SerialConnectInfo getLastDetected(String object) {
        SerialConnectInfo serialConnectInfo = null;
        if ((object = ConfigUtils.readObjectFrom((String)object)) instanceof SerialConnectInfo) {
            serialConnectInfo = (SerialConnectInfo)object;
        }
        return serialConnectInfo;
    }

    public static void setLastDetected(SerialConnectInfo serialConnectInfo, String string) {
        if (serialConnectInfo == null) {
            serialConnectInfo = new SerialConnectInfo("empty_port", 0);
        }
        ConfigUtils.writeObjectTo(serialConnectInfo, string);
    }

    public static SerialPortInstance detect(Integer[] object, String string, SerialIOBuilder serialIOBuilder, SerialDeviceDetector serialDeviceDetector, Vector vector) {
        a.lock();
        try {
            object = SerialUtils.getSerialConnectInfos((Integer[])object, string, vector);
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                Object object2 = (SerialConnectInfo)((Vector)object).get(i);
                Logger.logVerbose(SerialUtils.class.getName(), "trying to detect on: " + object2);
                object2 = SerialUtils.detect((SerialConnectInfo)object2, serialIOBuilder, string, serialDeviceDetector);
                if (object2 == null) continue;
                object = object2;
                a.unlock();
                return object;
            }
            a.unlock();
            return null;
        }
        catch (Throwable throwable) {
            a.unlock();
            throw throwable;
        }
    }

    public static SerialPortInstance detect(SerialConnectInfo serialConnectInfo, SerialIOBuilder serialIOBuilder, String string, SerialDeviceDetector serialDeviceDetector) {
        return SerialUtils.detect(serialConnectInfo.getName(), serialConnectInfo.getSpeed(), serialIOBuilder, string, serialDeviceDetector);
    }

    public static SerialPortInstance detect(String string, int n, SerialIOBuilder serialIOBuilder, String string2, SerialDeviceDetector serialDeviceDetector) {
        SerialSettings serialSettings = new SerialSettings();
        serialSettings.setName(string);
        serialSettings.setSpeed(n);
        return SerialUtils.detect(serialSettings, serialIOBuilder, string2, serialDeviceDetector);
    }

    public static SerialPortInstance detect(SerialSettings serialSettings, SerialIOBuilder serialIOBuilder, String string, SerialDeviceDetector serialDeviceDetector) {
        SerialPortInstance serialPortInstance = null;
        try {
            serialPortInstance = SerialUtils.initPort(serialSettings, serialIOBuilder);
            if (serialPortInstance != null) {
                Logger.logVerbose(SerialUtils.class.getName(), ">>>>>>>>>>>>>>>>>>>>> DETECTARE CASA: port=" + serialSettings.getName() + " speed=" + serialSettings.getSpeed() + " <<<<<<<<<<<<<<<<<<<");
                boolean bl = serialDeviceDetector.detectDevice(serialPortInstance.getReader(), serialPortInstance.getWriter());
                if (bl) {
                    SerialUtils.setLastDetected(new SerialConnectInfo(serialPortInstance.getPort(), serialPortInstance.getSpeed()), string);
                    Logger.logVerbose(SerialUtils.class.getName(), ">>>>> casa a fost detectata!");
                    return serialPortInstance;
                }
                Logger.logVerbose(SerialUtils.class.getName(), ">>>>> casa NU a fost detectata!");
                serialPortInstance.close();
            }
        }
        catch (Exception exception) {
            if (serialPortInstance != null) {
                serialPortInstance.close();
            }
            Logger.logWarning(SerialUtils.class.getName(), exception.toString());
        }
        return null;
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }
}

